/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.claims;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.registry.UserRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserClaimsRetriever {
    private static final TraceComponent tc = Tr.register(UserClaimsRetriever.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private AuthCacheService authCacheService;
    private UserRegistry userRegistry;
    static final long serialVersionUID = 7716851604604842252L;

    public UserClaimsRetriever(AuthCacheService authCacheService, UserRegistry userRegistry) {
        this.authCacheService = authCacheService;
        this.userRegistry = userRegistry;
    }

    public UserClaims getUserClaims(String username, String groupIdentifier) throws WSSecurityException {
        UserClaims userClaims = new UserClaims(username, groupIdentifier);
        String realmName = this.userRegistry.getRealm();
        String cacheKey = this.getCacheKey(realmName, username);
        Subject subject = this.authCacheService.getSubject((Object)cacheKey);
        if (subject == null) {
            subject = WSSubject.getRunAsSubject();
            if (subject != null && !this.isUnAuthenticated(subject, username)) {
                realmName = this.getRealmName(subject);
            } else {
                subject = null;
            }
        }
        userClaims.setRealmName(realmName);
        if (subject != null) {
            this.populateClaimsFromCachedSubject(userClaims, subject);
        } else {
            this.populateClaimsFromRegistry(userClaims, realmName, username);
        }
        return userClaims;
    }

    /*
     * WARNING - void declaration
     */
    String getRealmName(Subject subject) {
        WSCredential wsCredential = this.getWSCredential(subject);
        try {
            return wsCredential.getRealmName();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.claims.UserClaimsRetriever", (String)"89", (Object)this, (Object[])new Object[]{subject});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("RealmName Exception:" + e.getClass().getName() + " MSG:" + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    private String getCacheKey(String realmName, String username) {
        return realmName + ":" + username;
    }

    @FFDCIgnore(value={Exception.class})
    private void populateClaimsFromCachedSubject(UserClaims userClaims, Subject subject) {
        block2: {
            WSCredential wsCredential = this.getWSCredential(subject);
            try {
                List<String> groups = this.extractGroups(wsCredential.getGroupIds());
                this.setClaims(userClaims, wsCredential.getUniqueSecurityName(), groups);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was an exception populating the user claims from the cached subject.", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    WSCredential getWSCredential(Subject subject) {
        SubjectHelper subjectHelper = new SubjectHelper();
        return subjectHelper.getWSCredential(subject);
    }

    boolean isUnAuthenticated(Subject subject, String username) {
        WSCredential cred = this.getWSCredential(subject);
        if (cred == null) {
            return true;
        }
        try {
            if (username.equals(cred.getSecurityName()) && !cred.isUnauthenticated()) {
                return false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.claims.UserClaimsRetriever", (String)"134", (Object)this, (Object[])new Object[]{subject, username});
        }
        return true;
    }

    private List<String> extractGroups(List<String> groupIds) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String groupId : groupIds) {
            String group = AccessIdUtil.getUniqueId((String)groupId);
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    @FFDCIgnore(value={Exception.class})
    private void populateClaimsFromRegistry(UserClaims userClaims, String realmName, String username) {
        block2: {
            try {
                this.setClaims(userClaims, this.userRegistry.getUniqueUserId(username), this.userRegistry.getGroupsForUser(username));
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was an exception populating the user claims from the user registry.", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    private void setClaims(UserClaims userClaims, String uniqueSecurityName, List<String> groups) {
        userClaims.setUniqueSecurityName(uniqueSecurityName);
        if (!groups.isEmpty()) {
            userClaims.setGroups(groups);
        }
    }
}

