/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.granttype.impl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidScopeException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20RefreshTokenInvalidClientException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20GrantTypeHandlerRefreshImpl
implements OAuth20GrantTypeHandler {
    static final String CLASS = OAuth20GrantTypeHandlerRefreshImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKeysGrantType(AttributeList attributeList) throws OAuthException {
        String methodName = "getKeysGrantType";
        _log.entering(CLASS, methodName);
        ArrayList<String> tokenKeys = null;
        try {
            String refresh = attributeList.getAttributeValueByNameAndType("refresh_token", "urn:ibm:names:body:param");
            if (refresh == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "refresh_token", null);
            }
            tokenKeys = new ArrayList<String>();
            tokenKeys.add(refresh);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRequestGrantType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestGrantType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token refresh;
            if (tokens.size() >= 1 && (refresh = tokens.get(0)) != null) {
                String[] approvedScope;
                String clientId = attributeList.getAttributeValueByName("client_id");
                if (!clientId.equals(refresh.getClientId())) {
                    throw new OAuth20RefreshTokenInvalidClientException("security.oauth20.error.refreshtoken.invalid.client", refresh.getTokenString(), clientId);
                }
                String[] requestedScope = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:body:param");
                if (!OAuth20Util.scopeEquals(requestedScope, approvedScope = refresh.getScope())) {
                    throw new OAuth20InvalidScopeException("security.oauth20.error.invalid.scope", requestedScope, approvedScope);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        String methodName = "buildTokensGrantType";
        _log.entering(CLASS, methodName);
        ArrayList<OAuth20Token> tokenList = null;
        try {
            OAuth20Token refresh;
            if (tokens.size() >= 1 && (refresh = tokens.get(0)) != null) {
                String clientId = attributeList.getAttributeValueByName("client_id");
                String username = refresh.getUsername();
                String redirectUri = refresh.getRedirectUri();
                String[] origScope = refresh.getScope();
                String[] requestScope = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:body:param");
                if (requestScope == null || requestScope.length == 0) {
                    requestScope = origScope;
                }
                String stateId = refresh.getStateId();
                String grantType = refresh.getGrantType();
                Map<String, String[]> refreshTokenMap = tokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, origScope, refresh, grantType);
                String key = "com.ibm.wsspi.security.oidc.external.claims:originalGrantType";
                String[] originalGrantType = refresh.getExtensionProperty(key);
                if (originalGrantType != null && originalGrantType.length > 0) {
                    refreshTokenMap.put(key, originalGrantType);
                }
                OAuth20Token newRefresh = tokenFactory.createRefreshToken(refreshTokenMap);
                Map<String, String[]> tokenMap = tokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, requestScope, refresh, grantType);
                if (newRefresh != null) {
                    tokenMap.put("refresh_key", new String[]{newRefresh.getId()});
                    tokenMap.put("old_refresh_key", new String[]{refresh.getId()});
                }
                OAuth20Util.populateJwtAccessTokenData(attributeList, tokenMap);
                String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
                tokenMap.put("X-Forwarded-Host", new String[]{proxy});
                OAuth20Token token = tokenFactory.createAccessToken(tokenMap);
                tokenList = new ArrayList<OAuth20Token>();
                tokenList.add(token);
                if (newRefresh != null) {
                    tokenList.add(newRefresh);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token refresh;
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                String accessToken = token.getTokenString();
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
                String accessTokenId = token.getId();
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{accessTokenId});
                String type = token.getSubType();
                attributeList.setAttribute("token_type", "urn:ibm:names:oauth:response:attribute", new String[]{type});
                String expires = OAuth20TokenHelper.expiresInSeconds(token);
                attributeList.setAttribute("expires_in", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
                String stateId = token.getStateId();
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
                String[] scope = token.getScope();
                attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
            }
            if (tokens.size() >= 2 && (refresh = tokens.get(1)) != null) {
                String refreshToken = refresh.getTokenString();
                attributeList.setAttribute("refresh_token", "urn:ibm:names:oauth:response:attribute", new String[]{refreshToken});
                String refreshTokenId = refresh.getId();
                attributeList.setAttribute("refresh_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{refreshTokenId});
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

