/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.client;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.client.OAuth20Client;
import com.ibm.oauth.core.api.oauth20.client.OAuth20ClientProvider;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.statistics.OAuthStatHelper;
import com.ibm.oauth.core.internal.statistics.OAuthStatisticsImpl;

public class OAuth20ClientProviderWrapper
implements OAuth20ClientProvider {
    OAuth20ClientProvider _real;
    OAuthStatisticsImpl _stats;
    static boolean _debugDumpCallStacks = false;

    public OAuth20ClientProviderWrapper(OAuth20ClientProvider real, OAuthStatisticsImpl stats) {
        this._real = real;
        this._stats = stats;
    }

    @Override
    public boolean exists(String clientIdentifier) {
        if (_debugDumpCallStacks) {
            System.out.println(this.getClass().getName() + ".exists CALLED FROM: " + OAuth20Util.getCurrentStackTraceString(new Exception()));
        }
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.clientProvider.exists");
        boolean result = this._real.exists(clientIdentifier);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public OAuth20Client get(String clientIdentifier) {
        if (_debugDumpCallStacks) {
            System.out.println(this.getClass().getName() + ".get CALLED FROM: " + OAuth20Util.getCurrentStackTraceString(new Exception()));
        }
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.clientProvider.getClient");
        OAuth20Client result = this._real.get(clientIdentifier);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public boolean validateClient(String clientIdentifier, String clientSecret) {
        if (_debugDumpCallStacks) {
            System.out.println(this.getClass().getName() + ".get CALLED FROM: " + OAuth20Util.getCurrentStackTraceString(new Exception()));
        }
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.clientProvider.validateClient");
        boolean result = this._real.validateClient(clientIdentifier, clientSecret);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
        this._real.init(config);
    }
}

