/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.openidconnect.client.internal.FileInfo;
import com.ibm.ws.security.openidconnect.clients.common.HashUtils;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.common.ConfigUtils;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.security.openidconnect.client.oidcClientConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={OidcClientConfig.class}, property={"service.vendor=IBM"})
public class OidcClientConfigImpl
implements OidcClientConfig {
    private static final TraceComponent tc = Tr.register(OidcClientConfigImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    protected final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    public static final String CFG_KEY_ID = "id";
    public static final String CFG_KEY_GRANT_TYPE = "grantType";
    public static final String CFG_KEY_RESPONSE_TYPE = "responseType";
    public static final String CFG_KEY_SCOPE = "scope";
    public static final String CFG_KEY_CLIENT_ID = "clientId";
    public static final String CFG_KEY_CLIENT_SECRET = "clientSecret";
    public static final String CFG_KEY_REDIRECT_TO_RP_HOST_AND_PORT = "redirectToRPHostAndPort";
    public static final String CFG_KEY_USER_IDENTIFIER = "userIdentifier";
    public static final String CFG_KEY_GROUP_IDENTIFIER = "groupIdentifier";
    public static final String CFG_KEY_REALM_IDENTIFIER = "realmIdentifier";
    public static final String CFG_KEY_REALM_NAME = "realmName";
    public static final String CFG_KEY_UNIQUE_USER_IDENTIFIER = "uniqueUserIdentifier";
    public static final String CFG_KEY_TOKEN_ENDPOINT_AUTH_METHOD = "tokenEndpointAuthMethod";
    public static final String CFG_KEY_USER_IDENTITY_TO_CREATE_SUBJECT = "userIdentityToCreateSubject";
    public static final String CFG_KEY_MAP_IDENTITY_TO_REGISTRY_USER = "mapIdentityToRegistryUser";
    public static final String CFG_KEY_OidcclientRequestParameterSupported = "oidcclientRequestParameterSupported";
    public static final String CFG_KEY_VALIDATE_ACCESS_TOKEN_LOCALLY = "validateAccessTokenLocally";
    public static final String CFG_KEY_SHARED_KEY = "sharedKey";
    public static final String CFG_KEY_TRUST_ALIAS_NAME = "trustAliasName";
    public static final String CFG_KEY_HTTPS_REQUIRED = "httpsRequired";
    public static final String CFG_KEY_CLIENTSIDE_REDIRECT = "isClientSideRedirectSupported";
    public static final String CFG_KEY_disableLtpaCookie = "disableLtpaCookie";
    public static final String CFG_KEY_NONCE_ENABLED = "nonceEnabled";
    public static final String CFG_KEY_SSL_REF = "sslRef";
    public static final String CFG_KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String CFG_KEY_CLOCK_SKEW = "clockSkew";
    public static final String CFG_KEY_AUTHENTICATION_TIME_LIMIT = "authenticationTimeLimit";
    public static final String CFG_KEY_DISCOVERY_ENDPOINT_URL = "discoveryEndpointUrl";
    public static final String CFG_KEY_AUTHORIZATION_ENDPOINT_URL = "authorizationEndpointUrl";
    public static final String CFG_KEY_TOKEN_ENDPOINT_URL = "tokenEndpointUrl";
    public static final String CFG_KEY_USERINFO_ENDPOINT_URL = "userInfoEndpointUrl";
    public static final String CFG_KEY_VALIDATION_ENDPOINT_URL = "validationEndpointUrl";
    public static final String CFG_KEY_DISABLE_ISS_CHECKING = "disableIssChecking";
    public static final String CFG_KEY_INITIAL_STATE_CACHE_CAPACITY = "initialStateCacheCapacity";
    public static final String CFG_KEY_AUTO_AUTHORIZE_PARAM = "autoAuthorizeParam";
    public static final String CFG_KEY_ISSUER_IDENTIFIER = "issuerIdentifier";
    public static final String CFG_KEY_TRUSTSTORE_REF = "trustStoreRef";
    public static final String CFG_KEY_HOST_NAME_VERIFICATION_ENABLED = "hostNameVerificationEnabled";
    public static final String CFG_KEY_INCLUDE_ID_TOKEN_IN_SUBJECT = "includeIdTokenInSubject";
    public static final String CFG_KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT = "includeCustomCacheKeyInSubject";
    public static final String CFG_KEY_AUTH_CONTEXT_CLASS_REFERENCE = "authContextClassReference";
    public static final String CFG_KEY_AUTH_FILTER_REF = "authFilterRef";
    public static final String CFG_KEY_JSON_WEB_KEY = "jsonWebKey";
    public static final String CFG_KEY_JWK_ENDPOINT_URL = "jwkEndpointUrl";
    public static final String CFG_KEY_JWK_CLIENT_ID = "jwkClientId";
    public static final String CFG_KEY_JWK_CLIENT_SECRET = "jwkClientSecret";
    public static final String CFG_KEY_PROMPT = "prompt";
    public static final String CFG_KEY_AUDIENCES = "audiences";
    public static final String CFG_KEY_RESOURCES = "resource";
    public static final String CFG_KEY_CREATE_SESSION = "createSession";
    public static final String CFG_KEY_INBOUND_PROPAGATION = "inboundPropagation";
    public static final String CFG_KEY_VALIDATION_METHOD = "validationMethod";
    public static final String CFG_KEY_HEADER_NAME = "headerName";
    public static final String CFG_KEY_propagation_authnSessionDisabled = "authnSessionDisabled";
    public static final String CFG_KEY_reAuthnOnAccessTokenExpire = "reAuthnOnAccessTokenExpire";
    public static final String CFG_KEY_reAuthnCushionMilliseconds = "reAuthnCushion";
    public static final String CFG_KEY_jwt = "jwt";
    public static final String CFG_KEY_jwtRef = "builder";
    public static final String CFG_KEY_jwtClaims = "claims";
    public static final String CFG_KEY_AUTHZ_PARAM = "authzParameter";
    public static final String CFG_KEY_TOKEN_PARAM = "tokenParameter";
    public static final String CFG_KEY_USERINFO_PARAM = "userinfoParameter";
    public static final String CFG_KEY_JWK_PARAM = "jwkParameter";
    public static final String CFG_KEY_PARAM_NAME = "name";
    public static final String CFG_KEY_PARAM_VALUE = "value";
    public static final String CFG_KEY_JUNCTION_PATH = "redirectJunctionPath";
    public static final String CFG_KEY_accessTokenInLtpaCookie = "accessTokenInLtpaCookie";
    public static final String CFG_KEY_USE_ACCESS_TOKEN_AS_ID_TOKEN = "useAccessTokenAsIdToken";
    public static final String CFG_KEY_USERINFO_ENDPOINT_ENABLED = "userInfoEndpointEnabled";
    public static final String CFG_KEY_DISCOVERY_POLLING_RATE = "discoveryPollingRate";
    public static final String CFG_KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS = "useSystemPropertiesForHttpClientConnections";
    public static final String CFG_KEY_FORWARD_LOGIN_PARAMETER = "forwardLoginParameter";
    public static final String OPDISCOVERY_AUTHZ_EP_URL = "authorization_endpoint";
    public static final String OPDISCOVERY_TOKEN_EP_URL = "token_endpoint";
    public static final String OPDISCOVERY_INTROSPECTION_EP_URL = "introspection_endpoint";
    public static final String OPDISCOVERY_JWKS_EP_URL = "jwks_uri";
    public static final String OPDISCOVERY_USERINFO_EP_URL = "userinfo_endpoint";
    public static final String OPDISCOVERY_ISSUER = "issuer";
    public static final String OPDISCOVERY_TOKEN_EP_AUTH = "token_endpoint_auth_methods_supported";
    public static final String OPDISCOVERY_SCOPES = "scopes_supported";
    public static final String OPDISCOVERY_IDTOKEN_SIGN_ALG = "id_token_signing_alg_values_supported";
    public static final String CFG_KEY_TOKEN_REUSE = "tokenReuse";
    static String contextPath = "/oidcclient";
    static final String COMMA = ",";
    static final String BLANK = "";
    public static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    static final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private String id;
    private String grantType;
    private String responseType;
    private String scope;
    private String clientId;
    private String clientSecret;
    private String redirectToRPHostAndPort;
    private String userIdentifier;
    private String groupIdentifier;
    private String realmIdentifier;
    private String realmName;
    private String uniqueUserIdentifier;
    private String tokenEndpointAuthMethod;
    private String userIdentityToCreateSubject;
    private boolean mapIdentityToRegistryUser;
    private boolean oidcclientRequestParameterSupported;
    private boolean validateAccessTokenLocally;
    private boolean disableLtpaCookie = false;
    private String sharedKey;
    private String trustAliasName;
    private boolean httpsRequired;
    private boolean clientSideRedirect;
    private boolean nonceEnabled;
    private String sslRef;
    private String sslConfigurationName;
    private String signatureAlgorithm;
    private long clockSkewInSeconds;
    private long authenticationTimeLimitInSeconds;
    private String discoveryEndpointUrl;
    private String authorizationEndpointUrl;
    private String tokenEndpointUrl;
    private String userInfoEndpointUrl;
    private boolean userInfoEndpointEnabled;
    private String validationEndpointUrl;
    private int initialStateCacheCapacity;
    private String issuerIdentifier;
    private String trustStoreRef;
    private boolean hostNameVerificationEnabled;
    private boolean includeIdTokenInSubject;
    private boolean includeCustomCacheKeyInSubject;
    private String authenticationContextClassReferenceValue;
    private String authFilterRef;
    private String authFilterId;
    private String jsonWebKey;
    private String jwkEndpointUrl;
    private String jwkClientId;
    private String jwkClientSecret;
    private String jwtRef;
    private String[] jwtClaims;
    private JWKSet jwkset;
    private String prompt;
    private boolean createSession;
    private String inboundPropagation;
    private String validationMethod;
    private String headerName;
    private boolean disableIssChecking;
    private String[] audiences;
    private boolean allAudiences = false;
    private String[] resources;
    private boolean useAccessTokenAsIdToken;
    private List<String> forwardLoginParameter;
    private String oidcClientCookieName;
    private boolean authnSessionDisabled;
    boolean goodConfig = true;
    private boolean reAuthnOnAccessTokenExpire;
    private long reAuthnCushionMilliseconds;
    private String redirectJunctionPath;
    private boolean accessTokenInLtpaCookie = false;
    private JSONObject discoveryjson = null;
    private String discoveryDocumentHash = null;
    private long discoveryPollingRate = 300000L;
    private long nextDiscoveryTime;
    private boolean discovery = false;
    private HashMap<String, String> authzRequestParamMap;
    private HashMap<String, String> tokenRequestParamMap;
    private HashMap<String, String> userinfoRequestParamMap;
    private HashMap<String, String> jwkRequestParamMap;
    private final CommonConfigUtils configUtils = new CommonConfigUtils();
    private final ConfigUtils oidcConfigUtils = new ConfigUtils(this.configAdminRef);
    private boolean useSystemPropertiesForHttpClientConnections = false;
    private boolean tokenReuse = false;
    static String firstRandom = OidcUtil.generateRandom((int)32);
    static final long serialVersionUID = -4576737471342683909L;

    @Reference(name="configurationAdmin", service=ConfigurationAdmin.class, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.unsetReference(ref);
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.unsetReference(ref);
    }

    @Reference(service=SSLSupport.class, name="sslSupport", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSslSupport service.pid:" + ref.getProperty("service.pid")), (Object[])new Object[0]);
        }
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedtSslSupport service.pid:" + ref.getProperty("service.pid")), (Object[])new Object[0]);
        }
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetSslSupport service.pid:" + ref.getProperty("service.pid")), (Object[])new Object[0]);
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.configAdminRef.activate(cc);
        this.sslSupportRef.activate(cc);
        this.keyStoreServiceRef.activate(cc);
        locationAdminRef.activate(cc);
        this.processConfigProps(props);
        if (this.isValidConfig()) {
            Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_CONFIG_PROCESSED", (Object[])new Object[]{this.getId()});
        }
    }

    @Modified
    protected synchronized void modify(Map<String, Object> props) {
        this.processConfigProps(props);
        if (this.isValidConfig()) {
            Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_CONFIG_MODIFIED", (Object[])new Object[]{this.getId()});
        }
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        this.configAdminRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        this.keyStoreServiceRef.deactivate(cc);
        locationAdminRef.deactivate(cc);
    }

    private void processConfigProps(Map<String, Object> props) {
        String jwt;
        this.oidcClientCookieName = null;
        if (props == null || props.isEmpty()) {
            return;
        }
        this.id = (String)props.get(CFG_KEY_ID);
        this.grantType = (String)props.get(CFG_KEY_GRANT_TYPE);
        this.responseType = this.trimIt((String)props.get(CFG_KEY_RESPONSE_TYPE));
        if (this.responseType != null) {
            if ("code".equals(this.responseType)) {
                this.grantType = "authorization_code";
            } else if (this.responseType.contains("token")) {
                this.grantType = "implicit";
            }
        } else if ("code".equals(this.grantType)) {
            this.responseType = "code";
        } else if ("implicit".equals(this.grantType)) {
            this.responseType = "id_token token";
        }
        this.useSystemPropertiesForHttpClientConnections = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS, this.useSystemPropertiesForHttpClientConnections);
        this.scope = (String)props.get(CFG_KEY_SCOPE);
        this.clientId = this.trimIt((String)props.get(CFG_KEY_CLIENT_ID));
        this.clientSecret = this.processProtectedString(props, CFG_KEY_CLIENT_SECRET);
        this.redirectToRPHostAndPort = this.trimIt((String)props.get(CFG_KEY_REDIRECT_TO_RP_HOST_AND_PORT));
        this.redirectJunctionPath = this.trimIt((String)props.get(CFG_KEY_JUNCTION_PATH));
        if (this.redirectJunctionPath != null) {
            if (!this.redirectJunctionPath.startsWith("/")) {
                this.redirectJunctionPath = "/" + this.redirectJunctionPath;
            }
            if (this.redirectJunctionPath.endsWith("/")) {
                this.redirectJunctionPath = this.redirectJunctionPath.substring(0, this.redirectJunctionPath.length() - 1);
            }
        }
        this.userIdentifier = this.trimIt((String)props.get(CFG_KEY_USER_IDENTIFIER));
        this.groupIdentifier = this.trimIt((String)props.get(CFG_KEY_GROUP_IDENTIFIER));
        this.realmIdentifier = this.trimIt((String)props.get(CFG_KEY_REALM_IDENTIFIER));
        this.realmName = this.trimIt((String)props.get(CFG_KEY_REALM_NAME));
        this.uniqueUserIdentifier = this.trimIt((String)props.get(CFG_KEY_UNIQUE_USER_IDENTIFIER));
        this.tokenEndpointAuthMethod = this.trimIt((String)props.get(CFG_KEY_TOKEN_ENDPOINT_AUTH_METHOD));
        this.userIdentityToCreateSubject = this.trimIt((String)props.get(CFG_KEY_USER_IDENTITY_TO_CREATE_SUBJECT));
        this.checkForValidValue(this.userIdentityToCreateSubject);
        this.mapIdentityToRegistryUser = (Boolean)props.get(CFG_KEY_MAP_IDENTITY_TO_REGISTRY_USER);
        this.oidcclientRequestParameterSupported = (Boolean)props.get(CFG_KEY_OidcclientRequestParameterSupported);
        this.validateAccessTokenLocally = (Boolean)props.get(CFG_KEY_VALIDATE_ACCESS_TOKEN_LOCALLY);
        this.disableLtpaCookie = (Boolean)props.get(CFG_KEY_disableLtpaCookie);
        this.sharedKey = this.processProtectedString(props, CFG_KEY_SHARED_KEY);
        this.trustAliasName = this.trimIt((String)props.get(CFG_KEY_TRUST_ALIAS_NAME));
        this.httpsRequired = (Boolean)props.get(CFG_KEY_HTTPS_REQUIRED);
        this.clientSideRedirect = (Boolean)props.get(CFG_KEY_CLIENTSIDE_REDIRECT);
        this.nonceEnabled = (Boolean)props.get(CFG_KEY_NONCE_ENABLED);
        this.sslConfigurationName = this.sslRef = this.trimIt((String)props.get(CFG_KEY_SSL_REF));
        this.signatureAlgorithm = this.trimIt((String)props.get(CFG_KEY_SIGNATURE_ALGORITHM));
        if ("none".equals(this.signatureAlgorithm)) {
            Tr.warning((TraceComponent)tc, (String)"OIDC_CLIENT_NONE_ALG", (Object[])new Object[]{this.id, this.signatureAlgorithm});
        }
        this.clockSkewInSeconds = (Long)props.get(CFG_KEY_CLOCK_SKEW) / 1000L;
        this.authenticationTimeLimitInSeconds = (Long)props.get(CFG_KEY_AUTHENTICATION_TIME_LIMIT) / 1000L;
        this.validationMethod = this.trimIt((String)props.get(CFG_KEY_VALIDATION_METHOD));
        this.userInfoEndpointEnabled = (Boolean)props.get(CFG_KEY_USERINFO_ENDPOINT_ENABLED);
        this.discoveryEndpointUrl = this.trimIt((String)props.get(CFG_KEY_DISCOVERY_ENDPOINT_URL));
        this.discoveryPollingRate = (Long)props.get(CFG_KEY_DISCOVERY_POLLING_RATE);
        this.discovery = false;
        this.discoveryjson = null;
        if (this.discoveryEndpointUrl != null) {
            this.discovery = this.handleDiscoveryEndpoint(this.discoveryEndpointUrl);
            if (this.discovery) {
                this.logDiscoveryWarning(props);
            } else {
                this.reConfigEndpointsAfterDiscoveryFailure();
            }
        } else {
            this.authorizationEndpointUrl = this.trimIt((String)props.get(CFG_KEY_AUTHORIZATION_ENDPOINT_URL));
            this.tokenEndpointUrl = this.trimIt((String)props.get(CFG_KEY_TOKEN_ENDPOINT_URL));
            this.userInfoEndpointUrl = this.trimIt((String)props.get(CFG_KEY_USERINFO_ENDPOINT_URL));
            this.jwkEndpointUrl = this.trimIt((String)props.get(CFG_KEY_JWK_ENDPOINT_URL));
            this.validationEndpointUrl = this.trimIt((String)props.get(CFG_KEY_VALIDATION_ENDPOINT_URL));
            this.issuerIdentifier = this.trimIt((String)props.get(CFG_KEY_ISSUER_IDENTIFIER));
        }
        this.initialStateCacheCapacity = (Integer)props.get(CFG_KEY_INITIAL_STATE_CACHE_CAPACITY);
        this.trustStoreRef = this.trimIt((String)props.get(CFG_KEY_TRUSTSTORE_REF));
        this.hostNameVerificationEnabled = (Boolean)props.get(CFG_KEY_HOST_NAME_VERIFICATION_ENABLED);
        this.includeIdTokenInSubject = (Boolean)props.get(CFG_KEY_INCLUDE_ID_TOKEN_IN_SUBJECT);
        this.includeCustomCacheKeyInSubject = (Boolean)props.get(CFG_KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT);
        this.authenticationContextClassReferenceValue = this.trimIt((String)props.get(CFG_KEY_AUTH_CONTEXT_CLASS_REFERENCE));
        if (this.authenticationContextClassReferenceValue == null) {
            this.authenticationContextClassReferenceValue = BLANK;
        }
        this.authFilterRef = this.trimIt((String)props.get(CFG_KEY_AUTH_FILTER_REF));
        this.authFilterId = this.getAuthFilterId(this.authFilterRef);
        this.jsonWebKey = this.trimIt((String)props.get(CFG_KEY_JSON_WEB_KEY));
        this.jwkClientId = this.trimIt((String)props.get(CFG_KEY_JWK_CLIENT_ID));
        this.jwkClientSecret = this.processProtectedString(props, CFG_KEY_JWK_CLIENT_SECRET);
        this.jwkset = new JWKSet();
        this.prompt = this.trimIt((String)props.get(CFG_KEY_PROMPT));
        this.createSession = (Boolean)props.get(CFG_KEY_CREATE_SESSION);
        this.inboundPropagation = this.trimIt((String)props.get(CFG_KEY_INBOUND_PROPAGATION));
        this.audiences = this.trimIt((String[])props.get(CFG_KEY_AUDIENCES));
        this.allAudiences = false;
        if (this.audiences != null) {
            for (int iI = 0; iI < this.audiences.length; ++iI) {
                if (!"ALL_AUDIENCES".equals(this.audiences[iI])) continue;
                this.allAudiences = true;
                break;
            }
        }
        if ((jwt = this.trimIt((String)props.get(CFG_KEY_jwt))) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"jwt element exists", (Object[])new Object[0]);
            }
            Configuration config = null;
            try {
                config = ((ConfigurationAdmin)this.configAdminRef.getService()).getConfiguration(jwt, BLANK);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl", (String)"479", (Object)this, (Object[])new Object[]{props});
            }
            if (config != null && config.getProperties() != null) {
                this.jwtRef = this.trimIt((String)config.getProperties().get(CFG_KEY_jwtRef));
                this.jwtClaims = this.trimIt((String[])config.getProperties().get(CFG_KEY_jwtClaims));
            }
        }
        this.authzRequestParamMap = this.populateCustomRequestParameterMap(props, CFG_KEY_AUTHZ_PARAM);
        this.tokenRequestParamMap = this.populateCustomRequestParameterMap(props, CFG_KEY_TOKEN_PARAM);
        this.userinfoRequestParamMap = this.populateCustomRequestParameterMap(props, CFG_KEY_USERINFO_PARAM);
        this.jwkRequestParamMap = this.populateCustomRequestParameterMap(props, CFG_KEY_JWK_PARAM);
        this.resources = this.trimIt((String[])props.get(CFG_KEY_RESOURCES));
        this.headerName = this.trimIt((String)props.get(CFG_KEY_HEADER_NAME));
        this.authnSessionDisabled = (Boolean)props.get(CFG_KEY_propagation_authnSessionDisabled);
        this.reAuthnOnAccessTokenExpire = (Boolean)props.get(CFG_KEY_reAuthnOnAccessTokenExpire);
        this.reAuthnCushionMilliseconds = (Long)props.get(CFG_KEY_reAuthnCushionMilliseconds);
        this.disableIssChecking = (Boolean)props.get(CFG_KEY_DISABLE_ISS_CHECKING);
        this.goodConfig = true;
        this.accessTokenInLtpaCookie = (Boolean)props.get(CFG_KEY_accessTokenInLtpaCookie);
        this.useAccessTokenAsIdToken = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_USE_ACCESS_TOKEN_AS_ID_TOKEN, this.useAccessTokenAsIdToken);
        this.tokenReuse = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_TOKEN_REUSE, this.tokenReuse);
        this.forwardLoginParameter = this.oidcConfigUtils.readAndSanitizeForwardLoginParameter(props, this.id, CFG_KEY_FORWARD_LOGIN_PARAMETER);
        if (this.discovery) {
            this.logDiscoveryMessage("OIDC_CLIENT_DISCOVERY_COMPLETE");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("id: " + this.id), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("grantType: " + this.grantType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("responseType:" + this.responseType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("scope: " + this.scope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientId: " + this.clientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectToRPHostAndPort: " + this.redirectToRPHostAndPort), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userIdentifier: " + this.userIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupIdentifier: " + this.groupIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmIdentifier: " + this.realmIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmName: " + this.realmName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("uniqueUserIdentifier: " + this.uniqueUserIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointAuthMethod: " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userIdentityToCreateSubject: " + this.userIdentityToCreateSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapIdentityToRegistryUser: " + this.mapIdentityToRegistryUser), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("oidcclientRequestParameterSupported: " + this.oidcclientRequestParameterSupported), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("validateAccessTokenLocally: " + this.validateAccessTokenLocally), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("disableLtpaCookie:" + this.disableLtpaCookie), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("trustAliasName: " + this.trustAliasName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("httpsRequired: " + this.httpsRequired), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("isClientSideRedirectSupported: " + this.clientSideRedirect), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("nonceEnabled: " + this.nonceEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef: " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("signatureAlgorithm: " + this.signatureAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clockSkew: " + this.clockSkewInSeconds), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("discoveryEndpointUrl: " + this.discoveryEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("discoveryPollingRate: " + this.discoveryPollingRate), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authorizationEndpointUrl: " + this.authorizationEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointUrl: " + this.tokenEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userinfoEndpointUrl: " + this.userInfoEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userInfoEndpointEnabled: " + this.userInfoEndpointEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("validationEndpointUrl: " + this.validationEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("initialStateCacheCapacity: " + this.initialStateCacheCapacity), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("issuerIdentifier: " + this.issuerIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("trustStoreRef: " + this.trustStoreRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameVerificationEnabled: " + this.hostNameVerificationEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeIdTokenInSubject: " + this.includeIdTokenInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeCustomCacheKeyInSubject: " + this.includeCustomCacheKeyInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authContextClassReference: " + this.authenticationContextClassReferenceValue), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef: " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterId: " + this.authFilterId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jsonWebKey: " + this.jsonWebKey), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwkEndpointUrl: " + this.jwkEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwkClientIdentifier: " + this.jwkClientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("prompt: " + this.prompt), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("createSession: " + this.createSession), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("inboundPropagation: " + this.inboundPropagation), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("validationMethod: " + this.validationMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("headerName: " + this.headerName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authnSessionDisabled:" + this.authnSessionDisabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("disableIssChecking:" + this.disableIssChecking), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwt builder:" + this.jwtRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectJunctionPath:" + this.redirectJunctionPath), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("accessTokenInLtpaCookie:" + this.accessTokenInLtpaCookie), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("useAccessTokenAsIdToken:" + this.useAccessTokenAsIdToken), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenReuse:" + this.tokenReuse), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("forwardLoginParameter:" + this.forwardLoginParameter), (Object[])new Object[0]);
        }
    }

    private HashMap<String, String> populateCustomRequestParameterMap(Map<String, Object> configProps, String configAttributeName) {
        HashMap<String, String> customRequestParameterMap = new HashMap<String, String>();
        String[] customRequestParameterElements = this.configUtils.getStringArrayConfigAttribute(configProps, configAttributeName);
        if (customRequestParameterElements != null && customRequestParameterElements.length > 0) {
            this.populateCustomRequestParameterMap(customRequestParameterMap, customRequestParameterElements);
        }
        return customRequestParameterMap;
    }

    private void populateCustomRequestParameterMap(HashMap<String, String> paramMapToPopulate, String[] configuredCustomRequestParams) {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        if (configAdmin == null) {
            return;
        }
        this.oidcConfigUtils.populateCustomRequestParameterMap(configAdmin, paramMapToPopulate, configuredCustomRequestParams, CFG_KEY_PARAM_NAME, CFG_KEY_PARAM_VALUE);
    }

    private void validateAuthzTokenEndpoints() {
        if (this.tokenEndpointUrl == null) {
            this.logConfigError("CONFIG_REQUIRED_ATTRIBUTE_NULL", CFG_KEY_TOKEN_ENDPOINT_URL);
        }
        if (this.authorizationEndpointUrl == null && this.getGrantType() != "implicit") {
            this.logConfigError("CONFIG_REQUIRED_ATTRIBUTE_NULL", CFG_KEY_AUTHORIZATION_ENDPOINT_URL);
        }
    }

    private void logConfigError(String key, String attrib) {
        Tr.error((TraceComponent)tc, (String)key, (Object[])new Object[]{attrib});
    }

    private void reConfigEndpointsAfterDiscoveryFailure() {
        this.authorizationEndpointUrl = null;
        this.tokenEndpointUrl = null;
        this.userInfoEndpointUrl = null;
        this.jwkEndpointUrl = null;
        this.validationEndpointUrl = null;
        this.issuerIdentifier = null;
        this.discoveryDocumentHash = null;
    }

    private void logDiscoveryMessage(String key) {
        Tr.info((TraceComponent)tc, (String)key, (Object[])new Object[]{this.getId(), this.getDiscoveryEndpointUrl()});
    }

    public boolean getUseSystemPropertiesForHttpClientConnections() {
        return this.useSystemPropertiesForHttpClientConnections;
    }

    public boolean isDiscoveryInUse() {
        return this.isValidDiscoveryUrl(this.discoveryEndpointUrl);
    }

    private void logDiscoveryWarning(Map<String, Object> props) {
        String endpoints = BLANK;
        String ep = null;
        ep = this.trimIt((String)props.get(CFG_KEY_AUTHORIZATION_ENDPOINT_URL));
        if (ep != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, CFG_KEY_AUTHORIZATION_ENDPOINT_URL);
        }
        if ((ep = this.trimIt((String)props.get(CFG_KEY_TOKEN_ENDPOINT_URL))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, CFG_KEY_TOKEN_ENDPOINT_URL);
        }
        if ((ep = this.trimIt((String)props.get(CFG_KEY_USERINFO_ENDPOINT_URL))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, CFG_KEY_USERINFO_ENDPOINT_URL);
        }
        if ((ep = this.trimIt((String)props.get(CFG_KEY_JWK_ENDPOINT_URL))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, CFG_KEY_JWK_ENDPOINT_URL);
        }
        if ((ep = this.trimIt((String)props.get(CFG_KEY_VALIDATION_ENDPOINT_URL))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, CFG_KEY_VALIDATION_ENDPOINT_URL);
        }
        if (!endpoints.isEmpty()) {
            this.logWarning("OIDC_CLIENT_DISCOVERY_OVERRIDE_EP", endpoints);
        }
        if ((ep = this.trimIt((String)props.get(CFG_KEY_ISSUER_IDENTIFIER))) != null) {
            this.logWarning("OIDC_CLIENT_DISCOVERY_OVERRIDE_ISSUER", CFG_KEY_ISSUER_IDENTIFIER);
        }
    }

    private void logWarning(String key, String endpoints) {
        Tr.warning((TraceComponent)tc, (String)key, (Object[])new Object[]{CFG_KEY_DISCOVERY_ENDPOINT_URL, endpoints, this.getId()});
    }

    private String buildDiscoveryWarning(String endpoints, String ep) {
        return endpoints.concat(ep).concat(", ");
    }

    void adjustScopes() {
        ArrayList<String> discoveryScopes = this.discoverOPConfig(this.discoveryjson.get((Object)OPDISCOVERY_SCOPES));
        if (this.isRPUsingDefault(CFG_KEY_SCOPE) && !this.opHasRPDefault(CFG_KEY_SCOPE, discoveryScopes)) {
            String supported;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("See if we need to adjusted the scopes. The original is : " + this.scope), (Object[])new Object[0]);
            }
            if ((supported = this.rpSupportsOPConfig(CFG_KEY_SCOPE, discoveryScopes)) != null) {
                Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_OVERRIDE_DEFAULT", (Object[])new Object[]{this.scope, CFG_KEY_SCOPE, supported, this.getId()});
                this.scope = supported;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The adjusted value is : " + this.scope), (Object[])new Object[0]);
                }
            }
        }
    }

    void adjustTokenEndpointAuthMethod() {
        ArrayList<String> discoveryTokenepAuthMethod = this.discoverOPConfig(this.discoveryjson.get((Object)OPDISCOVERY_TOKEN_EP_AUTH));
        if (this.isRPUsingDefault("authMethod") && !this.opHasRPDefault("authMethod", discoveryTokenepAuthMethod)) {
            String supported;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("See if we need to adjusted the token endpoint authmethod. The original is : " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            }
            if ((supported = this.rpSupportsOPConfig("authMethod", discoveryTokenepAuthMethod)) != null) {
                Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_OVERRIDE_DEFAULT", (Object[])new Object[]{this.tokenEndpointAuthMethod, CFG_KEY_TOKEN_ENDPOINT_AUTH_METHOD, supported, this.getId()});
                this.tokenEndpointAuthMethod = supported;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The adjusted value is : " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
                }
            }
        }
    }

    void adjustSignatureAlgorithm() {
        ArrayList<String> discoverySigAlgorithm = this.discoverOPConfig(this.discoveryjson.get((Object)OPDISCOVERY_IDTOKEN_SIGN_ALG));
        if (this.isRPUsingDefault("alg") && !this.opHasRPDefault("alg", discoverySigAlgorithm)) {
            String supported;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("See if we need to Adjust the signature algorithm. The original value is : " + this.signatureAlgorithm), (Object[])new Object[0]);
            }
            if ((supported = this.rpSupportsOPConfig("alg", discoverySigAlgorithm)) != null) {
                Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_OVERRIDE_DEFAULT", (Object[])new Object[]{this.signatureAlgorithm, CFG_KEY_SIGNATURE_ALGORITHM, supported, this.getId()});
                this.signatureAlgorithm = supported;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The adjusted value is : " + this.signatureAlgorithm), (Object[])new Object[0]);
                }
            }
        }
    }

    private String rpSupportsOPConfig(String key, ArrayList<String> values) {
        String rpSupportedSignatureAlgorithms = "HS256 RS256";
        String rpSupportedTokenEndpointAuthMethods = "post basic";
        String rpSupportedScopes = "openid profile";
        if ("alg".equals(key) && values != null) {
            for (String value : values) {
                if (!rpSupportedSignatureAlgorithms.contains(value)) continue;
                return value;
            }
        }
        if ("authMethod".equals(key) && values != null) {
            for (String value : values) {
                if (!rpSupportedTokenEndpointAuthMethods.contains(value = this.matchingRPValue(value))) continue;
                return value;
            }
        }
        if (CFG_KEY_SCOPE.equals(key) && values != null) {
            String scopes = null;
            for (String value : values) {
                if (!rpSupportedScopes.contains(value)) continue;
                if (scopes == null) {
                    scopes = value;
                    continue;
                }
                scopes = scopes + " " + value;
            }
            return scopes;
        }
        return null;
    }

    private String matchingRPValue(String value) {
        if ("client_secret_post".equals(value)) {
            return "post";
        }
        if ("client_secret_basic".equals(value)) {
            return "basic";
        }
        return value;
    }

    private boolean opHasRPDefault(String key, ArrayList<String> opconfig) {
        if ("authMethod".equals(key)) {
            return this.matches("client_secret_post", opconfig);
        }
        if ("alg".equals(key)) {
            return this.matches("HS256", opconfig);
        }
        if (CFG_KEY_SCOPE.equals(key)) {
            return this.matches("openid", opconfig) && this.matches("profile", opconfig);
        }
        return false;
    }

    private boolean matches(String rpdefault, ArrayList<String> opconfig) {
        for (String str : opconfig) {
            if (!rpdefault.equals(str)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String rpdefault, String rpconfig) {
        return rpconfig.equals(rpdefault);
    }

    private boolean isRPUsingDefault(String key) {
        if ("authMethod".equals(key)) {
            return this.matches("post", this.tokenEndpointAuthMethod);
        }
        if ("alg".equals(key)) {
            return this.matches("HS256", this.signatureAlgorithm);
        }
        if (CFG_KEY_SCOPE.equals(key)) {
            return this.matchesMultipleValues("openid profile", this.scope);
        }
        return false;
    }

    private boolean matchesMultipleValues(String rpdefault, String rpconfig) {
        String[] configuredScope = rpconfig.split(" ");
        if (configuredScope.length != 2) {
            return false;
        }
        for (String scope : configuredScope) {
            if (rpdefault.contains(scope)) continue;
            return false;
        }
        return true;
    }

    @FFDCIgnore(value={com.ibm.websphere.ssl.SSLException.class})
    public boolean handleDiscoveryEndpoint(String discoveryUrl) {
        boolean valid;
        block8: {
            String jsonString = null;
            valid = false;
            if (!this.isValidDiscoveryUrl(discoveryUrl)) {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_SSL_ERROR", (Object[])new Object[]{this.getId(), discoveryUrl});
                return false;
            }
            try {
                this.setNextDiscoveryTime();
                SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory(discoveryUrl, this.sslConfigurationName, (SSLSupport)this.sslSupportRef.getService());
                HttpClient client = this.createHTTPClient(sslSocketFactory, discoveryUrl, this.hostNameVerificationEnabled);
                jsonString = this.getHTTPRequestAsString(client, discoveryUrl);
                if (jsonString != null) {
                    this.parseJsonResponse(jsonString);
                    if (this.discoveryjson != null) {
                        valid = this.discoverEndpointUrls(this.discoveryjson);
                    }
                }
            }
            catch (com.ibm.websphere.ssl.SSLException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Fail to get successful discovery response : ", (Object[])new Object[]{e.getCause()});
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl", (String)"891", (Object)this, (Object[])new Object[]{discoveryUrl});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Fail to get successful discovery response : ", (Object[])new Object[]{e.getCause()});
            }
        }
        if (!valid) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_SSL_ERROR", (Object[])new Object[]{this.getId(), discoveryUrl});
        }
        return valid;
    }

    private boolean isValidDiscoveryUrl(String discoveryUrl) {
        return discoveryUrl != null && discoveryUrl.startsWith("https");
    }

    boolean discoverEndpointUrls(JSONObject json) {
        if (this.calculateDiscoveryDocumentHash(json)) {
            this.authorizationEndpointUrl = this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_AUTHZ_EP_URL));
            this.tokenEndpointUrl = this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_TOKEN_EP_URL));
            this.jwkEndpointUrl = this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_JWKS_EP_URL));
            this.userInfoEndpointUrl = this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_USERINFO_EP_URL));
            this.issuerIdentifier = this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_ISSUER));
            this.handleValidationEndpoint(json);
            if (this.invalidEndpoints() || this.invalidIssuer()) {
                return false;
            }
            this.adjustSignatureAlgorithm();
            this.adjustTokenEndpointAuthMethod();
            this.adjustScopes();
        }
        return true;
    }

    public void setNextDiscoveryTime() {
        this.nextDiscoveryTime = System.currentTimeMillis() + this.discoveryPollingRate;
    }

    public long getNextDiscoveryTime() {
        return this.nextDiscoveryTime;
    }

    private boolean calculateDiscoveryDocumentHash(JSONObject json) {
        String latestDiscoveryHash = HashUtils.digest((String)json.toString());
        boolean updated = false;
        if (this.discoveryDocumentHash == null || !this.discoveryDocumentHash.equals(latestDiscoveryHash)) {
            if (this.discoveryDocumentHash != null) {
                this.logDiscoveryMessage("OIDC_CLIENT_DISCOVERY_UPDATED_CONFIG");
            }
            updated = true;
            this.discoveryDocumentHash = latestDiscoveryHash;
        } else {
            this.logDiscoveryMessage("OIDC_CLIENT_DISCOVERY_NOT_UPDATED_CONFIG");
        }
        return updated;
    }

    public String getDiscoveryDocumentHash() {
        return this.discoveryDocumentHash;
    }

    private String discoverOPConfigSingleValue(Object object) {
        String str = null;
        if (object != null) {
            return this.jsonValue(object).get(0);
        }
        return str;
    }

    private ArrayList<String> discoverOPConfig(Object obj) {
        return this.jsonValue(obj);
    }

    private ArrayList<String> jsonValue(Object obj) {
        ArrayList<String> str = new ArrayList<String>();
        int index = 0;
        if (obj != null) {
            if (obj instanceof String) {
                str.add(index, (String)obj);
                return str;
            }
            if (obj instanceof JSONArray) {
                return this.parseJsonArray((JSONArray)obj);
            }
        }
        return null;
    }

    private ArrayList<String> parseJsonArray(JSONArray jsonArrayOfStrings) {
        ArrayList<String> jsonString = new ArrayList<String>();
        int index = 0;
        if (jsonArrayOfStrings != null) {
            for (Object strObj : jsonArrayOfStrings) {
                if (!(strObj instanceof String)) continue;
                jsonString.add(index, (String)strObj);
                ++index;
            }
        }
        return jsonString;
    }

    private boolean invalidIssuer() {
        return this.issuerIdentifier == null;
    }

    private boolean invalidEndpoints() {
        return this.authorizationEndpointUrl == null && this.tokenEndpointUrl == null;
    }

    private void handleValidationEndpoint(JSONObject json) {
        this.validationEndpointUrl = this.isIntrospectionValidation() ? this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_INTROSPECTION_EP_URL)) : this.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_USERINFO_EP_URL));
    }

    private boolean isIntrospectionValidation() {
        return "introspect".equals(this.validationMethod);
    }

    /*
     * WARNING - void declaration
     */
    protected void parseJsonResponse(String jsonString) {
        block2: {
            try {
                this.discoveryjson = JSONObject.parse((String)jsonString);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl", (String)"1079", (Object)this, (Object[])new Object[]{jsonString});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={Exception.class})
    protected String getHTTPRequestAsString(HttpClient httpClient, String url) throws Exception {
        String json;
        block8: {
            json = null;
            HttpGet request = new HttpGet(url);
            request.addHeader("content-type", "application/json");
            HttpResponse result = null;
            try {
                result = httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException iOException) {
                void ioex;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl", (String)"1096", (Object)this, (Object[])new Object[]{httpClient, url});
                this.logErrorMessage(url, 0, "IOException: " + ioex.getMessage() + " " + ioex.getCause());
                throw ioex;
            }
            StatusLine statusLine = result.getStatusLine();
            int iStatusCode = statusLine.getStatusCode();
            if (iStatusCode == 200) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Response: ", (Object[])new Object[]{json});
                }
                if (json == null || json.isEmpty()) {
                    throw new Exception(this.logErrorMessage(url, iStatusCode, json));
                }
                break block8;
            }
            String errMsg = statusLine.getReasonPhrase();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("status:" + iStatusCode + " errorMsg:" + errMsg), (Object[])new Object[0]);
            }
            throw new Exception(this.logErrorMessage(url, iStatusCode, errMsg));
        }
        return json;
    }

    private String logErrorMessage(String url, int iStatusCode, String errMsg) {
        String defaultMessage = "Error processing discovery request";
        String message = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages", (String)"OIDC_CLIENT_DISC_RESPONSE_ERROR", (Object[])new Object[]{url, iStatusCode, errMsg}, (String)defaultMessage);
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return message;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification) {
        HttpClient client = null;
        boolean addBasicAuthHeader = false;
        BasicCredentialsProvider credentialsProvider = null;
        if (addBasicAuthHeader) {
            credentialsProvider = this.createCredentialsProvider();
        }
        client = this.createHttpClient(url.startsWith("https:"), isHostnameVerification, sslSocketFactory, addBasicAuthHeader, credentialsProvider);
        return client;
    }

    private HttpClient createHttpClient(boolean isSecure, boolean isHostnameVerification, SSLSocketFactory sslSocketFactory, boolean addBasicAuthHeader, BasicCredentialsProvider credentialsProvider) {
        CloseableHttpClient client = null;
        if (isSecure) {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = addBasicAuthHeader ? HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build() : HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        } else {
            client = addBasicAuthHeader ? HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build() : HttpClientBuilder.create().build();
        }
        return client;
    }

    private BasicCredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.jwkClientId, this.jwkClientSecret));
        return credentialsProvider;
    }

    @FFDCIgnore(value={SSLException.class})
    protected SSLSocketFactory getSSLSocketFactory(String requestUrl, String sslConfigurationName, SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        SSLSocketFactory sslSocketFactory = null;
        try {
            if (sslSupport != null) {
                sslSocketFactory = sslSupport.getSSLSocketFactory(sslConfigurationName);
            }
        }
        catch (SSLException e) {
            throw new com.ibm.websphere.ssl.SSLException(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslSocketFactory () get: " + sslSocketFactory), (Object[])new Object[0]);
        }
        if (sslSocketFactory == null) {
            throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", this.getId()}));
        }
        return sslSocketFactory;
    }

    private void checkForValidValue(String userIdentityToCreateSubject) {
        if (userIdentityToCreateSubject == null || userIdentityToCreateSubject.isEmpty()) {
            this.userIdentityToCreateSubject = "sub";
        }
    }

    private void checkValidationEndpointUrl() {
        if (this.validationEndpointUrl == null || !this.validationEndpointUrl.startsWith("http") || this.validationEndpointUrl.indexOf("/") < 0) {
            if ("required".equalsIgnoreCase(this.inboundPropagation)) {
                this.goodConfig = false;
                Tr.error((TraceComponent)tc, (String)"BAD_INBOUND_PRPAGATION_REQUIRED", (Object[])new Object[]{this.getId(), this.validationEndpointUrl});
            } else if ("supported".equalsIgnoreCase(this.inboundPropagation)) {
                this.inboundPropagation = "none";
                Tr.warning((TraceComponent)tc, (String)"BAD_INBOUND_PRPAGATION_SUPPORTED", (Object[])new Object[]{this.validationEndpointUrl, this.getId()});
            }
        }
    }

    @Sensitive
    private String processProtectedString(Map<String, Object> props, String cfgKey) {
        Object o = props.get(cfgKey);
        String secret = o != null ? (o instanceof SerializableProtectedString ? new String(((SerializableProtectedString)o).getChars()) : (String)o) : null;
        secret = PasswordUtil.passwordDecode(secret);
        return secret;
    }

    public synchronized String getId() {
        return this.id;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    @Sensitive
    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUrlFromServerToClient() {
        return new OIDCClientAuthenticatorUtil().getRedirectUrlFromServerToClient(this.getId(), this.getContextPath(), this.redirectToRPHostAndPort);
    }

    public String getRedirectUrlWithJunctionPath(String redirectURL) {
        if (this.redirectJunctionPath != null && this.redirectJunctionPath.length() > 0 && redirectURL != null && redirectURL.length() > 0) {
            int hostnameloc = redirectURL.indexOf("//");
            int pathBegin = redirectURL.indexOf("/", hostnameloc + 2);
            redirectURL = redirectURL.substring(0, pathBegin) + this.redirectJunctionPath + redirectURL.substring(pathBegin);
        }
        return redirectURL;
    }

    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public String getRealmIdentifier() {
        return this.realmIdentifier;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUniqueUserIdentifier() {
        return this.uniqueUserIdentifier;
    }

    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public String getUserIdentityToCreateSubject() {
        return this.userIdentityToCreateSubject;
    }

    public boolean isMapIdentityToRegistryUser() {
        return this.mapIdentityToRegistryUser;
    }

    public boolean isValidateAccessTokenLocally() {
        return this.validateAccessTokenLocally;
    }

    @Sensitive
    public String getSharedKey() {
        if (this.sharedKey != null) {
            return this.sharedKey;
        }
        return this.clientSecret;
    }

    public String getTrustAliasName() {
        return this.trustAliasName;
    }

    public boolean isHttpsRequired() {
        return this.httpsRequired;
    }

    public boolean isClientSideRedirect() {
        return this.clientSideRedirect;
    }

    public boolean isNonceEnabled() {
        return this.nonceEnabled;
    }

    public String getSslRef() {
        return this.sslRef;
    }

    public String getSSLConfigurationName() {
        return this.sslConfigurationName;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public long getClockSkewInSeconds() {
        return this.clockSkewInSeconds;
    }

    public long getAuthenticationTimeLimitInSeconds() {
        return this.authenticationTimeLimitInSeconds;
    }

    public String getAuthorizationEndpointUrl() {
        return this.authorizationEndpointUrl;
    }

    public String getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public String getValidationEndpointUrl() {
        return this.validationEndpointUrl;
    }

    public int getInitialStateCacheCapacity() {
        return this.initialStateCacheCapacity;
    }

    public String getIssuerIdentifier() {
        return this.issuerIdentifier;
    }

    public String getTrustStoreRef() {
        return this.trustStoreRef;
    }

    public PublicKey getPublicKey() throws KeyStoreException, CertificateException {
        KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
        return keyStoreService.getCertificateFromKeyStore(this.trustStoreRef, this.trustAliasName).getPublicKey();
    }

    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    public boolean isIncludeIdTokenInSubject() {
        return this.includeIdTokenInSubject;
    }

    public boolean isIncludeCustomCacheKeyInSubject() {
        return this.includeCustomCacheKeyInSubject;
    }

    public String getAuthContextClassReference() {
        return this.authenticationContextClassReferenceValue;
    }

    public String getAuthFilterId() {
        return this.authFilterId;
    }

    /*
     * WARNING - void declaration
     */
    private String getAuthFilterId(String authFilterRef) {
        if (authFilterRef == null || authFilterRef.isEmpty()) {
            return null;
        }
        Configuration config = null;
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            if (configAdmin != null) {
                config = configAdmin.getConfiguration(authFilterRef, null);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl", (String)"1563", (Object)this, (Object[])new Object[]{authFilterRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid authFilterRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        if (config == null) {
            return null;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return null;
        }
        String id = (String)props.get(CFG_KEY_ID);
        return id;
    }

    public String getJwkEndpointUrl() {
        return this.jwkEndpointUrl;
    }

    public JWKSet getJwkSet() {
        return this.jwkset;
    }

    public String getJsonWebKey() {
        return this.jsonWebKey;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean createSession() {
        return this.createSession;
    }

    public String getInboundPropagation() {
        return this.inboundPropagation;
    }

    public String getValidationMethod() {
        return this.validationMethod;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public boolean isDisableLtpaCookie() {
        return this.disableLtpaCookie;
    }

    public String getOidcClientCookieName() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)locationAdminRef.getService();
        if (this.oidcClientCookieName == null || this.oidcClientCookieName.isEmpty()) {
            String cookieLongName = BLANK;
            if (locationAdmin != null) {
                String usrLocation = locationAdmin.resolveString("${wlp.user.dir}").replace('\\', '/');
                String slash = usrLocation.endsWith("/") ? BLANK : "/";
                cookieLongName = FileInfo.getHostName() + "_" + usrLocation + slash + "servers/" + locationAdmin.getServerName() + "/oidcclient/" + this.getId();
            } else {
                Tr.error((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"WsLocationAdmin"});
                cookieLongName = this.clientId;
            }
            this.oidcClientCookieName = "WASOidcClient_" + OidcClientConfigImpl.hash(cookieLongName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cookieHashName: " + this.oidcClientCookieName + " cookieLongName: " + cookieLongName), (Object[])new Object[0]);
            }
        }
        return this.oidcClientCookieName;
    }

    public static String hash(String stringToEncrypt) {
        int hashCode = stringToEncrypt.hashCode();
        if (hashCode < 0) {
            return "n" + (hashCode *= -1);
        }
        return "p" + hashCode;
    }

    public boolean isAuthnSessionDisabled_propagation() {
        return this.authnSessionDisabled;
    }

    public boolean isValidConfig() {
        return this.goodConfig;
    }

    public boolean isReAuthnOnAccessTokenExpire() {
        return this.reAuthnOnAccessTokenExpire;
    }

    public long getReAuthnCushion() {
        return this.reAuthnCushionMilliseconds;
    }

    public boolean disableIssChecking() {
        return this.disableIssChecking;
    }

    String trimIt(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    String[] trimIt(String[] strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        String[] results = new String[strings.length];
        int iCnt = 0;
        for (int iI = 0; iI < strings.length; ++iI) {
            String result = this.trimIt(strings[iI]);
            if (result == null) continue;
            results[iCnt++] = result;
        }
        if (iCnt == strings.length) {
            return results;
        }
        if (iCnt > 0) {
            String[] newResults = new String[iCnt];
            System.arraycopy(results, 0, newResults, 0, iCnt);
            return newResults;
        }
        return null;
    }

    public List<String> getAudiences() {
        if (this.audiences != null) {
            ArrayList<String> audList = new ArrayList<String>();
            for (String aud : this.audiences) {
                audList.add(aud);
            }
            return audList;
        }
        return null;
    }

    public boolean allowedAllAudiences() {
        return this.allAudiences;
    }

    public String[] getResources() {
        if (this.resources != null) {
            return (String[])this.resources.clone();
        }
        return null;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public boolean isOidcclientRequestParameterSupported() {
        return this.oidcclientRequestParameterSupported;
    }

    public String getContextPath() {
        return contextPath;
    }

    public static void setContextPath(String ctx) {
        contextPath = ctx;
    }

    public String jwtRef() {
        return this.jwtRef;
    }

    public String[] getJwtClaims() {
        if (this.jwtClaims != null) {
            return (String[])this.jwtClaims.clone();
        }
        return null;
    }

    public String getJwkClientId() {
        return this.jwkClientId;
    }

    @Sensitive
    public String getJwkClientSecret() {
        return this.jwkClientSecret;
    }

    public boolean getAccessTokenInLtpaCookie() {
        return this.accessTokenInLtpaCookie;
    }

    public boolean getTokenReuse() {
        return this.tokenReuse;
    }

    public boolean getUseAccessTokenAsIdToken() {
        return this.useAccessTokenAsIdToken;
    }

    public List<String> getForwardLoginParameter() {
        if (this.forwardLoginParameter != null) {
            return new ArrayList<String>(this.forwardLoginParameter);
        }
        return null;
    }

    public boolean isSocial() {
        return false;
    }

    public OidcClientConfig getOidcClientConfig() {
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("Id: " + this.id);
        sb.append(" clientId: " + this.clientId);
        sb.append(" grantType: " + this.grantType);
        sb.append(" responseType: " + this.responseType);
        sb.append(" scope: " + this.scope);
        sb.append(" redirectToRPHostAndPort: " + this.redirectToRPHostAndPort);
        sb.append(" issuerIdentifier: " + this.issuerIdentifier);
        sb.append(" tokenEndpointUrl: " + this.tokenEndpointUrl);
        sb.append(" userInfoEndpointUrl: " + this.userInfoEndpointUrl);
        sb.append("}");
        return sb.toString();
    }

    public boolean isUserInfoEnabled() {
        return this.userInfoEndpointEnabled;
    }

    public String getUserInfoEndpointUrl() {
        return this.userInfoEndpointUrl;
    }

    public String getDiscoveryEndpointUrl() {
        return this.discoveryEndpointUrl;
    }

    public HashMap<String, String> getAuthzRequestParams() {
        return this.authzRequestParamMap;
    }

    public HashMap<String, String> getTokenRequestParams() {
        return this.tokenRequestParamMap;
    }

    public HashMap<String, String> getUserinfoRequestParams() {
        return this.userinfoRequestParamMap;
    }

    public HashMap<String, String> getJwkRequestParams() {
        return this.jwkRequestParamMap;
    }
}

