/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl;

import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRebalanceListener;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecords;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaConsumer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetCommitCallback;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.WakeupException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.AbstractKafkaAdapter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.ConsumerRebalanceListenerImpl;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.ConsumerRecordsImpl;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.OffsetAndMetadataImpl;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.TopicPartitionImpl;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KafkaConsumerImpl<K, V>
extends AbstractKafkaAdapter<org.apache.kafka.clients.consumer.KafkaConsumer<K, V>>
implements KafkaConsumer<K, V> {
    private static final String CLAZZ = KafkaConsumerImpl.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLAZZ);

    public KafkaConsumerImpl(Map<String, Object> consumerConfig) {
        super(new org.apache.kafka.clients.consumer.KafkaConsumer(consumerConfig));
    }

    public void wakeup() {
        ((org.apache.kafka.clients.consumer.KafkaConsumer)this.getDelegate()).wakeup();
    }

    public void close() {
        ((org.apache.kafka.clients.consumer.KafkaConsumer)this.getDelegate()).close();
    }

    public void subscribe(Collection<String> topics) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "subscribe", "Topics: {0}", topics);
        }
        ((org.apache.kafka.clients.consumer.KafkaConsumer)this.getDelegate()).subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "subscribe", "Topics: {0}", topics);
        }
        ConsumerRebalanceListenerImpl delegateListener = new ConsumerRebalanceListenerImpl(listener);
        ((org.apache.kafka.clients.consumer.KafkaConsumer)this.getDelegate()).subscribe(topics, (org.apache.kafka.clients.consumer.ConsumerRebalanceListener)delegateListener);
    }

    public ConsumerRecords<K, V> poll(Duration duration) {
        org.apache.kafka.clients.consumer.ConsumerRecords delegateRecords;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "poll", "Duration: {0}", duration);
        }
        try {
            delegateRecords = ((org.apache.kafka.clients.consumer.KafkaConsumer)this.getDelegate()).poll(duration);
        }
        catch (org.apache.kafka.common.errors.WakeupException dwe) {
            throw new WakeupException((Throwable)dwe);
        }
        ConsumerRecordsImpl records = new ConsumerRecordsImpl(delegateRecords);
        return records;
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "commitAsync", "Offsets: {0}", offsets);
        }
        Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> delegateOffsets = this.unwrap(offsets);
        org.apache.kafka.clients.consumer.OffsetCommitCallback delegateOffsetCommitCallback = (o, e) -> {
            Map delOffsets = o;
            Map<TopicPartition, OffsetAndMetadata> offsetsx = this.wrap(delOffsets);
            callback.onComplete(offsetsx, e);
        };
        ((org.apache.kafka.clients.consumer.KafkaConsumer)this.getDelegate()).commitAsync(delegateOffsets, delegateOffsetCommitCallback);
    }

    private Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> unwrap(Map<TopicPartition, OffsetAndMetadata> offsets) {
        HashMap<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> delegateOffsets = new HashMap<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata>();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            TopicPartitionImpl topicPartition = (TopicPartitionImpl)entry.getKey();
            org.apache.kafka.common.TopicPartition delegateTopicPartition = (org.apache.kafka.common.TopicPartition)topicPartition.getDelegate();
            OffsetAndMetadataImpl offsetAndMetadata = (OffsetAndMetadataImpl)entry.getValue();
            org.apache.kafka.clients.consumer.OffsetAndMetadata delegateOffsetAndMetadata = (org.apache.kafka.clients.consumer.OffsetAndMetadata)offsetAndMetadata.getDelegate();
            delegateOffsets.put(delegateTopicPartition, delegateOffsetAndMetadata);
        }
        return delegateOffsets;
    }

    private Map<TopicPartition, OffsetAndMetadata> wrap(Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> delegateOffsets) {
        HashMap<TopicPartition, OffsetAndMetadata> offsetsx = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (Map.Entry<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> entry : delegateOffsets.entrySet()) {
            org.apache.kafka.common.TopicPartition delegateTopicPartition = entry.getKey();
            TopicPartitionImpl topicPartitionx = new TopicPartitionImpl(delegateTopicPartition);
            org.apache.kafka.clients.consumer.OffsetAndMetadata delegateOffsetAndMetadata = entry.getValue();
            OffsetAndMetadataImpl offsetAndMetadatax = new OffsetAndMetadataImpl(delegateOffsetAndMetadata);
            offsetsx.put(topicPartitionx, offsetAndMetadatax);
        }
        return offsetsx;
    }
}

