/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.data.Pair;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class CollectorJsonHelpers {
    private static String startMessageJson = null;
    private static String startMessageJson1_1 = null;
    private static String startMessageJsonFields = null;
    private static String startTraceJson = null;
    private static String startTraceJson1_1 = null;
    private static String startTraceJsonFields = null;
    private static String startFFDCJson = null;
    private static String startFFDCJson1_1 = null;
    private static String startFFDCJsonFields = null;
    private static String startAccessLogJson = null;
    private static String startAccessLogJson1_1 = null;
    private static String startAccessLogJsonFields = null;
    private static String startGCJson = null;
    private static String startGCJson1_1 = null;
    private static String startAuditJson = null;
    private static String startAuditJson1_1 = null;
    private static String startAuditJsonFields = null;
    private static final String TYPE_FIELD_PREPPEND = "\"type\":\"";
    private static final String TYPE_FIELD_APPEND = "\"";
    private static final String MESSAGE_JSON_TYPE_FIELD = "\"type\":\"liberty_message\"";
    private static final String TRACE_JSON_TYPE_FIELD = "\"type\":\"liberty_trace\"";
    private static final String ACCESS_JSON_TYPE_FIELD = "\"type\":\"liberty_accesslog\"";
    private static final String FFDC_JSON_TYPE_FIELD = "\"type\":\"liberty_ffdc\"";
    private static final String GC_JSON_TYPE_FIELD = "\"type\":\"liberty_gc\"";
    private static final String AUDIT_JSON_TYPE_FIELD = "\"type\":\"liberty_audit\"";
    private static String unchangingFieldsJson = null;
    private static String unchangingFieldsJson1_1 = null;
    private static String unchangingFieldsJson_Audit = null;
    private static String unchangingFieldsJson_Message = null;
    private static String unchangingFieldsJson_Trace = null;
    private static String unchangingFieldsJson_AccessLog = null;
    private static String unchangingFieldsJson_FFDC = null;
    public static final String TRUE_BOOL = "true";
    public static final String FALSE_BOOL = "false";
    public static final String INT_SUFFIX = "_int";
    public static final String FLOAT_SUFFIX = "_float";
    public static final String BOOL_SUFFIX = "_bool";
    public static final String LONG_SUFFIX = "_long";
    public static final String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    protected static ThreadLocal<BurstDateFormat> dateFormatTL = new ThreadLocal<BurstDateFormat>(){

        @Override
        protected BurstDateFormat initialValue() {
            return new BurstDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        }
    };

    protected static String getEventType(String source, String location) {
        if (source.equals("com.ibm.ws.health.center.source.gcsource") && location.equals("memory")) {
            return "liberty_gc";
        }
        if (source.equals("com.ibm.ws.logging.source.message") && location.equals("memory")) {
            return "liberty_message";
        }
        if (source.endsWith("com.ibm.ws.logging.source.trace") && location.equals("memory")) {
            return "liberty_trace";
        }
        if (source.endsWith("com.ibm.ws.logging.ffdc.source.ffdcsource") && location.equals("memory")) {
            return "liberty_ffdc";
        }
        if (source.endsWith("com.ibm.ws.http.logging.source.accesslog") && location.equals("memory")) {
            return "liberty_accesslog";
        }
        if (source.contains("audit")) {
            return "liberty_audit";
        }
        return "";
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField) {
        boolean b = CollectorJsonHelpers.addToJSON(sb, name, value, jsonEscapeName, jsonEscapeValue, trim, isFirstField, false);
        return b;
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField, boolean isQuoteless) {
        if (name == null || value == null) {
            return false;
        }
        if (!isFirstField) {
            sb.append(",");
        }
        if (trim) {
            value = value.trim();
        }
        sb.append(TYPE_FIELD_APPEND);
        if (jsonEscapeName) {
            CollectorJsonHelpers.jsonEscape3(sb, name);
        } else {
            sb.append(name);
        }
        if (isQuoteless) {
            sb.append("\":");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
        } else {
            sb.append("\":\"");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
            sb.append(TYPE_FIELD_APPEND);
        }
        return true;
    }

    protected static void jsonEscape3(StringBuilder sb, String s) {
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static void addUnchangingFields(StringBuilder sb, String hostName, String wlpUserDir, String serverName) {
        if (unchangingFieldsJson == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, "hostName", hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, "wlpUserDir", wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, "serverName", serverName, false, false, false, false);
            unchangingFieldsJson = temp.toString();
        }
        sb.append(unchangingFieldsJson);
    }

    private static void addUnchangingFields1_1(StringBuilder sb, String hostName, String wlpUserDir, String serverName) {
        if (unchangingFieldsJson1_1 == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, "host", hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, "ibm_userDir", wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, "ibm_serverName", serverName, false, false, false, false);
            unchangingFieldsJson1_1 = temp.toString();
        }
        sb.append(unchangingFieldsJson1_1);
    }

    private static void addUnchangingFieldsJSON_Message(StringBuilder sb, String hostName, String wlpUserDir, String serverName, boolean isMessageEvent) {
        if (unchangingFieldsJson_Message == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, LogTraceData.getHostKeyJSON(isMessageEvent), hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, LogTraceData.getUserDirKeyJSON(isMessageEvent), wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, LogTraceData.getServerNameKeyJSON(isMessageEvent), serverName, false, false, false, false);
            unchangingFieldsJson_Message = temp.toString();
        }
        sb.append(unchangingFieldsJson_Message);
    }

    private static void addUnchangingFieldsJSON_Trace(StringBuilder sb, String hostName, String wlpUserDir, String serverName, boolean isMessageEvent) {
        if (unchangingFieldsJson_Trace == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, LogTraceData.getHostKeyJSON(isMessageEvent), hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, LogTraceData.getUserDirKeyJSON(isMessageEvent), wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, LogTraceData.getServerNameKeyJSON(isMessageEvent), serverName, false, false, false, false);
            unchangingFieldsJson_Trace = temp.toString();
        }
        sb.append(unchangingFieldsJson_Trace);
    }

    private static void addUnchangingFieldsJSON_AccessLog(StringBuilder sb, String hostName, String wlpUserDir, String serverName) {
        if (unchangingFieldsJson_AccessLog == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, AccessLogData.getHostKeyJSON(), hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, AccessLogData.getUserDirKeyJSON(), wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, AccessLogData.getServerNameKeyJSON(), serverName, false, false, false, false);
            unchangingFieldsJson_AccessLog = temp.toString();
        }
        sb.append(unchangingFieldsJson_AccessLog);
    }

    private static void addUnchangingFieldsJSON_FFDC(StringBuilder sb, String hostName, String wlpUserDir, String serverName) {
        if (unchangingFieldsJson_FFDC == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, FFDCData.getHostKeyJSON(), hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, FFDCData.getUserDirKeyJSON(), wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, FFDCData.getServerNameKeyJSON(), serverName, false, false, false, false);
            unchangingFieldsJson_FFDC = temp.toString();
        }
        sb.append(unchangingFieldsJson_FFDC);
    }

    private static void addUnchangingFieldsJSON_Audit(StringBuilder sb, String hostName, String wlpUserDir, String serverName) {
        if (unchangingFieldsJson_Audit == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, AuditData.getHostKeyJSON(), hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, AuditData.getUserDirKeyJSON(), wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, AuditData.getServerNameKeyJSON(), serverName, false, false, false, false);
            unchangingFieldsJson_Audit = temp.toString();
        }
        sb.append(unchangingFieldsJson_Audit);
    }

    protected static StringBuilder startMessageJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startMessageJson != null) {
            sb.append(startMessageJson);
        } else {
            sb.append("{");
            sb.append(MESSAGE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startMessageJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startTraceJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startTraceJson != null) {
            sb.append(startTraceJson);
        } else {
            sb.append("{");
            sb.append(TRACE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startTraceJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startFFDCJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startFFDCJson != null) {
            sb.append(startFFDCJson);
        } else {
            sb.append("{");
            sb.append(FFDC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startFFDCJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAccessLogJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startAccessLogJson != null) {
            sb.append(startAccessLogJson);
        } else {
            sb.append("{");
            sb.append(ACCESS_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startAccessLogJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startGCJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startGCJson != null) {
            sb.append(startGCJson);
        } else {
            sb.append("{");
            sb.append(GC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startGCJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAuditJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(2048);
        if (startAuditJson != null) {
            sb.append(startAuditJson);
        } else {
            sb.append("{");
            sb.append(AUDIT_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startAuditJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAuditJson1_1(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(2048);
        if (startAuditJson1_1 != null) {
            sb.append(startAuditJson1_1);
        } else {
            sb.append("{");
            sb.append(AUDIT_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields1_1(sb, hostName, wlpUserDir, serverName);
            startAuditJson1_1 = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startMessageJson1_1(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startMessageJson1_1 != null) {
            sb.append(startMessageJson1_1);
        } else {
            sb.append("{");
            sb.append(MESSAGE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields1_1(sb, hostName, wlpUserDir, serverName);
            startMessageJson1_1 = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startTraceJson1_1(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startTraceJson1_1 != null) {
            sb.append(startTraceJson1_1);
        } else {
            sb.append("{");
            sb.append(TRACE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields1_1(sb, hostName, wlpUserDir, serverName);
            startTraceJson1_1 = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startFFDCJson1_1(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startFFDCJson1_1 != null) {
            sb.append(startFFDCJson1_1);
        } else {
            sb.append("{");
            sb.append(FFDC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields1_1(sb, hostName, wlpUserDir, serverName);
            startFFDCJson1_1 = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAccessLogJson1_1(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startAccessLogJson1_1 != null) {
            sb.append(startAccessLogJson1_1);
        } else {
            sb.append("{");
            sb.append(ACCESS_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields1_1(sb, hostName, wlpUserDir, serverName);
            startAccessLogJson1_1 = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startGCJson1_1(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startGCJson1_1 != null) {
            sb.append(startGCJson1_1);
        } else {
            sb.append("{");
            sb.append(GC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields1_1(sb, hostName, wlpUserDir, serverName);
            startGCJson1_1 = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAuditJsonFields(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(2048);
        if (startAuditJsonFields != null) {
            sb.append(startAuditJsonFields);
        } else {
            sb.append("{");
            sb.append(AUDIT_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFieldsJSON_Audit(sb, hostName, wlpUserDir, serverName);
            startAuditJsonFields = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startMessageJsonFields(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startMessageJsonFields != null) {
            sb.append(startMessageJsonFields);
        } else {
            sb.append("{");
            sb.append(MESSAGE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFieldsJSON_Message(sb, hostName, wlpUserDir, serverName, true);
            startMessageJsonFields = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startTraceJsonFields(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startTraceJsonFields != null) {
            sb.append(startTraceJsonFields);
        } else {
            sb.append("{");
            sb.append(TRACE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFieldsJSON_Trace(sb, hostName, wlpUserDir, serverName, false);
            startTraceJsonFields = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startFFDCJsonFields(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startFFDCJsonFields != null) {
            sb.append(startFFDCJsonFields);
        } else {
            sb.append("{");
            sb.append(FFDC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFieldsJSON_FFDC(sb, hostName, wlpUserDir, serverName);
            startFFDCJsonFields = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAccessLogJsonFields(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startAccessLogJsonFields != null) {
            sb.append(startAccessLogJsonFields);
        } else {
            sb.append("{");
            sb.append(ACCESS_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFieldsJSON_AccessLog(sb, hostName, wlpUserDir, serverName);
            startAccessLogJsonFields = sb.toString();
        }
        return sb;
    }

    protected static String formatMessage(String message, int maxLength) {
        return message.length() > maxLength && maxLength > 0 ? message.substring(0, maxLength) + "..." : message;
    }

    protected static String removeIBMTag(String s) {
        s = s.replace("ibm_", "");
        return s;
    }

    protected static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"tags\":");
        return sb;
    }

    protected static String jsonifyTags(String[] tags) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
            if (tags[i].contains(" ") || tags[i].contains("-")) continue;
            sb.append(TYPE_FIELD_APPEND);
            CollectorJsonHelpers.jsonEscape3(sb, tags[i]);
            sb.append(TYPE_FIELD_APPEND);
            if (i == tags.length - 1) continue;
            sb.append(",");
        }
        if (sb.toString().lastIndexOf(",") == sb.toString().length() - 1) {
            sb.delete(sb.toString().lastIndexOf(","), sb.toString().lastIndexOf(",") + 1);
        }
        sb.append("]");
        return sb.toString();
    }

    protected static String jsonRemoveSpace(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isLine = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append(c);
                isLine = true;
                continue;
            }
            if (c == ' ' && isLine) continue;
            if (isLine && c != ' ') {
                isLine = false;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static String getLogLevel(ArrayList<Pair> pairs) {
        KeyValuePair kvp = null;
        String loglevel = null;
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair) || !(kvp = (KeyValuePair)((Object)p)).getKey().equals("loglevel")) continue;
            loglevel = kvp.getStringValue();
            break;
        }
        return loglevel;
    }

    public static void handleExtensions(KeyValuePairList extensions, String extKey, String extValue) {
        extKey = "ext_" + extKey;
        if (extKey.indexOf(95, 4) != -1) {
            if (extKey.endsWith(INT_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Integer.parseInt(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (extKey.endsWith(FLOAT_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Float.parseFloat(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (extKey.endsWith(BOOL_SUFFIX)) {
                if (extValue.toLowerCase().trim().equals(TRUE_BOOL)) {
                    extensions.addKeyValuePair(extKey, true);
                } else if (extValue.toLowerCase().trim().equals(FALSE_BOOL)) {
                    extensions.addKeyValuePair(extKey, false);
                }
            } else if (extKey.endsWith(LONG_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Long.parseLong(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                extensions.addKeyValuePair(extKey, extValue);
            }
        } else {
            extensions.addKeyValuePair(extKey, extValue);
        }
    }
}

