/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveIOException;
import com.ibm.ws.repository.parsers.internal.ManifestInfo;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.SampleResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SamplesParser
extends ParserBase
implements Parser<SampleResourceWritable> {
    static final long serialVersionUID = 157356619005018817L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    @Override
    public SampleResourceWritable parseFileToResource(File assetFile, File metadataFile, String contentUrl) throws RepositoryException {
        JarFile jar;
        ParserBase.ArtifactMetadata artifactMetadata = this.explodeArtifact(assetFile, metadataFile);
        if (artifactMetadata == null) {
            throw new RepositoryArchiveException("Unable to find sibling metadata zip for " + assetFile.getName() + " so do not have the required information", assetFile);
        }
        try {
            jar = new JarFile(assetFile);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.SamplesParser", (String)"49", (Object)this, (Object[])new Object[]{assetFile, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), assetFile, (Throwable)e);
        }
        ManifestInfo mi = ManifestInfo.parseManifest(jar);
        SampleResourceWritable resource = WritableResourceFactory.createSample(null, (ResourceType)mi.getType());
        this.setCommonFieldsFromSideZip(artifactMetadata, (RepositoryResourceWritable)resource);
        resource.setProviderName(mi.getProviderName());
        resource.setAppliesTo(mi.getAppliesTo());
        resource.setRequireFeature(mi.getRequiredFeature());
        this.addContent((RepositoryResourceWritable)resource, assetFile, assetFile.getName(), artifactMetadata, contentUrl);
        String archiveRoot = mi.getArchiveRoot();
        Pattern sampleShortNamePattern = Pattern.compile(archiveRoot + "servers/([^/]*)/server.xml");
        try {
            ZipFile zip = new ZipFile(assetFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                Matcher shortNameMatcher = sampleShortNamePattern.matcher(entryName);
                if (!shortNameMatcher.matches()) continue;
                resource.setShortName(shortNameMatcher.group(1));
                break;
            }
            zip.close();
        }
        catch (IOException zip) {
            void e;
            FFDCFilter.processException((Throwable)zip, (String)"com.ibm.ws.repository.parsers.SamplesParser", (String)"88", (Object)this, (Object[])new Object[]{assetFile, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), assetFile, (Throwable)e);
        }
        if (null != artifactMetadata && null != artifactMetadata.licenseFiles && !artifactMetadata.licenseFiles.isEmpty()) {
            if (artifactMetadata.licenseFiles.size() > 1) {
                throw new RepositoryArchiveException("There were too many licenses associated with " + assetFile.getName() + ". An English only license is expected but had: " + artifactMetadata.licenseFiles, assetFile);
            }
            resource.setLicenseType(LicenseType.UNSPECIFIED);
            resource.addLicense(artifactMetadata.licenseFiles.iterator().next(), Locale.ENGLISH);
            try {
                this.processLAandLI(assetFile, (RepositoryResourceWritable)resource, mi.getManifest());
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.SamplesParser", (String)"110", (Object)this, (Object[])new Object[]{assetFile, metadataFile, contentUrl});
                throw new RepositoryArchiveIOException(e.getMessage(), assetFile, e);
            }
        }
        return resource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.SamplesParser", SamplesParser.class, null, null);
    }
}

