/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.RetryState;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.DurationUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.PrimitiveIterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RetryStateImpl
implements RetryState {
    private final RetryPolicy policy;
    private final PrimitiveIterator.OfLong delayStream;
    private int attempts = 0;
    private long startNanos;
    private final MetricRecorder metricRecorder;
    static final long serialVersionUID = 4695743471009202524L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RetryStateImpl(RetryPolicy policy, MetricRecorder metricRecorder) {
        this.policy = policy;
        this.delayStream = RetryStateImpl.createDelayStream(policy.getDelay(), policy.getJitter());
        this.metricRecorder = metricRecorder;
    }

    @Override
    public void start() {
        this.startNanos = System.nanoTime();
    }

    @Override
    public RetryState.RetryResult recordResult(MethodResult<?> methodResult) {
        ResultCategory resultCategory = null;
        ++this.attempts;
        long duration = System.nanoTime() - this.startNanos;
        resultCategory = methodResult.isFailure() ? (this.abortOn(methodResult.getFailure()) ? ResultCategory.EXCEPTION_IN_ABORT_ON : (this.retryOn(methodResult.getFailure()) ? ResultCategory.EXCEPTION_IN_RETRY_ON : ResultCategory.EXCEPTION_NOT_IN_RETRY_ON)) : ResultCategory.NO_EXCEPTION;
        boolean resultWasRetryableFailure = RetryStateImpl.shouldRetry(resultCategory);
        if (resultWasRetryableFailure) {
            int maxAttempts = this.policy.getMaxRetries() + 1;
            if (maxAttempts != 0 && this.attempts >= maxAttempts) {
                resultCategory = ResultCategory.MAX_RETRIES_REACHED;
            } else if (this.overMaxDuration(duration)) {
                resultCategory = ResultCategory.MAX_DURATION_REACHED;
            }
        }
        if (RetryStateImpl.shouldRetry(resultCategory)) {
            this.metricRecorder.incrementRetriesCount();
        } else if (resultWasRetryableFailure) {
            this.metricRecorder.incrementRetryCallsFailureCount();
        } else if (this.attempts > 1) {
            this.metricRecorder.incrementRetryCallsSuccessRetriesCount();
        } else {
            this.metricRecorder.incrementRetryCallsSuccessImmediateCount();
        }
        return this.createResult(resultCategory);
    }

    private boolean overMaxDuration(long duration) {
        return !this.policy.getMaxDuration().isZero() && Duration.ofNanos(duration).compareTo(this.policy.getMaxDuration()) >= 0;
    }

    private boolean abortOn(Throwable failure) {
        for (Class abortClazz : this.policy.getAbortOn()) {
            if (!abortClazz.isInstance(failure)) continue;
            return true;
        }
        return false;
    }

    private boolean retryOn(Throwable failure) {
        for (Class retryClazz : this.policy.getRetryOn()) {
            if (!retryClazz.isInstance(failure)) continue;
            return true;
        }
        return false;
    }

    private RetryResultImpl createResult(ResultCategory resultCategory) {
        long delay = 0L;
        if (RetryStateImpl.shouldRetry(resultCategory) && (delay = this.delayStream.nextLong()) < 0L) {
            delay = 0L;
        }
        return new RetryResultImpl(resultCategory, delay, TimeUnit.NANOSECONDS);
    }

    private static boolean shouldRetry(ResultCategory category) {
        return category == ResultCategory.EXCEPTION_IN_RETRY_ON;
    }

    protected static PrimitiveIterator.OfLong createDelayStream(Duration delay, Duration jitter) {
        if (jitter.isZero()) {
            long delayNanos = DurationUtils.asClampedNanos(delay);
            return LongStream.generate(() -> delayNanos).iterator();
        }
        long lowerLimitNanos = DurationUtils.asClampedNanos(delay.minus(jitter));
        long upperLimitNanos = DurationUtils.asClampedNanos(delay.plus(jitter));
        return ThreadLocalRandom.current().longs(lowerLimitNanos, upperLimitNanos).iterator();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.RetryStateImpl", RetryStateImpl.class, (String)"FAULTTOLERANCE", null);
    }

    private static enum ResultCategory {
        NO_EXCEPTION("No exception thrown"),
        EXCEPTION_NOT_IN_RETRY_ON("Exception thrown does not match retryOn condition"),
        EXCEPTION_IN_RETRY_ON("Exception thrown matches retryOn condition"),
        EXCEPTION_IN_ABORT_ON("Exception thrown matches abortOn condition"),
        MAX_RETRIES_REACHED("Max retries reached"),
        MAX_DURATION_REACHED("Max duration reached");

        private final String reasonString;

        private ResultCategory(String reasonString) {
            this.reasonString = reasonString;
        }

        public String toString() {
            return this.reasonString;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RetryResultImpl
    implements RetryState.RetryResult {
        private final ResultCategory resultCategory;
        private final long delay;
        private final TimeUnit delayUnit;
        static final long serialVersionUID = -3171759617210549973L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RetryResultImpl(ResultCategory reason, long delay, TimeUnit delayUnit) {
            this.resultCategory = reason;
            this.delay = delay;
            this.delayUnit = delayUnit;
        }

        @Override
        public boolean shouldRetry() {
            return RetryStateImpl.shouldRetry(this.resultCategory);
        }

        @Override
        public long getDelay() {
            return this.delay;
        }

        @Override
        public TimeUnit getDelayUnit() {
            return this.delayUnit;
        }

        @Override
        public String toString() {
            return this.resultCategory.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.RetryStateImpl$RetryResultImpl", RetryResultImpl.class, (String)"FAULTTOLERANCE", null);
        }
    }
}

