/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncAttemptContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncExecutor;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.AsyncBulkheadState;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AsyncCompletionStageExecutor<R>
extends AsyncExecutor<CompletionStage<R>> {
    private static final TraceComponent tc = Tr.register(AsyncCompletionStageExecutor.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    private final ScheduledExecutorService executorService;
    static final long serialVersionUID = -710180811973399777L;

    public AsyncCompletionStageExecutor(RetryPolicy retry, CircuitBreakerPolicy cbPolicy, TimeoutPolicy timeoutPolicy, FallbackPolicy fallbackPolicy, BulkheadPolicy bulkheadPolicy, ScheduledExecutorService executorService, WSContextService contextService, MetricRecorder metricRecorder) {
        super(retry, cbPolicy, timeoutPolicy, fallbackPolicy, bulkheadPolicy, executorService, contextService, metricRecorder);
        this.executorService = executorService;
    }

    @Override
    protected CompletionStage<R> createEmptyResultWrapper(AsyncExecutionContextImpl<CompletionStage<R>> executionContext) {
        return new CompletableFuture();
    }

    @Override
    protected void setResult(AsyncExecutionContextImpl<CompletionStage<R>> executionContext, MethodResult<CompletionStage<R>> result) {
        if (System.getSecurityManager() != null && Thread.currentThread() instanceof ForkJoinWorkerThread) {
            this.executorService.submit(() -> this.doSetResult(executionContext, result));
        } else {
            this.doSetResult(executionContext, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalStateException.class})
    private void doSetResult(AsyncExecutionContextImpl<CompletionStage<R>> executionContext, MethodResult<CompletionStage<R>> result) {
        CompletableFuture resultWrapper = (CompletableFuture)executionContext.getResultWrapper();
        ThreadContextDescriptor threadContext = executionContext.getThreadContextDescriptor();
        try {
            ArrayList contexts = null;
            try {
                contexts = threadContext.taskStarting();
            }
            catch (IllegalStateException e) {
                result = MethodResult.internalFailure((Throwable)this.createAppStoppedException(e, executionContext));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} final fault tolerance result: {1}", (Object[])new Object[]{executionContext.getId(), result});
            }
            try {
                if (result.isFailure()) {
                    resultWrapper.completeExceptionally(result.getFailure());
                } else {
                    result.getResult().thenAccept(resultWrapper::complete);
                    result.getResult().exceptionally(ex -> {
                        resultWrapper.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
            finally {
                if (contexts != null) {
                    threadContext.taskStopping(contexts);
                }
            }
        }
        catch (Throwable contexts) {
            void t;
            FFDCFilter.processException((Throwable)contexts, (String)"com.ibm.ws.microprofile.faulttolerance20.impl.AsyncCompletionStageExecutor", (String)"104", (Object)this, (Object[])new Object[]{executionContext, result});
            Tr.error((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{t});
            resultWrapper.completeExceptionally((Throwable)new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{t}), (Throwable)t));
        }
    }

    @Override
    protected void processMethodResult(AsyncAttemptContextImpl<CompletionStage<R>> attemptContext, MethodResult<CompletionStage<R>> result, AsyncBulkheadState.BulkheadReservation reservation) {
        if (result.isFailure()) {
            super.processMethodResult(attemptContext, result, reservation);
        } else {
            result.getResult().thenRun(() -> super.processMethodResult(attemptContext, result, reservation));
            result.getResult().exceptionally(t -> {
                super.processMethodResult(attemptContext, MethodResult.failure(t), reservation);
                return null;
            });
        }
    }
}

