/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.activator;

import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.activator.ActivateRequestContext;
import org.jboss.weld.context.unbound.Unbound;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.manager.BeanManagerImpl;

@Vetoed
@Interceptor
@ActivateRequestContext
@Priority(value=100)
public class ActivateRequestContextInterceptor {
    private final BeanManagerImpl beanManager;
    private final RequestContext requestContext;
    private final FastEvent<Object> fastEventInit;
    private final FastEvent<Object> fastEventDestroyed;

    @Inject
    public ActivateRequestContextInterceptor(@Unbound RequestContext requestContext, BeanManagerImpl beanManager) {
        this.requestContext = requestContext;
        this.beanManager = beanManager;
        this.fastEventInit = FastEvent.of(Object.class, beanManager, new Annotation[]{InitializedLiteral.REQUEST});
        this.fastEventDestroyed = FastEvent.of(Object.class, beanManager, new Annotation[]{DestroyedLiteral.REQUEST});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    Object invoke(InvocationContext ctx) throws Exception {
        if (this.isRequestContextActive()) {
            return ctx.proceed();
        }
        Object dummyPayload = new Object();
        try {
            this.requestContext.activate();
            this.fastEventInit.fire(dummyPayload);
            Object object = ctx.proceed();
            return object;
        }
        finally {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
            this.fastEventDestroyed.fire(dummyPayload);
        }
    }

    protected boolean isRequestContextActive() {
        return this.beanManager.isContextActive(RequestScoped.class);
    }
}

