/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config.sources.InternalConfigSource;
import com.ibm.ws.microprofile.config.sources.StaticConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PropertiesConfigSource
extends InternalConfigSource
implements StaticConfigSource {
    private static final TraceComponent tc = Tr.register(PropertiesConfigSource.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final ConcurrentMap<String, String> properties;
    static final long serialVersionUID = 6470775571968377617L;

    @Trivial
    public PropertiesConfigSource(URL resource) {
        this(PropertiesConfigSource.loadProperties(resource), resource.toString());
    }

    @Trivial
    public PropertiesConfigSource(ConcurrentMap<String, String> properties, String id) {
        this(properties, PropertiesConfigSource.getPropsOrdinal(properties), Tr.formatMessage((TraceComponent)tc, (String)"properties.file.config.source", (Object[])new Object[]{id}));
    }

    public PropertiesConfigSource(ConcurrentMap<String, String> properties, int ordinal, String id) {
        super(ordinal, id);
        this.properties = properties;
    }

    public ConcurrentMap<String, String> getProperties() {
        return this.properties;
    }

    @Trivial
    public static int getPropsOrdinal(Map<String, String> properties) {
        String ordinalProp = properties.get("config_ordinal");
        int ordinal = 100;
        if (ordinalProp != null) {
            ordinal = Integer.parseInt(ordinalProp);
        }
        return ordinal;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConcurrentMap<String, String> loadProperties(URL resource) {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>();
        InputStream stream = null;
        try {
            stream = resource.openStream();
            Properties properties22 = new Properties();
            properties22.load(stream);
            Set<String> propNames = properties22.stringPropertyNames();
            for (String name : propNames) {
                props.put(name, properties22.getProperty(name));
            }
            if (stream == null) return props;
        }
        catch (IOException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.sources.PropertiesConfigSource", (String)"78", null, (Object[])new Object[]{resource});
                throw new ConfigException(e);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.config.sources.PropertiesConfigSource", (String)"84", null, (Object[])new Object[]{resource});
                    throw new ConfigException((Throwable)e2);
                }
            }
        }
        try {
            stream.close();
            return props;
        }
        catch (IOException properties22) {
            FFDCFilter.processException((Throwable)properties22, (String)"com.ibm.ws.microprofile.config.sources.PropertiesConfigSource", (String)"84", null, (Object[])new Object[]{resource});
            throw new ConfigException((Throwable)e);
        }
    }
}

