/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.config.archaius.cache.StampedValue;
import com.ibm.ws.microprofile.config.archaius.cache.TypeContainer;
import com.ibm.ws.microprofile.config.archaius.composite.CompositeConfig;
import com.ibm.ws.microprofile.config.archaius.composite.ConfigListener;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigCache
implements ConfigListener {
    private final CompositeConfig config;
    private final ConcurrentMap<String, TypeContainer> cache = new ConcurrentHashMap<String, TypeContainer>();
    private final AtomicInteger version = new AtomicInteger();
    static final long serialVersionUID = 140717313029984874L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConfigCache(CompositeConfig config) {
        this.config = config;
        this.config.addListener(this);
    }

    private TypeContainer getProperty(String propName) {
        TypeContainer existing;
        TypeContainer container = (TypeContainer)this.cache.get(propName);
        if (container == null && (existing = this.cache.putIfAbsent(propName, container = new TypeContainer(propName, this.config, this.version))) != null) {
            return existing;
        }
        return container;
    }

    @Override
    public void onConfigAdded() {
        this.invalidate();
    }

    @Override
    public void onConfigUpdated() {
        this.invalidate();
    }

    public void invalidate() {
        this.version.incrementAndGet();
    }

    public SourcedValue getSourcedValue(String propertyName, Type propertyType) {
        TypeContainer container = this.getProperty(propertyName);
        StampedValue property = container.asType(propertyType);
        SourcedValue value = property.getSourced();
        return value;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config.archaius.cache.ConfigCache", ConfigCache.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    }
}

