/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.annotations.Stream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class StreamProducer {
    @Inject
    ChannelRegistry channelRegistry;

    @Produces
    @Stream(value="")
    <T> Flowable<T> producePublisher(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable((Type)first, Message.class)) {
            return (Flowable)StreamProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (Flowable)StreamProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Stream(value="")
    <T> PublisherBuilder<T> producePublisherBuilder(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable((Type)first, Message.class)) {
            return (PublisherBuilder)StreamProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (PublisherBuilder)StreamProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Stream(value="")
    <T> Emitter<T> produceEmitter(InjectionPoint injectionPoint) {
        Emitter emitter = this.getEmitter(injectionPoint);
        return (Emitter)StreamProducer.cast(emitter);
    }

    private Publisher<? extends Message> getPublisher(InjectionPoint injectionPoint) {
        String name = StreamProducer.getStreamName(injectionPoint);
        List<PublisherBuilder<? extends Message>> list = this.channelRegistry.getPublishers(name);
        if (list.isEmpty()) {
            throw new IllegalStateException("Unable to find a stream with the name " + name + ", available streams are: " + this.channelRegistry.getIncomingNames());
        }
        return list.get(0).buildRs();
    }

    private SubscriberBuilder<? extends Message, Void> getSubscriberBuilder(InjectionPoint injectionPoint) {
        String name = StreamProducer.getStreamName(injectionPoint);
        List<SubscriberBuilder<? extends Message, Void>> list = this.channelRegistry.getSubscribers(name);
        if (list.isEmpty()) {
            throw new IllegalStateException("Unable to find a stream with the name " + name + ", available streams are: " + this.channelRegistry.getOutgoingNames());
        }
        return list.get(0);
    }

    private Emitter getEmitter(InjectionPoint injectionPoint) {
        String name = StreamProducer.getStreamName(injectionPoint);
        Emitter<?> emitter = this.channelRegistry.getEmitter(name);
        if (emitter == null) {
            throw new IllegalStateException("Unable to find a emitter with the name " + name + ", available emitters are: " + this.channelRegistry.getEmitterNames());
        }
        return emitter;
    }

    private Type getFirstParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    static String getStreamName(InjectionPoint injectionPoint) {
        Stream qualifier = StreamProducer.getStreamQualifier(injectionPoint);
        if (qualifier == null) {
            throw new IllegalStateException("@Stream qualifier not found on + " + injectionPoint);
        }
        return qualifier.value();
    }

    static Stream getStreamQualifier(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(Stream.class)) continue;
            return (Stream)qualifier;
        }
        return null;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

