/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.Size;
import net.sf.ehcache.pool.impl.DefaultSizeOfEngine;
import net.sf.ehcache.store.AbstractPolicy;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.FrontEndCacheTier;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.TierableStore;
import net.sf.ehcache.store.chm.SelectableConcurrentHashMap;
import net.sf.ehcache.store.disk.StoreUpdateException;
import net.sf.ehcache.util.ratestatistics.AtomicRateStatistic;
import net.sf.ehcache.util.ratestatistics.RateStatistic;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStore
extends AbstractStore
implements TierableStore,
PoolableStore,
CacheConfigurationListener {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 100;
    private static final int MAX_EVICTION_RATIO = 5;
    private static final Logger LOG = LoggerFactory.getLogger((String)MemoryStore.class.getName());
    private final boolean alwaysPutOnHeap;
    private final Ehcache cache;
    private final SelectableConcurrentHashMap map;
    private final PoolAccessor poolAccessor;
    private final RateStatistic hitRate = new AtomicRateStatistic(1000L, TimeUnit.MILLISECONDS);
    private final RateStatistic missRate = new AtomicRateStatistic(1000L, TimeUnit.MILLISECONDS);
    private final boolean cachePinned;
    private final boolean elementPinningEnabled;
    private volatile int maximumSize;
    private volatile Status status = Status.STATUS_UNINITIALISED;
    private volatile Policy policy;
    private volatile CacheLockProvider lockProvider;
    private final boolean tierPinned;

    protected MemoryStore(Ehcache cache, Pool pool, boolean doNotifications) {
        this.cache = cache;
        this.maximumSize = (int)cache.getCacheConfiguration().getMaxEntriesLocalHeap();
        this.policy = MemoryStore.determineEvictionPolicy(cache);
        this.poolAccessor = pool.createPoolAccessor(this, SizeOfPolicyConfiguration.resolveMaxDepth(cache), SizeOfPolicyConfiguration.resolveBehavior(cache).equals((Object)SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT));
        this.alwaysPutOnHeap = MemoryStore.getAdvancedBooleanConfigProperty("alwaysPutOnHeap", cache.getCacheConfiguration().getName(), false);
        this.cachePinned = this.determineCachePinned(cache.getCacheConfiguration());
        this.tierPinned = cache.getCacheConfiguration().getPinningConfiguration() != null && cache.getCacheConfiguration().getPinningConfiguration().getStore() == PinningConfiguration.Store.LOCALHEAP;
        this.elementPinningEnabled = !cache.getCacheConfiguration().isOverflowToOffHeap();
        float loadFactor = this.maximumSize == 1 ? 1.0f : 0.75f;
        int initialCapacity = MemoryStore.getInitialCapacityForLoadFactor(this.maximumSize, loadFactor);
        this.map = new SelectableConcurrentHashMap(this.poolAccessor, this.elementPinningEnabled, initialCapacity, loadFactor, 100, this.isClockEviction() && !this.cachePinned ? (long)this.maximumSize : 0L, doNotifications ? cache.getCacheEventNotificationService() : null);
        this.status = Status.STATUS_ALIVE;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialized " + this.getClass().getName() + " for " + cache.getName());
        }
    }

    private boolean determineCachePinned(CacheConfiguration cacheConfiguration) {
        PinningConfiguration pinningConfiguration = cacheConfiguration.getPinningConfiguration();
        if (pinningConfiguration == null) {
            return false;
        }
        switch (pinningConfiguration.getStore()) {
            case LOCALHEAP: {
                return true;
            }
            case LOCALMEMORY: {
                return !cacheConfiguration.isOverflowToOffHeap();
            }
            case INCACHE: {
                return !cacheConfiguration.isOverflowToOffHeap() && !cacheConfiguration.isOverflowToDisk() && !cacheConfiguration.isDiskPersistent();
            }
        }
        throw new IllegalArgumentException();
    }

    static int getInitialCapacityForLoadFactor(int maximumSizeGoal, float loadFactor) {
        double actualMaximum = Math.ceil((float)maximumSizeGoal / loadFactor);
        return Math.max(0, actualMaximum >= 2.147483647E9 ? Integer.MAX_VALUE : (int)actualMaximum);
    }

    public static MemoryStore create(Ehcache cache, Pool pool) {
        MemoryStore memoryStore = new MemoryStore(cache, pool, false);
        cache.getCacheConfiguration().addConfigurationListener(memoryStore);
        return memoryStore;
    }

    @Override
    public void unpinAll() {
        if (this.elementPinningEnabled) {
            this.map.unpinAll();
        }
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
        if (this.elementPinningEnabled) {
            this.map.setPinned(key, pinned);
        }
    }

    @Override
    public boolean isPinned(Object key) {
        return this.elementPinningEnabled && this.map.isPinned(key);
    }

    private boolean isPinningEnabled(Element element) {
        return this.cachePinned || this.elementPinningEnabled && this.isPinned(element.getObjectKey());
    }

    @Override
    public void fill(Element element) {
        if (this.alwaysPutOnHeap || this.isPinningEnabled(element) || this.remove(element.getObjectKey()) != null || this.canPutWithoutEvicting(element)) {
            this.put(element);
        }
    }

    @Override
    public boolean removeIfTierNotPinned(Object key) {
        return !this.tierPinned && this.remove(key) != null;
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        long delta = this.poolAccessor.add(element.getObjectKey(), element.getObjectValue(), this.map.storedObject(element), this.isPinningEnabled(element));
        if (delta > -1L) {
            Element old = this.map.put(element.getObjectKey(), element, delta);
            this.checkCapacity(element);
            return old == null;
        }
        this.notifyDirectEviction(element);
        return true;
    }

    @Override
    public final boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        long delta = this.poolAccessor.add(element.getObjectKey(), element.getObjectValue(), this.map.storedObject(element), this.isPinningEnabled(element));
        if (delta > -1L) {
            Element old = this.map.put(element.getObjectKey(), element, delta);
            if (writerManager != null) {
                try {
                    writerManager.put(element);
                }
                catch (RuntimeException e) {
                    throw new StoreUpdateException(e, old != null);
                }
            }
            this.checkCapacity(element);
            return old == null;
        }
        this.notifyDirectEviction(element);
        return true;
    }

    @Override
    public final Element get(Object key) {
        if (key == null) {
            return null;
        }
        Element e = (Element)this.map.get(key);
        if (e == null) {
            this.missRate.event();
        } else {
            this.hitRate.event();
        }
        return e;
    }

    @Override
    public final Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.remove(key);
    }

    @Override
    public void removeNoReturn(Object key) {
        this.remove(key);
    }

    @Override
    public boolean isTierPinned() {
        return this.tierPinned;
    }

    @Override
    public Set getPresentPinnedKeys() {
        return this.map.pinnedKeySet();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public final Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        if (key == null) {
            return null;
        }
        Element element = (Element)this.map.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, element));
        }
        if (element == null && LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: Cannot remove entry as key " + key + " was not found");
        }
        return element;
    }

    @Override
    public final boolean bufferFull() {
        return false;
    }

    @Override
    public void expireElements() {
        for (Object key : this.map.keySet()) {
            this.expireElement(key);
        }
    }

    protected Element expireElement(Object key) {
        Element value = this.get(key);
        return value != null && value.isExpired() && this.map.remove(key, value) ? value : null;
    }

    private static Policy determineEvictionPolicy(Ehcache cache) {
        MemoryStoreEvictionPolicy policySelection = cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.CLOCK)) {
            return null;
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    @Override
    public final void removeAll() throws CacheException {
        for (Object key : this.map.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.poolAccessor.unlink();
    }

    @Override
    public final void flush() {
        if (this.cache.getCacheConfiguration().isClearOnFlush()) {
            this.removeAll();
        }
    }

    @Override
    public final List<?> getKeys() {
        return new ArrayList<Object>(this.map.keySet());
    }

    protected Set<?> keySet() {
        return this.map.keySet();
    }

    @Override
    public final int getSize() {
        return this.map.size();
    }

    @Override
    public final int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    private void notifyExpiry(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    protected void notifyDirectEviction(Element element) {
    }

    public final boolean isFull() {
        return this.maximumSize > 0 && this.map.quickSize() >= this.maximumSize;
    }

    public final boolean canPutWithoutEvicting(Element element) {
        if (element == null) {
            return true;
        }
        return !this.isFull() && this.poolAccessor.canAddWithoutEvicting(element.getObjectKey(), element.getObjectValue(), this.map.storedObject(element));
    }

    private void checkCapacity(Element elementJustAdded) {
        if (this.maximumSize > 0 && !this.isClockEviction()) {
            int evict = Math.min(this.map.quickSize() - this.maximumSize, 5);
            for (int i = 0; i < evict; ++i) {
                this.removeElementChosenByEvictionPolicy(elementJustAdded);
            }
        }
    }

    private boolean removeElementChosenByEvictionPolicy(Element elementJustAdded) {
        if (this.policy == null) {
            return this.map.evict();
        }
        Element element = this.findEvictionCandidate(elementJustAdded);
        if (element == null) {
            LOG.debug("Eviction selection miss. Selected element is null");
            return false;
        }
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return true;
        }
        if (this.isPinningEnabled(element)) {
            return false;
        }
        return this.evict(element);
    }

    private Element findEvictionCandidate(Element elementJustAdded) {
        Object objectKey = elementJustAdded != null ? elementJustAdded.getObjectKey() : null;
        Element[] elements = this.sampleElements(objectKey);
        return this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
    }

    private Element[] sampleElements(Object keyHint) {
        int size = AbstractPolicy.calculateSampleSize(this.map.quickSize());
        return this.map.getRandomValues(size, keyHint);
    }

    @Override
    public Object getInternalContext() {
        if (this.lockProvider != null) {
            return this.lockProvider;
        }
        this.lockProvider = new LockProvider();
        return this.lockProvider;
    }

    @Override
    public final Status getStatus() {
        return this.status;
    }

    @Override
    public void timeToIdleChanged(long oldTti, long newTti) {
    }

    @Override
    public void timeToLiveChanged(long oldTtl, long newTtl) {
    }

    @Override
    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
    }

    @Override
    public void loggingChanged(boolean oldValue, boolean newValue) {
    }

    @Override
    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.maximumSize = newCapacity;
        if (this.isClockEviction() && !this.cachePinned) {
            this.map.setMaxSize(this.maximumSize);
        }
    }

    private boolean isClockEviction() {
        return this.policy == null;
    }

    @Override
    public void registered(CacheConfiguration config) {
    }

    @Override
    public void deregistered(CacheConfiguration config) {
    }

    @Override
    public void maxBytesLocalHeapChanged(long oldValue, long newValue) {
        this.poolAccessor.setMaxSize(newValue);
    }

    @Override
    public void maxBytesLocalDiskChanged(long oldValue, long newValue) {
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.policy;
    }

    @Override
    public int getInMemorySize() {
        return this.getSize();
    }

    @Override
    public long getInMemorySizeInBytes() {
        if (this.poolAccessor.getSize() < 0L) {
            DefaultSizeOfEngine defaultSizeOfEngine = new DefaultSizeOfEngine(SizeOfPolicyConfiguration.resolveMaxDepth(this.cache), SizeOfPolicyConfiguration.resolveBehavior(this.cache).equals((Object)SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT));
            long sizeInBytes = 0L;
            for (Element o : this.map.values()) {
                Element element = o;
                if (element == null) continue;
                Size size = defaultSizeOfEngine.sizeOf(element.getObjectKey(), element, this.map.storedObject(element));
                sizeInBytes += size.getCalculated();
            }
            return sizeInBytes;
        }
        return this.poolAccessor.getSize();
    }

    @Override
    public int getOffHeapSize() {
        return 0;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    @Override
    public int getOnDiskSize() {
        return 0;
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    @Override
    public boolean hasAbortedSizeOf() {
        return this.poolAccessor.hasAbortedSizeOf();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.policy = policy;
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (element == null) {
            return null;
        }
        long delta = this.poolAccessor.add(element.getObjectKey(), element.getObjectValue(), this.map.storedObject(element), this.isPinningEnabled(element));
        if (delta > -1L) {
            Element old = this.map.putIfAbsent(element.getObjectKey(), element, delta);
            if (old == null) {
                this.checkCapacity(element);
            } else {
                this.poolAccessor.delete(delta);
            }
            return old;
        }
        this.notifyDirectEviction(element);
        return null;
    }

    protected boolean evict(Element element) {
        Element remove = this.remove(element.getObjectKey());
        RegisteredEventListeners cacheEventNotificationService = this.cache.getCacheEventNotificationService();
        FrontEndCacheTier frontEndCacheTier = cacheEventNotificationService.getFrontEndCacheTier();
        if (remove != null && frontEndCacheTier != null && frontEndCacheTier.notifyEvictionFromCache(remove.getKey())) {
            cacheEventNotificationService.notifyElementEvicted(remove, false);
        }
        return remove != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        if (element == null || element.getObjectKey() == null) {
            return null;
        }
        Object key = element.getObjectKey();
        Lock lock = this.getWriteLock(key);
        lock.lock();
        try {
            Element toRemove = (Element)this.map.get(key);
            if (comparator.equals(element, toRemove)) {
                this.map.remove(key);
                Element element2 = toRemove;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (element == null || element.getObjectKey() == null) {
            return false;
        }
        Object key = element.getObjectKey();
        long delta = this.poolAccessor.add(element.getObjectKey(), element.getObjectValue(), this.map.storedObject(element), this.isPinningEnabled(element));
        if (delta > -1L) {
            Lock lock = this.getWriteLock(key);
            lock.lock();
            try {
                Element toRemove = (Element)this.map.get(key);
                if (comparator.equals(old, toRemove)) {
                    this.map.put(key, element, delta);
                    boolean bl = true;
                    return bl;
                }
                this.poolAccessor.delete(delta);
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        this.notifyDirectEviction(element);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element replace(Element element) throws NullPointerException {
        if (element == null || element.getObjectKey() == null) {
            return null;
        }
        Object key = element.getObjectKey();
        long delta = this.poolAccessor.add(element.getObjectKey(), element.getObjectValue(), this.map.storedObject(element), this.isPinningEnabled(element));
        if (delta > -1L) {
            Lock lock = this.getWriteLock(key);
            lock.lock();
            try {
                Element toRemove = (Element)this.map.get(key);
                if (toRemove != null) {
                    this.map.put(key, element, delta);
                    Element element2 = toRemove;
                    return element2;
                }
                this.poolAccessor.delete(delta);
                Element element3 = null;
                return element3;
            }
            finally {
                lock.unlock();
            }
        }
        this.notifyDirectEviction(element);
        return null;
    }

    @Override
    public Object getMBean() {
        return null;
    }

    @Override
    public boolean evictFromOnHeap(int count, long size) {
        if (this.cachePinned) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            boolean removed = this.removeElementChosenByEvictionPolicy(null);
            if (removed) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evictFromOnDisk(int count, long size) {
        return false;
    }

    @Override
    public float getApproximateDiskHitRate() {
        return 0.0f;
    }

    @Override
    public float getApproximateDiskMissRate() {
        return 0.0f;
    }

    @Override
    public long getApproximateDiskCountSize() {
        return 0L;
    }

    @Override
    public long getApproximateDiskByteSize() {
        return 0L;
    }

    @Override
    public float getApproximateHeapHitRate() {
        return this.hitRate.getRate();
    }

    @Override
    public float getApproximateHeapMissRate() {
        return this.missRate.getRate();
    }

    @Override
    public long getApproximateHeapCountSize() {
        return this.map.quickSize();
    }

    @Override
    public long getApproximateHeapByteSize() {
        return this.poolAccessor.getSize();
    }

    private Lock getWriteLock(Object key) {
        return this.map.lockFor(key).writeLock();
    }

    public Collection<Element> elementSet() {
        return this.map.values();
    }

    private static boolean getAdvancedBooleanConfigProperty(String property, String cacheName, boolean defaultValue) {
        String globalPropertyKey = "net.sf.ehcache.store.config." + property;
        String cachePropertyKey = "net.sf.ehcache.store." + cacheName + ".config." + property;
        return Boolean.parseBoolean(System.getProperty(cachePropertyKey, System.getProperty(globalPropertyKey, Boolean.toString(defaultValue))));
    }

    @Override
    public void recalculateSize(Object key) {
        if (key == null) {
            return;
        }
        this.map.recalculateSize(key);
    }

    private class LockProvider
    implements CacheLockProvider {
        private LockProvider() {
        }

        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(MemoryStore.this.map.lockFor(key));
        }
    }
}

