/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.RelationalColumnMetadata;

public class JoinColumnMetadata
extends RelationalColumnMetadata {
    private Boolean m_unique;
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;
    private String m_table;

    public JoinColumnMetadata() {
        super("<join-column>");
    }

    protected JoinColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    public JoinColumnMetadata(MetadataAnnotation joinColumn, MetadataAccessor accessor) {
        super(joinColumn, accessor);
        if (joinColumn != null) {
            this.m_table = joinColumn.getAttributeString("table");
            this.m_unique = joinColumn.getAttributeBooleanDefaultFalse("unique");
            this.m_nullable = joinColumn.getAttributeBooleanDefaultTrue("nullable");
            this.m_updatable = joinColumn.getAttributeBooleanDefaultTrue("updatable");
            this.m_insertable = joinColumn.getAttributeBooleanDefaultTrue("insertable");
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof JoinColumnMetadata) {
            JoinColumnMetadata joinColumn = (JoinColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_unique, joinColumn.getUnique())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nullable, joinColumn.getNullable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_updatable, joinColumn.getUpdatable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_insertable, joinColumn.getInsertable())) {
                return false;
            }
            return this.valuesMatch(this.m_table, joinColumn.getTable());
        }
        return false;
    }

    @Override
    protected DatabaseField getForeignKeyField() {
        DatabaseField fkField = super.getForeignKeyField();
        fkField.setTableName(this.m_table == null ? "" : this.m_table);
        fkField.setUnique(this.m_unique == null ? false : this.m_unique);
        fkField.setNullable(this.m_nullable == null ? true : this.m_nullable);
        fkField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
        fkField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
        return fkField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public void setInsertable(Boolean insertable) {
        this.m_insertable = insertable;
    }

    public void setNullable(Boolean nullable) {
        this.m_nullable = nullable;
    }

    public void setTable(String table) {
        this.m_table = table;
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }

    public void setUpdatable(Boolean updatable) {
        this.m_updatable = updatable;
    }
}

