/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKProvider;
import com.ibm.ws.security.openidconnect.common.ConfigUtils;
import com.ibm.ws.security.openidconnect.server.ServerConstants;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCProvidersConfig;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcServerConfigImpl
implements OidcServerConfig {
    public static final String KEY_HTTPS_REQUIRED = "httpsRequired";
    private static final TraceComponent tc = Tr.register(OidcServerConfigImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String CFG_KEY_ID = "id";
    public static final String CFG_KEY_OAUTH_PROVIDER_REF = "oauthProviderRef";
    public static final String CFG_KEY_UNIQUE_USER_IDENTIFIER = "uniqueUserIdentifier";
    public static final String CFG_KEY_ISSUER_IDENTIFIER = "issuerIdentifier";
    public static final String CFG_KEY_AUDIENCE = "audience";
    public static final String CFG_KEY_USER_IDENTITY = "userIdentity";
    public static final String CFG_KEY_GROUP_IDENTIFIER = "groupIdentifier";
    public static final String CFG_KEY_DEFAULT_SCOPE = "defaultScope";
    public static final String CFG_KEY_EXTERNAL_CLAIM_NAMES = "externalClaimNames";
    public static final String CFG_KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String CFG_KEY_CUSTOM_CLAIMS_ENABLED = "customClaimsEnabled";
    public static final String CFG_KEY_CUSTOM_CLAIMS = "customClaims";
    public static final String CFG_KEY_JTI_CLAIM_ENABLED = "jtiClaimEnabled";
    public static final String CFG_KEY_KEYSTORE_REF = "keyStoreRef";
    public static final String CFG_KEYSTORE_REF_DEFAULT = "opKeyStore";
    public static final String CFG_KEY_KEY_ALIAS_NAME = "keyAliasName";
    public static final String CFG_KEY_TRUSTSTORE_REF = "trustStoreRef";
    public static final String CFG_KEY_SESSION_MANAGED = "sessionManaged";
    public static final String CFG_KEY_ID_TOKEN_LIFETIME = "idTokenLifetime";
    public static final String CFG_KEY_CHECK_SESSION_IFRAME_ENDPOINT_URL = "checkSessionIframeEndpointUrl";
    public static final String CFG_KEY_PROTECTED_ENDPOINTS = "protectedEndpoints";
    public static final String CFG_KEY_CACHE_IDTOKEN = "idTokenCacheEnabled";
    public static final String CFG_KEY_RESPONSE_TYPES_SUPPORTED = "responseTypesSupported";
    public static final String CFG_KEY_SUBJECT_TYPES_SUPPORTED = "subjectTypesSupported";
    public static final String CFG_KEY_ID_TOKEN_SIGNING_ALG_VAL_SUPPORTED = "idTokenSigningAlgValuesSupported";
    public static final String CFG_KEY_SCOPES_SUPPORTED = "scopesSupported";
    public static final String CFG_KEY_CLAIMS_SUPPORTED = "claimsSupported";
    public static final String CFG_KEY_RESPONSE_MODES_SUPPORTED = "responseModesSupported";
    public static final String CFG_KEY_GRANT_TYPES_SUPPORTED = "grantTypesSupported";
    public static final String CFG_KEY_TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED = "tokenEndpointAuthMethodsSupported";
    public static final String CFG_KEY_DISPLAY_VALUES_SUPPORTED = "displayValuesSupported";
    public static final String CFG_KEY_CLAIM_TYPES_SUPPORTED = "claimTypesSupported";
    public static final String CFG_KEY_CLAIMS_PARAMETERS_SUPPORTED = "claimsParameterSupported";
    public static final String CFG_KEY_REQUEST_PARAMETERS_SUPPORTED = "requestParameterSupported";
    public static final String CFG_KEY_REQUEST_URI_PARAMETER_SUPPORTED = "requestUriParameterSupported";
    public static final String CFG_KEY_REQUIRE_REQUEST_URI_REGISTRATION = "requireRequestUriRegistration";
    public static final String CFG_KEY_BACKING_IDP_URI_PREFIX = "backingIdpUriPrefix";
    public static final String CFG_KEY_AUTH_PROXY_ENDPOINT_URL = "authProxyEndpointUrl";
    public static final String CFG_KEY_REQUIRE_OPENID_SCOPE_FOR_USERINFO = "requireOpenidScopeForUserInfo";
    public static final String CFG_KEY_JWK_ENABLED = "jwkEnabled";
    public static final String CFG_KEY_JWK_ROTATION = "jwkRotationTime";
    public static final String CFG_KEY_JWK_SIGNING_KEY_SIZE = "jwkSigningKeySize";
    public static final String CFG_KEY_SSO_COOKIE_NAME = "allowDefaultSsoCookieName";
    public static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    protected final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    private ConfigUtils configUtils;
    private String providerId;
    private String oauthProviderRef;
    private String userIdentifier;
    private String uniqueUserIdentifier;
    private String issuerIdentifier;
    private String audience;
    private String userIdentity;
    private String groupIdentifier;
    private String defaultScope;
    private String externalClaimNames;
    private Properties scopeToClaimMap;
    private Properties claimToUserRegistryMap;
    private String signatureAlgorithm;
    private boolean customClaimsEnabled;
    private boolean cacheIDToken;
    static final Set<String> defaultCustomClaims = new HashSet<String>();
    private Set<String> customClaims;
    private boolean jtiClaimEnabled;
    private boolean sessionManaged;
    private String keyStoreRef;
    private String keyAliasName;
    private String trustStoreRef;
    private long idTokenLifetime;
    private String checkSessionIframeEndpointUrl;
    private String protectedEndpoints;
    Pattern patternProtectedEndpoints;
    Pattern patternOidcEndpoints;
    Pattern patternNonOidcEndpoints;
    private Properties discovery;
    private String[] responseTypesSupported;
    private String[] subjectTypesSupported;
    private String idTokenSigningAlgValuesSupported;
    private String[] scopesSupported;
    private String[] claimsSupported;
    private String[] responseModesSupported;
    private String[] grantTypesSupported;
    private String[] tokenEndpointAuthMethodsSupported;
    private String[] displayValuesSupported;
    private String[] claimTypesSupported;
    private boolean claimsParameterSupported;
    private boolean requestParameterSupported;
    private boolean requestUriParameterSupported;
    private boolean requireRequestUriRegistration;
    private String backingIdpUriPrefix;
    private String authProxyEndpointUrl;
    private boolean jwkEnabled = false;
    private JWKProvider jwkProvider;
    private long jwkRotationTime = 0L;
    private int jwkSigningKeySize = 0;
    private boolean allowLtpaToken2Name = false;
    private boolean requireOpenidScopeForUserInfo = true;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    static final long serialVersionUID = 9059859333411504075L;

    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.writeLock.lock();
        try {
            this.configAdminRef.setReference(ref);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.writeLock.lock();
        try {
            this.configAdminRef.unsetReference(ref);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.writeLock.lock();
        try {
            this.keyStoreServiceRef.setReference(ref);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.writeLock.lock();
        try {
            this.keyStoreServiceRef.unsetReference(ref);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
    }

    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        this.writeLock.lock();
        try {
            this.configAdminRef.activate(cc);
            this.configUtils = new ConfigUtils(this.configAdminRef);
            this.keyStoreServiceRef.activate(cc);
            this.sslSupportRef.activate(cc);
            this.processConfigProps(props);
            Tr.info((TraceComponent)tc, (String)"OIDC_SERVER_CONFIG_PROCESSED", (Object[])new Object[]{this.providerId});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected synchronized void modify(Map<String, Object> props) {
        this.writeLock.lock();
        try {
            this.processConfigProps(props);
            Tr.info((TraceComponent)tc, (String)"OIDC_SERVER_CONFIG_MODIFIED", (Object[])new Object[]{this.providerId});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.writeLock.lock();
        try {
            this.configAdminRef.deactivate(cc);
            this.keyStoreServiceRef.deactivate(cc);
            this.sslSupportRef.deactivate(cc);
            OIDCProvidersConfig.removeOidcServerConfig(this.providerId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String processIssuerIdentifier(String issuer) {
        if (issuer == null || issuer.isEmpty()) {
            return issuer;
        }
        String HTTPS_SCHEME = "https:";
        boolean httpsRequired = false;
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            Configuration config = configAdmin.getConfiguration(this.oauthProviderRef, null);
            Dictionary properties = config.getProperties();
            httpsRequired = (Boolean)properties.get(KEY_HTTPS_REQUIRED);
        }
        catch (IOException config) {
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.security.openidconnect.server.internal.OidcServerConfigImpl", (String)"285", (Object)this, (Object[])new Object[]{issuer});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid oauthProviderRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        if (httpsRequired && !issuer.contains(HTTPS_SCHEME)) {
            Tr.warning((TraceComponent)tc, (String)"OIDC_SERVER_ISSUER_IDENTIFIER_NOT_HTTPS", (Object[])new Object[]{issuer});
            issuer = null;
        }
        return issuer;
    }

    private void processConfigProps(Map<String, Object> props) {
        String protectedEndpoints;
        if (props == null || props.isEmpty()) {
            return;
        }
        this.providerId = this.trimIt((String)props.get(CFG_KEY_ID));
        this.oauthProviderRef = this.trimIt((String)props.get(CFG_KEY_OAUTH_PROVIDER_REF));
        this.userIdentifier = this.trimIt((String)props.get(CFG_KEY_UNIQUE_USER_IDENTIFIER));
        this.uniqueUserIdentifier = this.trimIt((String)props.get(CFG_KEY_UNIQUE_USER_IDENTIFIER));
        this.issuerIdentifier = this.processIssuerIdentifier(this.trimIt((String)props.get(CFG_KEY_ISSUER_IDENTIFIER)));
        this.audience = this.trimIt((String)props.get(CFG_KEY_AUDIENCE));
        this.userIdentity = this.trimIt((String)props.get(CFG_KEY_USER_IDENTITY));
        this.groupIdentifier = this.trimIt((String)props.get(CFG_KEY_GROUP_IDENTIFIER));
        this.defaultScope = this.trimIt((String)props.get(CFG_KEY_DEFAULT_SCOPE));
        this.externalClaimNames = this.trimIt((String)props.get(CFG_KEY_EXTERNAL_CLAIM_NAMES));
        this.signatureAlgorithm = this.trimIt((String)props.get(CFG_KEY_SIGNATURE_ALGORITHM));
        this.customClaimsEnabled = (Boolean)props.get(CFG_KEY_CUSTOM_CLAIMS_ENABLED);
        String[] aCustomClaims = (String[])props.get(CFG_KEY_CUSTOM_CLAIMS);
        this.customClaims = this.newCustomClaims(aCustomClaims);
        this.jtiClaimEnabled = (Boolean)props.get(CFG_KEY_JTI_CLAIM_ENABLED);
        this.sessionManaged = (Boolean)props.get(CFG_KEY_SESSION_MANAGED);
        this.keyStoreRef = this.trimIt(this.fixUpKeyStoreRef((String)props.get(CFG_KEY_KEYSTORE_REF)));
        this.keyAliasName = this.trimIt((String)props.get(CFG_KEY_KEY_ALIAS_NAME));
        this.trustStoreRef = this.trimIt((String)props.get(CFG_KEY_TRUSTSTORE_REF));
        this.idTokenLifetime = (Long)props.get(CFG_KEY_ID_TOKEN_LIFETIME);
        this.checkSessionIframeEndpointUrl = this.trimIt((String)props.get(CFG_KEY_CHECK_SESSION_IFRAME_ENDPOINT_URL));
        this.cacheIDToken = (Boolean)props.get(CFG_KEY_CACHE_IDTOKEN);
        if (props.get(CFG_KEY_SSO_COOKIE_NAME) != null) {
            this.allowLtpaToken2Name = (Boolean)props.get(CFG_KEY_SSO_COOKIE_NAME);
        }
        if (!(protectedEndpoints = this.trimIt((String)props.get(CFG_KEY_PROTECTED_ENDPOINTS))).equals(this.protectedEndpoints)) {
            this.protectedEndpoints = protectedEndpoints;
            this.patternProtectedEndpoints = this.handleNewPattern(protectedEndpoints);
        }
        this.patternOidcEndpoints = this.handleOidcPattern();
        this.patternNonOidcEndpoints = this.handleNonOidcPattern();
        this.scopeToClaimMap = this.configUtils.processFlatProps(props, "scopeToClaimMap");
        this.claimToUserRegistryMap = this.configUtils.processFlatProps(props, "claimToUserRegistryMap");
        this.discovery = this.configUtils.processDiscoveryProps(props, "discovery");
        this.processDiscoveryRefElement();
        if (props.containsKey(CFG_KEY_REQUIRE_OPENID_SCOPE_FOR_USERINFO)) {
            this.requireOpenidScopeForUserInfo = (Boolean)props.get(CFG_KEY_REQUIRE_OPENID_SCOPE_FOR_USERINFO);
        }
        this.jwkEnabled = (Boolean)props.get(CFG_KEY_JWK_ENABLED);
        this.jwkRotationTime = (Long)props.get(CFG_KEY_JWK_ROTATION);
        this.jwkRotationTime = this.jwkRotationTime * 60L * 1000L;
        this.jwkSigningKeySize = ((Long)props.get(CFG_KEY_JWK_SIGNING_KEY_SIZE)).intValue();
        this.buildJwk();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("providerId: " + this.providerId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("oauthProviderRef: " + this.oauthProviderRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userIdentifier: " + this.userIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("uniqueUserIdentifier: " + this.uniqueUserIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("issuerIdentifier: " + this.issuerIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("audience: " + this.audience), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userIdentity: " + this.userIdentity), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupIdentifier: " + this.groupIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("customClaimsEnabled: " + this.customClaimsEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("customClaims: " + this.customClaims), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jtiClaimEnabled: " + this.jtiClaimEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("defaultScope: " + this.defaultScope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("externalClaimNames: " + this.externalClaimNames), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapScopeToClaims: " + this.scopeToClaimMap), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("claimToUserRegistryAttributeMappings: " + this.claimToUserRegistryMap), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("signatureAlgorithm: " + this.signatureAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("keyStoreRef: " + this.keyStoreRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("keyAliasName: " + this.keyAliasName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("trustStoreRef: " + this.trustStoreRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sessionManaged: " + this.sessionManaged), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("idTokenLifetime: " + this.idTokenLifetime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("checkSessionIframeEndpointUrl: " + this.checkSessionIframeEndpointUrl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("protectedEndpoints: " + protectedEndpoints), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwkRotationTime: " + this.jwkRotationTime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwkEnabled: " + this.jwkEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("allowLtpaToken2Name: " + this.allowLtpaToken2Name), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("cacheIDToken: " + this.cacheIDToken), (Object[])new Object[0]);
        }
        OIDCProvidersConfig.putOidcServerConfig(this.providerId, this);
    }

    protected Set<String> newCustomClaims(String[] aCustomClaims) {
        HashSet<String> result = new HashSet<String>();
        if (aCustomClaims != null) {
            for (String claim : aCustomClaims) {
                if (defaultCustomClaims.contains(claim = claim.trim())) continue;
                result.add(claim);
            }
        }
        return result;
    }

    private void processDiscoveryRefElement() {
        this.responseTypesSupported = (String[])this.discovery.get(CFG_KEY_RESPONSE_TYPES_SUPPORTED);
        this.subjectTypesSupported = (String[])this.discovery.get(CFG_KEY_SUBJECT_TYPES_SUPPORTED);
        this.idTokenSigningAlgValuesSupported = this.signatureAlgorithm;
        this.scopesSupported = (String[])this.discovery.get(CFG_KEY_SCOPES_SUPPORTED);
        this.claimsSupported = (String[])this.discovery.get(CFG_KEY_CLAIMS_SUPPORTED);
        this.responseModesSupported = (String[])this.discovery.get(CFG_KEY_RESPONSE_MODES_SUPPORTED);
        this.grantTypesSupported = (String[])this.discovery.get(CFG_KEY_GRANT_TYPES_SUPPORTED);
        this.tokenEndpointAuthMethodsSupported = (String[])this.discovery.get(CFG_KEY_TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED);
        this.displayValuesSupported = (String[])this.discovery.get(CFG_KEY_DISPLAY_VALUES_SUPPORTED);
        this.claimTypesSupported = (String[])this.discovery.get(CFG_KEY_CLAIM_TYPES_SUPPORTED);
        this.claimsParameterSupported = (Boolean)this.discovery.get(CFG_KEY_CLAIMS_PARAMETERS_SUPPORTED);
        this.requestParameterSupported = (Boolean)this.discovery.get(CFG_KEY_REQUEST_PARAMETERS_SUPPORTED);
        this.requestUriParameterSupported = (Boolean)this.discovery.get(CFG_KEY_REQUEST_URI_PARAMETER_SUPPORTED);
        this.requireRequestUriRegistration = (Boolean)this.discovery.get(CFG_KEY_REQUIRE_REQUEST_URI_REGISTRATION);
        this.backingIdpUriPrefix = this.trimIt((String)this.discovery.get(CFG_KEY_BACKING_IDP_URI_PREFIX));
        this.authProxyEndpointUrl = this.trimIt(this.discovery.getProperty(CFG_KEY_AUTH_PROXY_ENDPOINT_URL));
    }

    public String getProviderId() {
        this.readLock.lock();
        try {
            String string = this.providerId;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getOauthProviderName() {
        this.readLock.lock();
        try {
            String string = this.getOauthProviderName(this.oauthProviderRef);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getOauthProviderName(String oauthProviderRef) {
        Configuration config = null;
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            config = configAdmin.getConfiguration(oauthProviderRef, null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.server.internal.OidcServerConfigImpl", (String)"454", (Object)this, (Object[])new Object[]{oauthProviderRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid oauthProviderRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return null;
        }
        String id = (String)props.get(CFG_KEY_ID);
        return id;
    }

    public String getOauthProviderPid() {
        this.readLock.lock();
        try {
            String string = this.oauthProviderRef;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getUserIdentifier() {
        this.readLock.lock();
        try {
            String string = this.userIdentifier;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getIssuerIdentifier() {
        this.readLock.lock();
        try {
            String string = this.issuerIdentifier;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getGroupIdentifier() {
        this.readLock.lock();
        try {
            String string = this.groupIdentifier;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isCustomClaimsEnabled() {
        this.readLock.lock();
        try {
            boolean bl = this.customClaimsEnabled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isJTIClaimEnabled() {
        this.readLock.lock();
        try {
            boolean bl = this.jtiClaimEnabled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getDefaultScope() {
        this.readLock.lock();
        try {
            String string = this.defaultScope;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getExternalClaimNames() {
        this.readLock.lock();
        try {
            String string = this.externalClaimNames;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Properties getScopeToClaimMap() {
        this.readLock.lock();
        try {
            Properties properties = this.scopeToClaimMap;
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Properties getClaimToUserRegistryMap() {
        this.readLock.lock();
        try {
            Properties properties = this.claimToUserRegistryMap;
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getSignatureAlgorithm() {
        this.readLock.lock();
        try {
            String string = this.signatureAlgorithm;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getUniqueUserIdentifier() {
        this.readLock.lock();
        try {
            String string = this.uniqueUserIdentifier;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getAudience() {
        this.readLock.lock();
        try {
            String string = this.audience;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getUserIdentity() {
        this.readLock.lock();
        try {
            String string = this.userIdentity;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getTrustStoreRef() {
        this.readLock.lock();
        try {
            String string = this.trustStoreRef;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SSLSupport getSSLSupportService() {
        return (SSLSupport)this.sslSupportRef.getService();
    }

    public String getDefaultKeyStoreName(String propKey) {
        String keyStoreName = null;
        SSLSupport sslSupport = this.getSSLSupportService();
        JSSEHelper helper = null;
        if (sslSupport != null) {
            helper = sslSupport.getJSSEHelper();
        }
        Properties props = null;
        final JSSEHelper jsseHelper = helper;
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", "inbound");
        if (jsseHelper != null) {
            block6: {
                try {
                    props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                        static final long serialVersionUID = 673550988537273538L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() throws Exception {
                            return jsseHelper.getProperties("", connectionInfo, null, true);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.server.internal.OidcServerConfigImpl$1", 1.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.openidconnect.server.internal.OidcServerConfigImpl", (String)"664", (Object)this, (Object[])new Object[]{propKey});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting properties from jssehelper!!!", (Object[])new Object[0]);
                }
            }
            if (props != null) {
                keyStoreName = props.getProperty(propKey);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("KeyStore name from default ssl config = " + keyStoreName), (Object[])new Object[0]);
                }
            }
        }
        return keyStoreName;
    }

    private String fixUpKeyStoreRef(String keyStoreRef) {
        if (!keyStoreRef.equals(CFG_KEYSTORE_REF_DEFAULT)) {
            return keyStoreRef;
        }
        if (!this.keyStoreExists(keyStoreRef) && this.onlyOneKeyStore()) {
            return this.getDefaultKeyStoreName("com.ibm.ssl.keyStoreName");
        }
        return keyStoreRef;
    }

    @FFDCIgnore(value={KeyStoreException.class})
    private boolean keyStoreExists(String keyStoreRef) {
        KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
        try {
            keyStoreService.getKeyStoreLocation(keyStoreRef);
        }
        catch (KeyStoreException k) {
            return false;
        }
        return true;
    }

    private boolean onlyOneKeyStore() {
        KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
        return keyStoreService.getKeyStoreCount() == 1;
    }

    @Sensitive
    public PrivateKey getPrivateKey() throws KeyStoreException, CertificateException {
        this.readLock.lock();
        try {
            KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
            if (this.keyStoreRef == null) {
                this.keyStoreRef = this.getDefaultKeyStoreName("com.ibm.ssl.keyStoreName");
            }
            if (this.keyAliasName != null) {
                PrivateKey privateKey = keyStoreService.getPrivateKeyFromKeyStore(this.keyStoreRef, this.keyAliasName, null);
                return privateKey;
            }
            PrivateKey privateKey = keyStoreService.getPrivateKeyFromKeyStore(this.keyStoreRef);
            return privateKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    public PublicKey getPublicKey(String trustAliasName) throws KeyStoreException, CertificateException {
        this.readLock.lock();
        try {
            KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
            if (keyStoreService != null && this.signatureAlgorithm.equals("RS256")) {
                if (this.trustStoreRef == null) {
                    this.trustStoreRef = this.getDefaultKeyStoreName("com.ibm.ssl.trustStoreName");
                }
                if (trustAliasName != null) {
                    PublicKey publicKey = keyStoreService.getCertificateFromKeyStore(this.trustStoreRef, trustAliasName).getPublicKey();
                    return publicKey;
                }
                Collection aliases = keyStoreService.getTrustedCertEntriesInKeyStore(this.trustStoreRef);
                if (aliases == null || aliases.size() == 0) {
                    X509Certificate cert = keyStoreService.getX509CertificateFromKeyStore(this.trustStoreRef);
                    if (cert != null) {
                        PublicKey publicKey = cert.getPublicKey();
                        return publicKey;
                    }
                    PublicKey publicKey = null;
                    return publicKey;
                }
                if (aliases.size() > 1) {
                    PublicKey cert = null;
                    return cert;
                }
                String alias = (String)aliases.iterator().next();
                X509Certificate cert = keyStoreService.getX509CertificateFromKeyStore(this.trustStoreRef, alias);
                if (cert != null) {
                    PublicKey publicKey = cert.getPublicKey();
                    return publicKey;
                }
                PublicKey publicKey = null;
                return publicKey;
            }
            PublicKey publicKey = null;
            return publicKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    @FFDCIgnore(value={KeyStoreException.class, CertificateException.class})
    public PublicKey getX509PublicKey() {
        this.readLock.lock();
        PublicKey result = null;
        try {
            String myKeyStoreRef = this.keyStoreRef;
            KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
            if (keyStoreService != null) {
                String[] ksAliases = keyStoreService.getAllKeyStoreAliases();
                if (this.keyStoreRef != null && this.keyStoreRef.equals(CFG_KEYSTORE_REF_DEFAULT)) {
                    boolean keyStoreExists = false;
                    for (int i = 0; i < ksAliases.length; ++i) {
                        if (!ksAliases[i].equals(this.keyStoreRef)) continue;
                        keyStoreExists = true;
                        break;
                    }
                    if (!keyStoreExists) {
                        myKeyStoreRef = null;
                    }
                }
                if (myKeyStoreRef == null && ksAliases.length == 1) {
                    myKeyStoreRef = ksAliases[0];
                }
                if (myKeyStoreRef != null) {
                    X509Certificate x509 = null;
                    x509 = this.keyAliasName == null ? keyStoreService.getX509CertificateFromKeyStore(myKeyStoreRef) : keyStoreService.getX509CertificateFromKeyStore(myKeyStoreRef, this.keyAliasName);
                    if (x509 != null) {
                        result = x509.getPublicKey();
                    }
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateException certificateException) {
        }
        finally {
            this.readLock.unlock();
        }
        return result;
    }

    public boolean isSessionManaged() {
        this.readLock.lock();
        try {
            boolean bl = this.sessionManaged;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getIdTokenLifetime() {
        this.readLock.lock();
        try {
            long l = this.idTokenLifetime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getCheckSessionIframeEndpointUrl() {
        this.readLock.lock();
        try {
            String string = this.checkSessionIframeEndpointUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getResponseTypesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.responseTypesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getSubjectTypesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.subjectTypesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getIdTokenSigningAlgValuesSupported() {
        this.readLock.lock();
        try {
            String string = this.idTokenSigningAlgValuesSupported;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getScopesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.scopesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getClaimsSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.claimsSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getResponseModesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.responseModesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getGrantTypesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.grantTypesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getTokenEndpointAuthMethodsSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.tokenEndpointAuthMethodsSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getDisplayValuesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.displayValuesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String[] getClaimTypesSupported() {
        this.readLock.lock();
        try {
            String[] stringArray = (String[])this.claimTypesSupported.clone();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isClaimsParameterSupported() {
        this.readLock.lock();
        try {
            boolean bl = this.claimsParameterSupported;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isRequestParameterSupported() {
        this.readLock.lock();
        try {
            boolean bl = this.requestParameterSupported;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isRequestUriParameterSupported() {
        this.readLock.lock();
        try {
            boolean bl = this.requestUriParameterSupported;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isRequireRequestUriRegistration() {
        this.readLock.lock();
        try {
            boolean bl = this.requireRequestUriRegistration;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getBackingIdpUriPrefix() {
        this.readLock.lock();
        try {
            String string = this.backingIdpUriPrefix;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getAuthProxyEndpointUrl() {
        this.readLock.lock();
        try {
            String string = this.authProxyEndpointUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getKeyStoreRef() {
        this.readLock.lock();
        try {
            String string = this.keyStoreRef;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getKeyAliasName() {
        this.readLock.lock();
        try {
            String string = this.keyAliasName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Pattern getProtectedEndpointsPattern() {
        return this.patternProtectedEndpoints;
    }

    public Pattern getEndpointsPattern() {
        return this.patternOidcEndpoints;
    }

    public Pattern getNonEndpointsPattern() {
        return this.patternNonOidcEndpoints;
    }

    public boolean isOpenidScopeRequiredForUserInfo() {
        return this.requireOpenidScopeForUserInfo;
    }

    private Pattern handleNewPattern(String protectedEndpoints) {
        String pattern = "/oidc/(endpoint|providers)/" + this.providerId + "/(";
        StringTokenizer st = new StringTokenizer(protectedEndpoints, " ");
        boolean bHasOne = false;
        String ep = null;
        while (st.hasMoreTokens()) {
            if (bHasOne) {
                pattern = pattern.concat("|");
            }
            pattern = "authorize".equals(ep = st.nextToken()) ? pattern.concat(ep) : pattern.concat(ep + "|" + ep + "/.*");
            bHasOne = true;
        }
        pattern = pattern.concat(")");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Pattern:" + pattern), (Object[])new Object[0]);
        }
        return Pattern.compile(pattern);
    }

    private Pattern handleOidcPattern() {
        String pattern = "/oidc/(endpoint|providers)/" + this.providerId + "/.*";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Pattern:" + pattern), (Object[])new Object[0]);
        }
        return Pattern.compile(pattern);
    }

    private Pattern handleNonOidcPattern() {
        String pattern = "/oidc/(endpoint|providers)/" + this.providerId + "/(end_session|check_session_iframe)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Non Pattern:" + pattern), (Object[])new Object[0]);
        }
        return Pattern.compile(pattern);
    }

    public boolean isJwkEnabled() {
        return this.jwkEnabled;
    }

    private void buildJwk() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("buildJwk: jwkEnabled=" + this.jwkEnabled), (Object[])new Object[0]);
        }
        if (!this.jwkEnabled) {
            this.jwkProvider = null;
            return;
        }
        this.jwkProvider = new JWKProvider(this.jwkSigningKeySize, this.signatureAlgorithm, this.jwkRotationTime);
    }

    public String getJwkJsonString() {
        if (this.isJwkEnabled()) {
            return this.jwkProvider.getJwkSetString();
        }
        this.jwkProvider = this.getJwkProviderWithX509();
        if (this.jwkProvider != null) {
            return this.jwkProvider.getJwkSetString();
        }
        Tr.warning((TraceComponent)tc, (String)"OIDC_SERVER_JWK_NOT_AVAILABLE", (Object[])new Object[0]);
        return null;
    }

    public JSONWebKey getJSONWebKey() {
        if (this.isJwkEnabled()) {
            return this.jwkProvider.getJWK();
        }
        this.jwkProvider = this.getJwkProviderWithX509();
        if (this.jwkProvider != null) {
            return this.jwkProvider.getJWK();
        }
        return null;
    }

    @FFDCIgnore(value={KeyStoreException.class, CertificateException.class})
    private JWKProvider getJwkProviderWithX509() {
        JWKProvider jwkX509Provider = null;
        if (this.signatureAlgorithm.equals("RS256") && !ServerConstants.JAVA_VERSION_6) {
            PublicKey publicKey = null;
            PrivateKey privateKey = null;
            try {
                publicKey = this.getX509PublicKey();
                privateKey = this.getPrivateKey();
            }
            catch (KeyStoreException keyStoreException) {
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (publicKey != null) {
                jwkX509Provider = new JWKProvider(this.jwkSigningKeySize, this.signatureAlgorithm, this.jwkRotationTime, publicKey, privateKey);
            }
        }
        return jwkX509Provider;
    }

    public long getJwkRotationTime() {
        return this.jwkRotationTime;
    }

    public int getJwkSigningKeySize() {
        return this.jwkSigningKeySize;
    }

    public Set<String> getCustomClaims() {
        return new HashSet<String>(this.customClaims);
    }

    public boolean allowDefaultSsoCookieName() {
        return this.allowLtpaToken2Name;
    }

    @Trivial
    String trimIt(String str) {
        if (str == null) {
            return null;
        }
        String retVal = str.trim();
        if (retVal.isEmpty()) {
            retVal = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("trimIt(" + str + ") returns [" + retVal + "]"), (Object[])new Object[0]);
        }
        return retVal;
    }

    public boolean cacheIDToken() {
        return this.cacheIDToken;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        defaultCustomClaims.add("realmName");
        defaultCustomClaims.add("uniqueSecurityName");
        defaultCustomClaims.add("groupIds");
    }
}

