/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.security.openidconnect.server.internal.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcDiscoveryProviderConfig {
    private static final Map<String, String> endpointMap;
    private HttpServletRequest request;
    private String issuerId;
    static final long serialVersionUID = -2154674774633781894L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private OidcDiscoveryProviderConfig() {
    }

    public OidcDiscoveryProviderConfig(String providerId, HttpServletRequest request) {
        this.request = request;
        this.issuerId = this.getCalculatedIssuerId(providerId);
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getEndpoint(String endpointProp) {
        return this.getCalculatedEndpoint(endpointMap.get(endpointProp));
    }

    private String getCalculatedIssuerId(String providerId) {
        String fullServletPath = HttpUtils.getFullCtxServletPath(this.request);
        return new StringBuffer().append(fullServletPath).append(fullServletPath.endsWith("/") ? "" : "/").append(providerId).toString();
    }

    private String getCalculatedEndpoint(String endpoint) {
        return new StringBuffer().append(this.issuerId).append(this.issuerId.endsWith("/") ? "" : "/").append(endpoint).toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.server.internal.OidcDiscoveryProviderConfig", OidcDiscoveryProviderConfig.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
        endpointMap = new HashMap<String, String>();
        endpointMap.put("oidc.provider.authorizationEndpoint", OAuth20Request.EndpointType.authorize.name());
        endpointMap.put("oidc.provider.introspectionEndpoint", OAuth20Request.EndpointType.introspect.name());
        endpointMap.put("oidc.provider.tokenEndpoint", OAuth20Request.EndpointType.token.name());
        endpointMap.put("oidc.provider.jwksURI", OAuth20Request.EndpointType.jwk.name());
        endpointMap.put("oidc.provider.userinfoEndpoint", OAuth20Request.EndpointType.userinfo.name());
        endpointMap.put("oidc.provider.registrationEndpoint", OAuth20Request.EndpointType.registration.name());
        endpointMap.put("oidc.provider.checkSessionIframe", OAuth20Request.EndpointType.check_session_iframe.name());
        endpointMap.put("oidc.provider.endSessionEndpoint", OAuth20Request.EndpointType.end_session.name());
        endpointMap.put("oidc.provider.coverageMapEndpoint", OAuth20Request.EndpointType.coverage_map.name());
        endpointMap.put("oidc.provider.proxyEndpoint", OAuth20Request.EndpointType.proxy.name());
        endpointMap.put("oidc.provider.revocationEndpoint", OAuth20Request.EndpointType.revoke.name());
        endpointMap.put("oidc.provider.appPasswordsEndpoint", OAuth20Request.EndpointType.app_password_effective_name);
        endpointMap.put("oidc.provider.appTokensEndpoint", OAuth20Request.EndpointType.app_token_effective_name);
        endpointMap.put("oidc.provider.personalTokenMgmtEndpoint", OAuth20Request.EndpointType.personalTokenManagement.name());
        endpointMap.put("oidc.provider.usersTokenMgmtEndpoint", OAuth20Request.EndpointType.usersTokenManagement.name());
        endpointMap.put("oidc.provider.clientMgmtEndpoint", OAuth20Request.EndpointType.clientManagement.name());
    }
}

