/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.yoko.orb.OCI.AlignmentBoundary;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.SimplyCloseable;
import org.omg.CORBA.portable.InputStream;

public final class WriteBuffer
extends Buffer<WriteBuffer> {
    private static final byte PAD_BYTE = -67;
    private static final int PADDING_POWER = 5;
    private static final byte[] PADDING = new byte[32];
    private final Buffer.Core core;

    WriteBuffer(Buffer.Core core) {
        this.core = core;
    }

    @Override
    public int length() {
        return this.core.length;
    }

    @Override
    boolean dataEquals0(WriteBuffer that) {
        return this.core.dataEquals(that.core);
    }

    public boolean readFrom(java.io.InputStream in) throws IOException {
        try {
            int result = in.read(this.core.data, this.position, this.available());
            if (result <= 0) {
                return false;
            }
            this.position += result;
            assert (this.position <= this.core.length);
            return true;
        }
        catch (InterruptedIOException ex) {
            this.position += ex.bytesTransferred;
            throw ex;
        }
    }

    public WriteBuffer readFrom(InputStream source) {
        int length = this.available();
        source.read_octet_array(this.core.data, this.position, length);
        this.position += length;
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeBytes(byte[] bytes) {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public WriteBuffer writeBytes(byte[] bytes, int offset, int length) {
        System.arraycopy(bytes, offset, this.core.data, this.position, length);
        this.position += length;
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeByte(int i) {
        this.core.data[this.position++] = (byte)i;
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeByte(byte b) {
        this.core.data[this.position++] = b;
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeChar(char value) {
        this.core.data[this.position++] = (byte)(value >> 8);
        this.core.data[this.position++] = (byte)(value >> 0);
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeShort(short value) {
        this.core.data[this.position++] = (byte)(value >> 8);
        this.core.data[this.position++] = (byte)(value >> 0);
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeInt(int value) {
        this.core.data[this.position++] = (byte)(value >> 24);
        this.core.data[this.position++] = (byte)(value >> 16);
        this.core.data[this.position++] = (byte)(value >> 8);
        this.core.data[this.position++] = (byte)(value >> 0);
        assert (this.position <= this.core.length);
        return this;
    }

    public WriteBuffer writeLong(long value) {
        this.core.data[this.position++] = (byte)(value >> 56);
        this.core.data[this.position++] = (byte)(value >> 48);
        this.core.data[this.position++] = (byte)(value >> 40);
        this.core.data[this.position++] = (byte)(value >> 32);
        this.core.data[this.position++] = (byte)(value >> 24);
        this.core.data[this.position++] = (byte)(value >> 16);
        this.core.data[this.position++] = (byte)(value >> 8);
        this.core.data[this.position++] = (byte)(value >> 0);
        assert (this.position <= this.core.length);
        return this;
    }

    public SimplyCloseable recordLength(final Logger logger) {
        final int lengthPosition = this.position;
        logger.finest("Writing a gap value for a length at offset " + lengthPosition);
        this.pad(4);
        return new SimplyCloseable(){

            @Override
            public void close() {
                int length = WriteBuffer.this.position - (lengthPosition + 4);
                ((WriteBuffer)WriteBuffer.this).core.data[lengthPosition + 0] = (byte)(length >> 24);
                ((WriteBuffer)WriteBuffer.this).core.data[lengthPosition + 1] = (byte)(length >> 16);
                ((WriteBuffer)WriteBuffer.this).core.data[lengthPosition + 2] = (byte)(length >> 8);
                ((WriteBuffer)WriteBuffer.this).core.data[lengthPosition + 3] = (byte)(length >> 0);
                logger.finest("Wrote a length value of " + length + " at offset " + lengthPosition);
            }
        };
    }

    private WriteBuffer pad(int n) {
        int padByte = -67;
        switch (n) {
            case 7: {
                this.writeByte((byte)-67);
            }
            case 6: {
                this.writeByte((byte)-67);
            }
            case 5: {
                this.writeByte((byte)-67);
            }
            case 4: {
                this.writeByte((byte)-67);
            }
            case 3: {
                this.writeByte((byte)-67);
            }
            case 2: {
                this.writeByte((byte)-67);
            }
            case 1: {
                this.writeByte((byte)-67);
            }
            case 0: {
                break;
            }
            default: {
                for (int i = n >> 5; i > 0; --i) {
                    this.writeBytes(PADDING);
                }
                this.writeBytes(PADDING, 0, n & 0x1F);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureAvailable(int size, AlignmentBoundary boundary) {
        int gap = boundary.gap(this.position);
        try {
            boolean bl = this.ensureAvailable(gap + size);
            return bl;
        }
        finally {
            this.pad(gap);
        }
    }

    public boolean ensureAvailable(int size) {
        int shortfall = size - this.available();
        return shortfall > 0 && this.core.growBy(shortfall);
    }

    public WriteBuffer padAlign(AlignmentBoundary boundary) {
        return this.pad(boundary.gap(this.position));
    }

    public WriteBuffer padAll() {
        return this.pad(this.core.length);
    }

    public WriteBuffer trim() {
        this.core.length = this.position;
        return this;
    }

    public ReadBuffer readFromStart() {
        return new ReadBuffer(this.core);
    }

    @Override
    void dumpData(StringBuilder dump) {
        this.core.dumpTo(dump);
    }

    static {
        Arrays.fill(PADDING, (byte)-67);
    }
}

