/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CodeSetDatabase;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.DispatchRequest;
import org.apache.yoko.orb.OB.DispatchStrategy;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.UpcallReturn;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.util.Timeout;
import org.apache.yoko.util.cmsf.CmsfThreadLocal;
import org.omg.CORBA.Any;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableServer.Servant;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.CodeBaseHelper;

public class Upcall {
    private static final Logger logger = Logger.getLogger(Upcall.class.getName());
    private final ORBInstance orbInstance_;
    protected final UpcallReturn upcallReturn_;
    private final ProfileInfo profileInfo_;
    protected final TransportInfo transportInfo_;
    private final int reqId_;
    protected final String op_;
    private OutputStream out_;
    private final InputStream in_;
    protected final ServiceContexts requestContexts;
    protected final ServiceContexts replyContexts;
    private DispatchRequest dispatchRequest_;
    private DispatchStrategy dispatchStrategy_;
    private Servant servant_;
    private POA_impl poa_;
    private boolean postinvokeCalled_;
    private boolean userEx_;
    protected ServiceContext codeSetSC_;
    private ServiceContext codeBaseSC_;
    private final Timeout timeout;

    public Upcall(ORBInstance orbInstance, UpcallReturn upcallReturn, ProfileInfo profileInfo, TransportInfo transportInfo, int requestId, String op, InputStream in, ServiceContexts requestContexts) {
        this.orbInstance_ = orbInstance;
        this.upcallReturn_ = upcallReturn;
        this.profileInfo_ = profileInfo;
        this.transportInfo_ = transportInfo;
        this.reqId_ = requestId;
        this.op_ = op;
        this.in_ = in;
        this.requestContexts = requestContexts;
        this.replyContexts = new ServiceContexts();
        this.servant_ = null;
        this.poa_ = null;
        this.postinvokeCalled_ = false;
        this.userEx_ = false;
        logger.fine("Creating upcall request for operation " + op + " and request id " + requestId);
        in._OB_ORBInstance(this.orbInstance_);
        PolicyManager pm = orbInstance.getPolicyManager();
        Policy[] policy_overrides = pm.get_policy_overrides(new int[0]);
        RefCountPolicyList policies = new RefCountPolicyList(policy_overrides);
        this.timeout = Timeout.in((int)policies.replyTimeout);
    }

    public ORBInstance orbInstance() {
        return this.orbInstance_;
    }

    public ProfileInfo profileInfo() {
        return this.profileInfo_;
    }

    public TransportInfo transportInfo() {
        return this.transportInfo_;
    }

    public int requestId() {
        return this.reqId_;
    }

    public String operation() {
        return this.op_;
    }

    public boolean responseExpected() {
        return this.upcallReturn_ != null;
    }

    public boolean postinvokeCalled() {
        return this.postinvokeCalled_;
    }

    public OutputStream output() {
        return this.out_;
    }

    public InputStream input() {
        return this.in_;
    }

    public void createOutputStream(int offset) {
        GiopVersion giopVersion = GiopVersion.get(this.profileInfo_.major, this.profileInfo_.minor);
        this.out_ = new OutputStream(Buffer.createWriteBuffer(offset).padAll(), this.in_._OB_codeConverters(), giopVersion);
    }

    public InputStream preUnmarshal() {
        return this.in_;
    }

    public void unmarshalEx(SystemException ex) {
        throw ex;
    }

    public void postUnmarshal() throws LocationForward {
    }

    public void postinvoke() {
        if (this.servant_ != null) {
            Assert._OB_assert(this.poa_ != null && !this.postinvokeCalled_);
            this.servant_ = null;
            this.postinvokeCalled_ = true;
            this.poa_._OB_postinvoke();
        }
    }

    private void initServiceContexts() {
        if (this.codeBaseSC_ == null) {
            ValueHandler valueHandler = Util.createValueHandler();
            CodeBase codeBase = (CodeBase)valueHandler.getRunTimeCodeBase();
            try (OutputStream outCBC = new OutputStream();){
                outCBC._OB_writeEndian();
                CodeBaseHelper.write((org.omg.CORBA.portable.OutputStream)outCBC, (CodeBase)codeBase);
                this.codeBaseSC_ = new ServiceContext();
                this.codeBaseSC_.context_id = 6;
                this.codeBaseSC_.context_data = outCBC.copyWrittenBytes();
            }
        }
    }

    public OutputStream preMarshal() throws LocationForward {
        if (this.upcallReturn_ != null) {
            this.addUnsentConnectionServiceContexts();
            this.upcallReturn_.upcallBeginReply(this, this.replyContexts);
        } else {
            this.out_ = new OutputStream(this.in_._OB_codeConverters(), GiopVersion.get(this.profileInfo_.major, this.profileInfo_.minor));
        }
        this.out_._OB_ORBInstance(this.orbInstance());
        if (this.out_ != null) {
            this.out_.setTimeout(this.timeout);
        }
        return this.out_;
    }

    private void addUnsentConnectionServiceContexts() {
        if (this.upcallReturn_.replySent()) {
            return;
        }
        if (this.profileInfo_.major <= 1 && this.profileInfo_.minor < 1) {
            return;
        }
        this.initServiceContexts();
        Assert._OB_assert(this.codeBaseSC_ != null);
        this.replyContexts.mutable().add(this.codeBaseSC_);
    }

    public void marshalEx(SystemException ex) {
        throw ex;
    }

    public void postMarshal() {
        if (this.upcallReturn_ != null) {
            this.upcallReturn_.upcallEndReply(this);
        }
        this.out_.setTimeout(Timeout.NEVER);
    }

    public void setUserException(Any any) {
        if (this.upcallReturn_ != null) {
            this.upcallReturn_.upcallBeginUserException(this, this.replyContexts);
            try {
                any.write_value((org.omg.CORBA.portable.OutputStream)this.out_);
            }
            catch (SystemException ex) {
                this.marshalEx(ex);
            }
            this.userEx_ = true;
            if (this.out_ != null) {
                this.out_.setTimeout(Timeout.NEVER);
            }
        }
    }

    public OutputStream beginUserException(UserException ex) {
        if (this.upcallReturn_ != null) {
            this.upcallReturn_.upcallBeginUserException(this, this.replyContexts);
            this.userEx_ = true;
            return this.out_;
        }
        return null;
    }

    public boolean userException() {
        return this.userEx_;
    }

    public void endUserException() {
        if (this.upcallReturn_ != null) {
            Assert._OB_assert(this.userEx_);
            this.upcallReturn_.upcallEndUserException(this);
        }
    }

    public void setSystemException(SystemException ex) {
        if (this.upcallReturn_ != null) {
            this.addUnsentConnectionServiceContexts();
            this.userEx_ = false;
            if (ex instanceof UnknownException) {
                Upcall.createUnknownExceptionServiceContexts((UnknownException)ex, this.replyContexts);
            }
            this.upcallReturn_.upcallSystemException(this, ex, this.replyContexts);
        }
    }

    private static void createUnknownExceptionServiceContexts(UnknownException ex, ServiceContexts replyContexts) {
        Throwable t = ex.originalEx;
        try (CmsfThreadLocal.CmsfOverride o = CmsfThreadLocal.override();){
            CodeConverterBase outputWcharConverter = CodeSetDatabase.getConverter(CodeSetInfo.UTF_16, CodeSetInfo.UTF_16);
            CodeConverters codeConverters = new CodeConverters(null, null, null, outputWcharConverter);
            try (OutputStream os = new OutputStream(codeConverters, GiopVersion.GIOP1_2);){
                os._OB_writeEndian();
                os.write_value((Serializable)t, Throwable.class);
                ServiceContext sc = new ServiceContext(9, os.copyWrittenBytes());
                replyContexts.mutable().add(sc, false);
            }
        }
    }

    public void setLocationForward(IOR ior, boolean perm) {
        if (this.upcallReturn_ == null) {
            return;
        }
        this.userEx_ = false;
        this.upcallReturn_.upcallForward(this, ior, perm, this.replyContexts);
    }

    public void contextSwitch() {
    }

    public void setDispatchInfo(DispatchRequest dispatchRequest, DispatchStrategy dispatchStrategy) {
        this.dispatchRequest_ = dispatchRequest;
        this.dispatchStrategy_ = dispatchStrategy;
    }

    public void setServantAndPOA(Servant servant, POA_impl poa) {
        this.servant_ = servant;
        this.poa_ = poa;
    }

    public void invoke() {
        try {
            if (this.dispatchStrategy_ != null) {
                logger.fine("Dispatching request " + this.reqId_ + " with dispatch strategy " + this.dispatchStrategy_.getClass().getName());
                this.dispatchStrategy_.dispatch(this.dispatchRequest_);
            }
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Exception received dispatching request", ex);
            this.setSystemException(ex);
        }
    }
}

