/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadFactory;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.BootManager;
import org.apache.yoko.orb.OB.ClientManager;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.DispatchStrategyFactory;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.MultiRequestSender;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.OrbAsyncHandler;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.PolicyFactoryManager;
import org.apache.yoko.orb.OB.RecursiveMutex;
import org.apache.yoko.orb.OB.URLRegistry;
import org.apache.yoko.orb.OB.UnknownExceptionStrategy;
import org.apache.yoko.orb.OB.ValueFactoryManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OCI.AccFactoryRegistry;
import org.apache.yoko.orb.OCI.ConFactoryRegistry;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.util.Cache;
import org.apache.yoko.util.concurrent.WeakCountedCache;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.IOP.CodecFactory;

public final class ORBInstance {
    private boolean destroy_;
    private static final Cache.Cleaner<GIOPConnection> CLEANER = new Cache.Cleaner<GIOPConnection>(){

        public void clean(GIOPConnection conn) {
            conn.destroy();
        }
    };
    private final Cache<ConnectorInfo, GIOPConnection> outboundConnectionCache = new WeakCountedCache(CLEANER, 0, 100);
    private ORB orb_;
    private int nativeCs_;
    private int nativeWcs_;
    private int defaultWcs_;
    private String orbId_;
    private String serverId_;
    private String serverInstance_;
    private ObjectFactory objectFactory_;
    private ClientManager clientManager_;
    private PolicyFactoryManager policyFactoryManager_;
    private PIManager interceptorManager_;
    private InitialServiceManager initServiceManager_;
    private ValueFactoryManager valueFactoryManager_;
    private CodecFactory codecFactory_;
    private POAManagerFactory pmFactory_;
    private MultiRequestSender multiRequestSender_;
    private Properties properties_;
    private DispatchStrategyFactory dispatchStrategyFactory_;
    private BootManager bootManager_;
    private Logger logger_;
    private CoreTraceLevels coreTraceLevels_;
    private RecursiveMutex orbSyncMutex_ = new RecursiveMutex();
    private ExecutorService serverExecutor_;
    private Phaser serverPhaser = new Phaser(1);
    private ExecutorService clientExecutor_;
    private Phaser clientPhaser = new Phaser(1);
    private ConFactoryRegistry conFactoryRegistry_;
    private AccFactoryRegistry accFactoryRegistry_;
    private UnknownExceptionStrategy unknownExceptionStrategy_;
    private URLRegistry urlRegistry_;
    private boolean useTypeCodeCache_;
    private boolean extendedWchar_;
    OrbAsyncHandler asyncHandler_ = null;

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.destroy_);
        super.finalize();
    }

    public ORBInstance(ORB orb, String orbId, String serverId, String serverInstance, ObjectFactory objectFactory, ClientManager clientManager, PolicyFactoryManager policyFactoryManager, PIManager piManager, InitialServiceManager initServiceManager, ValueFactoryManager valueFactoryManager, CodecFactory codecFactory, POAManagerFactory pmFactory, MultiRequestSender multiRequestSender, Properties properties, DispatchStrategyFactory dispatchStrategyFactory, BootManager bootManager, Logger logger, CoreTraceLevels coreTraceLevels, ConFactoryRegistry conFactoryRegistry, AccFactoryRegistry accFactoryRegistry, UnknownExceptionStrategy unknownExceptionStrategy, URLRegistry urlRegistry, int nativeCs, int nativeWcs, int defaultWcs) {
        this.orb_ = orb;
        this.orbId_ = orbId;
        this.serverId_ = serverId;
        this.serverInstance_ = serverInstance;
        this.objectFactory_ = objectFactory;
        this.clientManager_ = clientManager;
        this.policyFactoryManager_ = policyFactoryManager;
        this.interceptorManager_ = piManager;
        this.initServiceManager_ = initServiceManager;
        this.valueFactoryManager_ = valueFactoryManager;
        this.codecFactory_ = codecFactory;
        this.pmFactory_ = pmFactory;
        this.multiRequestSender_ = multiRequestSender;
        this.properties_ = properties;
        this.dispatchStrategyFactory_ = dispatchStrategyFactory;
        this.bootManager_ = bootManager;
        this.logger_ = logger;
        this.coreTraceLevels_ = coreTraceLevels;
        this.conFactoryRegistry_ = conFactoryRegistry;
        this.accFactoryRegistry_ = accFactoryRegistry;
        this.unknownExceptionStrategy_ = unknownExceptionStrategy;
        this.urlRegistry_ = urlRegistry;
        this.nativeCs_ = nativeCs;
        this.nativeWcs_ = nativeWcs;
        this.defaultWcs_ = defaultWcs;
        this.clientExecutor_ = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setDaemon(true);
                return result;
            }
        });
        this.serverExecutor_ = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setDaemon(true);
                return result;
            }
        });
        String tcc = this.properties_.getProperty("yoko.orb.use_type_code_cache");
        this.useTypeCodeCache_ = tcc == null || !tcc.equals("false");
        String extWchar = this.properties_.getProperty("yoko.orb.extended_wchar");
        this.extendedWchar_ = extWchar != null && extWchar.equals("true");
        String amiWorkersStr = this.properties_.getProperty("yoko.orb.ami_workers");
        int amiWorkers = 1;
        if (amiWorkersStr != null && (amiWorkers = Integer.parseInt(amiWorkersStr)) <= 0) {
            amiWorkers = 1;
        }
        this.asyncHandler_ = new OrbAsyncHandler(amiWorkers);
    }

    public void destroy() {
        Assert._OB_assert(!this.destroy_);
        this.destroy_ = true;
        this.pmFactory_.destroy();
        this.pmFactory_ = null;
        this.initServiceManager_.destroy();
        this.initServiceManager_ = null;
        this.objectFactory_.destroy();
        this.objectFactory_ = null;
        this.clientManager_ = null;
        this.policyFactoryManager_.destroy();
        this.policyFactoryManager_ = null;
        this.interceptorManager_.destroy();
        this.interceptorManager_ = null;
        this.valueFactoryManager_.destroy();
        this.valueFactoryManager_ = null;
        this.codecFactory_ = null;
        this.multiRequestSender_ = null;
        this.dispatchStrategyFactory_ = null;
        this.bootManager_ = null;
        this.conFactoryRegistry_ = null;
        this.accFactoryRegistry_ = null;
        this.unknownExceptionStrategy_.destroy();
        this.unknownExceptionStrategy_ = null;
        this.asyncHandler_.shutdown();
        this.asyncHandler_ = null;
    }

    public ORB getORB() {
        return this.orb_;
    }

    public int getNativeCs() {
        return this.nativeCs_;
    }

    public int getNativeWcs() {
        return this.nativeWcs_;
    }

    public int getDefaultWcs() {
        return this.defaultWcs_;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory_;
    }

    public ClientManager getClientManager() {
        return this.clientManager_;
    }

    public PolicyFactoryManager getPolicyFactoryManager() {
        return this.policyFactoryManager_;
    }

    public PolicyManager getPolicyManager() {
        try {
            return PolicyManagerHelper.narrow((Object)this.orb_.resolve_initial_references("ORBPolicyManager"));
        }
        catch (InvalidName invalidName) {
            throw new INTERNAL("Could not find PolicyManager");
        }
    }

    public PIManager getPIManager() {
        return this.interceptorManager_;
    }

    public InitialServiceManager getInitialServiceManager() {
        return this.initServiceManager_;
    }

    public ValueFactoryManager getValueFactoryManager() {
        return this.valueFactoryManager_;
    }

    public CodecFactory getCodecFactory() {
        return this.codecFactory_;
    }

    public POAManagerFactory getPOAManagerFactory() {
        return this.pmFactory_;
    }

    public MultiRequestSender getMultiRequestSender() {
        return this.multiRequestSender_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public DispatchStrategyFactory getDispatchStrategyFactory() {
        return this.dispatchStrategyFactory_;
    }

    public BootManager getBootManager() {
        return this.bootManager_;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public CoreTraceLevels getCoreTraceLevels() {
        return this.coreTraceLevels_;
    }

    public RecursiveMutex getORBSyncMutex() {
        return this.orbSyncMutex_;
    }

    public ExecutorService getServerExecutor() {
        return this.serverExecutor_;
    }

    public Phaser getServerPhaser() {
        return this.serverPhaser;
    }

    public ExecutorService getClientExecutor() {
        return this.clientExecutor_;
    }

    public Phaser getClientPhaser() {
        return this.clientPhaser;
    }

    public ConFactoryRegistry getConFactoryRegistry() {
        return this.conFactoryRegistry_;
    }

    public AccFactoryRegistry getAccFactoryRegistry() {
        return this.accFactoryRegistry_;
    }

    public UnknownExceptionStrategy getUnknownExceptionStrategy() {
        return this.unknownExceptionStrategy_;
    }

    public UnknownExceptionStrategy setUnknownExceptionStrategy(UnknownExceptionStrategy strategy) {
        UnknownExceptionStrategy result = this.unknownExceptionStrategy_;
        this.unknownExceptionStrategy_ = strategy;
        return result;
    }

    public URLRegistry getURLRegistry() {
        return this.urlRegistry_;
    }

    public String getOrbId() {
        return this.orbId_;
    }

    public String getServerId() {
        return this.serverId_;
    }

    public String getServerInstance() {
        return this.serverInstance_;
    }

    public boolean useTypeCodeCache() {
        return this.useTypeCodeCache_;
    }

    public boolean extendedWchar() {
        return this.extendedWchar_;
    }

    public OrbAsyncHandler getAsyncHandler() {
        return this.asyncHandler_;
    }

    public Cache<ConnectorInfo, GIOPConnection> getOutboundConnectionCache() {
        return this.outboundConnectionCache;
    }
}

