/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CodeSetDatabase;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.CodeSetUtil;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.DowncallEmitter;
import org.apache.yoko.orb.OB.GIOPClient;
import org.apache.yoko.orb.OB.GIOPIncomingMessage;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.IORDump;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.MessageQueue;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.UnresolvedException;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OB.UpcallReturn;
import org.apache.yoko.orb.OB.Util;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHolder;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.SystemExceptionHelper;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.LocateStatusType_1_2Holder;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.GIOP.TargetAddressHolder;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.IORHolder;
import org.omg.IOP.ServiceContext;
import org.omg.PortableServer.POAManager;
import org.omg.SendingContext.CodeBase;

public abstract class GIOPConnection
implements DowncallEmitter,
UpcallReturn {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(GIOPConnection.class.getName());
    private final AtomicInteger nextRequestId;
    protected ORBInstance orbInstance_ = null;
    protected Transport transport_ = null;
    private final ConnectorInfo outboundConnectionKey;
    private OAInterface oaInterface_ = null;
    protected final MessageQueue messageQueue_ = new MessageQueue();
    protected int enabledOps_ = 0;
    protected int properties_ = 0;
    protected int state_ = 2;
    protected int upcallsInProgress_ = 0;
    private CodeConverters codeConverters_ = null;
    protected final Version giopVersion_ = new Version(0, 0);
    protected int shutdownTimeout_ = 2;
    private int idleTimeout_ = 0;
    protected Timer acmTimer_ = null;
    private CodeBase serverRuntime_;
    protected ACMTask acmTask_ = null;

    protected synchronized boolean canSendCloseConnection() {
        if ((this.properties_ & 0x20) != 0) {
            return true;
        }
        return this.giopVersion_.major > 1 || this.giopVersion_.major == 1 && this.giopVersion_.minor >= 2;
    }

    private void readCodeConverters(ServiceContexts contexts) {
        if (this.codeConverters_ != null) {
            return;
        }
        ServiceContext cssc = contexts.get(1);
        if (cssc == null) {
            return;
        }
        CodeSetContextHolder codeSetContextH = new CodeSetContextHolder();
        CodeSetUtil.extractCodeSetContext(cssc, codeSetContextH);
        CodeSetContext codeSetContext = codeSetContextH.value;
        int nativeCs = this.orbInstance_.getNativeCs();
        int alienCs = codeSetContext.char_data;
        int nativeWcs = this.orbInstance_.getNativeWcs();
        int alienWcs = codeSetContext.wchar_data;
        CodeConverterBase inputCharConverter = CodeSetDatabase.getConverter(nativeCs, alienCs);
        CodeConverterBase outputCharConverter = CodeSetDatabase.getConverter(alienCs, nativeCs);
        CodeConverterBase inputWcharConverter = CodeSetDatabase.getConverter(nativeWcs, alienWcs);
        CodeConverterBase outputWcharConverter = CodeSetDatabase.getConverter(alienWcs, nativeWcs);
        this.codeConverters_ = new CodeConverters(inputCharConverter, outputWcharConverter, inputWcharConverter, outputWcharConverter);
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() >= 2) {
            CodeSetInfo info;
            String msg = "receiving transmission code sets";
            msg = msg + "\nchar code set: ";
            if (this.codeConverters_.inputCharConverter != null) {
                msg = msg + this.codeConverters_.inputCharConverter.getSourceCodeSet().description;
            } else if (alienCs == 0) {
                msg = msg + "none";
            } else {
                info = CodeSetInfo.forRegistryId(nativeCs);
                msg = msg + (info != null ? info.description : null);
            }
            msg = msg + "\nwchar code set: ";
            if (this.codeConverters_.inputWcharConverter != null) {
                msg = msg + this.codeConverters_.inputWcharConverter.getSourceCodeSet().description;
            } else if (alienWcs == 0) {
                msg = msg + "none";
            } else {
                info = CodeSetInfo.forRegistryId(nativeWcs);
                msg = msg + (info != null ? info.description : null);
            }
            this.orbInstance_.getLogger().trace("incoming", msg);
        }
    }

    private boolean setOAInterface(ProfileInfo pi) {
        POAManager[] poaManagers;
        this.oaInterface_ = null;
        Assert._OB_assert((this.properties_ & 8) != 0);
        Assert._OB_assert((this.properties_ & 0x20) != 0);
        Assert._OB_assert(this.orbInstance_ != null);
        POAManagerFactory poamanFactory = this.orbInstance_.getPOAManagerFactory();
        Assert._OB_assert(poamanFactory != null);
        for (POAManager poaManager : poaManagers = poamanFactory.list()) {
            try {
                POAManager_impl poamanImpl = (POAManager_impl)poaManager;
                OAInterface oaImpl = poamanImpl._OB_getOAInterface();
                IORHolder refIOR = new IORHolder();
                if (oaImpl.findByKey(pi.key, refIOR) != 1) continue;
                this.oaInterface_ = oaImpl;
                return true;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    private synchronized void logClose(boolean initiatedClosure) {
        if ((this.properties_ & 0x40) != 0) {
            return;
        }
        this.properties_ |= 0x40;
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo info = this.transport_.get_info();
            String msg = "closing connection\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace(initiatedClosure ? "outgoing" : "incoming", msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Upcall processMessage(GIOPIncomingMessage msg) {
        GIOPConnection gIOPConnection = this;
        synchronized (gIOPConnection) {
            if (msg.version().major > this.giopVersion_.major) {
                this.giopVersion_.major = msg.version().major;
                this.giopVersion_.minor = msg.version().minor;
            } else if (msg.version().major == this.giopVersion_.major && msg.version().minor > this.giopVersion_.minor) {
                this.giopVersion_.minor = msg.version().minor;
            }
        }
        switch (msg.type().value()) {
            case 1: {
                this.processReply(msg);
                break;
            }
            case 0: {
                return this.processRequest(msg);
            }
            case 3: {
                this.processLocateRequest(msg);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.processLocateReply(msg);
                break;
            }
            case 5: {
                this.processCloseConnection(msg);
                break;
            }
            case 6: {
                this.processMessageError(msg);
                break;
            }
            case 7: {
                this.processFragment(msg);
                break;
            }
            default: {
                this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930), 1095974930, CompletionStatus.COMPLETED_MAYBE)), false);
            }
        }
        return null;
    }

    private synchronized Upcall processRequest(GIOPIncomingMessage msg) {
        int reqId;
        if ((this.properties_ & 0x20) == 0) {
            this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974931), 1095974931, CompletionStatus.COMPLETED_MAYBE)), false);
            return null;
        }
        if (this.state_ != 1) {
            return null;
        }
        BooleanHolder response = new BooleanHolder();
        StringHolder op = new StringHolder();
        ServiceContexts contexts = new ServiceContexts();
        TargetAddressHolder target = new TargetAddressHolder();
        try {
            reqId = msg.readRequestHeader(response, target, op, contexts);
            if (target.value.discriminator() != 0) {
                this.processException(4, (SystemException)new NO_IMPLEMENT(MinorCodes.describeNoImplement(1330446339), 1330446339, CompletionStatus.COMPLETED_NO), false);
                return null;
            }
        }
        catch (SystemException ex) {
            this.processException(4, ex, false);
            return null;
        }
        Version version = msg.version();
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = version.major;
        profileInfo.minor = version.minor;
        profileInfo.key = target.value.object_key();
        InputStream in = msg.input();
        if ((this.properties_ & 8) != 0 && !this.setOAInterface(profileInfo)) {
            return null;
        }
        this.readCodeConverters(contexts);
        in._OB_codeConverters(this.codeConverters_, GiopVersion.get(version.major, version.minor));
        this.assignSendingContextRuntime(in, contexts);
        if (response.value) {
            ++this.upcallsInProgress_;
        }
        this.orbInstance_.getLogger().debug("Processing request reqId=" + reqId + " op=" + op.value);
        return this.oaInterface_.createUpcall(response.value ? this.upcallReturnInterface() : null, profileInfo, this.transport_.get_info(), reqId, op.value, in, contexts);
    }

    private synchronized void processReply(GIOPIncomingMessage msg) {
        int reqId;
        if ((this.properties_ & 0x10) == 0) {
            this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974931), 1095974931, CompletionStatus.COMPLETED_MAYBE)), false);
            return;
        }
        ReplyStatusType_1_2Holder status = new ReplyStatusType_1_2Holder();
        ServiceContexts contexts = new ServiceContexts();
        try {
            reqId = msg.readReplyHeader(status, contexts);
        }
        catch (SystemException ex) {
            this.processException(4, ex, false);
            return;
        }
        Downcall down = this.messageQueue_.findAndRemovePending(reqId);
        if (down == null) {
            this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974936) + ": " + reqId, 1095974936, CompletionStatus.COMPLETED_MAYBE)), false);
            return;
        }
        down.setReplyContexts(contexts);
        InputStream in = msg.input();
        this.assignSendingContextRuntime(in, contexts);
        this.orbInstance_.getLogger().debug("Processing reply for reqId=" + reqId + " status=" + status.value.value());
        switch (status.value.value()) {
            case 0: {
                down.setNoException(in);
                break;
            }
            case 1: {
                down.setUserException(in);
                break;
            }
            case 2: {
                try {
                    SystemException ex = Util.unmarshalSystemException((org.omg.CORBA.portable.InputStream)in);
                    ex = this.convertToUnknownExceptionIfAppropriate(ex, in, contexts);
                    down.setSystemException(ex);
                }
                catch (SystemException ex) {
                    this.processException(4, ex, false);
                }
                break;
            }
            case 3: {
                try {
                    IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)in);
                    down.setLocationForward(ior, false);
                }
                catch (SystemException ex) {
                    this.processException(4, ex, false);
                }
                break;
            }
            case 4: {
                try {
                    IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)in);
                    down.setLocationForward(ior, true);
                    break;
                }
                catch (SystemException ex) {
                    this.processException(4, ex, false);
                }
            }
            case 5: {
                this.processException(4, (SystemException)new NO_IMPLEMENT(MinorCodes.describeNoImplement(1330446339), 1330446339, CompletionStatus.COMPLETED_NO), false);
                break;
            }
            default: {
                this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974941), 1095974941, CompletionStatus.COMPLETED_MAYBE)), false);
            }
        }
    }

    private SystemException convertToUnknownExceptionIfAppropriate(SystemException ex, InputStream is, ServiceContexts contexts) {
        if (!(ex instanceof UNKNOWN)) {
            return ex;
        }
        ServiceContext sc = contexts.get(9);
        if (sc == null) {
            return ex;
        }
        return new UnresolvedException((UNKNOWN)ex, sc.context_data, is);
    }

    private void assignSendingContextRuntime(InputStream in, ServiceContexts contexts) {
        if (this.serverRuntime_ == null) {
            this.serverRuntime_ = Util.getSendingContextRuntime(this.orbInstance_, contexts);
        }
        in.__setSendingContextRuntime(this.serverRuntime_);
    }

    private synchronized void processLocateRequest(GIOPIncomingMessage msg) {
        if ((this.properties_ & 0x20) == 0) {
            this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974931), 1095974931, CompletionStatus.COMPLETED_MAYBE)), false);
            return;
        }
        Assert._OB_assert(this.state_ == 1);
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            String message = "Discarding locate request - transport does not support twoway invocations";
            TransportInfo transportInfo = this.transport_.get_info();
            if (transportInfo != null) {
                String desc = transportInfo.describe();
                message = message + '\n';
                message = message + desc;
            } else {
                message = message + "\nCollocated method call";
            }
            Logger logger = this.orbInstance_.getLogger();
            logger.warning(message);
            return;
        }
        try {
            TargetAddressHolder target = new TargetAddressHolder();
            int reqId = msg.readLocateRequestHeader(target);
            if (target.value.discriminator() != 0) {
                this.processException(4, (SystemException)new NO_IMPLEMENT(MinorCodes.describeNoImplement(1330446339), 1330446339, CompletionStatus.COMPLETED_NO), false);
                return;
            }
            byte[] key = target.value.object_key();
            IORHolder ior = new IORHolder();
            int val = this.oaInterface_.findByKey(key, ior);
            LocateStatusType_1_2 status = LocateStatusType_1_2.from_int((int)val);
            try (OutputStream out = new OutputStream(Buffer.createWriteBuffer(12).padAll());){
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.major = msg.version().major;
                profileInfo.minor = msg.version().minor;
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeLocateReplyHeader(reqId, status);
                if (status == LocateStatusType_1_2.OBJECT_FORWARD || status == LocateStatusType_1_2.OBJECT_FORWARD_PERM) {
                    IORHelper.write((org.omg.CORBA.portable.OutputStream)out, (IOR)ior.value);
                }
                int pos = out.getPosition();
                out.setPosition(0);
                outgoing.writeMessageHeader(MsgType_1_1.LocateReply, false, pos - 12);
                out.setPosition(pos);
                ++this.upcallsInProgress_;
                this.sendUpcallReply(out.getBufferReader());
            }
        }
        catch (SystemException ex) {
            this.processException(4, ex, false);
        }
    }

    private synchronized void processLocateReply(GIOPIncomingMessage msg) {
        int reqId;
        if ((this.properties_ & 0x10) == 0) {
            this.processException(5, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974931), 1095974931, CompletionStatus.COMPLETED_MAYBE)), false);
            return;
        }
        LocateStatusType_1_2Holder status = new LocateStatusType_1_2Holder();
        try {
            reqId = msg.readLocateReplyHeader(status);
        }
        catch (SystemException ex) {
            this.processException(4, ex, false);
            return;
        }
        Downcall down = this.messageQueue_.findAndRemovePending(reqId);
        if (down == null) {
            this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974936), 1095974936, CompletionStatus.COMPLETED_MAYBE)), false);
            return;
        }
        String op = down.operation();
        if (!op.equals("_locate")) {
            this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974931), 1095974931, CompletionStatus.COMPLETED_MAYBE)), false);
            return;
        }
        InputStream in = msg.input();
        Logger logger = this.orbInstance_.getLogger();
        switch (status.value.value()) {
            case 0: {
                down.setSystemException((SystemException)((Object)new OBJECT_NOT_EXIST()));
                break;
            }
            case 1: {
                down.setNoException(in);
                break;
            }
            case 2: {
                try {
                    IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)in);
                    down.setLocationForward(ior, false);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Locate request forwarded to " + IORDump.PrintObjref(this.orbInstance_.getORB(), ior));
                }
                catch (SystemException ex) {
                    logger.warning("An error occurred while reading a locate reply, possibly indicating\nan interoperability problem. You may need to set the LocateRequestPolicy\nto false.");
                    down.setSystemException(ex);
                    this.processException(4, ex, false);
                }
                break;
            }
            case 3: {
                try {
                    IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)in);
                    down.setLocationForward(ior, true);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Locate request forwarded to " + IORDump.PrintObjref(this.orbInstance_.getORB(), ior));
                }
                catch (SystemException ex) {
                    logger.warning("An error occurred while reading a locate reply, possibly indicating\nan interoperability problem. You may need to set the LocateRequestPolicy\nto false.");
                    down.setSystemException(ex);
                    this.processException(4, ex, false);
                }
                break;
            }
            case 4: {
                try {
                    SystemException ex = SystemExceptionHelper.read((org.omg.CORBA.portable.InputStream)in);
                    down.setSystemException(ex);
                }
                catch (SystemException ex) {
                    down.setSystemException(ex);
                    this.processException(4, ex, false);
                }
                break;
            }
            case 5: {
                this.processException(4, (SystemException)new NO_IMPLEMENT(), false);
            }
        }
    }

    private void processCloseConnection(GIOPIncomingMessage msg) {
        this.orbInstance_.getLogger().debug("Close connection request received from peer");
        if ((this.properties_ & 0x10) != 0) {
            this.processException(5, (SystemException)((Object)new TRANSIENT(MinorCodes.describeTransient(1095974914), 1095974914, CompletionStatus.COMPLETED_NO)), true);
        } else {
            this.setState(5);
        }
    }

    private void processMessageError(GIOPIncomingMessage msg) {
        this.processException(4, (SystemException)((Object)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974933), 1095974933, CompletionStatus.COMPLETED_NO)), false);
    }

    private void processFragment(GIOPIncomingMessage msg) {
        Assert._OB_assert(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processException(int state, SystemException ex, boolean completed) {
        Assert._OB_assert(state == 4 || state == 5);
        this.orbInstance_.getLogger().debug("processing an exception, state=" + state, ex);
        GIOPConnection gIOPConnection = this;
        synchronized (gIOPConnection) {
            if (state <= this.state_) {
                return false;
            }
            this.state_ = state;
            switch (state) {
                case 4: {
                    this.enabledOps_ &= 0xFFFFFFFC;
                    this.enabledOps_ |= 4;
                    break;
                }
                case 5: {
                    this.enabledOps_ = 0;
                }
            }
            this.orbInstance_.getOutboundConnectionCache().remove((Object)this.outboundConnectionKey, (Object)this);
            this.messageQueue_.setException(state, ex, completed);
        }
        switch (state) {
            case 4: {
                this.abortiveShutdown();
                break;
            }
            case 5: {
                this.logClose(true);
                this.transport_.close();
            }
        }
        gIOPConnection = this;
        synchronized (gIOPConnection) {
            this.properties_ |= 4;
        }
        this.refresh();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpcallReply(ReadBuffer readBuffer) {
        GIOPConnection gIOPConnection = this;
        synchronized (gIOPConnection) {
            if (this.state_ == 5) {
                return;
            }
            Assert._OB_assert(this.upcallsInProgress_ > 0);
            --this.upcallsInProgress_;
            this.messageQueue_.add(this.orbInstance_, readBuffer);
        }
        this.refresh();
        gIOPConnection = this;
        synchronized (gIOPConnection) {
            if (this.upcallsInProgress_ == 0 && this.state_ == 3) {
                this.gracefulShutdown();
            }
        }
    }

    protected abstract void abortiveShutdown();

    protected abstract void gracefulShutdown();

    protected synchronized void ACM_enableIdleMonitor() {
        if (this.idleTimeout_ > 0) {
            this.acmTimer_ = new Timer(true);
            this.acmTask_ = new ACMTask(this);
            this.acmTimer_.schedule((TimerTask)this.acmTask_, this.idleTimeout_ * 1000);
        }
    }

    protected synchronized void ACM_disableIdleMonitor() {
        if (this.acmTimer_ != null) {
            this.acmTimer_.cancel();
            this.acmTimer_ = null;
        }
        if (this.acmTask_ != null) {
            this.acmTask_.cancel();
            this.acmTask_ = null;
        }
    }

    public GIOPConnection(ORBInstance orbInstance, Transport transport, GIOPClient client) {
        CoreTraceLevels coreTraceLevels;
        this.nextRequestId = new AtomicInteger(10);
        this.orbInstance_ = orbInstance;
        this.transport_ = transport;
        this.outboundConnectionKey = client.connectorInfo();
        this.state_ = 1;
        this.properties_ = 24;
        this.enabledOps_ = 3;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("yoko.orb.client_shutdown_timeout");
        if (value != null) {
            this.shutdownTimeout_ = Integer.parseInt(value);
        }
        if ((value = properties.getProperty("yoko.orb.client_timeout")) != null) {
            this.idleTimeout_ = Integer.parseInt(value);
        }
        if ((coreTraceLevels = this.orbInstance_.getCoreTraceLevels()).traceConnections() > 0) {
            TransportInfo info = this.transport_.get_info();
            String msg = "new connection\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("client-side", msg);
        }
    }

    public GIOPConnection(ORBInstance orbInstance, Transport transport, OAInterface oa) {
        this.nextRequestId = new AtomicInteger(11);
        this.orbInstance_ = orbInstance;
        this.transport_ = transport;
        this.outboundConnectionKey = null;
        this.oaInterface_ = oa;
        this.properties_ = 32;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("yoko.orb.server_shutdown_timeout");
        if (value != null) {
            this.shutdownTimeout_ = Integer.parseInt(value);
        }
        if ((value = properties.getProperty("yoko.orb.server_timeout")) != null) {
            this.idleTimeout_ = Integer.parseInt(value);
        }
    }

    private boolean isInbound() {
        return (this.properties_ & 8) == 0;
    }

    public final boolean isOutbound() {
        return !this.isInbound();
    }

    public int getNewRequestId() {
        return this.nextRequestId.getAndAdd(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upcallBeginReply(Upcall upcall, ServiceContexts contexts) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            GIOPConnection gIOPConnection = this;
            synchronized (gIOPConnection) {
                outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.NO_EXCEPTION, contexts);
            }
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex);
        }
    }

    @Override
    public void upcallEndReply(Upcall upcall) {
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            String msg = "Discarding reply - transport does not support twoway invocations";
            msg = msg + "\noperation name: \"";
            msg = msg + upcall.operation();
            msg = msg + '\"';
            TransportInfo transportInfo = this.transport_.get_info();
            if (transportInfo != null) {
                String desc = transportInfo.describe();
                msg = msg + '\n';
                msg = msg + desc;
            } else {
                msg = msg + "\nCollocated method call";
            }
            Logger logger = this.orbInstance_.getLogger();
            logger.warning(msg);
            return;
        }
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int pos = out.getPosition();
        out.setPosition(0);
        try {
            outgoing.writeMessageHeader(MsgType_1_1.Reply, false, pos - 12);
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex);
        }
        this.sendUpcallReply(out.getBufferReader());
    }

    @Override
    public void upcallBeginUserException(Upcall upcall, ServiceContexts contexts) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.USER_EXCEPTION, contexts);
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex);
        }
    }

    @Override
    public void upcallEndUserException(Upcall upcall) {
        this.upcallEndReply(upcall);
    }

    @Override
    public void upcallUserException(Upcall upcall, UserException ex, ServiceContexts contexts) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.USER_EXCEPTION, contexts);
            Assert._OB_assert(false);
        }
        catch (SystemException e) {
            Assert._OB_assert(ex);
        }
        this.upcallEndReply(upcall);
    }

    @Override
    public void upcallSystemException(Upcall upcall, SystemException ex, ServiceContexts contexts) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            this.orbInstance_.getLogger().debug("upcall exception", ex);
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.SYSTEM_EXCEPTION, contexts);
            Util.marshalSystemException((org.omg.CORBA.portable.OutputStream)out, ex);
        }
        catch (SystemException e) {
            Assert._OB_assert(ex);
        }
        this.upcallEndReply(upcall);
    }

    @Override
    public void upcallForward(Upcall upcall, IOR ior, boolean perm, ServiceContexts contexts) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        ReplyStatusType_1_2 status = perm ? ReplyStatusType_1_2.LOCATION_FORWARD_PERM : ReplyStatusType_1_2.LOCATION_FORWARD;
        try {
            outgoing.writeReplyHeader(reqId, status, contexts);
            Logger logger = this.orbInstance_.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("Sending forward reply to " + IORDump.PrintObjref(this.orbInstance_.getORB(), ior));
            }
            IORHelper.write((org.omg.CORBA.portable.OutputStream)out, (IOR)ior);
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex);
        }
        this.upcallEndReply(upcall);
    }

    public synchronized void activateClientSide() {
        this.properties_ |= 0x10;
        this.enableConnectionModes(true, true);
    }

    public synchronized void activateServerSide() {
        Assert._OB_assert((this.properties_ & 8) != 0);
        if ((this.properties_ & 0x20) == 0) {
            this.properties_ |= 0x20;
            this.enableConnectionModes(true, true);
        }
    }

    public DowncallEmitter emitterInterface() {
        Assert._OB_assert((this.properties_ & 0x10) != 0);
        return this;
    }

    private UpcallReturn upcallReturnInterface() {
        Assert._OB_assert((this.properties_ & 0x20) != 0);
        return this;
    }

    public Transport transport() {
        return this.transport_;
    }

    public synchronized int state() {
        Assert._OB_assert(this.state_ >= 1 && this.state_ <= 5);
        return this.state_;
    }

    public synchronized boolean requestSent() {
        return (this.properties_ & 1) != 0;
    }

    @Override
    public synchronized boolean replySent() {
        return (this.properties_ & 2) != 0;
    }

    public synchronized boolean destroyed() {
        return (this.properties_ & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int newState) {
        GIOPConnection gIOPConnection = this;
        synchronized (gIOPConnection) {
            if (this.state_ == newState || this.state_ != 2 && newState < this.state_) {
                logger.fine("No state change from " + this.state_ + " to " + newState);
                return;
            }
            this.state_ = newState;
        }
        switch (newState) {
            case 1: {
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.enabledOps_ = 3;
                }
                this.start();
                this.refresh();
                break;
            }
            case 2: {
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.enabledOps_ &= 0xFFFFFFFE;
                }
                this.pause();
                break;
            }
            case 3: {
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.enabledOps_ = 7;
                }
                this.gracefulShutdown();
                this.refresh();
                break;
            }
            case 4: {
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.enabledOps_ = 4;
                }
                this.abortiveShutdown();
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.properties_ |= 4;
                }
                this.refresh();
                break;
            }
            case 5: {
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.enabledOps_ = 0;
                }
                this.logClose(true);
                this.transport_.close();
                gIOPConnection = this;
                synchronized (gIOPConnection) {
                    this.properties_ |= 4;
                }
                this.refresh();
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
    }

    public void destroy() {
        this.setState(3);
    }

    public abstract void ACM_callback();

    public abstract void start();

    public abstract void refresh();

    public abstract void pause();

    public abstract void enableConnectionModes(boolean var1, boolean var2);

    final class ACMTask
    extends TimerTask {
        GIOPConnection connection_;

        public ACMTask(GIOPConnection parent) {
            this.connection_ = parent;
        }

        @Override
        public void run() {
            this.connection_.ACM_callback();
            this.connection_ = null;
        }
    }

    public static final class State {
        public static final int Active = 1;
        public static final int Holding = 2;
        public static final int Closing = 3;
        public static final int Error = 4;
        public static final int Closed = 5;
    }

    public static final class Property {
        public static final int RequestSent = 1;
        public static final int ReplySent = 2;
        public static final int Destroyed = 4;
        public static final int CreatedByClient = 8;
        public static final int ClientEnabled = 16;
        public static final int ServerEnabled = 32;
        public static final int ClosingLogged = 64;
    }

    public static final class AccessOp {
        public static final int Nil = 0;
        public static final int Read = 1;
        public static final int Write = 2;
        public static final int Close = 4;
        public static final int All = 7;
    }
}

