/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.OutputStreamHolder;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Client;
import org.apache.yoko.orb.OB.ClientManager;
import org.apache.yoko.orb.OB.ClientProfilePair;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.FailureException;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.MessageRoutingUtil;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.PIArgsDowncall;
import org.apache.yoko.orb.OB.PIDIIDowncall;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.PIVoidDowncall;
import org.apache.yoko.orb.OB.ParameterDesc;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OCI.AlignmentBoundary;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoHolder;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.GIOP.MessageHeader_1_1;
import org.omg.GIOP.MessageHeader_1_2Helper;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.RequestHeader_1_2;
import org.omg.GIOP.RequestHeader_1_2Helper;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHolder;
import org.omg.MessageRouting.MessageBody;
import org.omg.MessageRouting.PersistentRequest;
import org.omg.MessageRouting.PersistentRequestRouter;
import org.omg.MessageRouting.ReplyDestination;
import org.omg.MessageRouting.ReplyDisposition;
import org.omg.MessageRouting.RequestInfo;
import org.omg.MessageRouting.RequestMessage;
import org.omg.MessageRouting.Router;
import org.omg.MessageRouting.RouterListHolder;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.Messaging.PolicyValueSeqHolder;
import org.omg.Messaging.ReplyHandler;

public final class DowncallStub {
    static final Logger logger = Logger.getLogger(DowncallStub.class.getName());
    private ORBInstance orbInstance_;
    private IOR IOR_;
    private IOR origIOR_;
    private RefCountPolicyList policies_;
    private Vector<ClientProfilePair> clientProfilePairs_ = null;

    private synchronized Client getClientProfilePair(ProfileInfoHolder profileInfo) throws FailureException {
        if (this.clientProfilePairs_ == null) {
            ClientManager clientManager = this.orbInstance_.getClientManager();
            this.clientProfilePairs_ = clientManager.getClientProfilePairs(this.IOR_, this.policies_.value);
        }
        if (this.clientProfilePairs_.isEmpty()) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceRetry() >= 2) {
                logger.fine("retry: no profiles available");
            }
            throw new FailureException((SystemException)((java.lang.Object)new TRANSIENT(MinorCodes.describeTransient(1330446338), 1330446338, CompletionStatus.COMPLETED_NO)));
        }
        ClientProfilePair clientProfilePair = this.clientProfilePairs_.elementAt(0);
        profileInfo.value = clientProfilePair.profile;
        return clientProfilePair.client;
    }

    private void destroy() {
        ClientManager clientManager = this.orbInstance_.getClientManager();
        if (clientManager != null && this.clientProfilePairs_ != null) {
            for (ClientProfilePair pair : this.clientProfilePairs_) {
                clientManager.releaseClient(pair.client);
            }
        }
        this.clientProfilePairs_.removeAllElements();
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public DowncallStub(ORBInstance orbInstance, IOR ior, IOR origIOR, RefCountPolicyList policies) {
        this.orbInstance_ = orbInstance;
        this.IOR_ = ior;
        this.origIOR_ = origIOR;
        this.policies_ = policies;
    }

    public Downcall createDowncall(String op, boolean resp) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        PIManager piManager = this.orbInstance_.getPIManager();
        if (piManager.haveClientInterceptors()) {
            return new PIVoidDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, piManager);
        }
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
    }

    public Downcall createLocateRequestDowncall() throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, "_locate", true);
    }

    public Downcall createPIArgsDowncall(String op, boolean resp, ParameterDesc[] argDesc, ParameterDesc retDesc, TypeCode[] exceptionTC) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        PIManager piManager = this.orbInstance_.getPIManager();
        if (piManager.haveClientInterceptors()) {
            return new PIArgsDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, piManager, argDesc, retDesc, exceptionTC);
        }
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
    }

    public Downcall createPIDIIDowncall(String op, boolean resp, NVList args, NamedValue result, ExceptionList exceptions) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        PIManager piManager = this.orbInstance_.getPIManager();
        if (piManager.haveClientInterceptors()) {
            return new PIDIIDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, piManager, args, result, exceptions);
        }
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
    }

    public OutputStream preMarshal(Downcall down) throws LocationForward, FailureException {
        return down.preMarshal();
    }

    public void marshalEx(Downcall down, SystemException ex) throws LocationForward, FailureException {
        down.marshalEx(ex);
    }

    public void postMarshal(Downcall down) throws LocationForward, FailureException {
        down.postMarshal();
    }

    public void locate(Downcall down) throws LocationForward, FailureException {
        down.locate();
    }

    public void request(Downcall down) throws LocationForward, FailureException {
        down.request();
    }

    public void oneway(Downcall down) throws LocationForward, FailureException {
        down.oneway();
    }

    public void deferred(Downcall down) throws LocationForward, FailureException {
        down.deferred();
    }

    public void response(Downcall down) throws LocationForward, FailureException {
        down.response();
    }

    public boolean poll(Downcall down) throws LocationForward, FailureException {
        return down.poll();
    }

    public InputStream preUnmarshal(Downcall down) throws LocationForward, FailureException {
        return down.preUnmarshal();
    }

    public InputStream preUnmarshal(Downcall down, BooleanHolder uex) throws LocationForward, FailureException {
        InputStream in = down.preUnmarshal();
        uex.value = down.userException();
        return in;
    }

    public void unmarshalEx(Downcall down, SystemException ex) throws LocationForward, FailureException {
        down.unmarshalEx(ex);
    }

    public void postUnmarshal(Downcall down) throws LocationForward, FailureException {
        down.postUnmarshal();
    }

    public String unmarshalExceptionId(Downcall down) {
        return down.unmarshalExceptionId();
    }

    public void setUserException(Downcall down, UserException ex, String exId) {
        down.setUserException(ex, exId);
    }

    public void setUserException(Downcall down, UserException ex) {
        down.setUserException(ex);
    }

    public synchronized void handleFailureException(Downcall down, FailureException ex) throws FailureException {
        Assert._OB_assert(ex.exception != null);
        Client client = down.client();
        ProfileInfo profile = down.profileInfo();
        ClientManager clientManager = this.orbInstance_.getClientManager();
        if (clientManager == null) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        for (ClientProfilePair pair : this.clientProfilePairs_) {
            if (pair.client != client || pair.profile != profile) continue;
            clientManager.releaseClient(pair.client);
            this.clientProfilePairs_.remove(pair);
            break;
        }
        try {
            throw ex.exception;
        }
        catch (COMM_FAILURE | NO_RESPONSE | TRANSIENT throwable) {
        }
        catch (SystemException systemException) {
            throw ex;
        }
        if (this.policies_.retry.mode != 2 && ex.exception.completed != CompletionStatus.COMPLETED_NO) {
            throw ex;
        }
        if (this.clientProfilePairs_.isEmpty()) {
            logger.log(Level.FINE, "no profiles left to try", ex.exception);
            throw ex;
        }
        logger.log(Level.FINE, "trying next profile", ex.exception);
    }

    public boolean locate_request() throws LocationForward, FailureException {
        logger.fine("performing a locate_request");
        while (true) {
            Downcall down = this.createLocateRequestDowncall();
            try {
                try {
                    Client client = down.client();
                    client.bind(this.policies_.connectTimeout);
                    if (!this.policies_.locateRequest) {
                        logger.fine("LocateRequest policy is false, returning true");
                        return true;
                    }
                    if (!client.twoway()) {
                        logger.fine("Twoway invocations not supported, returning true");
                        return true;
                    }
                }
                catch (SystemException ex) {
                    logger.log(Level.FINE, "Exception occurred during locate request", ex);
                    throw new FailureException(ex);
                }
                this.preMarshal(down);
                this.postMarshal(down);
                this.locate(down);
                this.preUnmarshal(down);
                this.postUnmarshal(down);
                logger.fine("Object located");
                return true;
            }
            catch (OBJECT_NOT_EXIST ex) {
                logger.log(Level.FINE, "Object does not exist", ex);
                return false;
            }
            catch (FailureException ex) {
                logger.log(Level.FINE, "Object lookup failure", ex);
                this.handleFailureException(down, ex);
                continue;
            }
            break;
        }
    }

    public ConnectorInfo get_oci_connector_info() {
        try {
            ProfileInfoHolder profileInfo = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfo);
            Assert._OB_assert(client != null);
            return client.connectorInfo();
        }
        catch (FailureException ex) {
            Assert._OB_assert(ex);
            return null;
        }
    }

    public TransportInfo get_oci_transport_info() {
        try {
            ProfileInfoHolder profileInfo = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfo);
            Assert._OB_assert(client != null);
            return client.transportInfo();
        }
        catch (FailureException ex) {
            Assert._OB_assert(ex);
            return null;
        }
    }

    public OutputStream setupRequest(Object self, String operation, boolean responseExpected) throws LocationForward, FailureException {
        while (true) {
            Downcall downcall = this.createDowncall(operation, responseExpected);
            try {
                OutputStream out = this.preMarshal(downcall);
                InvocationContext ctx = new InvocationContext();
                ctx.downcallStub = this;
                ctx.downcall = downcall;
                out._OB_invocationContext(ctx);
                out._OB_ORBInstance(this._OB_getORBInstance());
                return out;
            }
            catch (FailureException ex) {
                this.handleFailureException(downcall, ex);
                continue;
            }
            break;
        }
    }

    public CodeConverters setupPollingRequest(ServiceContextListHolder sclHolder, OutputStreamHolder out) throws FailureException {
        ProfileInfoHolder info = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(info);
        out.value = new OutputStream(client.codeConverters(), GiopVersion.GIOP1_2);
        sclHolder.value = client.getAMIRouterContexts().toArray();
        InvocationContext ctx = new InvocationContext();
        ctx.downcallStub = this;
        ctx.downcall = null;
        out.value._OB_invocationContext(ctx);
        return client.codeConverters();
    }

    public GIOPOutgoingMessage AMIRouterPreMarshal(String operation, boolean responseExpected, OutputStreamHolder out, ProfileInfoHolder info) throws FailureException {
        WriteBuffer writeBuffer = Buffer.createWriteBuffer(12).padAll();
        Client client = this.getClientProfilePair(info);
        out.value = new OutputStream(writeBuffer, client.codeConverters(), GiopVersion.GIOP1_2);
        ServiceContexts contexts = client.getAMIRouterContexts();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out.value, info.value);
        outgoing.writeRequestHeader(client.getNewRequestID(), operation, responseExpected, contexts);
        return outgoing;
    }

    public void AMIRouterPostMarshal(GIOPOutgoingMessage outgoing, OutputStreamHolder out) {
        int pos = out.value.getPosition();
        out.value.setPosition(0);
        outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
        out.value.setPosition(pos);
        InvocationContext ctx = new InvocationContext();
        ctx.downcallStub = this;
        ctx.downcall = null;
        out.value._OB_invocationContext(ctx);
    }

    public InputStream invoke(Object self, OutputStream out) throws ApplicationException, RemarshalException, LocationForward, FailureException {
        OutputStream o = out;
        InvocationContext ctx = (InvocationContext)o._OB_invocationContext();
        Assert._OB_assert(ctx != null);
        if (ctx.downcallStub != this) {
            throw new RemarshalException();
        }
        Downcall down = ctx.downcall;
        try {
            down.postMarshal();
            boolean response = down.responseExpected();
            if (response) {
                down.request();
            } else {
                down.oneway();
            }
            if (response) {
                InputStream in = down.preUnmarshal();
                if (down.userException()) {
                    String id = null;
                    try {
                        id = down.unmarshalExceptionId();
                    }
                    catch (SystemException ex) {
                        down.unmarshalEx(ex);
                    }
                    down.setUserException(id);
                    down.postUnmarshal();
                    throw new ApplicationException(id, (org.omg.CORBA.portable.InputStream)in);
                }
                down.postUnmarshal();
                return in;
            }
            down.preUnmarshal();
            down.postUnmarshal();
            return null;
        }
        catch (FailureException ex) {
            this.handleFailureException(down, ex);
            throw new RemarshalException();
        }
    }

    public Object getAMIPollTarget() {
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        return objectFactory.createObject(this.IOR_);
    }

    public PersistentRequest ami_poll_request(org.omg.CORBA.portable.OutputStream out, String operation, ServiceContext[] scl) throws RemarshalException {
        Assert._OB_assert(out != null);
        OutputStream o = (OutputStream)out;
        InvocationContext ctx = (InvocationContext)o._OB_invocationContext();
        Assert._OB_assert(ctx != null);
        if (ctx.downcallStub != this) {
            throw new RemarshalException();
        }
        ORB orb = this.orbInstance_.getORB();
        Assert._OB_assert(orb != null);
        PersistentRequestRouter router = MessageRoutingUtil.getPersistentRouterFromConfig(this.orbInstance_);
        Assert._OB_assert(router != null);
        ProfileInfoHolder info = new ProfileInfoHolder();
        info.value = null;
        try {
            this.getClientProfilePair(info);
        }
        catch (FailureException ex) {
            throw new RemarshalException();
        }
        short index = (short)info.value.index;
        RouterListHolder to_visit = new RouterListHolder();
        to_visit.value = new Router[0];
        MessageRoutingUtil.getRouterListFromComponents(this.orbInstance_, info.value, to_visit);
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        Object target = objectFactory.createObject(this.IOR_);
        RequestMessage payload = new RequestMessage();
        payload.service_contexts = scl;
        payload.giop_version = new Version();
        payload.giop_version.major = info.value.major;
        payload.giop_version.minor = info.value.minor;
        payload.response_flags = 1;
        payload.reserved = new byte[3];
        payload.reserved[0] = 0;
        payload.reserved[1] = 0;
        payload.reserved[2] = 0;
        payload.operation = operation;
        payload.object_key = new byte[info.value.key.length];
        System.arraycopy(info.value.key, 0, payload.object_key, 0, info.value.key.length);
        MessageBody messageBody = new MessageBody();
        messageBody.byte_order = false;
        messageBody.body = o.getBufferReader().copyRemainingBytes();
        payload.body = messageBody;
        Policy[] qosList = new Policy[]{};
        PersistentRequest request = router.create_persistent_request(index, to_visit.value, target, qosList, payload);
        return request;
    }

    public boolean ami_callback_request(org.omg.CORBA.portable.OutputStream out, ReplyHandler reply, ProfileInfo info) throws RemarshalException {
        OutputStream o = (OutputStream)out;
        InvocationContext ctx = (InvocationContext)o._OB_invocationContext();
        Assert._OB_assert(ctx != null);
        if (ctx.downcallStub != this) {
            throw new RemarshalException();
        }
        InputStream tmpIn = (InputStream)out.create_input_stream();
        MessageHeader_1_1 msgHeader = MessageHeader_1_2Helper.read((org.omg.CORBA.portable.InputStream)tmpIn);
        if (msgHeader.GIOP_version.major < 1 || msgHeader.GIOP_version.minor < 2) {
            return false;
        }
        if (msgHeader.message_type != 0) {
            return false;
        }
        RequestInfo requestInfo = new RequestInfo();
        RequestHeader_1_2 requestHeader = RequestHeader_1_2Helper.read((org.omg.CORBA.portable.InputStream)tmpIn);
        RouterListHolder configRouterList = new RouterListHolder();
        configRouterList.value = new Router[0];
        MessageRoutingUtil.getRouterListFromComponents(this.orbInstance_, info, configRouterList);
        requestInfo.visited = new Router[0];
        requestInfo.to_visit = new Router[0];
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        requestInfo.target = objectFactory.createObject(this.IOR_);
        requestInfo.profile_index = (short)info.index;
        ReplyDestination replyDest = new ReplyDestination();
        replyDest.handler_type = ReplyDisposition.TYPED;
        replyDest.handler = reply;
        requestInfo.reply_destination = replyDest;
        PolicyValueSeqHolder invocPoliciesHolder = new PolicyValueSeqHolder();
        invocPoliciesHolder.value = new PolicyValue[0];
        MessageRoutingUtil.getInvocationPolicyValues(this.policies_, invocPoliciesHolder);
        requestInfo.selected_qos = invocPoliciesHolder.value;
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.giop_version = new Version();
        requestMessage.giop_version.major = info.major;
        requestMessage.giop_version.minor = info.minor;
        requestMessage.service_contexts = requestHeader.service_context;
        ServiceContext invocPoliciesSC = new ServiceContext();
        invocPoliciesSC.context_id = 7;
        if (invocPoliciesHolder.value != null) {
            try (OutputStream scOut = new OutputStream();){
                scOut._OB_writeEndian();
                PolicyValueSeqHelper.write((org.omg.CORBA.portable.OutputStream)scOut, (PolicyValue[])invocPoliciesHolder.value);
                invocPoliciesSC.context_data = scOut.copyWrittenBytes();
            }
        }
        int scLength = requestMessage.service_contexts.length;
        ServiceContext[] scList = new ServiceContext[scLength + 1];
        System.arraycopy(requestMessage.service_contexts, 0, scList, 0, scLength);
        scList[scLength] = invocPoliciesSC;
        requestMessage.response_flags = requestHeader.response_flags;
        requestMessage.reserved = new byte[3];
        requestMessage.reserved[0] = requestHeader.reserved[0];
        requestMessage.reserved[1] = requestHeader.reserved[1];
        requestMessage.reserved[2] = requestHeader.reserved[2];
        int keyLen = info.key.length;
        requestMessage.object_key = new byte[keyLen];
        System.arraycopy(info.key, 0, requestMessage.object_key, 0, keyLen);
        requestMessage.operation = requestHeader.operation;
        MessageBody messageBody = new MessageBody();
        messageBody.byte_order = false;
        ReadBuffer rbuf = tmpIn.getBuffer();
        rbuf.align(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
        messageBody.body = rbuf.copyRemainingBytes();
        requestMessage.body = messageBody;
        requestInfo.payload = requestMessage;
        boolean delivered = false;
        int numRouters = configRouterList.value.length;
        for (int i = numRouters - 1; !delivered && i >= 0; --i) {
            Router curRouter = configRouterList.value[i];
            int curLength = requestInfo.to_visit.length;
            Router[] toVisit = new Router[curLength + 1];
            if (curLength > 0) {
                System.arraycopy(requestInfo.to_visit, 0, toVisit, 1, curLength);
            }
            toVisit[0] = curRouter;
            requestInfo.to_visit = toVisit;
            try {
                curRouter.send_request(requestInfo);
                delivered = true;
                continue;
            }
            catch (SystemException ex) {
                logger.log(Level.FINE, "Failed to contact router: " + ex.getMessage(), ex);
            }
        }
        return delivered;
    }

    public ORBInstance _OB_getORBInstance() {
        return this.orbInstance_;
    }

    private class InvocationContext {
        DowncallStub downcallStub;
        Downcall downcall;

        private InvocationContext() {
        }
    }
}

