/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CORBA;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.Delegate;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.TypeCodeFactory;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;

public final class Any
extends org.omg.CORBA.Any {
    private static final Logger logger = Logger.getLogger(Any.class.getName());
    private ORBInstance orbInstance;
    private org.omg.CORBA.TypeCode typeCode;
    private TypeCode yokoTypeCode;
    private TypeCode origTypeCode;
    private java.lang.Object value;

    private void checkValue(TCKind kind) throws BAD_OPERATION {
        if (this.origTypeCode.kind().value() != kind.value()) {
            throw new BAD_OPERATION(MinorCodes.describeBadOperation(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (this.value == null) {
            throw new BAD_OPERATION(MinorCodes.describeBadOperation(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
        }
    }

    private void setType(org.omg.CORBA.TypeCode tc) {
        this.typeCode = tc;
        this.yokoTypeCode = tc instanceof TypeCode ? (TypeCode)tc : TypeCode._OB_convertForeignTypeCode(tc);
        this.origTypeCode = TypeCode._OB_getOrigType(this.yokoTypeCode);
    }

    private void readValue(org.omg.CORBA.portable.InputStream in) throws MARSHAL {
        int kind = this.origTypeCode.kind().value();
        logger.fine("Reading ANY value of kind " + kind);
        if (this.value instanceof Streamable && kind != 29 && kind != 30 && kind != 32) {
            ((Streamable)this.value)._read(in);
            return;
        }
        switch (kind) {
            case 0: 
            case 1: {
                this.value = null;
                break;
            }
            case 2: {
                this.value = (int)in.read_short();
                break;
            }
            case 3: {
                this.value = in.read_long();
                break;
            }
            case 23: {
                this.value = in.read_longlong();
                break;
            }
            case 4: {
                this.value = (int)in.read_ushort();
                break;
            }
            case 5: 
            case 17: {
                this.value = in.read_ulong();
                break;
            }
            case 24: {
                this.value = in.read_ulonglong();
                break;
            }
            case 6: {
                this.value = Float.valueOf(in.read_float());
                break;
            }
            case 7: {
                this.value = in.read_double();
                break;
            }
            case 8: {
                this.value = in.read_boolean();
                break;
            }
            case 9: {
                this.value = Character.valueOf(in.read_char());
                break;
            }
            case 26: {
                this.value = Character.valueOf(in.read_wchar());
                break;
            }
            case 10: {
                this.value = in.read_octet();
                break;
            }
            case 11: {
                this.value = in.read_any();
                break;
            }
            case 12: {
                this.value = in.read_TypeCode();
                break;
            }
            case 13: {
                this.value = in.read_Principal();
                break;
            }
            case 14: {
                this.value = in.read_Object();
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                try (OutputStream out = new OutputStream();){
                    out._OB_ORBInstance(this.orbInstance);
                    out.write_InputStream(in, this.origTypeCode);
                    this.value = out.create_input_stream();
                    break;
                }
            }
            case 29: 
            case 30: 
            case 32: {
                try {
                    InputStream is = (InputStream)in;
                    is.read_value(this, this.typeCode);
                }
                catch (ClassCastException ex) {
                    try {
                        org.omg.CORBA_2_3.portable.InputStream is = (org.omg.CORBA_2_3.portable.InputStream)in;
                        this.value = is.read_value(this.typeCode.id());
                    }
                    catch (BadKind e) {
                        Assert._OB_assert(e);
                    }
                }
                break;
            }
            case 18: {
                try {
                    String str = in.read_string();
                    int len = this.origTypeCode.length();
                    if (len != 0 && str.length() > len) {
                        throw new MARSHAL(String.format("string length (%d) exceeds bound (%d)", str.length(), len), 1095974927, CompletionStatus.COMPLETED_NO);
                    }
                    this.value = str;
                }
                catch (BadKind ex) {
                    Assert._OB_assert(ex);
                }
                break;
            }
            case 27: {
                try {
                    String str = in.read_wstring();
                    int len = this.origTypeCode.length();
                    if (len != 0 && str.length() > len) {
                        throw new MARSHAL(String.format("wstring length (%d) exceeds bound (%d)", str.length(), len), 1095974931, CompletionStatus.COMPLETED_NO);
                    }
                    this.value = str;
                }
                catch (BadKind ex) {
                    Assert._OB_assert(ex);
                }
                break;
            }
            case 28: {
                try {
                    this.value = in.read_fixed().movePointLeft(this.origTypeCode.fixed_scale());
                }
                catch (BadKind ex) {
                    Assert._OB_assert(ex);
                }
                break;
            }
            case 31: {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974953), 1095974953, CompletionStatus.COMPLETED_NO);
            }
            case 33: {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
            }
            default: {
                throw new DATA_CONVERSION(MinorCodes.describeDataConversion(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private void copyFrom(Any any) {
        this.orbInstance = any.orbInstance;
        this.typeCode = any.typeCode;
        this.yokoTypeCode = any.yokoTypeCode;
        this.origTypeCode = any.origTypeCode;
        if (any.value instanceof Streamable) {
            this.readValue(any.create_input_stream());
            return;
        }
        if (any.value == null) {
            this.value = null;
            return;
        }
        int kind = this.origTypeCode.kind().value();
        switch (kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                this.value = any.value;
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                this.readValue(any.create_input_stream());
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                if (any.value instanceof InputStream) {
                    this.readValue(any.create_input_stream());
                    break;
                }
                this.value = any.value;
                break;
            }
            default: {
                Assert._OB_assert("tk_alias not supported for copying");
            }
        }
    }

    public synchronized boolean equal(org.omg.CORBA.Any a) {
        Any any;
        if (a == null) {
            return false;
        }
        if (this == a) {
            return true;
        }
        if (!this.typeCode.equal(a.type())) {
            return false;
        }
        try {
            any = (Any)a;
        }
        catch (ClassCastException ex) {
            any = new Any(a);
        }
        if (this.value == any.value) {
            return true;
        }
        if (this.value == null || any.value == null) {
            return false;
        }
        if (this.value instanceof Streamable && any.value instanceof Streamable) {
            OutputStream os1 = (OutputStream)this.create_output_stream();
            ((Streamable)this.value)._write((org.omg.CORBA.portable.OutputStream)os1);
            OutputStream os2 = (OutputStream)this.create_output_stream();
            ((Streamable)any.value)._write((org.omg.CORBA.portable.OutputStream)os2);
            return os1.writtenBytesEqual(os2);
        }
        int kind = this.origTypeCode.kind().value();
        switch (kind) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                return this.value.equals(any.value);
            }
            case 11: {
                return this.extract_any().equal(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 13: {
                return this.extract_Principal().equals(any.extract_Principal());
            }
            case 14: 
            case 33: {
                return this.extract_Object()._is_equivalent(any.extract_Object());
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                return Any.compareValuesAsInputStreams(this, any);
            }
            case 29: 
            case 30: {
                if (this.value instanceof InputStream && any.value instanceof InputStream) {
                    return Any.compareValuesAsInputStreams(this, any);
                }
                return false;
            }
            case 32: {
                if (this.value instanceof Object && any.value instanceof Object) {
                    return this.extract_Object()._is_equivalent(any.extract_Object());
                }
                if (this.value instanceof InputStream && any.value instanceof InputStream) {
                    return Any.compareValuesAsInputStreams(this, any);
                }
                return false;
            }
            case 31: {
                return this.value == any.value;
            }
        }
        Assert._OB_assert("tk_alias not supported for comparison");
        return false;
    }

    private static boolean compareValuesAsInputStreams(Any any1, Any any2) {
        ReadBuffer buf1 = ((InputStream)((java.lang.Object)any1.value)).getBuffer();
        ReadBuffer buf2 = ((InputStream)((java.lang.Object)any2.value)).getBuffer();
        return buf1.dataEquals(buf2);
    }

    public synchronized org.omg.CORBA.TypeCode type() {
        return this.typeCode;
    }

    public synchronized void type(org.omg.CORBA.TypeCode tc) {
        this.setType(tc);
        this.value = null;
    }

    public synchronized void read_value(org.omg.CORBA.portable.InputStream in, org.omg.CORBA.TypeCode tc) throws MARSHAL {
        this.setType(tc);
        this.readValue(in);
    }

    public synchronized void write_value(org.omg.CORBA.portable.OutputStream out) {
        int kind = this.origTypeCode.kind().value();
        if (this.value instanceof Streamable && kind != 29 && kind != 30 && kind != 32) {
            ((Streamable)this.value)._write(out);
            return;
        }
        switch (kind) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                out.write_short(((Integer)this.value).shortValue());
                break;
            }
            case 3: {
                out.write_long(((Integer)this.value).intValue());
                break;
            }
            case 23: {
                out.write_longlong(((Long)this.value).longValue());
                break;
            }
            case 4: {
                out.write_ushort(((Integer)this.value).shortValue());
                break;
            }
            case 5: 
            case 17: {
                out.write_ulong(((Integer)this.value).intValue());
                break;
            }
            case 24: {
                out.write_ulonglong(((Long)this.value).longValue());
                break;
            }
            case 6: {
                out.write_float(((Float)this.value).floatValue());
                break;
            }
            case 7: {
                out.write_double(((Double)this.value).doubleValue());
                break;
            }
            case 8: {
                out.write_boolean(((Boolean)this.value).booleanValue());
                break;
            }
            case 9: {
                out.write_char(((Character)this.value).charValue());
                break;
            }
            case 26: {
                out.write_wchar(((Character)this.value).charValue());
                break;
            }
            case 10: {
                out.write_octet(((Byte)this.value).byteValue());
                break;
            }
            case 11: {
                out.write_any((org.omg.CORBA.Any)this.value);
                break;
            }
            case 12: {
                out.write_TypeCode((org.omg.CORBA.TypeCode)this.value);
                break;
            }
            case 13: {
                out.write_Principal((Principal)this.value);
                break;
            }
            case 14: {
                out.write_Object((Object)this.value);
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                OutputStream o = (OutputStream)out;
                InputStream in = (InputStream)((java.lang.Object)this.value);
                in._OB_reset();
                o.write_InputStream((org.omg.CORBA.portable.InputStream)in, this.typeCode);
                break;
            }
            case 29: {
                OutputStream o = (OutputStream)out;
                if (this.value instanceof InputStream) {
                    InputStream in = (InputStream)((java.lang.Object)this.value);
                    in._OB_reset();
                    o.write_InputStream((org.omg.CORBA.portable.InputStream)in, this.typeCode);
                    break;
                }
                o.write_value((Serializable)this.value);
                break;
            }
            case 30: {
                OutputStream o = (OutputStream)out;
                if (this.value instanceof InputStream) {
                    InputStream in = (InputStream)((java.lang.Object)this.value);
                    in._OB_reset();
                    o.write_InputStream((org.omg.CORBA.portable.InputStream)in, this.typeCode);
                    break;
                }
                o.write_value((Serializable)this.value, this.origTypeCode, null);
                break;
            }
            case 18: {
                out.write_string((String)this.value);
                break;
            }
            case 27: {
                out.write_wstring((String)this.value);
                break;
            }
            case 28: {
                try {
                    out.write_fixed(((BigDecimal)this.value).movePointRight(this.origTypeCode.fixed_scale()));
                }
                catch (BadKind ex) {
                    Assert._OB_assert(ex);
                }
                break;
            }
            case 32: {
                OutputStream o = (OutputStream)out;
                if (this.value != null && this.value instanceof InputStream) {
                    InputStream in = (InputStream)((java.lang.Object)this.value);
                    in._OB_reset();
                    Assert._OB_assert(!in.read_boolean());
                    o.write_abstract_interface(in.read_value());
                    break;
                }
                o.write_abstract_interface(this.value);
                break;
            }
            case 31: {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974953), 1095974953, CompletionStatus.COMPLETED_NO);
            }
            case 33: {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
            }
            default: {
                Assert._OB_assert("unable to write tk_alias types");
            }
        }
    }

    public synchronized org.omg.CORBA.portable.OutputStream create_output_stream() {
        OutputStream out = new OutputStream();
        out._OB_ORBInstance(this.orbInstance);
        return out;
    }

    public synchronized org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.value instanceof InputStream) {
            return new InputStream((InputStream)((java.lang.Object)this.value));
        }
        try (OutputStream out = new OutputStream();){
            out._OB_ORBInstance(this.orbInstance);
            this.write_value((org.omg.CORBA.portable.OutputStream)out);
            InputStream inputStream = out.create_input_stream();
            return inputStream;
        }
    }

    public synchronized short extract_short() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_short);
        return ((Integer)this.value).shortValue();
    }

    public synchronized void insert_short(short val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_short));
        this.value = (int)val;
    }

    public synchronized int extract_long() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_long);
        return (Integer)this.value;
    }

    public synchronized void insert_long(int val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_long));
        this.value = val;
    }

    public synchronized long extract_longlong() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_longlong);
        return (Long)this.value;
    }

    public synchronized void insert_longlong(long val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_longlong));
        this.value = val;
    }

    public synchronized short extract_ushort() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_ushort);
        return ((Integer)this.value).shortValue();
    }

    public synchronized void insert_ushort(short val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_ushort));
        this.value = (int)val;
    }

    public synchronized int extract_ulong() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_ulong);
        return (Integer)this.value;
    }

    public synchronized void insert_ulong(int val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_ulong));
        this.value = val;
    }

    public synchronized long extract_ulonglong() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_ulonglong);
        return (Long)this.value;
    }

    public synchronized void insert_ulonglong(long val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_ulonglong));
        this.value = val;
    }

    public synchronized boolean extract_boolean() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_boolean);
        return (Boolean)this.value;
    }

    public synchronized void insert_boolean(boolean val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_boolean));
        this.value = val;
    }

    public synchronized char extract_char() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_char);
        return ((Character)this.value).charValue();
    }

    public synchronized void insert_char(char val) throws DATA_CONVERSION {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_char));
        this.value = Character.valueOf(val);
    }

    public synchronized char extract_wchar() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_wchar);
        return ((Character)this.value).charValue();
    }

    public synchronized void insert_wchar(char val) throws DATA_CONVERSION {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_wchar));
        this.value = Character.valueOf(val);
    }

    public synchronized byte extract_octet() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_octet);
        return (Byte)this.value;
    }

    public synchronized void insert_octet(byte val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_octet));
        this.value = val;
    }

    public synchronized float extract_float() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_float);
        return ((Float)this.value).floatValue();
    }

    public synchronized void insert_float(float val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_float));
        this.value = Float.valueOf(val);
    }

    public synchronized double extract_double() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_double);
        return (Double)this.value;
    }

    public synchronized void insert_double(double val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_double));
        this.value = val;
    }

    public synchronized org.omg.CORBA.Any extract_any() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_any);
        return (org.omg.CORBA.Any)this.value;
    }

    public synchronized void insert_any(org.omg.CORBA.Any val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_any));
        this.value = val;
    }

    public synchronized org.omg.CORBA.TypeCode extract_TypeCode() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_TypeCode);
        return (org.omg.CORBA.TypeCode)this.value;
    }

    public synchronized void insert_TypeCode(org.omg.CORBA.TypeCode val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_TypeCode));
        this.value = val;
    }

    public synchronized Principal extract_Principal() throws BAD_OPERATION {
        throw new NO_IMPLEMENT();
    }

    public synchronized void insert_Principal(Principal val) {
        throw new NO_IMPLEMENT();
    }

    public synchronized Object extract_Object() throws BAD_OPERATION {
        TCKind kind = this.origTypeCode.kind();
        if (kind != TCKind.tk_objref && kind != TCKind.tk_abstract_interface && kind != org.omg.CORBA_2_4.TCKind.tk_local_interface) {
            throw new BAD_OPERATION(MinorCodes.describeBadOperation(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (this.value != null && !(this.value instanceof Object)) {
            throw new BAD_OPERATION(MinorCodes.describeBadOperation(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        return (Object)this.value;
    }

    public synchronized void insert_Object(Object val) {
        if (this.orbInstance == null && val != null) {
            try {
                Delegate d = (Delegate)((ObjectImpl)val)._get_delegate();
                this.orbInstance = d._OB_ORBInstance();
            }
            catch (BAD_OPERATION d) {
                // empty catch block
            }
        }
        org.omg.CORBA.TypeCode tc = TypeCodeFactory.createPrimitiveTC(TCKind.tk_objref);
        this.insert_Object(val, tc);
    }

    public synchronized void insert_Object(Object val, org.omg.CORBA.TypeCode tc) {
        if (this.orbInstance == null && val != null) {
            try {
                Delegate d = (Delegate)((ObjectImpl)val)._get_delegate();
                this.orbInstance = d._OB_ORBInstance();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                // empty catch block
            }
        }
        this.type(tc);
        this.value = val;
    }

    public synchronized String extract_string() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_string);
        return (String)this.value;
    }

    public synchronized void insert_string(String val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_string));
        this.value = val;
    }

    public synchronized String extract_wstring() throws BAD_OPERATION {
        this.checkValue(TCKind.tk_wstring);
        return (String)this.value;
    }

    public synchronized void insert_wstring(String val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_wstring));
        this.value = val;
    }

    public Streamable extract_Streamable() throws BAD_INV_ORDER {
        if (!(this.value instanceof Streamable)) {
            throw new BAD_INV_ORDER("Type mismatch");
        }
        return (Streamable)this.value;
    }

    public synchronized void insert_Streamable(Streamable val) {
        this.type(val._type());
        this.value = val;
    }

    public synchronized BigDecimal extract_fixed() {
        this.checkValue(TCKind.tk_fixed);
        return (BigDecimal)this.value;
    }

    public synchronized void insert_fixed(BigDecimal val) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_fixed));
        this.value = val;
    }

    public synchronized void insert_fixed(BigDecimal val, org.omg.CORBA.TypeCode tc) throws BAD_INV_ORDER {
        this.type(tc);
        this.value = val;
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        TCKind kind = this.origTypeCode.kind();
        if (kind != TCKind.tk_value && kind != TCKind.tk_value_box && kind != TCKind.tk_abstract_interface) {
            throw new BAD_OPERATION(MinorCodes.describeBadOperation(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (kind == TCKind.tk_abstract_interface && this.value instanceof Object) {
            throw new BAD_OPERATION(MinorCodes.describeBadOperation(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (this.value instanceof InputStream) {
            InputStream in = (InputStream)((java.lang.Object)this.value);
            in._OB_reset();
            if (kind == TCKind.tk_abstract_interface) {
                Assert._OB_assert(!in.read_boolean());
            }
            return in.read_value();
        }
        return (Serializable)this.value;
    }

    public synchronized void insert_Value(Serializable val) {
        org.omg.CORBA.TypeCode tc = TypeCodeFactory.createPrimitiveTC(TCKind.tk_value);
        this.insert_Value(val, tc);
    }

    public synchronized void insert_Value(Serializable val, org.omg.CORBA.TypeCode tc) throws MARSHAL {
        this.type(tc);
        this.value = val;
    }

    public Any() {
        this((ORBInstance)null);
    }

    public Any(ORBInstance orbInstance) {
        this.type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_null));
        this.value = null;
    }

    public Any(Any any) {
        this.copyFrom(any);
    }

    public Any(org.omg.CORBA.Any any) {
        if (any instanceof Any) {
            this.copyFrom((Any)any);
            return;
        }
        this.orbInstance = null;
        this.setType(any.type());
        switch (this.origTypeCode.kind().value()) {
            case 0: 
            case 1: 
            case 13: {
                break;
            }
            case 2: {
                this.value = (int)any.extract_short();
                break;
            }
            case 3: {
                this.value = any.extract_long();
                break;
            }
            case 23: {
                this.value = any.extract_longlong();
                break;
            }
            case 4: {
                this.value = (int)any.extract_ushort();
                break;
            }
            case 5: {
                this.value = any.extract_ulong();
                break;
            }
            case 24: {
                this.value = any.extract_ulonglong();
                break;
            }
            case 6: {
                this.value = Float.valueOf(any.extract_float());
                break;
            }
            case 7: {
                this.value = any.extract_double();
                break;
            }
            case 8: {
                this.value = any.extract_boolean();
                break;
            }
            case 9: {
                this.value = Character.valueOf(any.extract_char());
                break;
            }
            case 26: {
                this.value = Character.valueOf(any.extract_wchar());
                break;
            }
            case 10: {
                this.value = any.extract_octet();
                break;
            }
            case 18: {
                this.value = any.extract_string();
                break;
            }
            case 27: {
                this.value = any.extract_wstring();
                break;
            }
            case 28: {
                this.value = any.extract_fixed();
                break;
            }
            case 12: {
                this.value = any.extract_TypeCode();
                break;
            }
            case 14: 
            case 32: 
            case 33: {
                try {
                    this.value = any.extract_Object();
                    break;
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    // empty catch block
                }
            }
            default: {
                this.readValue(any.create_input_stream());
            }
        }
    }

    public Any(ORBInstance orbInstance, org.omg.CORBA.TypeCode type, java.lang.Object value) {
        this.setType(type);
        this.value = value;
    }

    public synchronized java.lang.Object value() {
        return this.value;
    }

    public synchronized void replace(org.omg.CORBA.TypeCode tc, java.lang.Object value) {
        this.setType(tc);
        this.value = value;
    }

    public synchronized void _OB_ORBInstance(ORBInstance orbInstance) {
    }

    public synchronized org.omg.CORBA.TypeCode _OB_type() {
        return this.yokoTypeCode;
    }
}

