/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsClientEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class DispatchImpl<T>
implements Dispatch<T>,
BindingProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private static final String DISPATCH_NS = "http://cxf.apache.org/jaxws/dispatch";
    private static final String INVOKE_NAME = "Invoke";
    private static final String INVOKE_ONEWAY_NAME = "InvokeOneWay";
    private static final QName INVOKE_QNAME = new QName("http://cxf.apache.org/jaxws/dispatch", "Invoke");
    private static final QName INVOKE_ONEWAY_QNAME = new QName("http://cxf.apache.org/jaxws/dispatch", "InvokeOneWay");
    private final Binding binding;
    private final EndpointReferenceBuilder builder;
    private final Client client;
    private final Class<T> cl;
    private final JAXBContext context;
    private Message error;
    private Service.Mode mode;
    static final long serialVersionUID = 8937208151831969093L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    DispatchImpl(Client client, Service.Mode m, JAXBContext ctx, Class<T> clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "<init>", new Object[]{client, m, ctx, clazz});
        }
        this.binding = ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding();
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)client.getEndpoint());
        this.client = client;
        this.mode = m;
        this.context = ctx;
        this.cl = clazz;
        this.setupEndpointAddressContext(client.getEndpoint());
        this.addInvokeOperation(false);
        this.addInvokeOperation(true);
        if (m == Service.Mode.MESSAGE && this.binding instanceof SOAPBinding) {
            if (DataSource.class.isAssignableFrom(clazz)) {
                this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"DataSource", m, "SOAP/HTTP"});
            } else if (m == Service.Mode.MESSAGE) {
                SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
                client.getOutInterceptors().add(saajOut);
                client.getOutInterceptors().add(new MessageModeOutInterceptor(saajOut, client.getEndpoint().getBinding().getBindingInfo().getName()));
                client.getInInterceptors().add(new SAAJInInterceptor());
                client.getInInterceptors().add(new MessageModeInInterceptor(clazz, client.getEndpoint().getBinding().getBindingInfo().getName()));
            }
        } else if (m == Service.Mode.PAYLOAD && this.binding instanceof SOAPBinding && SOAPMessage.class.isAssignableFrom(clazz)) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"SOAPMessage", m, "SOAP/HTTP"});
        } else if (DataSource.class.isAssignableFrom(clazz) && this.binding instanceof HTTPBinding) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"DataSource", m, "XML/HTTP"});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    DispatchImpl(Client cl, Service.Mode m, Class<T> clazz) {
        this(cl, m, null, clazz);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "<init>", new Object[]{cl, m, clazz});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addInvokeOperation(boolean oneWay) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "addInvokeOperation", new Object[]{oneWay});
        }
        String name = oneWay ? INVOKE_ONEWAY_NAME : INVOKE_NAME;
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo opInfo = info.getInterface().addOperation(oneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME);
        MessageInfo mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Request"), MessageInfo.Type.INPUT);
        opInfo.setInput(name + "Request", mInfo);
        MessagePartInfo mpi = mInfo.addMessagePart("parameters");
        if (this.context == null) {
            mpi.setTypeClass(this.cl);
        }
        mpi.setElement(true);
        if (!oneWay) {
            mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Response"), MessageInfo.Type.OUTPUT);
            opInfo.setOutput(name + "Response", mInfo);
            mpi = mInfo.addMessagePart("parameters");
            mpi.setElement(true);
            if (this.context == null) {
                mpi.setTypeClass(this.cl);
            }
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "addInvokeOperation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addInvokeOperation(QName operationName, boolean oneWay) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "addInvokeOperation", new Object[]{operationName, oneWay});
        }
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo invokeOpInfo = info.getInterface().getOperation(oneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME);
        OperationInfo opInfo = info.getInterface().addOperation(operationName);
        opInfo.setInput(invokeOpInfo.getInputName(), invokeOpInfo.getInput());
        if (!oneWay) {
            opInfo.setOutput(invokeOpInfo.getOutputName(), invokeOpInfo.getOutput());
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "addInvokeOperation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getRequestContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getRequestContext", new Object[0]);
        }
        WrappedMessageContext wrappedMessageContext = new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrappedMessageContext = wrappedMessageContext;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getRequestContext", wrappedMessageContext);
        }
        return wrappedMessageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getResponseContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getResponseContext", new Object[0]);
        }
        WrappedMessageContext wrappedMessageContext = new WrappedMessageContext(this.client.getResponseContext(), null, MessageContext.Scope.APPLICATION);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrappedMessageContext = wrappedMessageContext;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getResponseContext", wrappedMessageContext);
        }
        return wrappedMessageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Binding getBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getBinding", new Object[0]);
        }
        Binding binding = this.binding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            binding = binding;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getBinding", binding);
        }
        return binding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReference getEndpointReference() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getEndpointReference", new Object[0]);
        }
        EndpointReference endpointReference = this.builder.getEndpointReference();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointReference = endpointReference;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <X extends EndpointReference> X getEndpointReference(Class<X> clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getEndpointReference", new Object[]{clazz});
        }
        X x = this.builder.getEndpointReference(clazz);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            x = x;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getEndpointReference", x);
        }
        return x;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "setupEndpointAddressContext", new Object[]{endpoint});
        }
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            WrappedMessageContext requestContext = new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
            requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "setupEndpointAddressContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public T invoke(T obj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "invoke", new Object[]{obj});
        }
        T t = this.invoke(obj, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "invoke", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkError() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "checkError", new Object[0]);
        }
        if (this.error != null) {
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = null;
                try {
                    soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), new Exception(this.error.toString()));
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                if (soapFault != null) {
                    throw new SOAPFaultException(soapFault);
                }
            } else if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)new Exception(this.error.toString()));
                throw exception;
            }
            throw new WebServiceException(this.error.toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "checkError");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private RuntimeException mapException(Exception ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "mapException", new Object[]{ex});
        }
        if (ex instanceof Fault && ex.getCause() instanceof IOException) {
            throw new WebServiceException(ex.getMessage(), ex.getCause());
        }
        if (this.getBinding() instanceof HTTPBinding) {
            HTTPException exception = new HTTPException(500);
            exception.initCause((Throwable)ex);
            HTTPException hTTPException = exception;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                hTTPException = hTTPException;
                LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "mapException", hTTPException);
            }
            return hTTPException;
        }
        if (this.getBinding() instanceof SOAPBinding) {
            SOAPFault soapFault = null;
            try {
                soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            if (soapFault == null) {
                WebServiceException webServiceException = new WebServiceException((Throwable)ex);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    webServiceException = webServiceException;
                    LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "mapException", webServiceException);
                }
                return webServiceException;
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            exception.initCause((Throwable)ex);
            SOAPFaultException sOAPFaultException = exception;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                sOAPFaultException = sOAPFaultException;
                LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "mapException", sOAPFaultException);
            }
            return sOAPFaultException;
        }
        WebServiceException webServiceException = new WebServiceException((Throwable)ex);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            webServiceException = webServiceException;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "mapException", webServiceException);
        }
        return webServiceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public T invoke(T obj, boolean isOneWay) {
        Object object;
        block29: {
            Object[] ret;
            block27: {
                T t;
                block28: {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "invoke", new Object[]{obj, isOneWay});
                    }
                    StaxSource createdSource = null;
                    this.checkError();
                    try {
                        if (obj instanceof SOAPMessage) {
                            SOAPMessage msg = (SOAPMessage)obj;
                            if (msg.countAttachments() > 0) {
                                this.client.getRequestContext().put("write.attachments", Boolean.TRUE);
                            }
                        } else if (this.context != null) {
                            Boolean unwrapProperty = obj instanceof JAXBElement ? Boolean.FALSE : Boolean.TRUE;
                            this.getRequestContext().put("unwrap.jaxb.element", unwrapProperty);
                        }
                        QName opName = (QName)this.getRequestContext().get("javax.xml.ws.wsdl.operation");
                        boolean findDispatchOp = Boolean.TRUE.equals(this.getRequestContext().get("find.dispatch.operation"));
                        if (opName == null) {
                            opName = isOneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME;
                        } else {
                            BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                            if (bop == null) {
                                this.addInvokeOperation(opName, isOneWay);
                            }
                        }
                        if (!findDispatchOp) {
                            List<AbstractFeature> allFeatures;
                            List<AbstractFeature> endpointFeatures = ((JaxWsClientEndpointImpl)this.client.getEndpoint()).getFeatures();
                            if (this.client.getBus().getFeatures() != null) {
                                allFeatures = new ArrayList<AbstractFeature>(endpointFeatures.size() + this.client.getBus().getFeatures().size());
                                allFeatures.addAll(endpointFeatures);
                                allFeatures.addAll(this.client.getBus().getFeatures());
                            } else {
                                allFeatures = endpointFeatures;
                            }
                            for (AbstractFeature feature : allFeatures) {
                                if (!(feature instanceof WSAddressingFeature)) continue;
                                findDispatchOp = true;
                            }
                        }
                        Map<String, QName> payloadOPMap = this.createPayloadEleOpNameMap(this.client.getEndpoint().getBinding().getBindingInfo());
                        if (findDispatchOp && !payloadOPMap.isEmpty()) {
                            QName dispatchedOpName;
                            String payloadElementName = null;
                            if (obj instanceof Source) {
                                XMLStreamReader reader = null;
                                try {
                                    reader = StaxUtils.createXMLStreamReader((Source)((Source)obj));
                                    Document document = StaxUtils.read((XMLStreamReader)reader);
                                    createdSource = new StaxSource(StaxUtils.createXMLStreamReader((Document)document));
                                    payloadElementName = this.getPayloadElementName(document.getDocumentElement());
                                }
                                catch (Exception document) {
                                }
                                finally {
                                    StaxUtils.close((XMLStreamReader)reader);
                                }
                            }
                            if (obj instanceof SOAPMessage) {
                                payloadElementName = this.getPayloadElementName((SOAPMessage)obj);
                            }
                            if (this.context != null) {
                                payloadElementName = this.getPayloadElementName(obj);
                            }
                            if (payloadElementName != null && null != (dispatchedOpName = payloadOPMap.get(payloadElementName))) {
                                BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                                BindingOperationInfo dbop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(dispatchedOpName);
                                if (bop != null) {
                                    bop.setProperty("dispatchToOperation", (Object)dbop);
                                }
                            }
                        }
                        ret = this.client.invokeWrapped(opName, new Object[]{createdSource == null ? obj : createdSource});
                        if (!isOneWay && ret != null && ret.length != 0) break block27;
                        t = null;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block28;
                    }
                    catch (Exception ex) {
                        throw this.mapException(ex);
                    }
                    t = t;
                    LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "invoke", t);
                }
                return t;
            }
            object = ret[0];
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block29;
            object = object;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "invoke", object);
        }
        return (T)object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        JaxwsResponseCallback jaxwsResponseCallback;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "invokeAsync", new Object[]{obj, asyncHandler});
            }
            this.checkError();
            this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
            JaxwsClientCallback<T> callback = new JaxwsClientCallback<T>(asyncHandler, this);
            JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
            try {
                QName opName = (QName)this.getRequestContext().get("javax.xml.ws.wsdl.operation");
                if (opName == null) {
                    opName = INVOKE_QNAME;
                } else {
                    BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                    if (bop == null) {
                        this.addInvokeOperation(opName, false);
                    }
                }
                this.client.invokeWrapped(callback, opName, new Object[]{obj});
                jaxwsResponseCallback = ret;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (Exception ex) {
                throw this.mapException(ex);
            }
            jaxwsResponseCallback = jaxwsResponseCallback;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "invokeAsync", jaxwsResponseCallback);
        }
        return jaxwsResponseCallback;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Response<T> invokeAsync(T obj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "invokeAsync", new Object[]{obj});
        }
        Response response = (Response)this.invokeAsync(obj, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            response = response;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "invokeAsync", response);
        }
        return response;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void invokeOneWay(T obj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "invokeOneWay", new Object[]{obj});
        }
        this.invoke(obj, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "invokeOneWay");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client getClient() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getClient", new Object[0]);
        }
        Client client = this.client;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            client = client;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getClient", client);
        }
        return client;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPayloadElementName(Element ele) {
        block7: {
            String string;
            block8: {
                DepthXMLStreamReader reader;
                block5: {
                    String string2;
                    block6: {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", new Object[]{ele});
                        }
                        XMLStreamReader xmlreader = StaxUtils.createXMLStreamReader((Element)ele);
                        reader = new DepthXMLStreamReader(xmlreader);
                        if (this.mode != Service.Mode.PAYLOAD) break block5;
                        StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader);
                        string2 = reader.getName().toString();
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
                        string2 = string2;
                        LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string2);
                    }
                    return string2;
                }
                try {
                    if (this.mode != Service.Mode.MESSAGE) break block7;
                    StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader);
                    StaxUtils.toNextTag((DepthXMLStreamReader)reader, (QName)new QName(ele.getNamespaceURI(), "Body"));
                    reader.nextTag();
                    string = reader.getName().toString();
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPayloadElementName(SOAPMessage soapMessage) {
        block4: {
            String string;
            block5: {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", new Object[]{soapMessage});
                }
                try {
                    Element element = DOMUtils.getFirstElement((Node)SAAJUtils.getBody((SOAPMessage)soapMessage));
                    if (element == null) break block4;
                    string = DOMUtils.getElementQName((Element)element).toString();
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPayloadElementName(Object object) {
        DepthXMLStreamReader reader;
        XMLStreamWriter resultWriter;
        block7: {
            String string;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", new Object[]{object});
            }
            JAXBDataBinding dataBinding = new JAXBDataBinding();
            dataBinding.setContext(this.context);
            DataWriter dbwriter = dataBinding.createWriter(XMLStreamWriter.class);
            StringWriter stringWriter = new StringWriter();
            resultWriter = StaxUtils.createXMLStreamWriter((Writer)stringWriter);
            reader = null;
            try {
                dbwriter.write(object, (Object)resultWriter);
                resultWriter.flush();
                if (StringUtils.isEmpty((String)stringWriter.toString())) break block7;
                ByteArrayInputStream binput = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes());
                XMLStreamReader xmlreader = StaxUtils.createXMLStreamReader((InputStream)binput);
                reader = new DepthXMLStreamReader(xmlreader);
                StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader);
                string = reader.getName().toString();
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtils.close(reader);
                StaxUtils.close((XMLStreamWriter)resultWriter);
                catch (Throwable throwable) {
                    StaxUtils.close(reader);
                    StaxUtils.close((XMLStreamWriter)resultWriter);
                    throw throwable;
                }
            }
            StaxUtils.close((XMLStreamReader)reader);
            StaxUtils.close((XMLStreamWriter)resultWriter);
            String string2 = string;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string2 = string2;
                LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string2);
            }
            return string2;
        }
        StaxUtils.close(reader);
        StaxUtils.close((XMLStreamWriter)resultWriter);
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "getPayloadElementName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, QName> createPayloadEleOpNameMap(BindingInfo bindingInfo) {
        String tempStyle;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.DispatchImpl", "createPayloadEleOpNameMap", new Object[]{bindingInfo});
        }
        HashMap<String, QName> payloadElementMap = new HashMap<String, QName>();
        String bindingStyle = "document";
        if (bindingInfo instanceof SoapBindingInfo && (tempStyle = ((SoapBindingInfo)bindingInfo).getStyle()) != null) {
            bindingStyle = tempStyle;
        }
        for (BindingOperationInfo bop : bindingInfo.getOperations()) {
            String operationStyle;
            SoapOperationInfo soi = (SoapOperationInfo)bop.getExtensor(SoapOperationInfo.class);
            if (soi == null) continue;
            String string = operationStyle = soi.getStyle() != null ? soi.getStyle() : bindingStyle;
            if ("document".equals(operationStyle)) {
                if (bop.getOperationInfo().getInput() == null || bop.getOperationInfo().getInput().getMessageParts().isEmpty()) continue;
                QName qn = bop.getOperationInfo().getInput().getMessagePartByIndex(0).getElementQName();
                payloadElementMap.put(qn.toString(), bop.getOperationInfo().getName());
                continue;
            }
            if (!"rpc".equals(operationStyle)) continue;
            payloadElementMap.put(bop.getOperationInfo().getName().toString(), bop.getOperationInfo().getName());
        }
        HashMap<String, QName> hashMap = payloadElementMap;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.jaxws.DispatchImpl", "createPayloadEleOpNameMap", hashMap);
        }
        return hashMap;
    }
}

