/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsClientServiceFacadeInterface;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.jfapchannel.richclient.impl.JFapChannelFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class CommsOutboundChain {
    private static final TraceComponent tc = Tr.register(CommsOutboundChain.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String _OutboundChain_ConfigAlias = "wasJmsOutbound";
    private String _chainName = null;
    private String _tcpChannelName = null;
    private String _jfapChannelName = null;
    private String _sslChannelName = null;
    private ChannelConfiguration _tcpOptions = null;
    private final AtomicServiceReference<ChannelConfiguration> _sslOptions = new AtomicServiceReference("sslOptions");
    private CommsClientServiceFacadeInterface _commsClientService = null;
    private boolean _isChainActivated = false;
    private boolean _isChainDeactivated = false;
    private boolean _isSSLChain = false;

    @Trivial
    protected void setCommsClientService(CommsClientServiceFacadeInterface service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setCommsClientService", (Object[])new Object[]{service});
        }
        this._commsClientService = service;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setCommsClientService");
        }
    }

    @Trivial
    protected void setTcpOptions(ChannelConfiguration service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setTcpOptions", (Object[])new Object[]{service});
        }
        this._tcpOptions = service;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setTcpOptions");
        }
    }

    private Map<String, Object> getTcpOptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getTcpOptions", (Object[])new Object[0]);
        }
        Map tcpOptions = null;
        if (this._tcpOptions == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"getTcpOptions() returning NULL as __tcpOptions.getService() returned NUll _tcpOptions: ", (Object)this._tcpOptions);
            }
        } else {
            tcpOptions = this._tcpOptions.getConfiguration();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getTcpOptions", (Object)tcpOptions);
        }
        return tcpOptions;
    }

    @Trivial
    protected void setSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setSslOptions", (Object[])new Object[]{service});
        }
        this._sslOptions.setReference(service);
        this.createJFAPChain();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setSslOptions");
        }
    }

    private Map<String, Object> getSslOptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getSslOptions", (Object[])new Object[0]);
        }
        ChannelConfiguration chanCnfgService = (ChannelConfiguration)this._sslOptions.getService();
        Map sslOptions = null;
        if (chanCnfgService == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"getSslOptions() returning NULL as _sslOptions.getService() returned NUll _sslOptions: ", this._sslOptions);
            }
        } else {
            sslOptions = chanCnfgService.getConfiguration();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getSslOptions", (Object)sslOptions);
        }
        return sslOptions;
    }

    protected void activate(Map<String, Object> properties, ComponentContext context) {
        String Outboundname;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object)new Object[]{properties, context, this._isChainActivated, this._isChainDeactivated});
        }
        this._sslOptions.activate(context);
        this._isSSLChain = MetatypeUtils.parseBoolean((Object)_OutboundChain_ConfigAlias, (String)"useSSL", (Object)properties.get("useSSL"), (boolean)false);
        this._chainName = Outboundname = (String)properties.get("id");
        this._tcpChannelName = Outboundname + "_JfapTcp";
        this._sslChannelName = Outboundname + "_JfapSsl";
        this._jfapChannelName = Outboundname + "_JfapJfap";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("CommsOutboundChain: Creating " + (this._isSSLChain ? "Secure" : "Non-Secure") + " chain "), (Object)this._chainName);
        }
        if (this._isChainActivated) {
            FFDCFilter.processException((Throwable)new IllegalStateException("_isChainActivated=" + this._isChainActivated + " _isChainDeactivated=" + this._isChainDeactivated), (String)CommsOutboundChain.class.getName(), (String)"050819_210", (Object[])new Object[]{this._isChainActivated, this._isChainDeactivated});
        } else {
            this._isChainActivated = true;
            this.createJFAPChain();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    private synchronized void createJFAPChain() {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"createJFAPChain", (Object)new Object[]{this._chainName, this._isSSLChain, this._isChainActivated, this._isChainDeactivated});
            }
            if (!this._isChainActivated || this._isChainDeactivated) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createJFAPChain", (Object)"Chain is not activated, or is deactivated");
                }
                return;
            }
            try {
                ChannelData jfapChannel;
                ChannelFramework cfw = CommsClientServiceFacade.getChannelFramewrok();
                cfw.registerFactory("JFapChannelOutbound", JFapChannelFactory.class);
                Map<String, Object> tcpOptions = this.getTcpOptions();
                ChannelData tcpChannel = cfw.getChannel(this._tcpChannelName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    tcpChannel = cfw.addChannel(this._tcpChannelName, cfw.lookupFactory(typeName), new HashMap<String, Object>(tcpOptions));
                }
                if (this._isSSLChain) {
                    Map<String, Object> sslOptions = this.getSslOptions();
                    if (sslOptions == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"_sslOptions not set, continue waiting");
                        }
                        throw new ChainException(new Throwable(nls.getFormattedMessage("missingSslOptions.ChainNotStarted", new Object[]{this._chainName}, null)));
                    }
                    ChannelData sslChannel = cfw.getChannel(this._sslChannelName);
                    if (sslChannel == null) {
                        sslChannel = cfw.addChannel(this._sslChannelName, cfw.lookupFactory("SSLChannel"), new HashMap<String, Object>(sslOptions));
                    }
                }
                if ((jfapChannel = cfw.getChannel(this._jfapChannelName)) == null) {
                    jfapChannel = cfw.addChannel(this._jfapChannelName, cfw.lookupFactory("JFapChannelOutbound"), null);
                }
                String[] chanList = this._isSSLChain ? new String[]{this._jfapChannelName, this._sslChannelName, this._tcpChannelName} : new String[]{this._jfapChannelName, this._tcpChannelName};
                ChainData cd = cfw.addChain(this._chainName, FlowType.OUTBOUND, chanList);
                cd.setEnabled(true);
                if (this._isSSLChain) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound secure chain" + this._chainName + " successfully started "));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound chain" + this._chainName + " successfully started "));
                }
            }
            catch (ChainException | ChannelException exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound chain " + this._chainName + " failed to start, exception =" + exception));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createJFAPChain");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context, this._isChainActivated, this._isChainDeactivated});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("CommsOutboundChain: Destorying " + (this._isSSLChain ? "Secure" : "Non-Secure") + " chain "), (Object)this._chainName);
        }
        if (this._isChainDeactivated) {
            FFDCFilter.processException((Throwable)new IllegalStateException("_isChainActivated=" + this._isChainActivated + " _isChainDeactivated=" + this._isChainDeactivated), (String)CommsOutboundChain.class.getName(), (String)"050819_297", (Object[])new Object[]{this._isChainActivated, this._isChainDeactivated});
        } else {
            this._isChainDeactivated = true;
            this.terminateConnectionsAssociatedWithChain();
        }
        this._sslOptions.deactivate(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    private synchronized void terminateConnectionsAssociatedWithChain() {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain", (Object[])new Object[]{this._chainName});
            }
            try {
                ChannelFramework cfw = CommsClientServiceFacade.getChannelFramewrok();
                OutboundConnectionTracker oct = ClientConnectionManager.getRef().getOutboundConnectionTracker();
                if (oct != null) {
                    oct.terminateConnectionsAssociatedWithChain(this._chainName);
                } else if (cfw.getChain(this._chainName) != null) {
                    cfw.getOutboundVCFactory(this._chainName).destroy();
                }
                ChainData cd = cfw.getChain(this._chainName);
                if (cd != null) {
                    cfw.removeChain(cd);
                }
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                SibTr.debug((TraceComponent)tc, (String)("Failure in terminating conservations and physical connections while destroying chain : " + this._chainName), (Object)exception);
            }
        }
        this.removeChannel(this._tcpChannelName);
        if (this._isSSLChain) {
            this.removeChannel(this._sslChannelName);
        }
        this.removeChannel(this._jfapChannelName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain");
        }
    }

    private void removeChannel(String channelName) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeChannel", (Object)channelName);
            }
            ChannelFramework cfw = CommsClientServiceFacade.getChannelFramewrok();
            try {
                if (cfw.getChannel(channelName) != null) {
                    cfw.removeChannel(channelName);
                }
            }
            catch (ChainException | ChannelException exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel:" + channelName), (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeChannel");
        }
    }
}

