/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.java2sec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.java2sec.JavaPermissionsConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.security.PermissionsCombiner;
import com.ibm.ws.kernel.boot.security.WLPDynamicPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.AuthPermission;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.url.URLStreamHandlerService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PermissionManager
implements PermissionsCombiner {
    private static final TraceComponent tc = Tr.register(PermissionManager.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
    private BundleContext bundleContext;
    private ClassLoadingService classLoadingService;
    private static Permission[] DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS = null;
    private static Permission[] DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS;
    private boolean isServer = true;
    private boolean wsjarUrlStreamHandlerAvailable = false;
    private ArrayList<Permission> restrictablePermissions = new ArrayList();
    private ArrayList<Permission> grantedPermissions = new ArrayList();
    private static final String KEY_PERMISSION = "permission";
    private static final String INCORRECT_PERMISSION_CONFIGURATION = "INCORRECT_PERMISSION_CONFIGURATION";
    private static final String PERMISSION_CLASSNOTFOUND = "PERMISSION_CLASSNOTFOUND";
    private static final String SERVER_XML = "server.xml";
    private static final String CLIENT_XML = "client.xml";
    private String originationFile = null;
    private final ConcurrentServiceReferenceSet<JavaPermissionsConfiguration> permissions = new ConcurrentServiceReferenceSet("permission");
    private Map<String, ArrayList<Permission>> codeBasePermissionMap = new HashMap<String, ArrayList<Permission>>();
    private Map<String, ArrayList<Permission>> permissionXMLPermissionMap = new HashMap<String, ArrayList<Permission>>();
    private final boolean java2SecurityEnabled;
    static final long serialVersionUID = 8819607610050598163L;

    public PermissionManager() {
        this(System.getSecurityManager() != null);
    }

    PermissionManager(boolean java2SecurityEnabled) {
        this.java2SecurityEnabled = java2SecurityEnabled;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.bundleContext = cc.getBundleContext();
        this.isServer = "server".equals(this.bundleContext.getProperty("wlp.process.type"));
        if (this.java2SecurityEnabled) {
            this.permissions.activate(cc);
            this.initializePermissions();
            this.setAsDynamicPolicyPermissionCombiner(this);
        }
    }

    private void setAsDynamicPolicyPermissionCombiner(PermissionsCombiner effectivePolicy) {
        Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){
            static final long serialVersionUID = 2763094408741742358L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.PermissionManager$1", 1.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
            }
        });
        if (policy instanceof WLPDynamicPolicy) {
            ((WLPDynamicPolicy)policy).setPermissionsCombiner(effectivePolicy);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (this.java2SecurityEnabled) {
            this.permissions.deactivate(cc);
            this.clearPermissions();
            this.setAsDynamicPolicyPermissionCombiner(null);
        }
    }

    protected void setPermission(ServiceReference<JavaPermissionsConfiguration> permission) {
        this.permissions.addReference(permission);
    }

    protected synchronized void unsetPermission(ServiceReference<JavaPermissionsConfiguration> permission) {
        this.permissions.removeReference(permission);
        if (this.java2SecurityEnabled && this.wsjarUrlStreamHandlerAvailable) {
            this.clearPermissions();
            this.initializePermissions();
        }
    }

    protected synchronized void setWsjarURLStreamHandler(ServiceReference<URLStreamHandlerService> urlStreamHandlerServiceRef) {
        this.wsjarUrlStreamHandlerAvailable = true;
    }

    protected synchronized void unsetWsjarURLStreamHandler(ServiceReference<URLStreamHandlerService> urlStreamHandlerServiceRef) {
        this.wsjarUrlStreamHandlerAvailable = false;
    }

    protected synchronized void updatedConfiguration(ServiceReference<JavaPermissionsConfiguration> permission) {
        this.permissions.removeReference(permission);
        this.permissions.addReference(permission);
        if (this.java2SecurityEnabled && this.wsjarUrlStreamHandlerAvailable) {
            this.clearPermissions();
            this.initializePermissions();
        }
    }

    private void clearPermissions() {
        this.restrictablePermissions.clear();
        this.grantedPermissions.clear();
        this.codeBasePermissionMap.clear();
    }

    protected void setClassLoadingService(ClassLoadingService service) {
        this.classLoadingService = service;
    }

    protected void unsetClassLoadingService(ClassLoadingService service) {
        this.classLoadingService = null;
    }

    private void initializePermissions() {
        Iterable javaPermissions;
        int count = 0;
        if (tc.isDebugEnabled()) {
            if (this.isServer) {
                Tr.debug((TraceComponent)tc, (String)"running on server ", (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)"running on client ", (Object[])new Object[0]);
            }
        }
        if (this.isServer) {
            count = DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS.length;
            this.originationFile = SERVER_XML;
        } else {
            count = DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS.length;
            this.originationFile = CLIENT_XML;
        }
        for (int i = 0; i < count; ++i) {
            if (this.isServer) {
                this.restrictablePermissions.add(DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS[i]);
                continue;
            }
            this.restrictablePermissions.add(DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS[i]);
        }
        if (this.permissions != null && !this.permissions.isEmpty() && (javaPermissions = this.permissions.services()) != null) {
            for (JavaPermissionsConfiguration permission : javaPermissions) {
                String permissionClass = String.valueOf(permission.get("className"));
                String target = String.valueOf(permission.get("name"));
                String action = String.valueOf(permission.get("actions"));
                String credential = String.valueOf(permission.get("signedBy"));
                String principalType = String.valueOf(permission.get("principalType"));
                String principalName = String.valueOf(permission.get("principalName"));
                String codebase = this.normalize(String.valueOf(permission.get("codebase")));
                Permission perm = this.createPermissionObject(permissionClass, target, action, credential, principalType, principalName, this.originationFile);
                boolean isRestriction = false;
                if (permission.get("restriction") != null) {
                    isRestriction = (Boolean)permission.get("restriction");
                }
                if (isRestriction) {
                    if (perm == null) continue;
                    this.restrictablePermissions.add(perm);
                    continue;
                }
                if (perm == null) continue;
                if (codebase != null && !codebase.equalsIgnoreCase("null")) {
                    this.setCodeBasePermission(codebase, perm);
                    continue;
                }
                this.grantedPermissions.add(perm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("restrictablePermissions : " + this.restrictablePermissions), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("grantedPermissions : " + this.grantedPermissions), (Object[])new Object[0]);
            }
        }
        this.setSharedLibraryPermission();
    }

    private String normalize(String codebase) {
        if (codebase != null) {
            codebase = codebase.replace("\\", "/");
            codebase = codebase.replace("//", "/");
        }
        return codebase;
    }

    private void setCodeBasePermission(String codeBase, Permission permission) {
        ArrayList<Object> permissions = null;
        if (this.codeBasePermissionMap.containsKey(codeBase)) {
            permissions = this.codeBasePermissionMap.get(codeBase);
            permissions.add(permission);
        } else {
            permissions = new ArrayList<Permission>();
            permissions.add(permission);
            this.codeBasePermissionMap.put(codeBase, permissions);
        }
    }

    private void setSharedLibraryPermission() {
        HashMap<String, ProtectionDomain> protectionDomainMap = new HashMap<String, ProtectionDomain>();
        for (String codeBase : this.codeBasePermissionMap.keySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("codeBase = " + codeBase), (Object[])new Object[0]);
            }
            ArrayList<Permission> permissions = this.codeBasePermissionMap.get(codeBase);
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < permissions.size(); ++i) {
                    Tr.debug((TraceComponent)tc, (String)(" permission: " + permissions.get(i)), (Object[])new Object[0]);
                }
            }
            CodeSource codeSource = this.createCodeSource(codeBase);
            ProtectionDomain protectionDomain = this.createProtectionDomain(codeSource, permissions);
            protectionDomainMap.put(codeBase, protectionDomain);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("protectionDomainMap.size = " + protectionDomainMap.size()), (Object[])new Object[0]);
        }
        if (this.classLoadingService != null) {
            this.classLoadingService.setSharedLibraryProtectionDomains(protectionDomainMap);
        }
    }

    private CodeSource createCodeSource(String codeBase) {
        CodeSource codeSource;
        block2: {
            Certificate[] certs = null;
            codeSource = null;
            try {
                codeSource = new CodeSource(new URL("wsjar:file:/" + codeBase), certs);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.java2sec.PermissionManager", (String)"362", (Object)this, (Object[])new Object[]{codeBase});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Unable to create code source for protection domain", (Object[])new Object[0]);
            }
        }
        return codeSource;
    }

    private ProtectionDomain createProtectionDomain(CodeSource codeSource, ArrayList<Permission> permissions) {
        Permissions perms = new Permissions();
        if (!this.java2SecurityEnabled) {
            ((PermissionCollection)perms).add(new AllPermission());
        } else {
            for (Permission permission : permissions) {
                ((PermissionCollection)perms).add(permission);
            }
        }
        return new ProtectionDomain(codeSource, perms);
    }

    /*
     * WARNING - void declaration
     */
    public Permission createPermissionObject(String permissionClass, String target, String action, String credential, String principalType, String principalName, String fileName) {
        Permission permission;
        block15: {
            permission = null;
            if (target != null && (target.equals("ALL FILES") || target.contains("ALL FILES"))) {
                target = "<<ALL FILES>>";
            }
            try {
                if (permissionClass != null && !permissionClass.equalsIgnoreCase("null")) {
                    if (permissionClass.equalsIgnoreCase("javax.security.auth.PrivateCredentialPermission")) {
                        if (target == null || target.equalsIgnoreCase("null")) {
                            StringBuilder targetString = new StringBuilder();
                            targetString.append(credential);
                            targetString.append(" ");
                            targetString.append(principalType);
                            targetString.append(" \"");
                            targetString.append(principalName);
                            targetString.append("\"");
                            permission = (Permission)this.getPermissionClass(permissionClass).getConstructor(String.class, String.class).newInstance(targetString.toString(), "read");
                        } else {
                            permission = (Permission)this.getPermissionClass(permissionClass).getConstructor(String.class, String.class).newInstance(target, "read");
                        }
                    } else {
                        permission = action == null || action.equalsIgnoreCase("null") ? (target == null || target.equalsIgnoreCase("null") ? (Permission)this.getPermissionClass(permissionClass).newInstance() : (Permission)this.getPermissionClass(permissionClass).getConstructor(String.class).newInstance(target)) : (Permission)this.getPermissionClass(permissionClass).getConstructor(String.class, String.class).newInstance(target, action);
                    }
                }
            }
            catch (Exception targetString) {
                void e;
                FFDCFilter.processException((Throwable)targetString, (String)"com.ibm.ws.classloading.java2sec.PermissionManager", (String)"430", (Object)this, (Object[])new Object[]{permissionClass, target, action, credential, principalType, principalName, fileName});
                if (tc.isWarningEnabled()) {
                    String rootCause = null;
                    if (e.getCause() != null) {
                        rootCause = e.getCause().getClass().getName() + "[" + e.getCause().getMessage() + "]";
                    } else if (e.getMessage() != null) {
                        rootCause = e.getClass().getName() + "[" + e.getMessage() + "]";
                    }
                    if (rootCause == null) {
                        rootCause = "unknown reasons";
                    }
                    if (e instanceof ClassNotFoundException) {
                        Tr.warning((TraceComponent)tc, (String)PERMISSION_CLASSNOTFOUND, (Object[])new Object[]{permissionClass, rootCause, fileName});
                    } else {
                        Tr.warning((TraceComponent)tc, (String)INCORRECT_PERMISSION_CONFIGURATION, (Object[])new Object[]{permissionClass, rootCause, fileName});
                    }
                }
                if (!(e instanceof ClassNotFoundException)) break block15;
                permission = new UnresolvedPermission(permissionClass, target, action, null);
            }
        }
        return permission;
    }

    private Class<?> getPermissionClass(String className) throws ClassNotFoundException {
        Class<?> permissionClass = this.getPermissionClassUsingBundleClassLoader(className);
        if (permissionClass == null) {
            permissionClass = Class.forName(className);
        }
        return permissionClass;
    }

    private Class<?> getPermissionClassUsingBundleClassLoader(String className) throws ClassNotFoundException {
        Class<?> permissionClass = null;
        ClassLoader classloader = this.getBundleClassLoader(className);
        if (classloader != null) {
            permissionClass = classloader.loadClass(className);
        }
        return permissionClass;
    }

    private ClassLoader getBundleClassLoader(String className) {
        Collection<BundleCapability> bundleCapabilities = this.getBundlesProvidingPackage(className.substring(0, className.lastIndexOf(".")));
        BundleWiring providerBundleWiring = this.getBundleWiring(bundleCapabilities);
        return providerBundleWiring != null ? providerBundleWiring.getClassLoader() : null;
    }

    private Collection<BundleCapability> getBundlesProvidingPackage(final String classPackage) {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        Collection matchingCapabilities = frameworkWiring.findProviders(new Requirement(){
            static final long serialVersionUID = -9161294685101063159L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "osgi.wiring.package";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.wiring.package=" + classPackage + ")");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.PermissionManager$2", 2.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
            }
        });
        return matchingCapabilities;
    }

    private BundleWiring getBundleWiring(Collection<BundleCapability> bundleCapabilities) {
        BundleCapability bundleCapability = null;
        for (BundleCapability bc : bundleCapabilities) {
            if (bundleCapability != null && bc.getRevision().getBundle().getBundleId() == 0L) break;
            bundleCapability = bc;
        }
        return bundleCapability != null ? bundleCapability.getRevision().getWiring() : null;
    }

    public ArrayList<Permission> getRestrictablePermissions() {
        return (ArrayList)this.restrictablePermissions.clone();
    }

    public ArrayList<Permission> getEffectivePermissions(String codeBase) {
        List<Permission> emptyPermissions = Collections.emptyList();
        return this.getEffectivePermissions(emptyPermissions, codeBase);
    }

    public ArrayList<Permission> getEffectivePermissions(List<Permission> permissions, String codeBase) {
        ArrayList<Permission> effectivePermissions = new ArrayList<Permission>();
        effectivePermissions.addAll(this.grantedPermissions);
        codeBase = this.normalize(codeBase);
        if (this.codeBasePermissionMap.containsKey(codeBase)) {
            effectivePermissions.addAll((Collection)this.codeBasePermissionMap.get(codeBase));
        }
        if (this.permissionXMLPermissionMap.containsKey(codeBase)) {
            effectivePermissions.addAll((Collection)this.permissionXMLPermissionMap.get(codeBase));
        }
        for (Permission permission : permissions) {
            if (this.isRestricted(permission)) continue;
            effectivePermissions.add(permission);
        }
        return effectivePermissions;
    }

    public PermissionCollection getCombinedPermissions(PermissionCollection staticPolicyPermissionCollection, CodeSource codesource) {
        Permissions effectivePermissions = new Permissions();
        ArrayList<Permission> staticPolicyPermissions = Collections.list(staticPolicyPermissionCollection.elements());
        String codeBase = codesource.getLocation().getPath();
        ArrayList<Permission> permissions = this.getEffectivePermissions(staticPolicyPermissions, codeBase);
        for (Permission permission : permissions) {
            effectivePermissions.add(permission);
        }
        return effectivePermissions;
    }

    private boolean isRestricted(Permission permission) {
        for (Permission restrictedPermission : this.restrictablePermissions) {
            if (!restrictedPermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public void addPermissionsXMLPermission(CodeSource codeSource, Permission permission) {
        ArrayList<Object> permissions = null;
        String codeBase = codeSource.getLocation().getPath();
        if (!this.isRestricted(permission)) {
            if (this.permissionXMLPermissionMap.containsKey(codeBase)) {
                permissions = this.permissionXMLPermissionMap.get(codeBase);
                permissions.add(permission);
            } else {
                permissions = new ArrayList<Permission>();
                permissions.add(permission);
                this.permissionXMLPermissionMap.put(codeBase, permissions);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS = new Permission[4];
        PermissionManager.DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS[0] = new RuntimePermission("exitVM");
        PermissionManager.DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS[1] = new RuntimePermission("setSecurityManager");
        PermissionManager.DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS[2] = new SecurityPermission("setPolicy");
        PermissionManager.DEFAULT_SERVER_RESTRICTABLE_PERMISSIONS[3] = new AuthPermission("setLoginConfiguration");
        DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS = null;
        DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS = new Permission[3];
        PermissionManager.DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS[0] = new RuntimePermission("setSecurityManager");
        PermissionManager.DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS[1] = new SecurityPermission("setPolicy");
        PermissionManager.DEFAULT_CLIENT_RESTRICTABLE_PERMISSIONS[2] = new AuthPermission("setLoginConfiguration");
    }
}

