/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Service;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataApp;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataApps;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Options;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.annocache.util.internal.UtilImpl_Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_Factory;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetCacheImpl_Factory
implements TargetCache_Factory {
    private static final String CLASS_NAME = TargetCacheImpl_Factory.class.getSimpleName();
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected final AnnotationCacheServiceImpl_Service annoService;
    private final CacheLock cacheLock;
    private TargetCache_Options options;
    private TargetCacheImpl_DataApps cache;
    static final long serialVersionUID = 4125379165163541674L;

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void finer(String methodName, String text) {
        logger.logp(Level.FINER, CLASS_NAME, methodName, text);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void finer(String methodName, String text, Object parm) {
        logger.logp(Level.FINER, CLASS_NAME, methodName, text, parm);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static String getSystemProperty(String propertyName, String defaultValue) {
        return UtilImpl_Utils.getSystemProperty(logger, propertyName, defaultValue);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static boolean getSystemProperty(String propertyName, boolean defaultValue) {
        return UtilImpl_Utils.getSystemProperty(logger, propertyName, defaultValue);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static int getSystemProperty(String propertyName, int defaultValue) {
        return UtilImpl_Utils.getSystemProperty(logger, propertyName, defaultValue);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory(AnnotationCacheServiceImpl_Service annoService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "<init>", new Object[]{annoService});
        }
        this.cacheLock = new CacheLock();
        this.annoService = annoService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationCacheServiceImpl_Service getAnnotationService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "getAnnotationService", new Object[0]);
        }
        AnnotationCacheServiceImpl_Service annotationCacheServiceImpl_Service = this.annoService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationCacheServiceImpl_Service = annotationCacheServiceImpl_Service;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "getAnnotationService", annotationCacheServiceImpl_Service);
        }
        return annotationCacheServiceImpl_Service;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static TargetCacheImpl_Options createOptionsFromProperties() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createOptionsFromProperties", new Object[0]);
        }
        boolean disabled = TargetCacheImpl_Factory.getSystemProperty("anno.cache.disabled", false);
        String dir = TargetCacheImpl_Factory.getSystemProperty("anno.cache.dir", "./anno");
        boolean readOnly = TargetCacheImpl_Factory.getSystemProperty("anno.cache.readOnly", false);
        boolean alwaysValid = TargetCacheImpl_Factory.getSystemProperty("anno.cache.alwaysValid", false);
        int writeThreads = TargetCacheImpl_Factory.getSystemProperty("anno.cache.writeThreads", 1);
        int writeLimit = TargetCacheImpl_Factory.getSystemProperty("anno.cache.writeLimit", 16);
        boolean useJandexFormat = TargetCacheImpl_Factory.getSystemProperty("anno.cache.jandexFormat", false);
        boolean useBinaryFormat = TargetCacheImpl_Factory.getSystemProperty("anno.cache.binaryFormat", true);
        boolean logQueries = TargetCacheImpl_Factory.getSystemProperty("anno.cache.logQueries", false);
        TargetCacheImpl_Options targetCacheImpl_Options = new TargetCacheImpl_Options(disabled, dir, readOnly, alwaysValid, writeThreads, writeLimit, useJandexFormat, useBinaryFormat, logQueries);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_Options = targetCacheImpl_Options;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createOptionsFromProperties", targetCacheImpl_Options);
        }
        return targetCacheImpl_Options;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static TargetCacheImpl_Options createOptionsFromDefaults() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createOptionsFromDefaults", new Object[0]);
        }
        TargetCacheImpl_Options targetCacheImpl_Options = new TargetCacheImpl_Options(false, "./anno", false, false, 1, 16, false, true, false);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_Options = targetCacheImpl_Options;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createOptionsFromDefaults", targetCacheImpl_Options);
        }
        return targetCacheImpl_Options;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Options createOptions() {
        return TargetCacheImpl_Factory.createOptionsFromProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCache_Options getCacheOptions() {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            return this.options;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setOptions(TargetCache_Options options) {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            String methodName = "setOptions";
            this.cache = null;
            this.options = options;
            if (logger.isLoggable(Level.FINER)) {
                TargetCacheImpl_Factory.finer(methodName, "Annotation Cache Options:");
                TargetCacheImpl_Factory.finer(methodName, "  Enabled             [ {0} ]", !options.getDisabled());
                TargetCacheImpl_Factory.finer(methodName, "  Directory           [ {0} ]", options.getDir());
                TargetCacheImpl_Factory.finer(methodName, "  AlwaysValid         [ {0} ]", options.getAlwaysValid());
                TargetCacheImpl_Factory.finer(methodName, "  ReadOnly            [ {0} ]", options.getReadOnly());
                TargetCacheImpl_Factory.finer(methodName, "  Write Threads       [ {0} ]", options.getWriteThreads());
                TargetCacheImpl_Factory.finer(methodName, "  Write Limit         [ {0} ]", options.getWriteLimit());
                TargetCacheImpl_Factory.finer(methodName, "  Use Jandex Format   [ {0} ]", options.getUseJandexFormat());
                TargetCacheImpl_Factory.finer(methodName, "  Use Binary Format   [ {0} ]", options.getUseBinaryFormat());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void clearCache() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "clearCache", new Object[0]);
        }
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.cache = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "clearCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_DataApps getCache() {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            if (this.cache == null) {
                this.cache = this.createCache();
            }
        }
        return this.cache;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataApps createCache() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createCache", new Object[0]);
        }
        TargetCache_Options useOptions = this.getCacheOptions();
        if (useOptions == null) {
            throw new IllegalStateException("Annotation targets cache options not set");
        }
        File cacheDir = new File(useOptions.getDir());
        String cacheName = cacheDir.getName();
        String e_cacheName = TargetCacheImpl_Utils.encodePath(cacheName);
        TargetCacheImpl_DataApps targetCacheImpl_DataApps = this.createCache(cacheName, e_cacheName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_DataApps = targetCacheImpl_DataApps;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createCache", targetCacheImpl_DataApps);
        }
        return targetCacheImpl_DataApps;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataApps createCache(String cacheName, String e_cacheName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createCache", new Object[]{cacheName, e_cacheName});
        }
        TargetCacheImpl_DataApps targetCacheImpl_DataApps = new TargetCacheImpl_DataApps(this, cacheName, e_cacheName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_DataApps = targetCacheImpl_DataApps;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createCache", targetCacheImpl_DataApps);
        }
        return targetCacheImpl_DataApps;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataApp createAppData(TargetCacheImpl_DataApps appsData, String appName, String e_appName, File appDir) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createAppData", new Object[]{appsData, appName, e_appName, appDir});
        }
        TargetCacheImpl_DataApp targetCacheImpl_DataApp = new TargetCacheImpl_DataApp(appsData, appName, e_appName, appDir);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_DataApp = targetCacheImpl_DataApp;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createAppData", targetCacheImpl_DataApp);
        }
        return targetCacheImpl_DataApp;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataMod createModData(TargetCacheImpl_DataApp appData, String modName, String e_modName, File modDir, boolean isLightweight) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createModData", new Object[]{appData, modName, e_modName, modDir, isLightweight});
        }
        TargetCacheImpl_DataMod targetCacheImpl_DataMod = new TargetCacheImpl_DataMod(appData, modName, e_modName, modDir, isLightweight);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_DataMod = targetCacheImpl_DataMod;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createModData", targetCacheImpl_DataMod);
        }
        return targetCacheImpl_DataMod;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataCon createConData(TargetCacheImpl_DataBase parentCache, String conName, String e_conName, File conFile, boolean isSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createConData", new Object[]{parentCache, conName, e_conName, conFile, isSource});
        }
        TargetCacheImpl_DataCon targetCacheImpl_DataCon = new TargetCacheImpl_DataCon(parentCache, conName, e_conName, conFile, isSource);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_DataCon = targetCacheImpl_DataCon;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createConData", targetCacheImpl_DataCon);
        }
        return targetCacheImpl_DataCon;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataQueries createQueriesData(String appName, String e_appName, String modName, String e_modName, File modDir) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createQueriesData", new Object[]{appName, e_appName, modName, e_modName, modDir});
        }
        TargetCacheImpl_DataQueries targetCacheImpl_DataQueries = new TargetCacheImpl_DataQueries(this, appName, e_appName, modName, e_modName, modDir);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_DataQueries = targetCacheImpl_DataQueries;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createQueriesData", targetCacheImpl_DataQueries);
        }
        return targetCacheImpl_DataQueries;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_Reader createReader(File inputFile) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createReader", new Object[]{inputFile});
        }
        String inputPath = inputFile.getPath();
        FileInputStream inputStream = UtilImpl_FileUtils.createFileInputStream(inputFile);
        TargetCacheImpl_Reader targetCacheImpl_Reader = this.createReader(inputPath, inputStream);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_Reader = targetCacheImpl_Reader;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createReader", targetCacheImpl_Reader);
        }
        return targetCacheImpl_Reader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_Reader createReader(String path, InputStream stream) {
        TargetCacheImpl_Reader targetCacheImpl_Reader;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createReader", new Object[]{path, stream});
            }
            try {
                targetCacheImpl_Reader = new TargetCacheImpl_Reader(this, path, stream, "UTF-8");
                if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", (String)"261", (Object)this, (Object[])new Object[]{path, stream});
                TargetCacheImpl_Reader targetCacheImpl_Reader2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    targetCacheImpl_Reader2 = targetCacheImpl_Reader2;
                    logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createReader", targetCacheImpl_Reader2);
                }
                return targetCacheImpl_Reader2;
            }
            targetCacheImpl_Reader = targetCacheImpl_Reader;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createReader", targetCacheImpl_Reader);
        }
        return targetCacheImpl_Reader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_Writer createWriter(String path, OutputStream stream) {
        TargetCacheImpl_Writer targetCacheImpl_Writer;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createWriter", new Object[]{path, stream});
            }
            try {
                targetCacheImpl_Writer = new TargetCacheImpl_Writer(this, path, stream, "UTF-8");
                if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", (String)"272", (Object)this, (Object[])new Object[]{path, stream});
                TargetCacheImpl_Writer targetCacheImpl_Writer2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    targetCacheImpl_Writer2 = targetCacheImpl_Writer2;
                    logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createWriter", targetCacheImpl_Writer2);
                }
                return targetCacheImpl_Writer2;
            }
            targetCacheImpl_Writer = targetCacheImpl_Writer;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createWriter", targetCacheImpl_Writer);
        }
        return targetCacheImpl_Writer;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_ReaderBinary createBinaryReader(String path, boolean readStrings, boolean readFull) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createBinaryReader", new Object[]{path, readStrings, readFull});
        }
        TargetCacheImpl_ReaderBinary targetCacheImpl_ReaderBinary = new TargetCacheImpl_ReaderBinary(this, path, "UTF-8", readStrings, readFull);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_ReaderBinary = targetCacheImpl_ReaderBinary;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createBinaryReader", targetCacheImpl_ReaderBinary);
        }
        return targetCacheImpl_ReaderBinary;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_WriterBinary createBinaryWriter(String path, OutputStream stream) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createBinaryWriter", new Object[]{path, stream});
        }
        TargetCacheImpl_WriterBinary targetCacheImpl_WriterBinary = new TargetCacheImpl_WriterBinary(this, path, stream, "UTF-8");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_WriterBinary = targetCacheImpl_WriterBinary;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory", "createBinaryWriter", targetCacheImpl_WriterBinary);
        }
        return targetCacheImpl_WriterBinary;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<TargetCache_ParseError> read(TargetsTableContainersImpl containerTable, String path, InputStream stream) throws IOException {
        return this.createReader(path, stream).read(containerTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<TargetCache_ParseError> read(TargetsTableTimeStampImpl stampTable, String path, InputStream stream) throws IOException {
        return this.createReader(path, stream).read(stampTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<TargetCache_ParseError> read(TargetsTableClassesImpl classTable, String path, InputStream stream) throws IOException {
        return this.createReader(path, stream).read(classTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<TargetCache_ParseError> read(TargetsTableAnnotationsImpl targetTable, String path, InputStream stream) throws IOException {
        return this.createReader(path, stream).read(targetTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<TargetCache_ParseError> read(TargetsTableDetailsImpl detailTable, String path, InputStream stream) throws IOException {
        return this.createReader(path, stream).read(detailTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void write(TargetsTableContainersImpl containerTable, String path, OutputStream stream) throws IOException {
        this.createWriter(path, stream).write(containerTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void write(TargetsTableTimeStampImpl stampTable, String path, OutputStream stream) throws IOException {
        this.createWriter(path, stream).write(stampTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void write(TargetsTableClassesImpl classTable, String path, OutputStream stream) throws IOException {
        this.createWriter(path, stream).write(classTable);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void write(TargetsTableAnnotationsImpl targetTable, String path, OutputStream stream) throws IOException {
        this.createWriter(path, stream).write(targetTable);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CacheLock {
        static final long serialVersionUID = 6021328190923696080L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CacheLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory$CacheLock", CacheLock.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }
}

