/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AddressUtils {
    private static final LogMgr s_logger = Log.get(AddressUtils.class);
    private static final ThreadLocal<byte[]> s_ipv4workBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4];
        }
    };
    private static final ThreadLocal<byte[]> s_ipv6workBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[16];
        }
    };
    private static final ThreadLocal<byte[]> s_inet4addressNumericValue = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4];
        }
    };
    private static final ThreadLocal<StringBuilder> s_stringBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            int maxSize = "0000:0000:0000:0000:0000:0000:0000:0000".length();
            return new StringBuilder(maxSize);
        }
    };
    private static final byte[] s_zeroAddress = new byte[]{0, 0, 0, 0};

    public static boolean equals(String address1, String address2) {
        boolean _1_isValid;
        boolean address2isIPv6;
        if (address1.equalsIgnoreCase(address2)) {
            return true;
        }
        boolean address1isIPv6 = address1.indexOf(58) != -1;
        boolean bl = address2isIPv6 = address2.indexOf(58) != -1;
        if (!address1isIPv6 && !address2isIPv6) {
            return false;
        }
        byte[] workBuffer = address1isIPv6 ? s_ipv6workBuffer.get() : s_ipv4workBuffer.get();
        boolean bl2 = _1_isValid = address1isIPv6 ? AddressUtils.convertIPv6(address1, workBuffer) : AddressUtils.convertIPv4(address1, workBuffer);
        if (!_1_isValid) {
            return false;
        }
        return AddressUtils.compareIP(address2, workBuffer);
    }

    public static boolean compare(byte[] address1, byte[] address2) {
        if (address1.length < address2.length) {
            byte[] tempAddress = address1;
            address1 = address2;
            address2 = tempAddress;
        }
        int i1 = address1.length;
        int i2 = address2.length;
        while (i1 > 0) {
            byte b1;
            byte b2 = i2 > 0 ? address2[--i2] : (byte)0;
            if ((b1 = address1[--i1]) == b2) continue;
            return false;
        }
        return true;
    }

    public static boolean isZeroAddress(CharSequence address) {
        return AddressUtils.compareIP(address, s_zeroAddress);
    }

    public static boolean isIpAddress(CharSequence address) {
        return AddressUtils.isIPv4address(address) || AddressUtils.isIPv6address(address);
    }

    public static boolean compareIP(CharSequence address, byte[] bytes) {
        switch (bytes.length) {
            case 4: {
                return AddressUtils.ipv4(address, bytes, true) || AddressUtils.ipv6(address, bytes, true);
            }
            case 16: {
                return AddressUtils.ipv6(address, bytes, true) || AddressUtils.ipv4(address, bytes, true);
            }
        }
        return false;
    }

    public static byte[] convertIP(String address) {
        boolean addressIsIPv6 = address.indexOf(58) != -1;
        byte[] workBuffer = addressIsIPv6 ? s_ipv6workBuffer.get() : s_ipv4workBuffer.get();
        boolean result = addressIsIPv6 ? AddressUtils.convertIPv6(address, workBuffer) : AddressUtils.convertIPv4(address, workBuffer);
        return (byte[])(result ? workBuffer : null);
    }

    public static boolean convertIP(CharSequence address, byte[] bytes) {
        return AddressUtils.convertIPv4(address, bytes) || AddressUtils.convertIPv6(address, bytes);
    }

    public static boolean isIPv4address(CharSequence address) {
        return AddressUtils.ipv4(address, null, false);
    }

    public static boolean compareIPv4(CharSequence address, byte[] bytes) {
        if (bytes.length != 4 && bytes.length != 16) {
            return false;
        }
        return AddressUtils.ipv4(address, bytes, true);
    }

    public static boolean convertIPv4(CharSequence address, byte[] bytes) {
        if (bytes.length != 4 && bytes.length != 16) {
            return false;
        }
        return AddressUtils.ipv4(address, bytes, false);
    }

    private static boolean ipv4(CharSequence address, byte[] bytes, boolean compare) {
        int i;
        int offset;
        boolean start = false;
        int len = address.length();
        int octet = 0;
        int nOctets = 0;
        int n = offset = bytes != null && bytes.length == 4 ? 0 : 12;
        if (bytes != null && bytes.length == 16 && compare) {
            for (i = 0; i < 12; ++i) {
                if (bytes[i] == 0) continue;
                return false;
            }
        }
        block5: for (i = 0; i <= len; ++i) {
            int c = i < len ? (int)address.charAt(i) : 46;
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int digit = c - 48;
                    octet = 10 * octet + digit;
                    if (octet <= 255) continue block5;
                    return false;
                }
                case 46: {
                    if (nOctets > 3) {
                        return false;
                    }
                    if (i == len - 1) {
                        return false;
                    }
                    if (compare) {
                        if (bytes[offset + nOctets] != (byte)octet) {
                            return false;
                        }
                    } else if (bytes != null) {
                        bytes[offset + nOctets] = (byte)octet;
                    }
                    ++nOctets;
                    octet = 0;
                    continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (nOctets != 4) {
            return false;
        }
        if (bytes != null && bytes.length == 16 && !compare) {
            for (i = 0; i < 12; ++i) {
                bytes[i] = 0;
            }
        }
        return true;
    }

    public static boolean isIPv6address(CharSequence address) {
        return AddressUtils.ipv6(address, null, false);
    }

    public static boolean compareIPv6(CharSequence address, byte[] bytes) {
        if (bytes.length != 4 && bytes.length != 16) {
            return false;
        }
        return AddressUtils.ipv6(address, bytes, true);
    }

    public static boolean convertIPv6(CharSequence address, byte[] bytes) {
        if (bytes.length != 4 && bytes.length != 16) {
            return false;
        }
        return AddressUtils.ipv6(address, bytes, false);
    }

    private static boolean ipv6(CharSequence address, byte[] bytes, boolean compare) {
        boolean mixed;
        int start = 0;
        int end = address.length();
        boolean openBracket = false;
        boolean closeBracket = false;
        int compression = -1;
        int nDots = 0;
        int nHex = 0;
        int lastColon = -1;
        boolean component = false;
        block17: for (int i = start; i < end; ++i) {
            char c = address.charAt(i);
            switch (c) {
                case '[': {
                    if (i != start) {
                        return false;
                    }
                    if (openBracket) {
                        return false;
                    }
                    openBracket = true;
                    continue block17;
                }
                case ']': {
                    if (closeBracket) {
                        return false;
                    }
                    if (!openBracket) {
                        return false;
                    }
                    if (i < end - 1) {
                        return false;
                    }
                    closeBracket = true;
                    continue block17;
                }
                case ':': {
                    if (nDots > 0) {
                        return false;
                    }
                    if (i < end - 1 && address.charAt(i + 1) == ':') {
                        if (compression != -1) {
                            return false;
                        }
                        compression = i;
                    }
                    if (component) {
                        component = false;
                        if (++nHex > 8) {
                            return false;
                        }
                    }
                    lastColon = i;
                    continue block17;
                }
                case '.': {
                    ++nDots;
                    continue block17;
                }
                default: {
                    component = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
                }
            }
        }
        if (openBracket && !closeBracket) {
            return false;
        }
        if (openBracket) {
            ++start;
            --end;
        }
        if (end < 2) {
            return false;
        }
        switch (nDots) {
            case 0: {
                mixed = false;
                break;
            }
            case 3: {
                mixed = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (component && !mixed) {
            ++nHex;
        }
        if (compression == -1 ? (mixed ? nHex != 6 : nHex != 8) : (mixed ? nHex > 5 : nHex > 7)) {
            return false;
        }
        boolean v4 = false;
        int digit = 0;
        int dec = 0;
        int hex = 0;
        int iBytes = 0;
        block18: for (int i = start; i <= end; ++i) {
            int c = i < end ? address.charAt(i) : (v4 ? 46 : 58);
            switch (c) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    c = (char)(c + 32);
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    if (v4) {
                        return false;
                    }
                    digit = 10 + c - 97;
                    if ((hex = 16 * hex + digit) <= 65535) continue block18;
                    return false;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    digit = c - 48;
                    if (!(v4 ? (dec = 10 * dec + digit) > 255 : (hex = 16 * hex + digit) > 65535)) continue block18;
                    return false;
                }
                case 58: {
                    if (i <= start) continue block18;
                    if (address.charAt(i - 1) == ':') {
                        if (bytes != null) {
                            for (int zeros = 16 - 2 * nHex - (mixed ? 4 : 0); zeros > 0; --zeros) {
                                if (!(compare ? AddressUtils.byteAt(bytes, iBytes++) != 0 : !AddressUtils.setByte(bytes, iBytes++, (byte)0))) continue;
                                return false;
                            }
                            if (iBytes == 16) {
                                return true;
                            }
                        }
                    } else {
                        if (bytes != null) {
                            byte b1 = (byte)((hex & 0xFF00) >> 8);
                            byte b2 = (byte)(hex & 0xFF);
                            if (compare) {
                                if (AddressUtils.byteAt(bytes, iBytes++) != b1 || AddressUtils.byteAt(bytes, iBytes++) != b2) {
                                    return false;
                                }
                            } else {
                                if (!AddressUtils.setByte(bytes, iBytes++, b1)) {
                                    return false;
                                }
                                if (!AddressUtils.setByte(bytes, iBytes++, b2)) {
                                    return false;
                                }
                            }
                        }
                        hex = 0;
                    }
                    if (!mixed || i != lastColon) continue block18;
                    v4 = true;
                    continue block18;
                }
                case 46: {
                    if (bytes != null && (compare ? AddressUtils.byteAt(bytes, iBytes++) != (byte)dec : !AddressUtils.setByte(bytes, iBytes++, (byte)dec))) {
                        return false;
                    }
                    dec = 0;
                    continue block18;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static byte byteAt(byte[] array, int index) {
        if (array.length == 16) {
            return array[index];
        }
        if ((index -= 12) < 0) {
            return 0;
        }
        return array[index];
    }

    private static boolean setByte(byte[] array, int index, byte b) {
        if (array.length == 16) {
            array[index] = b;
        } else {
            if ((index -= 12) < 0) {
                return b == 0;
            }
            array[index] = b;
        }
        return true;
    }

    public static String getLocalAddress() {
        InetAddress localHost;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e2) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(AddressUtils.class.getName(), "getLocalAddress", "error determining local address", e2);
            }
            return "127.0.0.1";
        }
        String localAddress = InetAddressCache.getHostAddress(localHost);
        return localAddress;
    }

    public static byte[] numericValue(InetAddress address) {
        byte[] bytes;
        if (address instanceof Inet4Address) {
            int addressValue = address.hashCode();
            bytes = s_inet4addressNumericValue.get();
            bytes[0] = (byte)((addressValue & 0xFF000000) >> 24);
            bytes[1] = (byte)((addressValue & 0xFF0000) >> 16);
            bytes[2] = (byte)((addressValue & 0xFF00) >> 8);
            bytes[3] = (byte)(addressValue & 0xFF);
        } else {
            bytes = address.getAddress();
        }
        return bytes;
    }

    public static String convertIP(byte[] ip, int offset, int length) {
        StringBuilder b = s_stringBuilder.get();
        b.setLength(0);
        if (!AddressUtils.convertIP(ip, offset, length, b)) {
            return null;
        }
        return b.toString();
    }

    public static boolean convertIP(byte[] ip, int offset, int length, Appendable appendable) {
        try {
            if (length == 16) {
                char c1 = AddressUtils.hex((ip[offset + 0] & 0xF0) >> 4);
                char c2 = AddressUtils.hex(ip[offset + 0] & 0xF);
                char c3 = AddressUtils.hex((ip[offset + 1] & 0xF0) >> 4);
                char c4 = AddressUtils.hex(ip[offset + 1] & 0xF);
                char c5 = AddressUtils.hex((ip[offset + 2] & 0xF0) >> 4);
                char c6 = AddressUtils.hex(ip[offset + 2] & 0xF);
                char c7 = AddressUtils.hex((ip[offset + 3] & 0xF0) >> 4);
                char c8 = AddressUtils.hex(ip[offset + 3] & 0xF);
                char c9 = AddressUtils.hex((ip[offset + 4] & 0xF0) >> 4);
                char c10 = AddressUtils.hex(ip[offset + 4] & 0xF);
                char c11 = AddressUtils.hex((ip[offset + 5] & 0xF0) >> 4);
                char c12 = AddressUtils.hex(ip[offset + 5] & 0xF);
                char c13 = AddressUtils.hex((ip[offset + 6] & 0xF0) >> 4);
                char c14 = AddressUtils.hex(ip[offset + 6] & 0xF);
                char c15 = AddressUtils.hex((ip[offset + 7] & 0xF0) >> 4);
                char c16 = AddressUtils.hex(ip[offset + 7] & 0xF);
                char c17 = AddressUtils.hex((ip[offset + 8] & 0xF0) >> 4);
                char c18 = AddressUtils.hex(ip[offset + 8] & 0xF);
                char c19 = AddressUtils.hex((ip[offset + 9] & 0xF0) >> 4);
                char c20 = AddressUtils.hex(ip[offset + 9] & 0xF);
                char c21 = AddressUtils.hex((ip[offset + 10] & 0xF0) >> 4);
                char c22 = AddressUtils.hex(ip[offset + 10] & 0xF);
                char c23 = AddressUtils.hex((ip[offset + 11] & 0xF0) >> 4);
                char c24 = AddressUtils.hex(ip[offset + 11] & 0xF);
                char c25 = AddressUtils.hex((ip[offset + 12] & 0xF0) >> 4);
                char c26 = AddressUtils.hex(ip[offset + 12] & 0xF);
                char c27 = AddressUtils.hex((ip[offset + 13] & 0xF0) >> 4);
                char c28 = AddressUtils.hex(ip[offset + 13] & 0xF);
                char c29 = AddressUtils.hex((ip[offset + 14] & 0xF0) >> 4);
                char c30 = AddressUtils.hex(ip[offset + 14] & 0xF);
                char c31 = AddressUtils.hex((ip[offset + 15] & 0xF0) >> 4);
                char c32 = AddressUtils.hex(ip[offset + 15] & 0xF);
                appendable.append('[');
                appendable.append(c1).append(c2).append(c3).append(c4);
                appendable.append(':');
                appendable.append(c5).append(c6).append(c7).append(c8);
                appendable.append(':');
                appendable.append(c9).append(c10).append(c11).append(c12);
                appendable.append(':');
                appendable.append(c13).append(c14).append(c15).append(c16);
                appendable.append(':');
                appendable.append(c17).append(c18).append(c19).append(c20);
                appendable.append(':');
                appendable.append(c21).append(c22).append(c23).append(c24);
                appendable.append(':');
                appendable.append(c25).append(c26).append(c27).append(c28);
                appendable.append(':');
                appendable.append(c29).append(c30).append(c31).append(c32);
                appendable.append(']');
                return true;
            }
            if (length == 4) {
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        appendable.append('.');
                    }
                    int octet = ip[offset + i] & 0xFF;
                    int d1 = octet % 10;
                    int d2 = (octet /= 10) % 10;
                    int d3 = (octet /= 10) % 10;
                    if (d3 != 0) {
                        appendable.append((char)(48 + d3));
                    }
                    if (d3 != 0 || d2 != 0) {
                        appendable.append((char)(48 + d2));
                    }
                    appendable.append((char)(48 + d1));
                }
                return true;
            }
            return false;
        }
        catch (IOException e2) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(AddressUtils.class.getName(), "appendIP", "", e2);
            }
            return false;
        }
    }

    private static char hex(int n) {
        return n < 10 ? (char)(48 + n) : (char)(55 + n);
    }
}

