/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.udp;

import com.ibm.ws.sip.parser.DatagramMessageParser;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionAdapter;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.udp.SIPListenningConnectionImpl;
import java.io.IOException;
import java.util.Objects;

public class SIPConnectionImpl
extends SIPConnectionAdapter {
    private SIPListenningConnectionImpl m_listenningConnection;
    private boolean m_connected;
    private boolean m_OpenForRead;

    SIPConnectionImpl(SIPListenningConnectionImpl listenningConnection, String peerHost, int peerPort) {
        super(peerHost, peerPort);
        this.m_listenningConnection = listenningConnection;
        this.m_connected = false;
    }

    @Override
    public void start() {
        this.m_OpenForRead = true;
    }

    @Override
    public synchronized void connect() throws IOException {
    }

    @Override
    public boolean isReliable() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.m_connected;
    }

    public void setConnected() {
        this.m_connected = true;
    }

    @Override
    public MessageParser getMessageParser() {
        return DatagramMessageParser.getGlobalInstance();
    }

    @Override
    public synchronized void close() {
        super.close();
    }

    @Override
    public String getTransport() {
        return "udp";
    }

    @Override
    public SIPListenningConnection getSIPListenningConnection() {
        return this.m_listenningConnection;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SIPConnectionImpl) {
            return ((SIPConnectionImpl)obj).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    @Override
    public void write(MessageContext messageContext, boolean considerMtu, UseCompactHeaders useCompactHeaders) throws IOException {
        this.prepareBuffer(messageContext, considerMtu, useCompactHeaders);
        this.write(messageContext);
    }

    private void write(MessageContext messageContext) throws IOException {
        this.m_listenningConnection.write(messageContext, this.getRemoteHost(), this.getRemotePort());
    }

    @Override
    public int getPathMTU() {
        return SIPListenningConnectionImpl.getPathMTU();
    }
}

