/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.ResponseImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.SipResponseCodes;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.common.BadRequestException;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTranaction;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransaction;
import com.ibm.ws.sip.stack.transaction.transport.FlowFailedException;
import com.ibm.ws.sip.stack.transaction.transport.FlowTamperedException;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.LoopBackMessage;
import com.ibm.ws.sip.stack.transaction.transport.PathMtuExceeded;
import com.ibm.ws.sip.stack.transaction.transport.SIPConnectionsModel;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.transport.connections.udp.SIPListenningConnectionImpl;
import com.ibm.ws.sip.stack.transaction.transport.routers.SLSPRouter;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import com.ibm.ws.sip.stack.util.ThreadLocalStorage;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipEvent;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.RetryAfterHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.MessageFactory;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TransportCommLayerMgr {
    private static final LogMgr c_logger = Log.get(TransportCommLayerMgr.class);
    private SIPConnectionsModel m_connectionsModel = SIPConnectionsModel.instance();
    private boolean m_startupReceived = false;
    private SLSPRouter m_router;
    private LoopBackAddressThread m_loopBackAddressQ;
    private static final String IBM_MTU_PARAM = "ibmmtu";
    private static final String IBM_PO_HEADER = "IBM-PO";
    private static final String IBM_SID_PARAM = "ibmsid";
    public static final char SESSION_ID_SEPARATOR = '_';
    private static TransportCommLayerMgr s_instance = new TransportCommLayerMgr();

    public static TransportCommLayerMgr instance() {
        return s_instance;
    }

    private TransportCommLayerMgr() {
        this.initRouter();
        this.m_loopBackAddressQ = new LoopBackAddressThread();
        Thread loopback = new Thread((Runnable)this.m_loopBackAddressQ, "SIP Stack LoopBack Address Thread");
        loopback.start();
    }

    private void initRouter() {
        block3: {
            this.m_router = SLSPRouter.getInstance();
            String outproxy = ApplicationProperties.getProperties().getString("javax.sip.OUTBOUND_PROXY");
            try {
                if (!outproxy.equals("") && outproxy.trim().length() > 0) {
                    SipURL proxy = SIPStackUtil.parseNameAdressFromConfig(outproxy);
                    Hop proxyHop = Hop.getHop(proxy);
                    this.m_router.setOutboundProxy(proxyHop);
                }
            }
            catch (SipParseException exp) {
                if (!c_logger.isTraceDebugEnabled()) break block3;
                c_logger.traceDebug(this, "TransportCommLayerMgr", "could not parse outbound proxy:" + outproxy + " set to null");
            }
        }
    }

    public void sendMessage(MessageContext sipMsgContext, SipProvider provider, SIPConnection sipConnection) throws SIPTransportException {
        this.sendMessage(sipMsgContext, provider, sipConnection, null);
    }

    public void sendMessage(MessageContext messageContext, SipProvider provider, SIPConnection connection, SIPTransaction transaction) throws SIPTransportException {
        MessageImpl msg = (MessageImpl)messageContext.getSipMessage();
        try {
            boolean considerMtu;
            String msgString;
            boolean connectionAlreadyClosed;
            if (msg.isLoopback()) {
                LoopBackMessage loopBackMessage = new LoopBackMessage(msg, provider, connection);
                this.m_loopBackAddressQ.add(loopBackMessage);
                MessageContext.doneWithContext(messageContext);
                return;
            }
            boolean connectionNotExists = connection == null;
            boolean bl = connectionAlreadyClosed = connectionNotExists ? false : connection.isClosed();
            if (connectionNotExists || !connection.isReliable() || connectionAlreadyClosed) {
                try {
                    connection = this.getConnection(messageContext.getSipMessage(), transaction, provider);
                    if (!connectionNotExists && connectionAlreadyClosed) {
                        transaction.setTransportConnection(connection);
                    }
                }
                catch (FlowFailedException e2) {
                    this.handleFlowFailed((Request)((Object)msg), provider, transaction);
                    return;
                }
                catch (FlowTamperedException e3) {
                    this.handleFlowTampered((Request)((Object)msg), provider, transaction);
                    return;
                }
            }
            if (connection == null) {
                SIPTransportException ex = new SIPTransportException("No connection for sending the message");
                throw ex;
            }
            if (c_logger.isTraceDebugEnabled()) {
                msgString = messageContext.getSipMessage().toString();
                c_logger.traceDebug(this, "TransportCommLayerMgr", "\r\nOut Message:\r\n" + msgString);
            }
            if (SIPTransactionStack.instance().getConfiguration().isTraceOutMsg()) {
                msgString = messageContext.getSipMessage().toString();
                System.out.println("Out Message:\r\n" + msgString);
            }
            String useCompactHeadersStrValue = ApplicationProperties.getProperties().getString("compactHeaders");
            UseCompactHeaders useCompactHeaders = UseCompactHeaders.fromString(useCompactHeadersStrValue);
            boolean bl2 = considerMtu = messageContext.getSipMessage().isRequest() && !connection.isReliable() && !messageContext.transportSwitched();
            if (this.m_router.isStandAloneMode()) {
                messageContext.getSipMessage().removeHeader("IBM-Destination", true);
            }
            try {
                messageContext.setSipConnection(connection);
                connection.write(messageContext, considerMtu, useCompactHeaders);
            }
            catch (PathMtuExceeded pathMtuExceeded) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "sendMessage", "request is too large for MTU of size [" + SIPListenningConnectionImpl.getPathMTU() + ']');
                }
                connection = this.handlePathMtuExceeded(messageContext, connection, provider);
                try {
                    connection.write(messageContext, false, useCompactHeaders);
                }
                catch (IOException e4) {
                    messageContext.writeError(e4);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "sendMessage", "failed sending out large request", e4);
                    }
                }
            }
            catch (IOException e5) {
                throw new SIPTransportException(e5.getMessage());
            }
        }
        catch (SipException e6) {
            throw new SIPTransportException(e6.getMessage());
        }
    }

    private SIPConnection getConnection(Message message, SIPTransaction transaction, SipProvider provider) throws SipException {
        SIPConnection connection;
        try {
            if (message.isRequest()) {
                Request request = (Request)message;
                SIPClientTranaction clientTransaction = (SIPClientTranaction)transaction;
                connection = this.getRequestConnection(request, clientTransaction, provider);
            } else {
                Response response = (Response)message;
                SIPServerTransaction serverTransaction = (SIPServerTransaction)transaction;
                connection = this.getResponseConnection(response, serverTransaction, provider);
            }
        }
        catch (IOException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer str = new StringBuffer("could not create connection. ");
                str.append(" reason [");
                str.append(e2.getMessage());
                str.append("]\nMessage:");
                str.append(message);
                c_logger.traceDebug(this, "sendMessage", str.toString(), e2);
            }
            connection = null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIPConnection getRequestConnection(Request request, SIPClientTranaction transaction, SipProvider provider) throws SipException, IOException {
        Hop nextHop;
        Object destinationSipURL;
        boolean outboundExtension;
        this.validateOutgoingRequest(request);
        NameAddressHeader destination = (NameAddressHeader)request.getHeader("IBM-Destination", true);
        if (destination == null) {
            outboundExtension = false;
        } else {
            URI destinationURI = destination.getNameAddress().getAddress();
            destinationSipURL = (SipURL)destinationURI;
            outboundExtension = destinationSipURL.hasParameter("ibm-ob");
            if (outboundExtension && destinationSipURL.hasParameter("ibm-tampered")) {
                FlowTamperedException.throwIt();
            }
        }
        destinationSipURL = this;
        synchronized (destinationSipURL) {
            Hop originalHop = transaction == null ? null : transaction.getHop();
            nextHop = this.m_router.getNextHop(request, originalHop);
            if (transaction != null && originalHop == null) {
                transaction.setHop(nextHop);
            }
        }
        String transport = nextHop.getTrasport();
        boolean create = !outboundExtension || transport.equalsIgnoreCase("udp");
        ListeningPoint listeningPoint = this.getRequestListeningPoint(request, provider, nextHop, outboundExtension);
        SIPConnection connection = this.getHopConnection(nextHop, request, provider, listeningPoint, create);
        if (connection == null) {
            if (outboundExtension) {
                if (c_logger.isTraceFailureEnabled()) {
                    c_logger.traceFailure(this, "getRequestConnection", "no connection for outbound extension request");
                }
                FlowFailedException.throwIt();
            }
        } else {
            ListeningPoint lp = connection.getSIPListenningConnection().getListeningPoint();
            ViaHeader topVia = (ViaHeader)request.getHeader("Via", true);
            if (!TransportCommLayerMgr.equals(topVia, lp)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getRequestConnection", "changing Via from [" + topVia + "] to [" + lp + ']');
                }
                TransportCommLayerMgr.modifyVia(topVia, lp);
            }
        }
        return connection;
    }

    private ListeningPoint getRequestListeningPoint(Request request, SipProvider provider, Hop nextHop, boolean outboundExtension) throws FlowFailedException, HeaderParseException {
        ListeningPoint listeningPoint;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRequestListeningPoint", " provider = " + provider + " outboundExtension = " + outboundExtension);
        }
        if (this.isStandAloneMode()) {
            Header ibmPO = request.getHeader(IBM_PO_HEADER, true);
            if (ibmPO == null) {
                if (SIPTransactionStack.instance().getConfiguration().getSentByHost() != null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getRequestListeningPoint", "no ibmPO but using getSentByHost, return null ");
                    }
                    return null;
                }
                listeningPoint = null;
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getRequestListeningPoint", "ibmPO = " + ibmPO + " provider = " + provider + " request = " + request);
                }
                request.removeHeader(IBM_PO_HEADER, true);
                String po = ibmPO.getValue();
                String transport = nextHop.getTrasport();
                try {
                    int index = Integer.parseInt(po);
                    listeningPoint = this.m_connectionsModel.getListeningPoint(index, transport);
                }
                catch (NumberFormatException e2) {
                    if (c_logger.isTraceFailureEnabled()) {
                        c_logger.traceFailure(this, "getRequestListeningPoint", "", e2);
                    }
                    listeningPoint = null;
                }
            }
            if (outboundExtension && listeningPoint == null) {
                if (c_logger.isTraceFailureEnabled()) {
                    c_logger.traceFailure(this, "getRequestListeningPoint", "no listening point for outbound extension request");
                }
                FlowFailedException.throwIt();
            }
        } else {
            listeningPoint = null;
        }
        if (listeningPoint == null && provider != null && SIPTransactionStack.instance().getConfiguration().strictOutboundLocalPort()) {
            listeningPoint = provider.getListeningPoint();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRequestListeningPoint", "return listeningPoint = " + listeningPoint);
        }
        return listeningPoint;
    }

    private static boolean equals(ViaHeader via, ListeningPoint lp) {
        String lpTransport;
        String viaTransport = via.getTransport();
        if (!viaTransport.equalsIgnoreCase(lpTransport = lp.getTransport())) {
            return false;
        }
        String lpHost = lp.getSentBy();
        String viaHost = via.getHost();
        if (!viaHost.equalsIgnoreCase(lpHost)) {
            return false;
        }
        int lpPort = lp.getPort();
        int viaPort = via.getPort();
        if (viaPort == -1) {
            int n = viaPort = viaTransport.equalsIgnoreCase("tls") ? 5061 : 5060;
        }
        return viaPort == lpPort;
    }

    private static void modifyVia(ViaHeader via, ListeningPoint lp) throws SipParseException {
        String lpTransport;
        String viaTransport = via.getTransport();
        if (!viaTransport.equalsIgnoreCase(lpTransport = lp.getTransport())) {
            via.setTransport(lpTransport.toUpperCase());
        }
        String lpHost = lp.getSentBy();
        String viaHost = via.getHost();
        if (!viaHost.equalsIgnoreCase(lpHost)) {
            via.setHost(lpHost);
        }
        int lpPort = lp.getPort();
        int viaPort = via.getPort();
        if (viaPort == -1) {
            int n = viaPort = viaTransport.equalsIgnoreCase("tls") ? 5061 : 5060;
        }
        if (viaPort != lpPort) {
            via.setPort(lpPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIPConnection getResponseConnection(Response response, SIPServerTransaction transaction, SipProvider provider) throws SipException, IOException {
        SIPConnection connection;
        SIPConnectionsModel sIPConnectionsModel = this.m_connectionsModel;
        synchronized (sIPConnectionsModel) {
            ViaHeader topVia;
            int rport;
            String transport;
            Hop nextHop = this.m_router.getNextHop(response);
            if (nextHop == null) {
                return null;
            }
            ListeningPoint listeningPoint = provider == null || !SIPTransactionStack.instance().getConfiguration().strictOutboundLocalPort() ? null : provider.getListeningPoint();
            connection = this.m_connectionsModel.getConnection(listeningPoint, nextHop);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getResponseConnection", "listeningPoint [" + listeningPoint + "] connection [" + connection + "] nexthop [" + nextHop + ']');
            }
            if (connection == null && !(transport = nextHop.getTrasport()).equals("UDP") && (rport = (topVia = (ViaHeader)response.getHeader("Via", true)).getRPort()) != -1 && nextHop.getPort() == rport) {
                int port = topVia.getPort();
                if (port == -1) {
                    port = transport.equals("TLS") ? 5061 : 5060;
                }
                nextHop.setPort(port);
                connection = this.m_connectionsModel.getConnection(listeningPoint, nextHop);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getResponseConnection", "connection lookup after replacing the port of the next hop, listeningPoint [" + listeningPoint + "] connection [" + connection + "] nexthop [" + nextHop + ']');
                }
            }
            if (connection == null) {
                SIPConnection originalConn;
                ListeningPoint lp = null;
                if (transaction != null && (originalConn = transaction.getTransportConnection()) != null) {
                    lp = originalConn.getSIPListenningConnection().getListeningPoint();
                }
                if (lp == null && (lp = this.getDefaultListenningPoint(response)) == null) {
                    return null;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getResponseConnection", "Try to get connection for, listening point: " + lp + " ,nexthop: " + nextHop);
                }
                if ((connection = this.m_connectionsModel.getConnection(lp, nextHop)) == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getResponseConnection", "Create new connection for, listening point: " + lp + " ,nexthop: " + nextHop);
                    }
                    connection = this.createConnection(nextHop, lp);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getResponseConnection", "new connection was created,  listeningPoint [" + listeningPoint + "] nexthop [" + nextHop + "] connection [" + connection + ']');
                    }
                }
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIPConnection getHopConnection(Hop hop, Request request, SipProvider provider, ListeningPoint listeningPoint, boolean create) throws IOException {
        SIPConnection connection;
        if (hop == null) {
            throw new IOException("No hop for sending request");
        }
        try {
            SIPConnectionsModel sIPConnectionsModel = this.m_connectionsModel;
            synchronized (sIPConnectionsModel) {
                connection = this.m_connectionsModel.getConnection(listeningPoint, hop);
                if (create && connection == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getHopConnection", "creating connection to [" + hop + ']');
                    }
                    if (ApplicationProperties.getProperties().getBoolean("use.listening.point.from.outbound")) {
                        if (listeningPoint == null) {
                            listeningPoint = provider.getListeningPoint();
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug(this, "getHopConnection", "replace NULL LP with LP from Provider  " + provider);
                            }
                        }
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "getHopConnection", "creating connection from  [" + listeningPoint + ']' + " to [" + hop + ']');
                        }
                        connection = this.createConnection(hop, listeningPoint);
                    } else {
                        ListeningPoint lp = provider.getListeningPoint();
                        connection = this.createConnection(hop, lp);
                    }
                }
            }
        }
        catch (IOException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getHopConnection", "cannot create connection to [" + hop + ']', e2);
            }
            connection = null;
        }
        if (create && connection == null) {
            throw new IOException("could not connect to [" + hop + ']');
        }
        return connection;
    }

    public SIPConnection createConnection(Hop nextHop, ListeningPoint lp) throws IOException {
        String host = nextHop.getHost();
        int port = nextHop.getPort();
        if (port < 0 || port > 65535) {
            throw new IOException("port out of range: " + port);
        }
        SIPConnection connection = this.m_connectionsModel.createConnection(lp, host, port);
        connection.setOutbound(true);
        String transport = lp.getTransport();
        Hop key = nextHop.getTrasport().equalsIgnoreCase(transport) ? nextHop : new Hop(transport, nextHop.getHost(), nextHop.getPort());
        connection.setKey(key);
        if (connection.isReliable()) {
            this.m_connectionsModel.addConnection(connection);
        }
        try {
            connection.connect();
        }
        catch (IOException e2) {
            if (connection.isReliable()) {
                this.m_connectionsModel.removeConnection(connection);
            }
            throw e2;
        }
        connection.start();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createConnection", "from [" + lp + "] to [" + nextHop.toString() + ']');
        }
        return connection;
    }

    private SIPConnection handlePathMtuExceeded(MessageContext messageContext, SIPConnection connection, SipProvider udpProvider) throws SipParseException {
        String newTransport;
        Message message = messageContext.getSipMessage();
        Hop nextHop = connection.getKey();
        if (nextHop.getTrasport().equals("UDP")) {
            nextHop = this.m_router.switchTransport(nextHop);
        }
        if (!(newTransport = nextHop.getTrasport()).equals("UDP")) {
            NameAddressHeader destination;
            ViaHeader topVia;
            boolean standalone = this.isStandAloneMode();
            if (standalone) {
                message = (Message)message.clone();
                messageContext.setSipMessage(message);
            }
            if ((topVia = (ViaHeader)message.getHeader("Via", true)).getTransport().equalsIgnoreCase("UDP")) {
                topVia.setTransport(newTransport);
            }
            if ((destination = (NameAddressHeader)message.getHeader("IBM-Destination", true)) != null) {
                URI detinationUri = destination.getNameAddress().getAddress();
                if (!(detinationUri instanceof SipURL)) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("Error: getTargetSipUri - IBM destination uri is not a SipURL");
                    }
                } else {
                    SipURL detinationSipUrl = (SipURL)detinationUri;
                    if (detinationSipUrl.getTransport().equalsIgnoreCase("UDP")) {
                        detinationSipUrl.setTransport(newTransport);
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("IBM-Destination header transport value was changed to: " + newTransport);
                        }
                    }
                }
            }
            ListeningPoint udpListeningPoint = connection.getSIPListenningConnection().getListeningPoint();
            ListeningPointImpl tcpListeningPoint = null;
            if (!SIPTransactionStack.instance().getConfiguration().strictOutboundLocalPort()) {
                tcpListeningPoint = this.getTcpListeningPoint(udpListeningPoint);
            }
            if (tcpListeningPoint == null) {
                IOException e2 = new IOException("TCP is disabled,strictOutboundLocalPort value = " + SIPTransactionStack.instance().getConfiguration().strictOutboundLocalPort());
                this.revertToUdp(topVia, newTransport, e2);
                return connection;
            }
            SipProvider tcpProvider = tcpListeningPoint.getProvider();
            try {
                connection = this.getHopConnection(nextHop, (Request)message, tcpProvider, tcpListeningPoint, true);
                if (standalone) {
                    messageContext.transportSwitch();
                } else {
                    topVia.setParameter(IBM_MTU_PARAM, "");
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "handlePathMtuExceeded", "transport successfully switched for large request");
                }
            }
            catch (IOException e3) {
                this.revertToUdp(topVia, newTransport, e3);
            }
        }
        return connection;
    }

    private void revertToUdp(ViaHeader topVia, String newTransport, IOException e2) throws SipParseException {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "handlePathMtuExceeded", "failed establishing [" + newTransport + "] connection, falling back to fragmented UDP", e2);
        }
        topVia.setTransport("UDP");
    }

    private ListeningPointImpl getTcpListeningPoint(ListeningPoint udpListeningPoint) {
        String udpHost = udpListeningPoint.getHost();
        int udpPort = udpListeningPoint.getPort();
        List<ListeningPoint> listeningPoints = this.m_connectionsModel.getListeningPoints();
        Iterator<ListeningPoint> i = listeningPoints.iterator();
        ListeningPointImpl tcpListeningPoint = null;
        while (i.hasNext()) {
            ListeningPointImpl listeningPoint = (ListeningPointImpl)i.next();
            String transport = listeningPoint.getTransport();
            if (!transport.equalsIgnoreCase("tcp")) continue;
            tcpListeningPoint = listeningPoint;
            int tcpPort = tcpListeningPoint.getPort();
            String tcpHost = tcpListeningPoint.getHost();
            if (tcpPort != udpPort || !tcpHost.equals(udpHost)) continue;
            return tcpListeningPoint;
        }
        return tcpListeningPoint;
    }

    public synchronized SIPListenningConnection createSIPListenningConnection(ListeningPointImpl lp) throws IOException {
        SIPListenningConnection listenConnection = this.m_connectionsModel.createSIPListenningConnection(lp);
        return listenConnection;
    }

    public synchronized void removeSIPListenningConnection(ListeningPointImpl lp) {
        this.m_connectionsModel.removeSIPListenningConnection(lp);
    }

    public List getListeningPoints() {
        return this.m_connectionsModel.getListeningPoints();
    }

    ListeningPointImpl getDefaultListenningPoint(Message msg) throws BadRequestException {
        try {
            ViaHeader topVia = (ViaHeader)msg.getHeader("Via", true);
            String transport = topVia.getTransport();
            ListeningPointImpl retVal = this.m_connectionsModel.getDefaultListenningPoint(transport);
            return retVal;
        }
        catch (SipException exp) {
            throw new BadRequestException("bad via header", 400);
        }
    }

    protected void validateOutgoingRequest(Request sipRequest) throws BadRequestException {
        HeaderIterator headerIterator;
        if (!sipRequest.hasMaxForwardsHeader()) {
            try {
                MaxForwardsHeader maxForwardHeader = SipJainFactories.getInstance().getHeaderFactory().createMaxForwardsHeader(70);
                sipRequest.addHeader(maxForwardHeader, true);
            }
            catch (SipParseException e2) {
                throw new BadRequestException(400);
            }
        }
        if ((headerIterator = sipRequest.getViaHeaders()) == null || !headerIterator.hasNext()) {
            throw new BadRequestException(400);
        }
    }

    private void validateIncomingRequest(Request request) throws BadRequestException {
        MaxForwardsHeader maxForwardsHeader;
        if (request.getCallIdHeader() == null) {
            throw new BadRequestException("Missing Call-ID header field", 400);
        }
        if (request.getCSeqHeader() == null) {
            throw new BadRequestException("Missing CSeq header field", 400);
        }
        if (request.getFromHeader() == null) {
            throw new BadRequestException("Missing From header field", 400);
        }
        if (request.getToHeader() == null) {
            throw new BadRequestException("Missing To header field", 400);
        }
        if (!request.hasViaHeaders()) {
            throw new BadRequestException("Missing Via header field", 400);
        }
        try {
            maxForwardsHeader = request.getMaxForwardsHeader();
        }
        catch (HeaderParseException e2) {
            throw new BadRequestException("Bad Request, Malformed Max-Forwards header", 400);
        }
        if (maxForwardsHeader != null && maxForwardsHeader.getMaxForwards() < 0) {
            throw new BadRequestException(SipResponseCodes.getResponseCodeText(483), 483);
        }
    }

    private void validateTopViaAddress(ViaHeader topVia, SIPConnection connection) {
        block5: {
            try {
                String netHost = connection.getRemoteHost();
                topVia.setReceived(netHost);
                if (connection.isReliable() && this.isStandAloneMode() || topVia.hasParameter("rport")) {
                    int netPort = connection.getRemotePort();
                    topVia.setParameter("rport", String.valueOf(netPort));
                }
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "Exception in validateTopViaAddress", e2.getMessage());
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isTraceDebugEnabled()) break block5;
                c_logger.traceDebug(this, "Exception in validateTopViaAddress", e3.getMessage());
            }
        }
    }

    public void onConnectionClosed(SIPConnection connection) {
        this.cleanUpConnection(connection);
    }

    public void onConnectionCreated(SIPListenningConnection listenConnection, SIPConnection connection) {
        try {
            if (connection.isReliable()) {
                this.m_connectionsModel.addConnection(connection);
            }
            connection.start();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "onConnectionCreated", connection.toString());
            }
        }
        catch (IOException exp) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "onConnectionCreated", exp.getMessage(), exp);
            }
            this.cleanUpConnection(connection);
        }
    }

    private void cleanUpConnection(SIPConnection connection) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "onConnectionClosed", "connection " + connection + " closed");
        }
        this.m_connectionsModel.removeConnection(connection);
    }

    public void onListeningConnectionClosed(SIPListenningConnection listenConnection) {
    }

    public void onIOError(SIPConnection connection) {
        this.cleanUpConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRead(SipMessageByteBuffer buffer, SIPConnection connection) {
        MessageParser parser = connection.getMessageParser();
        do {
            Message message = parser.parse(buffer);
            String parseError = parser.getError();
            if (message == null) {
                if (parseError == null) continue;
                connection.incrementNumberOfParseErrors();
                TransportCommLayerMgr.messageDropped(null, parseError);
                boolean reliable = connection.isReliable();
                if (reliable) {
                    if (connection.shouldDropConnection()) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "onRead", "closing connection [" + connection + "] on parse error");
                        }
                        this.cleanUpConnection(connection);
                        break;
                    }
                    if (!connection.isAParseErrorAllowed()) continue;
                    parser.setStartLineHuntingMode(true);
                    continue;
                }
                if (!this.isStandAloneMode()) continue;
                this.cleanUpConnection(connection);
                break;
            }
            try {
                this.setLogExtOnThread(message);
                int errorCode = parser.getErrorCode();
                parser.setStartLineHuntingMode(false);
                this.onMessage(message, connection, parser, parseError, errorCode);
                if (!connection.isClosed()) continue;
                break;
            }
            catch (Throwable t) {
                if (!c_logger.isTraceFailureEnabled()) continue;
                c_logger.traceFailure(this, "onRead", "exception occured " + t.getLocalizedMessage());
                t.printStackTrace();
            }
            finally {
                ThreadLocalStorage.setCallID(null);
                ThreadLocalStorage.setSasID(null);
            }
        } while (parser.hasMore());
    }

    private void setLogExtOnThread(Message message) {
        CallIdHeader callIdHeader = message.getCallIdHeader();
        if (callIdHeader != null) {
            String callID = callIdHeader.getCallId();
            ThreadLocalStorage.setCallID(callID);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setLogExtOnThread", "storing the call ID on the current thread: " + callID);
            }
        }
        String sasID = this.retrieveSasId(message);
        ThreadLocalStorage.setSasID(sasID);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setLogExtOnThread", "storing the SAS ID on the current thread: " + sasID);
        }
    }

    private String retrieveSasId(Message message) {
        int first;
        int second;
        String sasId;
        String sid;
        block7: {
            sid = null;
            sasId = null;
            try {
                ViaHeader topVia = (ViaHeader)message.getHeader("Via", true);
                if (topVia != null) {
                    sid = topVia.getParameter(IBM_SID_PARAM);
                }
            }
            catch (HeaderParseException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "retrieveSasId", e2.getLocalizedMessage(), e2);
                }
            }
            catch (IllegalArgumentException e3) {
                if (!c_logger.isTraceDebugEnabled()) break block7;
                c_logger.traceDebug(this, "retrieveSasId", e3.getLocalizedMessage(), e3);
            }
        }
        if (sid != null && (second = sid.indexOf(95, (first = sid.indexOf(95)) + 1)) != -1) {
            sasId = sid.substring(0, second);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "retrieveSasId", "returning " + sasId);
        }
        return sasId;
    }

    private ResponseImpl createResponse(RequestImpl request) {
        ResponseImpl response = new ResponseImpl();
        request.copyCriticalHeaders(response);
        SipStackUtil.addToTag(response);
        if (request.isLoopback()) {
            response.setLoopback(true);
        }
        return response;
    }

    public void onMessage(Message msg, SIPConnection connection, MessageParser parser, String parseError, int errorCode) {
        block39: {
            SipProvider provider = ((ListeningPointImpl)connection.getSIPListenningConnection().getListeningPoint()).getProvider();
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "onMessage", "In Message:\r\n" + msg.toString());
                }
                if (SIPTransactionStack.instance().getConfiguration().isTraceInMsg()) {
                    System.out.println("In Message:\n" + msg.toString());
                }
                if (msg.isRequest()) {
                    RequestImpl request;
                    block38: {
                        request = (RequestImpl)msg;
                        if (parseError != null) {
                            block36: {
                                connection.incrementNumberOfParseErrors();
                                if (request.getMethod().equals("ACK")) {
                                    if (c_logger.isTraceDebugEnabled()) {
                                        c_logger.traceDebug(this, "onMessage", "Error parsing ACK: " + parseError);
                                    }
                                    TransportCommLayerMgr.messageDropped(request, parseError);
                                } else if (request.getMethod().equals("PROXYERROR")) {
                                    if (c_logger.isTraceDebugEnabled()) {
                                        c_logger.traceDebug(this, "onMessage", "Error parsing PROXYERROR: " + parseError);
                                    }
                                    TransportCommLayerMgr.messageDropped(request, parseError);
                                } else {
                                    MessageContext messageContext = null;
                                    try {
                                        ResponseImpl response = this.createResponse(request);
                                        response.setStatusCode(errorCode);
                                        response.setReasonPhrase(parseError);
                                        messageContext = MessageContextFactory.instance().getMessageContext(response);
                                        this.sendMessage(messageContext, provider, connection);
                                        TransportCommLayerMgr.messageDropped(request, parseError);
                                    }
                                    catch (SIPTransportException transportX) {
                                        if (c_logger.isTraceDebugEnabled()) {
                                            c_logger.traceDebug(this, "failed sending response to unparsed request", transportX.getMessage());
                                        }
                                        TransportCommLayerMgr.messageDropped(request, parseError);
                                        if (messageContext == null) break block36;
                                        messageContext.writeError(transportX);
                                    }
                                }
                            }
                            if (connection.isReliable()) {
                                this.reliableConnectionOnError(connection, parser);
                            } else if (this.isStandAloneMode()) {
                                this.cleanUpConnection(connection);
                            }
                            return;
                        }
                        if (provider == null) {
                            this.handlePartialInitialization(request, connection);
                        }
                        if (request.getMethod().equals("PROXYERROR")) {
                            this.handleProxyError(msg, connection);
                            return;
                        }
                        try {
                            this.validateIncomingRequest(request);
                        }
                        catch (BadRequestException e2) {
                            try {
                                ResponseImpl response = this.createResponse(request);
                                response.setStatusCode(e2.getStatusCode());
                                String reason = e2.getMessage();
                                if (reason != null && reason.length() > 0) {
                                    response.setReasonPhrase(reason);
                                }
                                MessageContext messageContext = MessageContextFactory.instance().getMessageContext(response);
                                this.sendMessage(messageContext, provider, connection);
                                TransportCommLayerMgr.messageDropped(request, reason);
                            }
                            catch (SipParseException parseX) {
                                if (c_logger.isTraceDebugEnabled()) {
                                    c_logger.traceDebug(this, "failed creating response to invalid incoming request", parseX.getMessage());
                                }
                                TransportCommLayerMgr.messageDropped(request, "could not create response");
                            }
                            catch (SIPTransportException transportX) {
                                if (c_logger.isTraceDebugEnabled()) {
                                    c_logger.traceDebug(this, "failed sending response to invalid incoming request", transportX.getMessage());
                                }
                                TransportCommLayerMgr.messageDropped(request, "could not send response");
                            }
                            return;
                        }
                        this.m_startupReceived = this.m_startupReceived || SipStackUtil.isSlspStartup(request);
                        try {
                            ViaHeader topVia = (ViaHeader)request.getHeader("Via", true);
                            this.validateTopViaAddress(topVia, connection);
                            this.processConnectionReuseExtension(topVia, connection, request);
                        }
                        catch (HeaderParseException e3) {
                            if (!c_logger.isTraceDebugEnabled()) break block38;
                            c_logger.traceDebug(this, "onMessage", "failed parsing top via");
                        }
                    }
                    this.m_router.processRequest(request);
                } else if (parseError != null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "got parse error(s) for response", parseError);
                    }
                    connection.incrementNumberOfParseErrors();
                    if (connection.isReliable()) {
                        this.reliableConnectionOnError(connection, parser);
                    } else if (this.isStandAloneMode()) {
                        this.cleanUpConnection(connection);
                    }
                    TransportCommLayerMgr.messageDropped(msg, "bad response: " + parseError);
                    return;
                }
                SIPListenningConnection listenningConnection = connection.getSIPListenningConnection();
                SIPStackUtil.addIbmClientAddressHeader(msg, connection, listenningConnection.getListeningPoint());
                ListeningPointImpl lpImpl = (ListeningPointImpl)listenningConnection.getListeningPoint();
                SIPTransactionStack.instance().prossesTransportSipMessage(msg, lpImpl.getProvider(), connection);
            }
            catch (Exception e4) {
                if (!c_logger.isErrorEnabled()) break block39;
                c_logger.error("error.exception.stack", "Create", null, (Throwable)e4);
            }
        }
    }

    private void reliableConnectionOnError(SIPConnection connection, MessageParser parser) {
        if (connection.shouldDropConnection()) {
            this.cleanUpConnection(connection);
        } else if (connection.isAParseErrorAllowed()) {
            parser.setStartLineHuntingMode(true);
        }
    }

    private void handlePartialInitialization(RequestImpl request, SIPConnection connection) {
        block3: {
            if (c_logger.isTraceFailureEnabled()) {
                c_logger.traceFailure(this, "handlePartialInitialization", "stack is not fully initialized");
            }
            ResponseImpl response = this.createResponse(request);
            try {
                response.setStatusCode(503);
                RetryAfterHeader retryAfterHeader = SipJainFactories.getInstance().getHeaderFactory().createRetryAfterHeader(5L);
                retryAfterHeader.setComment("Initializing");
                response.setRetryAfterHeader(retryAfterHeader);
                MessageContext messageContext = MessageContextFactory.instance().getMessageContext(response);
                this.sendMessage(messageContext, null, connection);
            }
            catch (Exception e2) {
                if (!c_logger.isTraceFailureEnabled()) break block3;
                c_logger.traceFailure(this, "handlePartialInitialization", "failed generating response", e2);
            }
        }
    }

    private void handleProxyError(Message proxyErrorMessage, SIPConnection connection) {
        Message originalMessage = this.parseOriginalMessage(proxyErrorMessage, connection);
        if (originalMessage == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleProxyError", "Original message of PROXYERROR was not created: " + proxyErrorMessage);
            }
            return;
        }
        boolean isProxyErrorDueToMtu = false;
        try {
            ViaHeader topVia = (ViaHeader)originalMessage.getHeader("Via", true);
            String param = topVia.getParameter(IBM_MTU_PARAM);
            if (param != null) {
                isProxyErrorDueToMtu = true;
            }
        }
        catch (Exception e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleProxyError", "Could not obtain top via of original message of PROXYERROR: " + proxyErrorMessage);
            }
            return;
        }
        if (isProxyErrorDueToMtu) {
            this.handleMtuError(null, originalMessage, connection);
        } else {
            this.handleGeneralProxyError(originalMessage, connection);
        }
    }

    public void handleMtuError(MessageContext messageContext, Message originalMessage, SIPConnection connection) {
        block3: {
            try {
                ViaHeader topVia = (ViaHeader)originalMessage.getHeader("Via", true);
                Hop nextHop = connection.getKey();
                String previousTransport = nextHop.getTrasport();
                this.revertToUdp(topVia, previousTransport, null);
                String finalTransport = topVia.getTransport();
                if (messageContext == null) {
                    messageContext = MessageContextFactory.instance().getMessageContext(originalMessage);
                    topVia.removeParameter(IBM_MTU_PARAM);
                }
                SipProvider provider = StackProperties.getInstance().getProvider(finalTransport);
                this.sendMessage(messageContext, provider, null);
            }
            catch (Exception e2) {
                if (!c_logger.isTraceDebugEnabled()) break block3;
                c_logger.traceDebug(this, "handleMtuProxyError", "Exception occurred while handling MTU proxy error of Message: " + originalMessage);
            }
        }
    }

    private void handleGeneralProxyError(Message originalMessage, SIPConnection connection) {
        MessageContext messageContext = MessageContextFactory.instance().getMessageContext(originalMessage);
        if (messageContext == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleGeneralProxyError", "Message context for original message of PROXYERROR was not created: " + originalMessage);
            }
            return;
        }
        messageContext.setSipConnection(connection);
        this.onMessageSendingFailed(messageContext);
    }

    private Message parseOriginalMessage(Message proxyErrorMessage, SIPConnection connection) {
        byte[] originalMsgBytes = proxyErrorMessage.getBodyAsBytes();
        if (originalMsgBytes == null || originalMsgBytes.length <= 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "parseOriginalMessage", "Original message not found inside PROXYERROR: " + proxyErrorMessage);
            }
            return null;
        }
        MessageParser parser = connection.getMessageParser();
        int origMsgLength = originalMsgBytes.length;
        String peerHost = connection.getRemoteHost();
        int peerPort = connection.getRemotePort();
        SipMessageByteBuffer buffer = SipMessageByteBuffer.fromNetwork(originalMsgBytes, origMsgLength, peerHost, peerPort);
        Message originalMessage = parser.parse(buffer);
        String parseError = parser.getError();
        if (parseError != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "parseOriginalMessage", "Error parsing original message inside PROXYERROR: " + parseError + " Message: " + proxyErrorMessage);
            }
            return null;
        }
        return originalMessage;
    }

    private void processConnectionReuseExtension(ViaHeader topVia, SIPConnection connection, RequestImpl request) {
        if (connection.hasAliacePort()) {
            return;
        }
        if (connection.isOutbound()) {
            return;
        }
        if (topVia.getTransport().equalsIgnoreCase("udp")) {
            return;
        }
        boolean isSlspStartup = false;
        if (SIPTransactionStack.instance().getConfiguration().forceConnectionReuse() || topVia.getParameter("alias") != null || (isSlspStartup = SipStackUtil.isSlspStartup(request))) {
            int aliasPort;
            if (isSlspStartup && !topVia.hasPort()) {
                aliasPort = 0;
            } else {
                boolean outboundSupported = this.isOutboundSupported(request);
                aliasPort = SipStackUtil.getPortFromTopVia(topVia, outboundSupported);
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processConnectionReuseExtension", "replacing connection key of [" + connection + "] from port [" + connection.getRemotePort() + "] to port [" + aliasPort + ']');
            }
            this.m_connectionsModel.updateConnection(connection, aliasPort);
        }
    }

    private boolean isOutboundSupported(RequestImpl request) {
        try {
            Header topVia = request.getHeader("Via", true);
            Header botVia = request.getHeader("Via", false);
            if (topVia != botVia) {
                return false;
            }
        }
        catch (Exception e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isOutboundExtension", "", e2);
            }
            return false;
        }
        return SipStackUtil.isSupported(request, "outbound");
    }

    private void handleFlowFailed(Request request, SipProvider provider, SIPTransaction transaction) {
        block2: {
            MessageFactory messageFactory = SipJainFactories.getInstance().getMesssageFactory();
            try {
                Response response = messageFactory.createResponse(430, request);
                response.setReasonPhrase("Flow Failed");
                long transactionId = transaction == null ? -1L : transaction.getId();
                SipEvent event = new SipEvent((Object)provider, transactionId, response);
                SIPTransactionStack.UACommLayer uaLayer = SIPTransactionStack.instance().getUACommLayer();
                uaLayer.sendEventToUA(event);
            }
            catch (Exception e2) {
                if (!c_logger.isTraceFailureEnabled()) break block2;
                c_logger.traceFailure(this, "handleFlowFailed", "", e2);
            }
        }
    }

    private void handleFlowTampered(Request request, SipProvider provider, SIPTransaction transaction) {
        block2: {
            MessageFactory messageFactory = SipJainFactories.getInstance().getMesssageFactory();
            try {
                Response response = messageFactory.createResponse(403, request);
                response.setReasonPhrase("Forbidden Flow");
                long transactionId = transaction == null ? -1L : transaction.getId();
                SipEvent event = new SipEvent((Object)provider, transactionId, response);
                SIPTransactionStack.UACommLayer uaLayer = SIPTransactionStack.instance().getUACommLayer();
                uaLayer.sendEventToUA(event);
            }
            catch (Exception e2) {
                if (!c_logger.isTraceFailureEnabled()) break block2;
                c_logger.traceFailure(this, "handleFlowTampered", "", e2);
            }
        }
    }

    public SIPConnectionsModel getConnectionsModel() {
        return this.m_connectionsModel;
    }

    public void onMessageSendingFailed(MessageContext messageSendingContext) {
        messageSendingContext.handleFailure();
    }

    private static void messageDropped(Message dropped, String reason) {
        if (c_logger.isTraceFailureEnabled()) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("message dropped");
            if (reason != null && reason.length() > 0) {
                buffer.append(" reason [");
                buffer.append(reason);
                buffer.append("]");
            }
            if (dropped != null) {
                buffer.append(" message:\r\n");
                buffer.append(dropped);
            }
            c_logger.traceFailure(buffer.toString());
        }
        TransportCommLayerMgr.updateRejectedMessagesPMICounter();
    }

    private static void updateRejectedMessagesPMICounter() {
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null) {
            perfMgr.updateRejectedMessagesCounter();
        }
    }

    public boolean isStandAloneMode() {
        if (this.m_startupReceived) {
            return false;
        }
        return this.m_router.isStandAloneMode();
    }

    static class LoopBackAddressThread
    implements Runnable {
        private LinkedList m_msgQueue = new LinkedList();

        LoopBackAddressThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(LoopBackMessage msg) {
            LinkedList linkedList = this.m_msgQueue;
            synchronized (linkedList) {
                this.m_msgQueue.addLast(msg);
                this.m_msgQueue.notify();
            }
        }

        @Override
        public void run() {
            this.readLoopBackMessages();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readLoopBackMessages() {
            while (true) {
                LoopBackMessage msg;
                block11: {
                    msg = null;
                    try {
                        LinkedList linkedList = this.m_msgQueue;
                        synchronized (linkedList) {
                            if (this.m_msgQueue.isEmpty()) {
                                this.m_msgQueue.wait();
                            }
                            if (!this.m_msgQueue.isEmpty()) {
                                msg = (LoopBackMessage)this.m_msgQueue.removeFirst();
                            }
                        }
                    }
                    catch (InterruptedException e2) {
                        if (!c_logger.isTraceDebugEnabled()) break block11;
                        c_logger.traceDebug(this, "readLoopBackMessages", e2.getMessage());
                    }
                }
                if (msg == null) continue;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "readLoopBackMessages", "\nLoopback Message:\n" + msg.toString());
                }
                msg.getMsg().removeHeader("IBM-Destination", true);
                try {
                    SIPTransactionStack.instance().prossesTransportSipMessage(msg.getMsg(), msg.getProvider(), msg.getConnection());
                    continue;
                }
                catch (Exception e3) {
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug(this, "readLoopBackMessages", e3.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

