/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.security.auth;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.security.auth.AuthHeader;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.sip.AuthInfo;

public class AuthInfoImpl
implements AuthInfo {
    private static final LogMgr c_logger = Log.get(AuthInfoImpl.class);
    List<AuthHeader> _authHeaders = new LinkedList<AuthHeader>();

    @Override
    public void addAuthInfo(int statusCode, String realm, String username, String password) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "<init>", statusCode, realm, username, "*****");
        }
        AuthHeader newHeader = new AuthHeader(statusCode, realm, username, password);
        this._authHeaders.add(newHeader);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "<init>");
        }
    }

    public void writeToRequest(SipServletRequestImpl request, SipServletResponseImpl response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "writeToRequest", request, response);
        }
        for (AuthHeader header : this._authHeaders) {
            header.writeToRequest(request, response);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "writeToRequest");
        }
    }
}

