/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.virtualhost;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAlias;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Pattern;

public class VirtualHostAliasImpl
implements VirtualHostAlias {
    private static final LogMgr c_logger = Log.get(VirtualHostAliasImpl.class);
    private boolean _isAnyHost;
    private boolean isAnyPort;
    private boolean _isRegExp;
    private Pattern _regExp;
    private String _host;
    private String _ip;
    private InetAddress _inetAddress;
    private int _port = -1;
    private static final String ANY_HOST = "*";
    private static final String ANY_CHAR = ".*";
    private String hostPortStr;

    @Override
    public void init(String hostPortStr) {
        int dots = hostPortStr.lastIndexOf(58);
        String host = hostPortStr.substring(0, dots);
        String port = hostPortStr.substring(dots + 1);
        if (port.equals(ANY_HOST)) {
            this.setAnyPort(true);
            port = "-1";
        }
        this.init(host, Integer.parseInt(port));
    }

    @Override
    public boolean isAnyPort() {
        return this.isAnyPort;
    }

    private void setAnyPort(boolean isAnyPort) {
        this.isAnyPort = isAnyPort;
    }

    @Override
    public void init(String host, int port) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "init", host, port);
        }
        this._port = port;
        this._isAnyHost = host.equals(ANY_HOST);
        if (!this._isAnyHost && (host.endsWith(ANY_HOST) || host.startsWith(ANY_HOST))) {
            this._isRegExp = true;
            String reExpStr = host.replace(ANY_HOST, ANY_CHAR);
            this._regExp = Pattern.compile(reExpStr);
        }
        this._host = host;
        if (!this._isAnyHost && !this._isRegExp) {
            InetAddress addr = null;
            try {
                addr = InetAddressCache.getByName(host);
                this._ip = InetAddressCache.getHostAddress(addr);
                this._inetAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.cannot.lookup.host", null, host, (Throwable)e2);
                }
                this._ip = host;
            }
        }
        this.hostPortStr = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "init", "result: host=" + this._host + ", _ip=" + this._ip + ", _isAnyHost=" + this._isAnyHost);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "init");
        }
    }

    @Override
    public boolean isAnyHost() {
        return this._isAnyHost;
    }

    @Override
    public String getIp() {
        return this._ip;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(VirtualHostAlias vh) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "match", (Object)vh);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "match", "Matching with this VH _ip=" + this._ip + ", _host=" + this._host + ", _port=" + this._port);
        }
        boolean matches = false;
        try {
            if (this == vh) {
                matches = true;
                boolean bl = true;
                return bl;
            }
            if (vh.isAnyHost() || this.isAnyHost()) {
                matches = true;
            } else if (this.isRegExp() && !vh.isRegExp()) {
                matches = this.getRegExp().matcher(vh.getHost()).matches() || this.getRegExp().matcher(vh.getIp()).matches();
            } else if (!this.isRegExp() && vh.isRegExp()) {
                matches = vh.getRegExp().matcher(this.getHost()).matches() || vh.getRegExp().matcher(this.getIp()).matches();
            } else {
                boolean bl = matches = this._ip.equals(vh.getIp()) || this._host.equals(vh.getHost()) || this.matchInetAddr(vh);
            }
            if (matches) {
                matches = this.isAnyPort() || vh.isAnyPort() || this.getPort() == vh.getPort();
            }
            boolean bl = matches;
            return bl;
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "match", matches);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matchInetAddr(VirtualHostAlias vh) {
        boolean result = false;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "matchInetAddr", (Object)vh);
        }
        try {
            if (this._inetAddress == null || vh.getInetAddress() == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug((Object)null, "matchInetAddr", "no match: _inetAddress=" + this._inetAddress + ", vh.getInetAddress()=" + vh.getInetAddress());
                }
                result = false;
                boolean bl = false;
                return bl;
            }
            String thisCanonicalName = this._inetAddress.getCanonicalHostName();
            String otherCanonicalName = vh.getInetAddress().getCanonicalHostName();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)null, "matchInetAddr", "thisCanonicalName=" + thisCanonicalName + ", otherCanonicalName=" + otherCanonicalName);
            }
            boolean bl = result = thisCanonicalName.equalsIgnoreCase(otherCanonicalName);
            return bl;
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "matchInetAddr", result);
            }
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this._inetAddress;
    }

    public String toString() {
        if (this.hostPortStr == null) {
            String hostToString = null;
            String portToString = null;
            hostToString = this._isAnyHost || this._isRegExp ? this._host : this._ip;
            portToString = this.isAnyPort() ? ANY_HOST : Integer.toString(this._port);
            this.hostPortStr = hostToString + ":" + portToString;
        }
        return this.hostPortStr;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public Pattern getRegExp() {
        return this._regExp;
    }

    @Override
    public boolean isRegExp() {
        return this._isRegExp;
    }

    public void setRegExp(boolean regExp) {
        this._isRegExp = regExp;
    }

    public boolean equals(Object o) {
        if (o instanceof VirtualHostAliasImpl) {
            VirtualHostAliasImpl other = (VirtualHostAliasImpl)o;
            return this._host.equals(other._host) && this._port == other._port;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this._host, this._port);
    }

    public static String createHostAliasString(String host, String port) {
        StringBuilder sb = new StringBuilder();
        sb.append(host).append(":").append(port);
        return sb.toString();
    }
}

