/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.annotation;

import com.ibm.websphere.sip.unmatchedMessages.UnmatchedMessageListener;
import com.ibm.ws.sip.container.annotation.SipXmlNameSpace;
import com.ibm.ws.sip.container.annotation.StopDeploymentException;
import com.ibm.ws.sip.container.annotation.WebXmlNameSpace;
import com.ibm.ws.sip.container.properties.SarToWarProperties;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipSessionActivationListener;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SipAnnotationUtil {
    private static final String className = SipAnnotationUtil.class.getName();
    private static Logger c_logger = null;
    private static String basicSipXML;
    private static String basicWebXML;

    public static Node getAppName(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        Node sipAppNode = null;
        try {
            sipAppNode = (Node)xPath.evaluate("/:sip-app/:app-name", sipXml, XPathConstants.NODE);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return sipAppNode;
    }

    public static boolean checkIfAppNameExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:app-name", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfDisplayNameExistInWar(Document webXml) {
        NodeList nodeList;
        block2: {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new WebXmlNameSpace());
            nodeList = null;
            try {
                nodeList = (NodeList)xPath.evaluate("/:web-app/:display-name", webXml, XPathConstants.NODESET);
            }
            catch (XPathExpressionException exception) {
                if (!c_logger.isLoggable(Level.SEVERE)) break block2;
                c_logger.logp(Level.SEVERE, className, "checkIfDisplayNameExistInWar", "failed to parse web.xml", exception);
            }
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfDescriptionExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/javaee:description", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfDisplayNameExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/javaee:display-name", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfIconExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/javaee:icon", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfIconExistInWeb(Document webXml) {
        NodeList nodeList;
        block2: {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new WebXmlNameSpace());
            nodeList = null;
            try {
                nodeList = (NodeList)xPath.evaluate("/:web-app/:icon", webXml, XPathConstants.NODESET);
            }
            catch (XPathExpressionException exception) {
                if (!c_logger.isLoggable(Level.SEVERE)) break block2;
                c_logger.logp(Level.SEVERE, className, "checkIfIconExistInWeb", "failed to parse web.xml", exception);
            }
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfDistributableExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:distributable", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfDistributableExistInWeb(Document webXml) {
        NodeList nodeList;
        block2: {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new WebXmlNameSpace());
            nodeList = null;
            try {
                nodeList = (NodeList)xPath.evaluate("/:web-app/:distributable", webXml, XPathConstants.NODESET);
            }
            catch (XPathExpressionException exception) {
                if (!c_logger.isLoggable(Level.SEVERE)) break block2;
                c_logger.logp(Level.SEVERE, className, "checkIfDistributableExistInWeb", "failed to parse web.xml", exception);
            }
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfProxyConfigExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:proxy-config", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfMainServletExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:servlet-selection", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static String getMainServlet(Document sipXml) {
        String mainServlet;
        block2: {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new SipXmlNameSpace());
            mainServlet = null;
            try {
                mainServlet = (String)xPath.evaluate("/:sip-app/:servlet-selection/:main-servlet/text()", sipXml, XPathConstants.STRING);
            }
            catch (XPathExpressionException exception) {
                if (!c_logger.isLoggable(Level.FINEST)) break block2;
                c_logger.logp(Level.FINEST, className, "getMainServlet", "Failed to get main servlet from sip.xml, error is: " + exception.getMessage());
            }
        }
        return mainServlet;
    }

    public static boolean checkIfSessionConfigExist(Document sipXml) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:session-config", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfListenerExist(Document sipXml, String listenerClassName) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:listener/javaee:listener-class[text()='" + listenerClassName + "']", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfServletExist(Document sipXml, String servletName, String servletClassName) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new SipXmlNameSpace());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:servlet/javaee:servlet-class[text()='" + servletClassName + "']", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        if (nodeList != null && nodeList.item(0) != null) {
            return true;
        }
        try {
            nodeList = (NodeList)xPath.evaluate("/:sip-app/:servlet/javaee:servlet-name[text()='" + servletName + "']", sipXml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            System.out.println(exception.getMessage());
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean checkIfServletExistInWeb(Document webXml, String servletName, String servletClassName) {
        NodeList nodeList;
        block5: {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new WebXmlNameSpace());
            nodeList = null;
            try {
                nodeList = (NodeList)xPath.evaluate("/:web-app/:servlet/:servlet-class[text()='" + servletClassName + "']", webXml, XPathConstants.NODESET);
            }
            catch (XPathExpressionException exception) {
                System.out.println(exception.getMessage());
            }
            if (nodeList != null && nodeList.item(0) != null) {
                return true;
            }
            try {
                nodeList = (NodeList)xPath.evaluate("/:web-app/:servlet/:servlet-name[text()='" + servletName + "']", webXml, XPathConstants.NODESET);
            }
            catch (XPathExpressionException exception) {
                if (!c_logger.isLoggable(Level.SEVERE)) break block5;
                c_logger.logp(Level.SEVERE, className, "checkIfServletExistInWeb", "failed to parse web.xml", exception);
            }
        }
        return nodeList != null && nodeList.item(0) != null;
    }

    public static boolean isOffspringOfSipServlet(Class clazz) {
        if (clazz.getSuperclass() == null) {
            return false;
        }
        if (clazz.getSuperclass().equals(SipServlet.class)) {
            return true;
        }
        return SipAnnotationUtil.isOffspringOfSipServlet(clazz.getSuperclass());
    }

    public static boolean isOffspringOfClass(Class clazz, Class ancesstor) {
        if (clazz.equals(ancesstor)) {
            return true;
        }
        if (clazz.getSuperclass() == null) {
            return false;
        }
        return SipAnnotationUtil.isOffspringOfSipServlet(clazz.getSuperclass());
    }

    public static boolean isOffspringOfOneOfListeners(Class clazz) {
        if (clazz.getSuperclass() == null) {
            return false;
        }
        for (Class<?> interfaceClazz : clazz.getInterfaces()) {
            if (!SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipServletListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipApplicationSessionActivationListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipApplicationSessionAttributeListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipApplicationSessionBindingListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipApplicationSessionListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipErrorListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipSessionActivationListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipSessionAttributeListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipSessionBindingListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, SipSessionListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, TimerListener.class) && !SipAnnotationUtil.isOffspringOfClass(interfaceClazz, UnmatchedMessageListener.class)) continue;
            return true;
        }
        return SipAnnotationUtil.isOffspringOfSipServlet(clazz.getSuperclass());
    }

    public static String getBaicSipXml() {
        return basicSipXML;
    }

    public static String getBaicWebXml() {
        return basicWebXML;
    }

    public static void processListenerAnnotations(Document sipXmlDocument) {
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.entering(className, "processListenerAnnotations");
        }
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.exiting(className, "processListenerAnnotations");
        }
    }

    public static void processServletAnnotations(Document sipXmlDocument, Document webXmlDocument) {
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.entering(className, "processServletAnnotations");
        }
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.exiting(className, "processServletAnnotations");
        }
    }

    public static String processSipApplicationAnnotations(Document sipXmlDocument, Document webXmlDocument) throws StopDeploymentException {
        return " ";
    }

    public static void validateJsr289(Document sipXmlDocument) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String wasRoot = System.getProperty("was.install.root");
        String prefix = wasRoot + File.separator + "sar2war_tool" + File.separator;
        File file = new File(prefix + "sip-app_1_1.xsd");
        prefix = "file:////" + prefix.replaceAll(" ", "%20");
        String xmlXsdFile = prefix + "xml.xsd";
        String schemaXsdFile = prefix + "XMLSchema.xsd";
        String webXsdFile = prefix + "web-app_2_5.xsd";
        String sipXsdFile = prefix + "sip-app_1_1.xsd";
        String value = "http://www.w3.org/XML/1998/namespace " + xmlXsdFile + " http://www.w3.org/2001/XMLSchema " + schemaXsdFile + " http://www.jcp.org/xml/ns/sipservlet " + sipXsdFile + " http://java.sun.com/xml/ns/javaee " + webXsdFile;
        factory.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", value);
        Schema schema = factory.newSchema(file);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(sipXmlDocument));
    }

    public static boolean supportAmm() {
        boolean supportAmm = false;
        if (SarToWarProperties.isLoaded()) {
            supportAmm = SarToWarProperties.getSupportAmmAnnotationReading();
            if (c_logger.isLoggable(Level.FINEST)) {
                c_logger.logp(Level.FINEST, className, "supportAmm", "found support amm property in the custom properties");
            }
        } else {
            String supportSarToWarStr = System.getProperty("supportAmmAnnotationReading", "false");
            if (supportSarToWarStr.equalsIgnoreCase("true")) {
                supportAmm = true;
            }
        }
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.exiting(className, "supportAmm", supportAmm);
        }
        return supportAmm;
    }

    static {
        c_logger = Logger.getLogger(className);
        basicSipXML = "<?xml version=\"1.0\"?><sip-app xmlns=\"http://www.jcp.org/xml/ns/sipservlet\" xmlns:javaee=\"http://java.sun.com/xml/ns/javaee\"></sip-app>";
        basicWebXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \t<web-app id=\"WebApp_1\" version=\"2.5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\">\t</web-app>";
    }
}

