/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.internal.osgi.TrLogImpl;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class TrLogReaderServiceImpl
implements LogReaderService {
    private static final TraceComponent myTc = Tr.register(TrLogReaderServiceImpl.class);
    protected final TrLogImpl logImpl;

    TrLogReaderServiceImpl(TrLogImpl logImpl) {
        this.logImpl = logImpl;
    }

    public void addLogListener(LogListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)myTc, (String)"addLogListener", (Object[])new Object[]{listener});
        }
        ListenerHolder.listeners.putIfAbsent(listener, listener);
    }

    public void removeLogListener(LogListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)myTc, (String)"removeLogListener", (Object[])new Object[]{listener});
        }
        ListenerHolder.listeners.remove(listener);
    }

    public Enumeration getLog() {
        return this.logImpl.getRecentEntries();
    }

    protected Set<LogListener> getListeners() {
        return ListenerHolder.listeners.keySet();
    }

    protected synchronized void release() {
        ListenerHolder.listeners.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + ListenerHolder.listeners + "]";
    }

    static final class ListenerHolder {
        protected static final ConcurrentHashMap<LogListener, LogListener> listeners = new ConcurrentHashMap();

        ListenerHolder() {
        }
    }
}

