/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.impl.AbstractConfigBuilder;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractProviderResolver
extends ConfigProviderResolver {
    private static final TraceComponent tc = Tr.register(AbstractProviderResolver.class);
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    private final WeakHashMap<ClassLoader, WeakReference<Config>> configCache = new WeakHashMap();
    static final long serialVersionUID = 7358761058777907466L;

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.unsetReference(ref);
    }

    public void activate(ComponentContext cc) {
        this.scheduledExecutorServiceRef.activate(cc);
        ConfigProviderResolver.setInstance((ConfigProviderResolver)this);
    }

    public void deactivate(ComponentContext cc) throws IOException {
        ConfigProviderResolver.setInstance(null);
        this.shutdown();
        this.scheduledExecutorServiceRef.deactivate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws IOException {
        WeakHashMap<ClassLoader, WeakReference<Config>> weakHashMap = this.configCache;
        synchronized (weakHashMap) {
            for (Map.Entry<ClassLoader, WeakReference<Config>> entry : this.configCache.entrySet()) {
                Config config;
                WeakReference<Config> configRef = entry.getValue();
                if (configRef == null || (config = (Config)configRef.get()) == null) continue;
                this.closeConfig(config);
            }
            this.configCache.clear();
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.scheduledExecutorServiceRef.getService();
    }

    public Config getConfig() {
        ClassLoader classloader = this.getThreadContextClassLoader();
        Config config = this.getConfig(classloader);
        return config;
    }

    private ClassLoader getThreadContextClassLoader() {
        ClassLoader classloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -1358665995610986238L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config getConfig(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"null.classloader.CWMCG0002E", (Object[])new Object[0]));
        }
        Config config = null;
        WeakHashMap<ClassLoader, WeakReference<Config>> weakHashMap = this.configCache;
        synchronized (weakHashMap) {
            WeakReference<Config> ref = this.configCache.get(loader);
            Config config2 = config = ref == null ? null : (Config)ref.get();
            if (config == null) {
                AbstractConfigBuilder builder = this.newBuilder(loader);
                builder.addDefaultSources();
                builder.addDiscoveredSources();
                builder.addDefaultConverters();
                builder.addDiscoveredConverters();
                config = builder.build();
                this.registerConfig(config, loader);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(Config config, ClassLoader classLoader) {
        WeakHashMap<ClassLoader, WeakReference<Config>> weakHashMap = this.configCache;
        synchronized (weakHashMap) {
            WeakReference<Config> previous = this.configCache.get(classLoader);
            if (previous != null) {
                if (previous.get() != null) {
                    throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"config.already.exists.CWMCG0003E", (Object[])new Object[0]));
                }
                this.configCache.remove(classLoader);
            }
            this.configCache.put(classLoader, new WeakReference<Config>(config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConfig(Config config) {
        WeakHashMap<ClassLoader, WeakReference<Config>> weakHashMap = this.configCache;
        synchronized (weakHashMap) {
            for (Map.Entry<ClassLoader, WeakReference<Config>> entry : this.configCache.entrySet()) {
                Config cachedConfig;
                ClassLoader classLoader = entry.getKey();
                WeakReference<Config> configRef = entry.getValue();
                if (configRef == null || (cachedConfig = (Config)configRef.get()) == null || config != cachedConfig) continue;
                this.configCache.remove(classLoader);
                break;
            }
            this.closeConfig(config);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeConfig(Config config) {
        if (config instanceof Closeable) {
            try {
                ((Closeable)config).close();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.config.impl.AbstractProviderResolver", (String)"195", (Object)((Object)this), (Object[])new Object[]{config});
                throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"could.not.close.CWMCG0004E", (Object[])new Object[]{e}));
            }
        }
    }

    public ConfigBuilder getBuilder() {
        ClassLoader classLoader = this.getThreadContextClassLoader();
        AbstractConfigBuilder builder = this.newBuilder(classLoader);
        builder.addDefaultConverters();
        return builder;
    }

    protected abstract AbstractConfigBuilder newBuilder(ClassLoader var1);
}

