/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.converters.DefaultConverters;
import com.ibm.ws.microprofile.config.converters.PriorityConverterMap;
import com.ibm.ws.microprofile.config.converters.UserConverter;
import com.ibm.ws.microprofile.config.impl.ConfigSourceComparator;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.microprofile.config.sources.DefaultSources;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractConfigBuilder
implements ConfigBuilder {
    private static final TraceComponent tc = Tr.register(AbstractConfigBuilder.class);
    private final PriorityConverterMap userConverters = new PriorityConverterMap();
    private final TreeSet<ConfigSource> userSources = new TreeSet<ConfigSource>(ConfigSourceComparator.INSTANCE);
    private ClassLoader classloader;
    private boolean addDefaultSources = false;
    private boolean addDiscoveredSources = false;
    private boolean addDefaultConverters = false;
    private boolean addDiscoveredConverters = false;
    private final ScheduledExecutorService executor;
    static final long serialVersionUID = 1011640268656383544L;

    public AbstractConfigBuilder(ClassLoader classLoader, ScheduledExecutorService executor) {
        this.classloader = classLoader;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDefaultSources() {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            this.addDefaultSources = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDiscoveredSources() {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            this.addDiscoveredSources = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDefaultConverters() {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            this.addDefaultConverters = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDiscoveredConverters() {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            this.addDiscoveredConverters = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder forClassLoader(ClassLoader loader) {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            if (loader == null) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"null.classloader.CWMCG0002E", (Object[])new Object[0]));
            }
            this.classloader = loader;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder withSources(ConfigSource ... sources) {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            for (ConfigSource source : sources) {
                this.addSource(source);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder withConverters(Converter<?> ... converters) {
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            for (Converter<?> con : converters) {
                UserConverter<?> userConverter = UserConverter.newInstance(con);
                this.addUserConverter(userConverter);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSphereConfig build() {
        WebSphereConfig config = null;
        AbstractConfigBuilder abstractConfigBuilder = this;
        synchronized (abstractConfigBuilder) {
            SortedSources sources = this.getSources();
            PriorityConverterMap converters = this.getConverters();
            ScheduledExecutorService executor = this.getScheduledExecutorService();
            long refreshInterval = this.getRefreshInterval();
            ClassLoader classLoader = this.getClassLoader();
            ConversionManager conversionManager = this.getConversionManager(converters, classLoader);
            config = this.buildConfig(conversionManager, sources, executor, refreshInterval);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDumpEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config dump: {0}", (Object[])new Object[]{config.dump()});
            }
        }
        return config;
    }

    protected void addUserConverter(UserConverter<?> userConverter) {
        this.userConverters.addConverter(userConverter);
    }

    protected abstract WebSphereConfig buildConfig(ConversionManager var1, SortedSources var2, ScheduledExecutorService var3, long var4);

    protected SortedSources getSources() {
        SortedSources sources = new SortedSources(this.userSources);
        if (this.addDefaultSources) {
            sources.addAll(DefaultSources.getDefaultSources(this.getClassLoader()));
        }
        if (this.addDiscoveredSources) {
            sources.addAll(DefaultSources.getDiscoveredSources(this.getClassLoader()));
        }
        sources = sources.unmodifiable();
        return sources;
    }

    protected PriorityConverterMap getConverters() {
        PriorityConverterMap allConverters = new PriorityConverterMap();
        if (this.addDefaultConverters) {
            allConverters.addAll(this.getDefaultConverters());
        }
        if (this.addDiscoveredConverters) {
            allConverters.addAll(DefaultConverters.getDiscoveredConverters(this.getClassLoader()));
        }
        allConverters.addAll(this.userConverters);
        allConverters.setUnmodifiable();
        return allConverters;
    }

    protected PriorityConverterMap getDefaultConverters() {
        return DefaultConverters.getDefaultConverters();
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    protected long getRefreshInterval() {
        long refreshInterval = 500L;
        String refreshProp = AbstractConfigBuilder.getRefreshRateSystemProperty();
        if (refreshProp != null && !"".equals(refreshProp)) {
            refreshInterval = Long.parseLong(refreshProp);
        }
        if (refreshInterval > 0L && refreshInterval < 500L) {
            refreshInterval = 500L;
        }
        return refreshInterval;
    }

    private static String getRefreshRateSystemProperty() {
        String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 8802573291016984121L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("microprofile.config.refresh.rate");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return prop;
    }

    private void addSource(ConfigSource source) {
        this.userSources.add(source);
    }

    protected ClassLoader getClassLoader() {
        return this.classloader;
    }

    protected ConversionManager getConversionManager(PriorityConverterMap converters, ClassLoader classLoader) {
        return new ConversionManager(converters, classLoader);
    }
}

