/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.ejb.TaskLocker;
import com.ibm.ws.concurrent.persistent.internal.ApplicationTracker;
import com.ibm.ws.concurrent.persistent.internal.Config;
import com.ibm.ws.concurrent.persistent.internal.LastExecutionImpl;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.concurrent.persistent.internal.TaskInfo;
import com.ibm.ws.concurrent.persistent.serializable.TaskFailure;
import com.ibm.ws.concurrent.persistent.serializable.TaskSkipped;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.concurrent.persistent.TaskRecord;
import com.ibm.wsspi.concurrent.persistent.TaskStore;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.Trigger;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InvokerTask
implements Runnable,
Synchronization {
    private static final TraceComponent tc = Tr.register(InvokerTask.class);
    public static final ThreadLocal<Long> taskIdsOfRunningTasks = new ThreadLocal();
    private static final int DEFAULT_TIMEOUT_FOR_SUSPENDED_TRAN = 1800;
    private final short binaryFlags;
    private long expectedExecTime;
    private final PersistentExecutorImpl persistentExecutor;
    final long taskId;
    private final int txTimeout;
    static final long serialVersionUID = -7792364745549143672L;

    InvokerTask(PersistentExecutorImpl persistentExecutor, long taskId, long expectedExecTime, short binaryFlags, int txTimeout) {
        this.persistentExecutor = persistentExecutor;
        this.taskId = taskId;
        this.expectedExecTime = expectedExecTime;
        this.binaryFlags = binaryFlags;
        this.txTimeout = txTimeout;
    }

    public void afterCompletion(int status) {
        if (status == 3) {
            Boolean previous = this.persistentExecutor.inMemoryTaskIds.put(this.taskId, Boolean.TRUE);
            if (previous == null) {
                long delay = this.expectedExecTime - new Date().getTime();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Schedule " + this.taskId + " for " + delay + "ms from now"), (Object[])new Object[0]);
                }
                this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found task " + this.taskId + " already scheduled"), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    public void beforeCompletion() {
    }

    public boolean equals(Object other) {
        return other instanceof InvokerTask && this.taskId == ((InvokerTask)other).taskId && this.persistentExecutor == ((InvokerTask)other).persistentExecutor;
    }

    public int hashCode() {
        return (int)this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void processRetryableTaskFailure(Throwable failure, ClassLoader loader, short consecutiveFailureCount, Config config, String taskName) {
        boolean retry;
        block33: {
            taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
            TaskStore taskStore = this.persistentExecutor.taskStore;
            TransactionManager tranMgr = (TransactionManager)this.persistentExecutor.tranMgrRef.getServiceWithException();
            retry = false;
            try {
                Object failed = null;
                if (config.retryLimit >= 0 && consecutiveFailureCount > config.retryLimit && (this.binaryFlags & TaskRecord.Flags.AUTO_PURGE_ALWAYS.bit) != 0) {
                    if (failure == null) {
                        Tr.warning((TraceComponent)tc, (String)"CWWKC1510.retry.limit.reached.rollback", (Object[])new Object[]{this.persistentExecutor.name, taskName, consecutiveFailureCount});
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, consecutiveFailureCount, failure});
                    }
                    tranMgr.begin();
                    try {
                        taskStore.remove(this.taskId, null, false);
                        break block33;
                    }
                    catch (Throwable throwable) {
                        void x;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"144", (Object)this, (Object[])new Object[]{failure, loader, consecutiveFailureCount, config, taskName});
                        failed = x;
                        break block33;
                    }
                    finally {
                        if (failed == null) {
                            tranMgr.commit();
                        } else {
                            tranMgr.rollback();
                        }
                    }
                }
                tranMgr.begin();
                try {
                    if (config.retryLimit < 0 || consecutiveFailureCount <= config.retryLimit) {
                        consecutiveFailureCount = taskStore.incrementFailureCount(this.taskId);
                    }
                    if (config.retryLimit >= 0 && consecutiveFailureCount > config.retryLimit) {
                        if (failure == null) {
                            Tr.warning((TraceComponent)tc, (String)"CWWKC1510.retry.limit.reached.rollback", (Object[])new Object[]{this.persistentExecutor.name, taskName, consecutiveFailureCount});
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, consecutiveFailureCount, failure});
                        }
                        TaskFailure taskFailure = new TaskFailure(failure, failure == null ? null : loader, this.persistentExecutor, 1, Short.toString(consecutiveFailureCount));
                        TaskRecord updates = new TaskRecord(false);
                        updates.setConsecutiveFailureCount(consecutiveFailureCount);
                        updates.setResult(this.persistentExecutor.serialize(taskFailure));
                        updates.setState((short)(TaskState.ENDED.bit | TaskState.FAILURE_LIMIT_REACHED.bit));
                        TaskRecord expected = new TaskRecord(false);
                        expected.setId(this.taskId);
                        taskStore.persist(updates, expected);
                    } else {
                        boolean bl = retry = consecutiveFailureCount != -1;
                        if (retry) {
                            String seconds;
                            String string = seconds = consecutiveFailureCount == 1 || config.retryInterval == 0L ? "0" : NumberFormat.getInstance().format((double)config.retryInterval / 1000.0);
                            if (failure == null) {
                                Tr.warning((TraceComponent)tc, (String)"CWWKC1500.task.rollback.retry", (Object[])new Object[]{this.persistentExecutor.name, taskName, seconds});
                            } else {
                                Tr.warning((TraceComponent)tc, (String)"CWWKC1501.task.failure.retry", (Object[])new Object[]{this.persistentExecutor.name, taskName, failure, seconds});
                            }
                        } else if (failure == null) {
                            Tr.warning((TraceComponent)tc, (String)"CWWKC1502.task.rollback", (Object[])new Object[]{this.persistentExecutor.name, taskName});
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"CWWKC1503.task.failure", (Object[])new Object[]{this.persistentExecutor.name, taskName, failure});
                        }
                    }
                }
                catch (Throwable seconds) {
                    void x;
                    FFDCFilter.processException((Throwable)seconds, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"195", (Object)this, (Object[])new Object[]{failure, loader, consecutiveFailureCount, config, taskName});
                    failed = x;
                    retry = true;
                }
                finally {
                    if (failed == null) {
                        tranMgr.commit();
                    } else {
                        tranMgr.rollback();
                    }
                }
            }
            catch (Throwable failed) {
                FFDCFilter.processException((Throwable)failed, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"205", (Object)this, (Object[])new Object[]{failure, loader, consecutiveFailureCount, config, taskName});
                retry = true;
            }
        }
        if (retry) {
            if (consecutiveFailureCount == 1 || config.retryInterval == 0L) {
                this.persistentExecutor.scheduledExecutor.submit(this);
            } else {
                this.persistentExecutor.scheduledExecutor.schedule(this, config.retryInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @ManualTrace
    public void run() {
        block176: {
            block174: {
                block173: {
                    block172: {
                        block171: {
                            block177: {
                                trace = TraceComponent.isAnyTracingEnabled();
                                if (trace && InvokerTask.tc.isEntryEnabled()) {
                                    Tr.entry((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object[])new Object[]{this.persistentExecutor});
                                }
                                config = this.persistentExecutor.configRef.get();
                                if (this.persistentExecutor.deactivated || !config.enableTaskExecution) {
                                    if (trace && InvokerTask.tc.isEntryEnabled()) {
                                        Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)(this.persistentExecutor.deactivated != false ? "deactivated" : "enableTaskExecution? " + config.enableTaskExecution));
                                    }
                                    return;
                                }
                                execTime = new Date().getTime();
                                if (execTime < this.expectedExecTime) {
                                    delay = this.expectedExecTime - execTime;
                                    this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                                    if (trace && InvokerTask.tc.isEntryEnabled()) {
                                        Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)("attempted to run " + delay + " ms too early. Rescheduled."));
                                    }
                                    return;
                                }
                                if (this.persistentExecutor.deferExecutionForConfigUpdate(this)) {
                                    if (trace && InvokerTask.tc.isEntryEnabled()) {
                                        Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)"attempted to run during a configuration update.");
                                    }
                                    return;
                                }
                                taskName = null;
                                taskIdForPropTable = null;
                                ejbSingletonLockCollaborator = null;
                                ownerForDeferredTask = null;
                                loader = null;
                                failure = null;
                                prevFailureCount = null;
                                nextFailureCount = null;
                                nextExecTime /* !! */  = null;
                                taskStore = this.persistentExecutor.taskStore;
                                appTracker = (ApplicationTracker)this.persistentExecutor.appTrackerRef.getServiceWithException();
                                tranMgr = (TransactionManager)this.persistentExecutor.tranMgrRef.getServiceWithException();
                                InvokerTask.taskIdsOfRunningTasks.set(this.taskId);
                                timeout = this.txTimeout == 0 && (this.binaryFlags & TaskRecord.Flags.SUSPEND_TRAN_OF_EXECUTOR_THREAD.bit) != 0 ? 1800 : this.txTimeout;
                                tranMgr.setTransactionTimeout(timeout);
                                ejbSingletonRecord = null;
                                if ((this.binaryFlags & TaskRecord.Flags.EJB_SINGLETON.bit) != 0 && (this.binaryFlags & TaskRecord.Flags.SUSPEND_TRAN_OF_EXECUTOR_THREAD.bit) == 0) {
                                    tranMgr.begin();
                                    ejbSingletonRecord = taskStore.getTrigger(this.taskId);
                                    tranMgr.commit();
                                }
                                tranMgr.begin();
                                if ((this.binaryFlags & TaskRecord.Flags.SUSPEND_TRAN_OF_EXECUTOR_THREAD.bit) == 0) break block177;
                                taskIdForPropTable = "{" + this.taskId + "}";
                                if (!taskStore.createProperty(taskIdForPropTable, " ")) {
                                    throw new IllegalStateException(taskIdForPropTable);
                                }
                                suspendedTran = tranMgr.suspend();
                                try {
                                    failed = null;
                                    tranMgr.begin();
                                    try {
                                        taskRecord = taskStore.find(this.taskId, this.persistentExecutor.getPartitionId(), new Date().getTime(), false);
                                        ** GOTO lbl123
                                    }
                                    catch (Throwable var22_32) {
                                        FFDCFilter.processException((Throwable)var22_32, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"294", (Object)this, (Object[])new Object[0]);
                                        failed = x;
                                        throw failed;
                                    }
                                    finally {
                                        if (failed == null) {
                                            tranMgr.commit();
                                        } else {
                                            tranMgr.rollback();
                                        }
                                    }
                                }
                                finally {
                                    tranMgr.resume(suspendedTran);
                                }
                            }
                            if (ejbSingletonRecord == null) ** GOTO lbl122
                            owner = ejbSingletonRecord.getIdentifierOfOwner();
                            if (appTracker.isStarted(owner)) break block171;
                            ownerForDeferredTask = owner;
                            if (trace && InvokerTask.tc.isEntryEnabled()) {
                                Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)"unavailable - deferred");
                            }
                            if (ejbSingletonLockCollaborator != null) {
                                ejbSingletonLockCollaborator.unlock();
                            }
                            InvokerTask.taskIdsOfRunningTasks.remove();
                            try {
                                tranMgr.setTransactionTimeout(0);
                                if (tranMgr.getStatus() == 1) {
                                    if (trace && InvokerTask.tc.isEventEnabled()) {
                                        Tr.event((Object)this, (TraceComponent)InvokerTask.tc, (String)"rolling back task execution attempt", (Object[])new Object[0]);
                                    }
                                    if (nextFailureCount == null || nextFailureCount == 0) {
                                        nextFailureCount = (short)(prevFailureCount == null ? 1 : (prevFailureCount < 32767 ? prevFailureCount + 1 : 32767));
                                    }
                                    tranMgr.rollback();
                                    if (config == null) {
                                        config = this.persistentExecutor.configRef.get();
                                    }
                                    this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                                } else {
                                    if (taskIdForPropTable != null) {
                                        taskStore.removeProperty(taskIdForPropTable);
                                    }
                                    tranMgr.commit();
                                    config = this.persistentExecutor.configRef.get();
                                    if (config.enableTaskExecution && nextExecTime /* !! */  != null && (config.pollInterval < 0L || nextExecTime /* !! */  <= new Date().getTime() + config.pollInterval)) {
                                        this.expectedExecTime = nextExecTime /* !! */ ;
                                        delay = nextExecTime /* !! */  - new Date().getTime();
                                        this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                                    } else if (ownerForDeferredTask != null) {
                                        appTracker.deferTask(this, ownerForDeferredTask, this.persistentExecutor);
                                    } else {
                                        this.persistentExecutor.inMemoryTaskIds.remove(this.taskId);
                                        if (failure != null) {
                                            taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
                                            Tr.warning((TraceComponent)InvokerTask.tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, nextFailureCount, failure});
                                        }
                                    }
                                }
                            }
                            catch (Throwable delay) {
                                FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"601", (Object)this, (Object[])new Object[0]);
                                if (failure != null) {
                                    failure = x;
                                }
                                this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                            }
                            return;
                        }
                        bytes = ejbSingletonRecord.getTrigger();
                        ejbSingletonLockCollaborator = (TaskLocker)this.persistentExecutor.deserialize(bytes, PrivHelper.getSystemClassLoader());
                        if (trace && InvokerTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)"notify EJB container to lock singleton", (Object[])new Object[0]);
                        }
                        ejbSingletonLockCollaborator.lock();
lbl122:
                        // 2 sources

                        taskRecord = taskStore.find(this.taskId, this.persistentExecutor.getPartitionId(), new Date().getTime(), true);
lbl123:
                        // 2 sources

                        if (taskRecord != null && (taskRecord.getState() & TaskState.ENDED.bit) == 0) break block172;
                        if (trace && InvokerTask.tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)"not appropriate to run task at this time");
                        }
                        if (ejbSingletonLockCollaborator != null) {
                            ejbSingletonLockCollaborator.unlock();
                        }
                        InvokerTask.taskIdsOfRunningTasks.remove();
                        try {
                            tranMgr.setTransactionTimeout(0);
                            if (tranMgr.getStatus() == 1) {
                                if (trace && InvokerTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)InvokerTask.tc, (String)"rolling back task execution attempt", (Object[])new Object[0]);
                                }
                                if (nextFailureCount == null || nextFailureCount == 0) {
                                    nextFailureCount = (short)(prevFailureCount == null ? 1 : (prevFailureCount < 32767 ? prevFailureCount + 1 : 32767));
                                }
                                tranMgr.rollback();
                                if (config == null) {
                                    config = this.persistentExecutor.configRef.get();
                                }
                                this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                            } else {
                                if (taskIdForPropTable != null) {
                                    taskStore.removeProperty(taskIdForPropTable);
                                }
                                tranMgr.commit();
                                config = this.persistentExecutor.configRef.get();
                                if (config.enableTaskExecution && nextExecTime /* !! */  != null && (config.pollInterval < 0L || nextExecTime /* !! */  <= new Date().getTime() + config.pollInterval)) {
                                    this.expectedExecTime = nextExecTime /* !! */ ;
                                    delay = nextExecTime /* !! */  - new Date().getTime();
                                    this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                                } else if (ownerForDeferredTask != null) {
                                    appTracker.deferTask(this, ownerForDeferredTask, this.persistentExecutor);
                                } else {
                                    this.persistentExecutor.inMemoryTaskIds.remove(this.taskId);
                                    if (failure != null) {
                                        taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
                                        Tr.warning((TraceComponent)InvokerTask.tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, nextFailureCount, failure});
                                    }
                                }
                            }
                        }
                        catch (Throwable delay) {
                            FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"601", (Object)this, (Object[])new Object[0]);
                            if (failure != null) {
                                failure = x;
                            }
                            this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                        }
                        return;
                    }
                    taskName = taskRecord.getName();
                    prevFailureCount = taskRecord.getConsecutiveFailureCount();
                    classLoaderIdentifier = taskRecord.getIdentifierOfClassLoader();
                    if (trace && InvokerTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)"classloader identifier", (Object[])new Object[]{classLoaderIdentifier});
                    }
                    v0 = loader = ejbSingletonRecord == null ? this.persistentExecutor.classloaderIdSvc.getClassLoader(classLoaderIdentifier) : PrivHelper.getSystemClassLoader();
                    if (trace && InvokerTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)"classloader", (Object[])new Object[]{loader});
                    }
                    owner = taskRecord.getIdentifierOfOwner();
                    if (loader != null && appTracker.isStarted(owner)) break block173;
                    ownerForDeferredTask = owner;
                    if (trace && InvokerTask.tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)"unavailable - deferred");
                    }
                    if (ejbSingletonLockCollaborator != null) {
                        ejbSingletonLockCollaborator.unlock();
                    }
                    InvokerTask.taskIdsOfRunningTasks.remove();
                    try {
                        tranMgr.setTransactionTimeout(0);
                        if (tranMgr.getStatus() == 1) {
                            if (trace && InvokerTask.tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)InvokerTask.tc, (String)"rolling back task execution attempt", (Object[])new Object[0]);
                            }
                            if (nextFailureCount == null || nextFailureCount == 0) {
                                nextFailureCount = (short)(prevFailureCount == null ? 1 : (prevFailureCount < 32767 ? prevFailureCount + 1 : 32767));
                            }
                            tranMgr.rollback();
                            if (config == null) {
                                config = this.persistentExecutor.configRef.get();
                            }
                            this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                        } else {
                            if (taskIdForPropTable != null) {
                                taskStore.removeProperty(taskIdForPropTable);
                            }
                            tranMgr.commit();
                            config = this.persistentExecutor.configRef.get();
                            if (config.enableTaskExecution && nextExecTime /* !! */  != null && (config.pollInterval < 0L || nextExecTime /* !! */  <= new Date().getTime() + config.pollInterval)) {
                                this.expectedExecTime = nextExecTime /* !! */ ;
                                delay = nextExecTime /* !! */  - new Date().getTime();
                                this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                            } else if (ownerForDeferredTask != null) {
                                appTracker.deferTask(this, ownerForDeferredTask, this.persistentExecutor);
                            } else {
                                this.persistentExecutor.inMemoryTaskIds.remove(this.taskId);
                                if (failure != null) {
                                    taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
                                    Tr.warning((TraceComponent)InvokerTask.tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, nextFailureCount, failure});
                                }
                            }
                        }
                    }
                    catch (Throwable delay) {
                        FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"601", (Object)this, (Object[])new Object[0]);
                        if (failure != null) {
                            failure = x;
                        }
                        this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                    }
                    return;
                }
                info = (TaskInfo)this.persistentExecutor.deserialize(taskRecord.getTaskInformation(), null);
                triggerBytes = taskRecord.getTrigger();
                v1 = triggerBytes == null ? null : (trigger = ejbSingletonRecord != null && Arrays.equals(triggerBytes, ejbSingletonRecord.getTrigger()) != false ? ejbSingletonLockCollaborator : (Trigger)this.persistentExecutor.deserialize(triggerBytes, loader));
                if (trigger == null && (triggerClassName = info.getClassNameForNonSerializableTrigger()) != null) {
                    trigger = (Trigger)loader.loadClass(triggerClassName).newInstance();
                }
                v2 = task = (taskBytes = taskRecord.getTask()) == null ? null : this.persistentExecutor.deserialize(taskBytes, loader);
                if (task == null) {
                    taskClassName = info.getClassNameForNonSerializableTask();
                    task = taskClassName == null ? trigger : loader.loadClass(taskClassName).newInstance();
                }
                resultBytes = taskRecord.getResult();
                skipped = false;
                skippedX = null;
                lastExecution = null;
                startTime = 0L;
                stopTime = 0L;
                result = null;
                execProps = this.persistentExecutor.getExecutionProperties(task);
                threadContext = info.deserializeThreadContext(execProps);
                contextAppliedToThread = threadContext == null ? null : threadContext.taskStarting();
                try {
                    if (trigger != null) {
                        prevScheduledStart = taskRecord.getPreviousScheduledStartTime();
                        if (prevScheduledStart != null) {
                            lastExecution = new LastExecutionImpl(this.persistentExecutor, this.taskId, taskName, resultBytes, taskRecord.getPreviousStopTime(), taskRecord.getPreviousStartTime(), prevScheduledStart, loader);
                        }
                        try {
                            skipped = trigger.skipRun(lastExecution, new Date(taskRecord.getNextExecutionTime()));
                        }
                        catch (RuntimeException var40_56) {
                            FFDCFilter.processException((Throwable)var40_56, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"402", (Object)this, (Object[])new Object[0]);
                            skipped = true;
                            skippedX = x;
                        }
                    }
                    if (skipped) {
                        if (trace && InvokerTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)"skipping task", (Object[])new Object[]{skippedX});
                        }
                        nextExecTime /* !! */  = (nextExecDate = trigger.getNextRunTime(lastExecution, new Date(taskRecord.getOriginalSubmitTime()))) == null ? null : Long.valueOf(nextExecDate.getTime());
                        break block174;
                    }
                    if (!info.isSubmittedAsCallable() && info.getInterval() == -1L && trigger == null && resultBytes != null) {
                        result = this.persistentExecutor.deserialize(resultBytes, loader);
                    }
                    if (trace && InvokerTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)("task about to start " + task), (Object[])new Object[0]);
                    }
                    startTime = new Date().getTime();
                    try {
                        if (info.isSubmittedAsCallable()) {
                            result = ((Callable)task).call();
                        } else {
                            ((Runnable)task).run();
                        }
                        if (trace && InvokerTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)("task result " + result), (Object[])new Object[0]);
                        }
                        nextFailureCount = (short)0;
                    }
                    catch (Throwable nextExecDate) {
                        FFDCFilter.processException((Throwable)nextExecDate, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"431", (Object)this, (Object[])new Object[0]);
                        if (trace && InvokerTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)"task failed", (Object[])new Object[]{x});
                        }
                        failure = x;
                        nextFailureCount = (short)(prevFailureCount < 32767 ? prevFailureCount + 1 : 32767);
                        config = this.persistentExecutor.configRef.get();
                        if (config.retryLimit == -1 || nextFailureCount <= config.retryLimit) {
                            throw failure;
                        }
                    }
                    finally {
                        stopTime = new Date().getTime();
                    }
                    if (failure == null) {
                        interval = info.getInterval();
                        if (interval == -1L) {
                            nextExecTime /* !! */  = trigger == null ? null : ((nextExecDate = trigger.getNextRunTime(lastExecution = new LastExecutionImpl(this.persistentExecutor, this.taskId, taskName, result, stopTime, startTime, taskRecord.getNextExecutionTime()), new Date(taskRecord.getOriginalSubmitTime()))) == null ? null : Long.valueOf(nextExecDate.getTime()));
                        } else if (info.isFixedRate()) {
                            originalScheduledStartTime = taskRecord.getOriginalSubmitTime() + info.getInitialDelay();
                            elapsed = stopTime - originalScheduledStartTime;
                            nextExecTime /* !! */  = (elapsed / interval + 1L) * interval + originalScheduledStartTime;
                        } else {
                            nextExecTime /* !! */  = stopTime + interval;
                        }
                    }
                }
                finally {
                    if (contextAppliedToThread != null) {
                        threadContext.taskStopping(contextAppliedToThread);
                    }
                }
            }
            v3 = autoPurgeBit = failure == null ? TaskRecord.Flags.AUTO_PURGE_ON_SUCCESS.bit : TaskRecord.Flags.AUTO_PURGE_ALWAYS.bit;
            if ((nextExecTime /* !! */  == null || !skipped && nextFailureCount > 0) && (this.binaryFlags & autoPurgeBit) != 0) {
                taskStore.remove(this.taskId, null, false);
            } else {
                updates = new TaskRecord(false);
                if (nextExecTime /* !! */  != null) {
                    updates.setNextExecutionTime(nextExecTime /* !! */ );
                }
                v4 = state = nextExecTime /* !! */  == null ? (short)(TaskState.ENDED.bit | TaskState.SUCCESSFUL.bit) : TaskState.SCHEDULED.bit;
                if (skipped) {
                    state = (short)(state | TaskState.SKIPPED.bit);
                    if (skippedX != null) {
                        state = (short)(state | TaskState.SKIPRUN_FAILED.bit);
                        previousResultBytes = this.persistentExecutor.serialize(lastExecution == null ? null : lastExecution.getResult());
                        updates.setResult(this.persistentExecutor.serialize(new TaskSkipped(previousResultBytes, skippedX, loader, this.persistentExecutor)));
                    }
                } else {
                    updates.setConsecutiveFailureCount(nextFailureCount);
                    updates.setPreviousScheduledStartTime(taskRecord.getNextExecutionTime());
                    updates.setPreviousStartTime(startTime);
                    updates.setPreviousStopTime(stopTime);
                    if (failure == null) {
                        v5 = updatedResultBytes = result == null ? null : this.serializeResult(result, loader);
                        if (updatedResultBytes == null || !Arrays.equals(resultBytes, updatedResultBytes)) {
                            updates.setResult(updatedResultBytes);
                        }
                    } else {
                        updates.setResult(this.persistentExecutor.serialize(new TaskFailure(failure, loader, this.persistentExecutor, 1, new String[]{Short.toString(nextFailureCount)})));
                        state = (short)(TaskState.ENDED.bit | TaskState.FAILURE_LIMIT_REACHED.bit);
                    }
                }
                updates.setState(state);
                if (taskBytes != null && !Arrays.equals(taskBytes, updatedTaskBytes = this.persistentExecutor.serialize(task))) {
                    updates.setTask(updatedTaskBytes);
                }
                if (triggerBytes != null && !Arrays.equals(triggerBytes, updatedTriggerBytes = this.persistentExecutor.serialize(trigger))) {
                    updates.setTrigger(updatedTriggerBytes);
                }
                expected = new TaskRecord(false);
                expected.setId(this.taskId);
                expected.setVersion(taskRecord.getVersion());
                updatesPersisted = taskStore.persist(updates, expected);
                if (!updatesPersisted && (taskRecordRefresh = taskStore.findById(this.taskId, null, false)) != null) {
                    refreshedState = taskRecordRefresh.getState();
                    if ((refreshedState & TaskState.CANCELED.bit) != 0 && (this.binaryFlags & TaskRecord.Flags.SUSPEND_TRAN_OF_EXECUTOR_THREAD.bit) == 0) {
                        state = refreshedState;
                        updates.setState(state);
                        expected.setVersion(taskRecordRefresh.getVersion());
                        taskStore.persist(updates, expected);
                    } else if ((refreshedState & TaskState.SUSPENDED.bit) != 0) {
                        state = (short)(state | TaskState.SUSPENDED.bit);
                        state = (short)(state & ~TaskState.SCHEDULED.bit);
                        expected.setVersion(taskRecordRefresh.getVersion());
                        taskStore.persist(updates, expected);
                    }
                }
            }
            if (ejbSingletonLockCollaborator != null) {
                ejbSingletonLockCollaborator.unlock();
            }
            InvokerTask.taskIdsOfRunningTasks.remove();
            try {
                tranMgr.setTransactionTimeout(0);
                if (tranMgr.getStatus() == 1) {
                    if (trace && InvokerTask.tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)InvokerTask.tc, (String)"rolling back task execution attempt", (Object[])new Object[0]);
                    }
                    if (nextFailureCount == null || nextFailureCount == 0) {
                        nextFailureCount = (short)(prevFailureCount == null ? 1 : (prevFailureCount < 32767 ? prevFailureCount + 1 : 32767));
                    }
                    tranMgr.rollback();
                    if (config == null) {
                        config = this.persistentExecutor.configRef.get();
                    }
                    this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                } else {
                    if (taskIdForPropTable != null) {
                        taskStore.removeProperty(taskIdForPropTable);
                    }
                    tranMgr.commit();
                    config = this.persistentExecutor.configRef.get();
                    if (config.enableTaskExecution && nextExecTime /* !! */  != null && (config.pollInterval < 0L || nextExecTime /* !! */  <= new Date().getTime() + config.pollInterval)) {
                        this.expectedExecTime = nextExecTime /* !! */ ;
                        delay = nextExecTime /* !! */  - new Date().getTime();
                        this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                    } else if (ownerForDeferredTask != null) {
                        appTracker.deferTask(this, ownerForDeferredTask, this.persistentExecutor);
                    } else {
                        this.persistentExecutor.inMemoryTaskIds.remove(this.taskId);
                        if (failure != null) {
                            taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
                            Tr.warning((TraceComponent)InvokerTask.tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, nextFailureCount, failure});
                        }
                    }
                }
                break block176;
            }
            catch (Throwable delay) {
                FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"601", (Object)this, (Object[])new Object[0]);
                if (failure != null) {
                    failure = x;
                }
                this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
            }
            break block176;
            catch (Throwable x) {
                try {
                    FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"547", (Object)this, (Object[])new Object[0]);
                    if (trace && InvokerTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)InvokerTask.tc, (String)"marking transaction to roll back in response to error", (Object[])new Object[]{x});
                    }
                    try {
                        tranMgr.setRollbackOnly();
                    }
                    catch (Throwable var18_24) {
                        FFDCFilter.processException((Throwable)var18_24, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"552", (Object)this, (Object[])new Object[0]);
                    }
                    if (failure == null) {
                        failure = x;
                    }
                    if (ejbSingletonLockCollaborator != null) {
                        ejbSingletonLockCollaborator.unlock();
                    }
                    InvokerTask.taskIdsOfRunningTasks.remove();
                }
                catch (Throwable var46_68) {
                    if (ejbSingletonLockCollaborator != null) {
                        ejbSingletonLockCollaborator.unlock();
                    }
                    InvokerTask.taskIdsOfRunningTasks.remove();
                    try {
                        tranMgr.setTransactionTimeout(0);
                        if (tranMgr.getStatus() == 1) {
                            if (trace && InvokerTask.tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)InvokerTask.tc, (String)"rolling back task execution attempt", (Object[])new Object[0]);
                            }
                            if (nextFailureCount == null || nextFailureCount == 0) {
                                nextFailureCount = (short)(prevFailureCount == null ? 1 : (prevFailureCount < 32767 ? prevFailureCount + 1 : 32767));
                            }
                            tranMgr.rollback();
                            if (config == null) {
                                config = this.persistentExecutor.configRef.get();
                            }
                            this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                        } else {
                            if (taskIdForPropTable != null) {
                                taskStore.removeProperty(taskIdForPropTable);
                            }
                            tranMgr.commit();
                            config = this.persistentExecutor.configRef.get();
                            if (config.enableTaskExecution && nextExecTime /* !! */  != null && (config.pollInterval < 0L || nextExecTime /* !! */  <= new Date().getTime() + config.pollInterval)) {
                                this.expectedExecTime = nextExecTime /* !! */ ;
                                delay = nextExecTime /* !! */  - new Date().getTime();
                                this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                            } else if (ownerForDeferredTask != null) {
                                appTracker.deferTask(this, ownerForDeferredTask, this.persistentExecutor);
                            } else {
                                this.persistentExecutor.inMemoryTaskIds.remove(this.taskId);
                                if (failure != null) {
                                    taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
                                    Tr.warning((TraceComponent)InvokerTask.tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, nextFailureCount, failure});
                                }
                            }
                        }
                    }
                    catch (Throwable delay) {
                        FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"601", (Object)this, (Object[])new Object[0]);
                        if (failure != null) {
                            failure = x;
                        }
                        this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                    }
                    throw var46_68;
                }
                try {
                    tranMgr.setTransactionTimeout(0);
                    if (tranMgr.getStatus() == 1) {
                        if (trace && InvokerTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)InvokerTask.tc, (String)"rolling back task execution attempt", (Object[])new Object[0]);
                        }
                        if (nextFailureCount == null || nextFailureCount == 0) {
                            nextFailureCount = (short)(prevFailureCount == null ? 1 : (prevFailureCount < 32767 ? prevFailureCount + 1 : 32767));
                        }
                        tranMgr.rollback();
                        if (config == null) {
                            config = this.persistentExecutor.configRef.get();
                        }
                        this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                    } else {
                        if (taskIdForPropTable != null) {
                            taskStore.removeProperty(taskIdForPropTable);
                        }
                        tranMgr.commit();
                        config = this.persistentExecutor.configRef.get();
                        if (config.enableTaskExecution && nextExecTime /* !! */  != null && (config.pollInterval < 0L || nextExecTime /* !! */  <= new Date().getTime() + config.pollInterval)) {
                            this.expectedExecTime = nextExecTime /* !! */ ;
                            delay = nextExecTime /* !! */  - new Date().getTime();
                            this.persistentExecutor.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                        } else if (ownerForDeferredTask != null) {
                            appTracker.deferTask(this, ownerForDeferredTask, this.persistentExecutor);
                        } else {
                            this.persistentExecutor.inMemoryTaskIds.remove(this.taskId);
                            if (failure != null) {
                                taskName = taskName == null || taskName.length() == 0 || taskName.length() == 1 && taskName.charAt(0) == ' ' ? String.valueOf(this.taskId) : this.taskId + " (" + taskName + ")";
                                Tr.warning((TraceComponent)InvokerTask.tc, (String)"CWWKC1511.retry.limit.reached.failed", (Object[])new Object[]{this.persistentExecutor.name, taskName, nextFailureCount, failure});
                            }
                        }
                    }
                }
                catch (Throwable delay) {
                    FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.concurrent.persistent.internal.InvokerTask", (String)"601", (Object)this, (Object[])new Object[0]);
                    if (failure != null) {
                        failure = x;
                    }
                    this.processRetryableTaskFailure(failure, loader, nextFailureCount, config, taskName);
                }
            }
        }
        if (trace && InvokerTask.tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)InvokerTask.tc, (String)("run[" + this.taskId + ']'), (Object)failure);
        }
    }

    @Sensitive
    @FFDCIgnore(value={Throwable.class})
    private byte[] serializeResult(Object result, ClassLoader loader) throws IOException {
        try {
            return this.persistentExecutor.serialize(result);
        }
        catch (Throwable x) {
            return this.persistentExecutor.serialize(new TaskFailure(x, loader, this.persistentExecutor, 2, result.getClass().getName()));
        }
    }
}

