/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.utility;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SubjectHelper {
    private static final TraceComponent tc = Tr.register(SubjectHelper.class);
    static final long serialVersionUID = -892250569803095632L;

    public boolean isUnauthenticated(Subject subject) {
        if (subject == null) {
            return true;
        }
        WSCredential wsCred = this.getWSCredential(subject);
        if (wsCred == null) {
            return true;
        }
        return wsCred.isUnauthenticated();
    }

    public String getRealm(Subject subject) throws Exception {
        String realm = null;
        WSCredential credential = this.getWSCredential(subject);
        if (credential != null) {
            realm = credential.getRealmName();
        }
        return realm;
    }

    public WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    public Hashtable<String, ?> getHashtableFromSubject(final Subject subject, final String[] properties) {
        return (Hashtable)AccessController.doPrivileged(new PrivilegedAction<Hashtable<String, ?>>(){
            static final long serialVersionUID = 8403741094066435368L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Hashtable<String, ?> run() {
                Set<Object> list_private;
                Hashtable hashtableFromPrivate;
                Set<Object> list_public;
                Hashtable hashtableFromPublic;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in public cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPublic = SubjectHelper.this.getHashtable(list_public = subject.getPublicCredentials(), properties)) != null) {
                    return hashtableFromPublic;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in private cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPrivate = SubjectHelper.this.getHashtable(list_private = subject.getPrivateCredentials(), properties)) != null) {
                    return hashtableFromPrivate;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private Hashtable<String, ?> getHashtable(Set<Object> creds, String[] properties) {
        int i = 0;
        for (Object cred : creds) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Object[" + i + "] in credential list: " + cred), (Object[])new Object[0]);
            }
            if (cred instanceof Hashtable) {
                for (int j = 0; j < properties.length; ++j) {
                    if (((Hashtable)cred).get(properties[j]) == null) continue;
                    return (Hashtable)cred;
                }
            }
            ++i;
        }
        return null;
    }

    public static GSSCredential getGSSCredentialFromSubject(final Subject subject) {
        KerberosTicket tgt;
        if (subject == null) {
            return null;
        }
        GSSCredential gssCredential = AccessController.doPrivileged(new PrivilegedAction<GSSCredential>(){
            static final long serialVersionUID = 1363074790083390286L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public GSSCredential run() {
                Iterator<GSSCredential> privCredItr;
                GSSCredential gssCredInSubject = null;
                Set<GSSCredential> privCredentials = subject.getPrivateCredentials(GSSCredential.class);
                if (privCredentials != null && (privCredItr = privCredentials.iterator()).hasNext()) {
                    gssCredInSubject = privCredItr.next();
                }
                return gssCredInSubject;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (gssCredential == null && (tgt = SubjectHelper.getKerberosTicketFromSubject(subject, null)) != null) {
            gssCredential = SubjectHelper.createGSSCredential(subject, tgt);
        }
        return gssCredential;
    }

    private static KerberosTicket getKerberosTicketFromSubject(final Subject subject, final String user) {
        KerberosTicket tgt = AccessController.doPrivileged(new PrivilegedAction<KerberosTicket>(){
            static final long serialVersionUID = -7146177311615792679L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public KerberosTicket run() {
                KerberosTicket kerberosTicketInSubject = null;
                Set<KerberosTicket> privCredentials = subject.getPrivateCredentials(KerberosTicket.class);
                if (privCredentials != null) {
                    for (KerberosTicket kTicket : privCredentials) {
                        if (user == null) {
                            return kTicket;
                        }
                        if (!kTicket.getClient().getName().startsWith(user)) continue;
                        return kTicket;
                    }
                }
                return kerberosTicketInSubject;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
        return tgt;
    }

    public static boolean isSpnTGTInSubject(Subject subject, String user) {
        boolean result = false;
        KerberosTicket tgt = SubjectHelper.getKerberosTicketFromSubject(subject, user);
        if (tgt != null) {
            result = true;
        }
        return result;
    }

    public static boolean isTGTInSubjectValid(Subject subject, String user) {
        boolean result = false;
        KerberosTicket tgt = SubjectHelper.getKerberosTicketFromSubject(subject, user);
        if (tgt != null) {
            return tgt.isCurrent();
        }
        return result;
    }

    private static GSSCredential createGSSCredential(Subject subject, final KerberosTicket ticket) {
        GSSCredential gssCred = null;
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){
            static final long serialVersionUID = 8133146334442070446L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                GSSCredential inGssCrd;
                block3: {
                    inGssCrd = null;
                    try {
                        String clientName = ticket.getClient().getName();
                        Oid krbOid = new Oid("1.2.840.113554.1.2.2");
                        if (clientName != null && clientName.length() > 0) {
                            GSSManager gssMgr = GSSManager.getInstance();
                            GSSName gssName = gssMgr.createName(clientName, GSSName.NT_USER_NAME, krbOid);
                            inGssCrd = gssMgr.createCredential(gssName.canonicalize(krbOid), Integer.MAX_VALUE, krbOid, 0);
                        }
                    }
                    catch (GSSException clientName) {
                        void e;
                        FFDCFilter.processException((Throwable)clientName, (String)"com.ibm.ws.security.authentication.utility.SubjectHelper$4", (String)"249", (Object)this, (Object[])new Object[0]);
                        if (!tc.isDebugEnabled()) break block3;
                        Tr.debug((TraceComponent)tc, (String)"getGSSCredential unexpected exception", (Object[])new Object[]{e});
                    }
                }
                return inGssCrd;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        };
        gssCred = (GSSCredential)WSSubject.doAs(subject, action);
        return gssCred;
    }

    @Sensitive
    public Hashtable<String, ?> getSensitiveHashtableFromSubject(final @Sensitive Subject subject, final @Sensitive String[] properties) {
        return (Hashtable)AccessController.doPrivileged(new PrivilegedAction<Hashtable<String, ?>>(){
            static final long serialVersionUID = -1290943062061820413L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Hashtable<String, ?> run() {
                Set<Object> list_private;
                Hashtable hashtableFromPrivate;
                Set<Object> list_public;
                Hashtable hashtableFromPublic;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in public cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPublic = SubjectHelper.this.getSensitiveHashtable(list_public = subject.getPublicCredentials(), properties)) != null) {
                    return hashtableFromPublic;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in private cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPrivate = SubjectHelper.this.getSensitiveHashtable(list_private = subject.getPrivateCredentials(), properties)) != null) {
                    return hashtableFromPrivate;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(5.class);
            }
        });
    }

    @Trivial
    private Hashtable<String, ?> getSensitiveHashtable(Set<Object> creds, String[] properties) {
        ArrayList<String> props = new ArrayList<String>();
        for (String property : properties) {
            props.add(property);
        }
        for (Object e : creds) {
            if (!(e instanceof Hashtable) || !((Hashtable)e).keySet().containsAll(props)) continue;
            return (Hashtable)e;
        }
        return null;
    }

    private static String setSystemProperty(final String propName, final String propValue) {
        String savedPropValue = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = -7798008994906597697L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String run() {
                String oldValue = System.getProperty(propName);
                System.setProperty(propName, propValue);
                return oldValue;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(6.class);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(propName + " property previous: " + (savedPropValue != null ? savedPropValue : "<null>") + " and now: " + propValue), (Object[])new Object[0]);
        }
        return savedPropValue;
    }
}

