/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal.eclipselink;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.persistence.internal.eclipselink.LogChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.platform.server.ServerLog;

@Trivial
public class Log
extends ServerLog {
    public static final String LOG_PREFIX = "eclipselink.ps";
    private static final String EMPTY_CHANNEL = "eclipselink.ps";
    private static final TraceComponent _tc = Tr.register(Log.class, (String)"persistenceService");
    private final Map<String, LogChannel> _channels = new ConcurrentHashMap<String, LogChannel>();

    public Log() {
        for (String category : SessionLog.loggerCatagories) {
            this._channels.put(category, new LogChannel("eclipselink.ps." + category));
        }
        this._channels.put("eclipselink.ps", new LogChannel("eclipselink.ps"));
    }

    @Trivial
    public void log(SessionLogEntry entry) {
        String category = entry.getNameSpace();
        int level = entry.getLevel();
        LogChannel channel = this.getLogChannel(category);
        if (channel.shouldLog(level)) {
            channel.log(entry, this.formatMessage(entry));
        }
    }

    @Trivial
    public boolean shouldLog(int level, String category) {
        return this.getLogChannel(category).shouldLog(level);
    }

    @Trivial
    private LogChannel getLogChannel(String category) {
        LogChannel channel;
        if (category == null) {
            category = "eclipselink.ps";
        }
        if ((channel = this._channels.get(category)) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Found an unmapped logging channel (" + category + ") in log(...). Possibly something wrong in EclipseLink, remapping to base channel."), (Object[])new Object[0]);
                channel = this._channels.get("eclipselink.ps");
            }
            channel = this._channels.get("eclipselink.ps");
        }
        return channel;
    }
}

