/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerForwarderDelegate;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerPipeline;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JMXSecurityMBeanServer
extends MBeanServerForwarderDelegate {
    private static final TraceComponent tc = Tr.register(JMXSecurityMBeanServer.class);
    static final String KEY_MBEAN_SERVER_PIPLINE = "mBeanServerPipeline";
    static final String KEY_SECURITY_SERVICE = "securityService";
    private final AtomicServiceReference<MBeanServerPipeline> pipelineRef = new AtomicServiceReference("mBeanServerPipeline");
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    final List<String> requiredRoles = new ArrayList<String>();
    static final long serialVersionUID = -1305311308773171573L;

    public JMXSecurityMBeanServer() {
        this.requiredRoles.add("Administrator");
    }

    protected synchronized void setMBeanServerPipeline(ServiceReference<MBeanServerPipeline> ref) {
        this.pipelineRef.setReference(ref);
    }

    protected synchronized void unsetMBeanServerPipeline(ServiceReference<MBeanServerPipeline> ref) {
        this.pipelineRef.unsetReference(ref);
    }

    protected synchronized void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected synchronized void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    private void insertJMXSecurityFilter() {
        MBeanServerPipeline pipeline = (MBeanServerPipeline)this.pipelineRef.getService();
        if (!pipeline.contains((MBeanServerForwarderDelegate)this)) {
            if (!pipeline.insert((MBeanServerForwarderDelegate)this) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Insertion of " + ((Object)((Object)this)).getClass().getCanonicalName() + " into MBeanServerPipeline failed"), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(((Object)((Object)this)).getClass().getCanonicalName() + " already exists in MBeanServerPipeline"), (Object[])new Object[0]);
        }
    }

    protected synchronized void activate(ComponentContext cc) {
        this.pipelineRef.activate(cc);
        this.securityServiceRef.activate(cc);
        this.insertJMXSecurityFilter();
    }

    private void removeJMXSecurityFilter() {
        MBeanServerPipeline pipeline = (MBeanServerPipeline)this.pipelineRef.getService();
        if (pipeline.contains((MBeanServerForwarderDelegate)this)) {
            if (!pipeline.remove((MBeanServerForwarderDelegate)this) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removal of " + ((Object)((Object)this)).getClass().getCanonicalName() + " into MBeanServerPipeline failed"), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(((Object)((Object)this)).getClass().getCanonicalName() + " already removed from MBeanServerPipeline"), (Object[])new Object[0]);
        }
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.removeJMXSecurityFilter();
        this.pipelineRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private boolean isAuthorized() {
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthorizationService authzService = securityService.getAuthorizationService();
        boolean isAuthorized = authzService.isAuthorized("com.ibm.ws.management.security.resource", this.requiredRoles, null);
        return isAuthorized;
    }

    private void throwAuthzException() throws SecurityException {
        SubjectManager subjectManager = new SubjectManager();
        String name = "UNAUTHENTICATED";
        if (subjectManager.getInvocationSubject() != null) {
            name = subjectManager.getInvocationSubject().getPrincipals().iterator().next().getName();
        }
        Tr.audit((TraceComponent)tc, (String)"MANAGEMENT_SECURITY_AUTHZ_FAILED", (Object[])new Object[]{name, "MBeanAccess", this.requiredRoles});
        String message = Tr.formatMessage((TraceComponent)tc, (String)"MANAGEMENT_SECURITY_AUTHZ_FAILED", (Object[])new Object[]{name, "MBeanAccess", this.requiredRoles});
        throw new SecurityException(message);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (!this.isAuthorized()) {
            this.throwAuthzException();
        }
        return super.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (!this.isAuthorized()) {
            this.throwAuthzException();
        }
        return super.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.isAuthorized()) {
            this.throwAuthzException();
        }
        super.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (!this.isAuthorized()) {
            this.throwAuthzException();
        }
        return super.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (!this.isAuthorized()) {
            this.throwAuthzException();
        }
        return super.invoke(name, operationName, params, signature);
    }
}

