/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.jca.adapter.WSManagedConnectionFactory;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.impl.ConnectionResults;
import com.ibm.ws.rsadapter.impl.DB2JCCHelper;
import com.ibm.ws.rsadapter.impl.DB2iNativeHelper;
import com.ibm.ws.rsadapter.impl.DB2iToolboxHelper;
import com.ibm.ws.rsadapter.impl.DataDirectConnectSQLServerHelper;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.DerbyHelper;
import com.ibm.ws.rsadapter.impl.DerbyNetworkClientHelper;
import com.ibm.ws.rsadapter.impl.InformixHelper;
import com.ibm.ws.rsadapter.impl.InformixJCCHelper;
import com.ibm.ws.rsadapter.impl.MicrosoftSQLServerHelper;
import com.ibm.ws.rsadapter.impl.OracleHelper;
import com.ibm.ws.rsadapter.impl.SybaseHelper;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import org.ietf.jgss.GSSCredential;
import org.osgi.framework.Version;

public class WSManagedConnectionFactoryImpl
extends WSManagedConnectionFactory
implements ValidatingManagedConnectionFactory,
FFDCSelfIntrospectable {
    private static final long serialVersionUID = -56589160441993572L;
    private static final AtomicInteger NUM_INITIALIZED = new AtomicInteger();
    public final ConnectorService connectorSvc;
    Properties defaultClientInfo = new Properties();
    private transient CommonDataSource dataSource;
    transient Class<?> dataSourceImplClass;
    final Class<? extends CommonDataSource> dataSourceInterface;
    transient DatabaseHelper helper;
    public final int instanceID;
    public final boolean isUCP;
    final ClassLoader jdbcDriverLoader;
    public int jdbcDriverSpecVersion;
    public final JDBCRuntimeVersion jdbcRuntime;
    transient PrintWriter logWriter;
    public boolean detectedMultithreadedAccess;
    private static TraceComponent tc = Tr.register(WSManagedConnectionFactoryImpl.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    boolean loggingEnabled;
    final AtomicLong fatalErrorCount = new AtomicLong();
    long oracleRACXARetryDelay;
    final AtomicLong oracleRACLastStale = new AtomicLong();
    boolean warnedAboutNonTransactionalDataSource;
    protected boolean loggedDbUowMessage = false;
    protected boolean loggedImmplicitTransactionFound = false;
    public boolean doArrayCleanup = true;
    public boolean doBlobCleanup = true;
    public boolean doClobCleanup = true;
    public boolean doXMLCleanup = true;
    public final AtomicReference<DSConfig> dsConfig;
    public boolean supportsGetNetworkTimeout;
    public boolean supportsGetSchema;
    boolean supportsGetTypeMap = true;
    boolean supportsIsReadOnly = true;
    boolean supportsUOWDetection;
    public final transient Set<Method> vendorMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean wasUsedToGetAConnection;

    public WSManagedConnectionFactoryImpl(AtomicReference<DSConfig> dsConfigRef, Class<? extends CommonDataSource> ifc, CommonDataSource ds, JDBCRuntimeVersion jdbcRuntime) throws Exception {
        com.ibm.ejs.ras.TraceComponent tracer;
        this.dsConfig = dsConfigRef;
        DSConfig config = this.dsConfig.get();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{dsConfigRef, ifc, jdbcRuntime});
        }
        this.connectorSvc = config.connectorSvc;
        this.jdbcRuntime = jdbcRuntime;
        this.instanceID = NUM_INITIALIZED.incrementAndGet();
        this.dataSourceImplClass = ds.getClass();
        this.dataSourceInterface = ifc;
        this.jdbcDriverLoader = PrivHelper.getClassLoader(this.dataSourceImplClass);
        this.supportsGetNetworkTimeout = this.supportsGetSchema = this.atLeastJDBCVersion(JDBCRuntimeVersion.VERSION_4_1);
        String dataSourceImplClassName = this.dataSourceImplClass.getName();
        this.isUCP = dataSourceImplClassName.charAt(2) == 'a' && dataSourceImplClassName.startsWith("oracle.ucp.jdbc.");
        this.createDatabaseHelper(config.vendorProps instanceof PropertyService ? ((PropertyService)config.vendorProps).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties");
        if ((config.supplementalJDBCTrace == null || config.supplementalJDBCTrace.booleanValue()) && (tracer = this.helper.getTracer()) != null && tracer.isDebugEnabled()) {
            try {
                ds = (CommonDataSource)this.getTraceableDataSource(ds);
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"supplemental tracing set for data source", (Object[])new Object[]{"Data source: " + ds, "Tracer: " + tracer});
            }
            catch (ResourceException e) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"error setting supplemental trace on data source", (Object[])new Object[]{"Data source: " + ds, e});
            }
        }
        this.dataSource = ds;
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public final Object createConnectionFactory(ConnectionManager connMgr) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"createConnectionFactory", (Object[])new Object[]{connMgr});
        }
        WSJdbcDataSource connFactory = new WSJdbcDataSource(this, (WSConnectionManager)connMgr);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createConnectionFactory", (Object)connFactory);
        }
        return connFactory;
    }

    public boolean atLeastJDBCVersion(Version ver) {
        return this.jdbcRuntime.getVersion().compareTo(ver) >= 0;
    }

    public final boolean beforeJDBCVersion(Version ver) {
        return this.jdbcRuntime.getVersion().compareTo(ver) < 0;
    }

    public final Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException();
    }

    private void createDatabaseHelper(String vPropsPid) throws Exception {
        String dsClassName = this.dataSourceImplClass.getName();
        if (dsClassName.startsWith("oracle.")) {
            this.helper = new OracleHelper(this);
        } else if (dsClassName.startsWith("com.ibm.as400.")) {
            this.helper = new DB2iToolboxHelper(this);
        } else if (dsClassName.startsWith("com.ibm.db2.jdbc.app.")) {
            this.helper = new DB2iNativeHelper(this);
        } else if (dsClassName.startsWith("com.microsoft.")) {
            this.helper = new MicrosoftSQLServerHelper(this);
        } else if (dsClassName.startsWith("com.ddtek.jdbcx.sqlserver.")) {
            this.helper = new DataDirectConnectSQLServerHelper(this);
        } else if (dsClassName.startsWith("com.informix.")) {
            this.helper = new InformixHelper(this);
        } else if (dsClassName.startsWith("com.sybase.")) {
            this.helper = new SybaseHelper(this);
        } else if (dsClassName.startsWith("org.apache.derby.jdbc.Client")) {
            this.helper = new DerbyNetworkClientHelper(this);
        } else if (dsClassName.startsWith("org.apache.derby.jdbc.Embedded")) {
            this.helper = new DerbyHelper(this);
        } else if (vPropsPid.length() > "com.ibm.ws.jdbc.dataSource.properties".length()) {
            String suffix = vPropsPid.substring("com.ibm.ws.jdbc.dataSource.properties".length() + 1);
            if (suffix.startsWith("oracle")) {
                this.helper = new OracleHelper(this);
            } else if (suffix.startsWith("db2.jcc")) {
                this.helper = new DB2JCCHelper(this);
            } else if (suffix.startsWith("db2.i.native")) {
                this.helper = new DB2iNativeHelper(this);
            } else if (suffix.startsWith("db2.i.toolbox")) {
                this.helper = new DB2iToolboxHelper(this);
            } else if (suffix.startsWith("microsoft.sqlserver")) {
                this.helper = new MicrosoftSQLServerHelper(this);
            } else if (suffix.startsWith("datadirect.sqlserver")) {
                this.helper = new DataDirectConnectSQLServerHelper(this);
            } else if (suffix.startsWith("informix.jcc")) {
                this.helper = new InformixJCCHelper(this);
            } else if (suffix.startsWith("informix")) {
                this.helper = new InformixHelper(this);
            } else if (suffix.startsWith("sybase")) {
                this.helper = new SybaseHelper(this);
            } else if (suffix.startsWith("derby.client")) {
                this.helper = new DerbyNetworkClientHelper(this);
            } else if (suffix.startsWith("derby.embedded")) {
                this.helper = new DerbyHelper(this);
            }
        }
        if (this.helper == null) {
            this.helper = dsClassName.startsWith("com.ibm.db2.jcc.") ? new DB2JCCHelper(this) : new DatabaseHelper(this);
        }
        if (this.helper.shouldTraceBeEnabled(this)) {
            this.helper.enableJdbcLogging(this);
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        String password;
        String userName;
        WSConnectionRequestInfoImpl cri;
        boolean isAnyTraceOn;
        Object credential;
        boolean useKerb;
        block17: {
            block18: {
                block16: {
                    useKerb = false;
                    credential = null;
                    isAnyTraceOn = TraceComponent.isAnyTracingEnabled();
                    if (isAnyTraceOn && tc.isEntryEnabled()) {
                        Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"createManagedConnection", (Object[])new Object[]{subject == null ? null : "subject", AdapterUtil.toString(cxRequestInfo)});
                    }
                    cri = cxRequestInfo == null ? new WSConnectionRequestInfoImpl() : (WSConnectionRequestInfoImpl)cxRequestInfo;
                    userName = null;
                    password = null;
                    if (subject != null) break block16;
                    password = cri.getPassword();
                    userName = cri.getUserName();
                    if (!isAnyTraceOn || !tc.isEventEnabled()) break block17;
                    if (userName == null) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using DataSource default user/password for authentication", (Object[])new Object[0]);
                    } else {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using ConnectionRequestInfo for authentication", (Object[])new Object[0]);
                    }
                    break block17;
                }
                if (isAnyTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Subject found.  Will try to use either PasswordCredentials or GenericCredentials ", (Object[])new Object[0]);
                }
                userName = null;
                password = null;
                int threadIdentitySupport = this.helper.getThreadIdentitySupport();
                boolean subjectHasUtokenCred = false;
                if (threadIdentitySupport != 0) {
                    if (isAnyTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"The JDBC Provider supports the use of Thread Identity for authentication.", (Object[])new Object[0]);
                    }
                    final Subject subj = subject;
                    Set<GenericCredential> privateGenericCredentials = null;
                    privateGenericCredentials = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Set<GenericCredential>>(){

                        @Override
                        public Set<GenericCredential> run() {
                            return subj.getPrivateCredentials(GenericCredential.class);
                        }
                    }) : subj.getPrivateCredentials(GenericCredential.class);
                    final Iterator<GenericCredential> iterator = privateGenericCredentials.iterator();
                    PrivilegedAction<GenericCredential> iterationAction = new PrivilegedAction<GenericCredential>(){

                        @Override
                        public GenericCredential run() {
                            return (GenericCredential)iterator.next();
                        }
                    };
                    GenericCredential genericCredential = null;
                    while (iterator.hasNext()) {
                        genericCredential = System.getSecurityManager() != null ? AccessController.doPrivileged(iterationAction) : iterator.next();
                        if (!genericCredential.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                        subjectHasUtokenCred = true;
                        break;
                    }
                    if (!subjectHasUtokenCred && threadIdentitySupport == 2) {
                        String message = "createManagedConnection() error: Jdbc Provider requires ThreadIdentitySupport, but no UTOKEN generic credential was found.";
                        DataStoreAdapterException resX = new DataStoreAdapterException("WS_INTERNAL_ERROR", null, ((Object)((Object)this)).getClass(), message);
                        throw resX;
                    }
                }
                if (!subjectHasUtokenCred) break block18;
                userName = null;
                password = null;
                if (!isAnyTraceOn || !tc.isEventEnabled()) break block17;
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using thread identity for authentication by the JDBC Provider's DataSource.", (Object[])new Object[0]);
                break block17;
            }
            final Iterator<Object> iter = subject.getPrivateCredentials().iterator();
            PrivilegedAction<Object> iterationAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return iter.next();
                }
            };
            while (iter.hasNext()) {
                credential = System.getSecurityManager() != null ? AccessController.doPrivileged(iterationAction) : iter.next();
                if (credential instanceof PasswordCredential) {
                    PasswordCredential pwcred = (PasswordCredential)credential;
                    if (!pwcred.getManagedConnectionFactory().equals((Object)this)) continue;
                    if (isAnyTraceOn && tc.isEventEnabled()) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using PasswordCredentials for authentication", (Object[])new Object[0]);
                    }
                    userName = pwcred.getUserName();
                    char[] pwdChars = pwcred.getPassword();
                    password = pwdChars == null ? null : new String(pwdChars);
                    break;
                }
                if (!(credential instanceof GSSCredential)) continue;
                useKerb = true;
                if (!isAnyTraceOn || !tc.isEventEnabled()) break;
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using GenericCredentials for authentication", (Object[])new Object[0]);
                break;
            }
        }
        WSRdbManagedConnectionImpl mc = null;
        ConnectionResults results = null;
        try {
            results = this.getConnection(userName, password, subject, cri, useKerb, credential);
            mc = new WSRdbManagedConnectionImpl(this, results.pooledConnection, results.connection, subject, cri);
            if (useKerb) {
                mc.setKerberosConnection();
            }
            if (isAnyTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createManagedConnection", (Object)mc);
            }
            return mc;
        }
        catch (ResourceException resX) {
            if (isAnyTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createManagedConnection", (Object)((Object)resX));
            }
            throw resX;
        }
    }

    private Connection getConnection(PooledConnection pconn, WSConnectionRequestInfoImpl cri, String userName) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{AdapterUtil.toString(pconn)});
        }
        Connection conn = null;
        boolean isConnectionSetupComplete = false;
        try {
            conn = pconn.getConnection();
            this.postGetConnectionHandling(conn);
            isConnectionSetupComplete = true;
        }
        catch (SQLException se) {
            FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"260", (Object)((Object)this));
            ResourceException x = AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)se);
            }
            throw x;
        }
        finally {
            if (!isConnectionSetupComplete) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (pconn != null) {
                    try {
                        pconn.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)AdapterUtil.toString(conn));
        }
        return conn;
    }

    private ConnectionResults getConnection(final String userName, final String password, final Subject subject, final WSConnectionRequestInfoImpl cri, boolean useKerb, final Object credential) throws ResourceException {
        ConnectionResults results;
        final boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{userName, subject == null ? null : "subject", AdapterUtil.toString(cri), useKerb, credential});
        }
        if (useKerb && this.helper.supportsSubjectDoAsForKerberos()) {
            try {
                final PrivilegedExceptionAction<ConnectionResults> getConnection = new PrivilegedExceptionAction<ConnectionResults>(){

                    @Override
                    public ConnectionResults run() throws ResourceException {
                        return WSManagedConnectionFactoryImpl.this.getConnection(userName, password, subject, cri, false, credential);
                    }
                };
                results = AccessController.doPrivileged(new PrivilegedExceptionAction<ConnectionResults>(){

                    @Override
                    public ConnectionResults run() throws Exception {
                        Subject copy = new Subject(subject.isReadOnly(), subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"running as subject", (Object[])new Object[]{copy});
                        }
                        return (ConnectionResults)Subject.doAs(copy, getConnection);
                    }
                });
            }
            catch (PrivilegedActionException privX) {
                Throwable x = privX.getCause();
                if (x instanceof PrivilegedActionException) {
                    x = x.getCause();
                }
                FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"1734", (Object)((Object)this));
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)x);
                }
                if (x instanceof ResourceException) {
                    throw (ResourceException)x;
                }
                throw new DataStoreAdapterException("GENERAL_EXCEPTION", null, ((Object)((Object)this)).getClass(), x.getMessage());
            }
        }
        if (DataSource.class.equals(this.dataSourceInterface) || this.isUCP) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Getting a connection using Datasource. Is UCP? " + this.isUCP), (Object[])new Object[0]);
            }
            Connection conn = this.getConnectionUsingDS(userName, password, cri);
            results = new ConnectionResults(null, conn);
        } else {
            try {
                results = this.helper.getPooledConnection(this.dataSource, userName, password, XADataSource.class.equals(this.dataSourceInterface), cri, useKerb, credential);
            }
            catch (DataStoreAdapterException dae) {
                throw (ResourceException)((Object)AdapterUtil.mapException((Exception)((Object)dae), null, (Object)this, false));
            }
            results.connection = this.getConnection(results.pooledConnection, cri, userName);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)results);
        }
        return results;
    }

    private final Connection getConnectionUsingDS(String userN, String password, final WSConnectionRequestInfoImpl cri) throws ResourceException {
        final boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object[])new Object[]{AdapterUtil.toString(this.dataSource), userN});
        }
        final String user = userN == null ? null : userN.trim();
        final String pwd = password == null ? null : password.trim();
        Connection conn = null;
        boolean isConnectionSetupComplete = false;
        try {
            conn = AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    Properties oracleProps = cri.getOracleProperties();
                    if (oracleProps != null) {
                        try {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"obtain Oracle data source with properties:", (Object[])new Object[]{oracleProps});
                            }
                            Object ods = WSJdbcTracer.getImpl(WSManagedConnectionFactoryImpl.this.dataSource);
                            Class dsClass = null;
                            dsClass = System.getSecurityManager() == null ? WSManagedConnectionFactoryImpl.this.jdbcDriverLoader.loadClass("oracle.jdbc.pool.OracleDataSource") : (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                                @Override
                                public Class<?> run() throws ClassNotFoundException {
                                    return WSManagedConnectionFactoryImpl.this.jdbcDriverLoader.loadClass("oracle.jdbc.pool.OracleDataSource");
                                }
                            });
                            Method method = dsClass.getMethod("getConnection", Properties.class);
                            return (Connection)method.invoke(ods, oracleProps.clone());
                        }
                        catch (InvocationTargetException x) {
                            throw x.getCause() instanceof Exception ? (Exception)x.getCause() : x;
                        }
                    }
                    if (WSManagedConnectionFactoryImpl.this.dataSource instanceof XADataSource) {
                        return user == null ? ((XADataSource)WSManagedConnectionFactoryImpl.this.dataSource).getXAConnection().getConnection() : ((XADataSource)WSManagedConnectionFactoryImpl.this.dataSource).getXAConnection(user, pwd).getConnection();
                    }
                    return user == null ? ((DataSource)WSManagedConnectionFactoryImpl.this.dataSource).getConnection() : ((DataSource)WSManagedConnectionFactoryImpl.this.dataSource).getConnection(user, pwd);
                }
            });
            try {
                this.postGetConnectionHandling(conn);
            }
            catch (SQLException se) {
                FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"260", (Object)((Object)this));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)se);
                }
                throw AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
            }
            isConnectionSetupComplete = true;
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)((Object)((Object)this)).getClass().getName(), (String)"1372");
            DataStoreAdapterException resX = new DataStoreAdapterException("JAVAX_CONN_ERR", pae.getException(), ((Object)((Object)this)).getClass(), "Connection");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)pae.getException());
            }
            throw resX;
        }
        catch (ClassCastException castX) {
            FFDCFilter.processException((Throwable)castX, (String)((Object)((Object)this)).getClass().getName(), (String)"1312");
            DataStoreAdapterException resX = new DataStoreAdapterException("NOT_A_1_PHASE_DS", null, ((Object)((Object)this)).getClass(), castX.getMessage());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)castX);
            }
            throw resX;
        }
        finally {
            if (conn != null && !isConnectionSetupComplete) {
                try {
                    conn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)AdapterUtil.toString(conn));
        }
        return conn;
    }

    public Set<ManagedConnection> getInvalidConnections(Set connectionSet) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getInvalidConnections", (Object[])new Object[]{connectionSet});
        }
        HashSet<ManagedConnection> badSet = new HashSet<ManagedConnection>();
        WSRdbManagedConnectionImpl mc2 = null;
        for (WSRdbManagedConnectionImpl mc2 : connectionSet) {
            if (mc2.validate()) continue;
            badSet.add((ManagedConnection)mc2);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getInvalidConnections", badSet);
        }
        return badSet;
    }

    private Object getTraceableDataSource(Object ds) throws ResourceException {
        WSJdbcTracer tracer = new WSJdbcTracer(this.helper.getTracer(), this.helper.getPrintWriter(), ds, this.dataSourceInterface, null, true);
        HashSet classes = new HashSet();
        for (Class<?> cl = ds.getClass(); cl != null; cl = cl.getSuperclass()) {
            classes.addAll(Arrays.asList(cl.getInterfaces()));
        }
        return Proxy.newProxyInstance(this.jdbcDriverLoader, classes.toArray(new Class[classes.size()]), (InvocationHandler)tracer);
    }

    public CommonDataSource getUnderlyingDataSource() throws SQLException {
        return this.dataSource;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        WSConnectionRequestInfoImpl finalCRI;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", (Object[])new Object[]{connectionSet == null ? null : Integer.valueOf(connectionSet.size()), subject == null ? null : "subject", cxRequestInfo});
        }
        if (connectionSet == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", null);
            }
            return null;
        }
        try {
            finalCRI = (WSConnectionRequestInfoImpl)cxRequestInfo;
        }
        catch (ClassCastException castX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", null);
            }
            return null;
        }
        WSRdbManagedConnectionImpl matchedmc = null;
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"the size of the set should be 1, and it is", (Object[])new Object[]{connectionSet.size()});
        }
        Iterator iter = connectionSet.iterator();
        WSRdbManagedConnectionImpl currentmc = (WSRdbManagedConnectionImpl)iter.next();
        if (currentmc._claimedVictim && finalCRI.isReconfigurable(currentmc.cri, true)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"mc is claimedVictim matched", (Object[])new Object[]{currentmc});
            }
            matchedmc = currentmc;
        } else if (subject == null) {
            if (currentmc.getSubject() == null && finalCRI.isReconfigurable(currentmc.cri, false)) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"mc matched", (Object[])new Object[]{currentmc});
                }
                matchedmc = currentmc;
            }
        } else {
            Subject _sub = currentmc.getSubject();
            if (_sub != null) {
                Equals e = new Equals();
                e.setSubjects(subject, _sub);
                if (AccessController.doPrivileged(e).booleanValue() && finalCRI.isReconfigurable(currentmc.cri, false)) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"mc matched", (Object[])new Object[]{currentmc});
                    }
                    matchedmc = currentmc;
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", (Object)matchedmc);
        }
        return matchedmc;
    }

    private void onConnect(Connection con, String[] sqlCommands) throws SQLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        EmbeddableWebSphereTransactionManager tm = this.connectorSvc.getTransactionManager();
        Transaction suspendedTx = null;
        String currentSQL = null;
        Throwable failure = null;
        try {
            UOWCoordinator coord;
            UOWCoordinator uOWCoordinator = coord = tm == null ? null : ((UOWCurrent)tm).getUOWCoord();
            if (coord != null && coord.isGlobal()) {
                suspendedTx = tm.suspend();
            }
            Statement stmt = con.createStatement();
            String[] stringArray = sqlCommands;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String sql;
                currentSQL = sql = stringArray[i];
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"execute onConnect SQL", (Object[])new Object[]{sql});
                }
                stmt.execute(sql);
            }
            stmt.close();
        }
        catch (Throwable x) {
            failure = x;
        }
        if (suspendedTx != null) {
            try {
                tm.resume(suspendedTx);
            }
            catch (Throwable x) {
                failure = x;
            }
        }
        if (failure != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"failed", (Object[])new Object[]{AdapterUtil.stackTraceToString(failure)});
            }
            throw new SQLNonTransientConnectionException(AdapterUtil.getNLSMessage("DSRA4004.onconnect.sql", currentSQL, this.dsConfig.get().id), "08000", 0, failure);
        }
    }

    private void postGetConnectionHandling(Connection conn) throws SQLException {
        this.helper.doConnectionSetup(conn);
        String[] sqlCommands = this.dsConfig.get().onConnect;
        if (sqlCommands != null && sqlCommands.length > 0) {
            this.onConnect(conn, sqlCommands);
        }
        if (!this.wasUsedToGetAConnection) {
            this.helper.gatherAndDisplayMetaDataInfo(conn, this);
            this.wasUsedToGetAConnection = true;
        }
    }

    public final void setLogWriter(PrintWriter out) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setLogWriter on the mcf is a no-op when calling this method", (Object[])new Object[0]);
        }
    }

    final void reallySetLogWriter(final PrintWriter out) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setting the logWriter to:", (Object[])new Object[]{out});
        }
        if (this.dataSource != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws SQLException {
                        WSManagedConnectionFactoryImpl.this.dataSource.setLogWriter(out);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                SQLException se = (SQLException)pae.getCause();
                FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"593", (Object)((Object)this));
                throw AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
            }
        }
        this.logWriter = out;
    }

    public String[] introspectSelf() {
        FFDCLogger info = new FFDCLogger((Object)this);
        info.append(this.dsConfig.get().introspectSelf());
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            info.append("Multithreaded access was detected?", this.detectedMultithreadedAccess);
        }
        info.append("DataSource Implementation Class:", this.dataSourceImplClass);
        info.append("DataSource interface:", this.dataSourceInterface);
        info.append("Underlying DataSource Object: " + AdapterUtil.toString(this.dataSource), this.dataSource);
        info.append("Instance id:", this.instanceID);
        info.append("Log Writer:", this.logWriter);
        info.append("Counter of fatal connection errors on ManagedConnections created by this MCF:", this.fatalErrorCount);
        return info.toStringArray();
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        if (this.dataSource == null) {
            return this.logWriter;
        }
        try {
            return this.dataSource.getLogWriter();
        }
        catch (SQLException se) {
            FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"1656", (Object)((Object)this));
            throw AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
        }
    }

    public final int getLoginTimeout() throws SQLException {
        try {
            return this.dataSource.getLoginTimeout();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)((Object)((Object)this)).getClass().getName(), (String)"1670", (Object)((Object)this));
            throw AdapterUtil.mapSQLException(sqlX, (Object)this);
        }
    }

    public DatabaseHelper getHelper() {
        return this.helper;
    }

    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        return this.helper.getCorrelator(mc);
    }

    public final Class<?> getDataSourceClass() {
        return this.dataSourceImplClass;
    }

    public final int getDefaultBranchCoupling() {
        return this.helper.getDefaultBranchCoupling();
    }

    public final int getXAStartFlagForBranchCoupling(int couplingType) {
        return this.helper.branchCouplingSupported(couplingType);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Version getJDBCRuntimeVersion() {
        return this.jdbcRuntime.getVersion();
    }

    public boolean isPooledConnectionValidationEnabled() {
        return this.jdbcDriverSpecVersion >= 40 && this.dsConfig.get().validationTimeout > -1;
    }

    static class Equals
    implements PrivilegedAction<Boolean> {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject s1, Subject s2) {
            this._s1 = s1;
            this._s2 = s2;
        }

        @Override
        public Boolean run() {
            boolean subjestsMatch = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Using adapter set equals", (Object[])new Object[0]);
            }
            if (this.checkCredentials(this._s1.getPrivateCredentials(), this._s2.getPrivateCredentials())) {
                subjestsMatch = this.checkCredentials(this._s1.getPublicCredentials(), this._s2.getPublicCredentials());
            }
            return subjestsMatch;
        }

        private boolean checkCredentials(Set<Object> s1Credentials, Set<Object> s2Credentials) {
            boolean rVal = false;
            if (s1Credentials != s2Credentials) {
                if (s1Credentials != null && s2Credentials != null) {
                    int it2size;
                    int it1size = s1Credentials.size();
                    if (it1size == (it2size = s2Credentials.size())) {
                        if (it1size == 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Processing credential sets, both are empty, They are equal", (Object[])new Object[0]);
                            }
                            return true;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Processing credential sets, sets do not contain the same number of elements. They are not equal", (Object[])new Object[0]);
                        }
                        return false;
                    }
                    if (it1size > 1) {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        int objectsEqual = 0;
                        block0: while (it1.hasNext()) {
                            Object s1Cred = it1.next();
                            for (Object s2Cred : s2Credentials) {
                                if (s1Cred != null ? !s1Cred.equals(s2Cred) : s2Cred != null) continue;
                                ++objectsEqual;
                                continue block0;
                            }
                        }
                        if (objectsEqual == it1size) {
                            rVal = true;
                        }
                    } else {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        Iterator<Object> it2 = s2Credentials.iterator();
                        Object s1Cred = it1.next();
                        Object s2Cred = it2.next();
                        if (s1Cred != null) {
                            if (!s1Cred.equals(s2Cred)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal", (Object[])new Object[0]);
                                }
                                return false;
                            }
                        } else if (s2Cred != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal, one objest is null", (Object[])new Object[0]);
                            }
                            return false;
                        }
                        rVal = true;
                    }
                }
            } else {
                rVal = true;
            }
            return rVal;
        }
    }
}

