/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.ConnectionRequestInfo;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;

public class WSConnectionRequestInfoImpl
implements ConnectionRequestInfo,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(WSConnectionRequestInfoImpl.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private boolean changable = false;
    String ivUserName;
    String ivPassword;
    int ivIsoLevel;
    String ivCatalog;
    Boolean ivReadOnly;
    Map<String, Class<?>> ivTypeMap;
    int ivHoldability;
    int ivConfigID;
    String ivSchema;
    int ivNetworkTimeout;
    String defaultCatalog;
    int defaultHoldability;
    Boolean defaultReadOnly;
    Map<String, Class<?>> defaultTypeMap;
    String defaultSchema;
    int defaultNetworkTimeout;
    Properties oracleProperties;
    GSSName gssName;
    GSSCredential gssCredential;
    boolean kerberosIdentityisSet;
    boolean kerberosMappingIsUsed;
    private int hashcode;
    private boolean hasIsolationLevelOnly;
    boolean supportIsolvlSwitching;

    WSConnectionRequestInfoImpl() {
        this.ivIsoLevel = 2;
        this.hasIsolationLevelOnly = true;
    }

    public WSConnectionRequestInfoImpl(int isolationLevel) {
        this.ivIsoLevel = isolationLevel;
        this.hasIsolationLevelOnly = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object[])new Object[]{this});
        }
    }

    public WSConnectionRequestInfoImpl(int isolationLevel, Properties props) {
        this.ivIsoLevel = isolationLevel;
        this.oracleProperties = props;
    }

    public WSConnectionRequestInfoImpl(int isolationLevel, boolean supportIsolationLvlSwitching) {
        this.ivIsoLevel = isolationLevel;
        this.supportIsolvlSwitching = supportIsolationLvlSwitching;
        this.hashcode = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object[])new Object[]{this});
        }
    }

    public WSConnectionRequestInfoImpl(String user, String password, int isolationLevel, int configID, boolean supportIsolationLvlSwitching) {
        this.ivUserName = user;
        this.ivPassword = password;
        this.ivIsoLevel = isolationLevel;
        this.ivConfigID = configID;
        this.supportIsolvlSwitching = supportIsolationLvlSwitching;
        this.hashcode = this.ivConfigID + (this.ivUserName == null ? 0 : this.ivUserName.hashCode()) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object[])new Object[]{this});
        }
    }

    public WSConnectionRequestInfoImpl(String user, String password, int isolationLevel, String catalog, Boolean isReadOnly, Map<String, Class<?>> typeMap, int holdability, String schema, int networkTimeout, int configID, boolean supportIslSwitching) {
        this.ivUserName = user;
        this.ivPassword = password;
        this.ivIsoLevel = isolationLevel;
        this.ivCatalog = catalog;
        this.ivReadOnly = isReadOnly;
        this.ivTypeMap = typeMap;
        this.ivSchema = schema;
        this.ivNetworkTimeout = networkTimeout;
        this.ivHoldability = holdability;
        this.ivConfigID = configID;
        this.supportIsolvlSwitching = supportIslSwitching;
        this.hashcode = this.ivConfigID + (this.ivUserName == null ? 0 : this.ivUserName.hashCode()) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object[])new Object[]{this});
        }
    }

    public final int getConfigID() {
        return this.ivConfigID;
    }

    public final String getUserName() {
        return this.ivUserName;
    }

    public final String getPassword() {
        return this.ivPassword;
    }

    public final int getIsolationLevel() {
        return this.ivIsoLevel;
    }

    public final String getCatalog() {
        return this.ivCatalog;
    }

    public final Map<String, Class<?>> getTypeMap() {
        return this.ivTypeMap;
    }

    public final int getHoldability() {
        return this.ivHoldability;
    }

    public final String getSchema() {
        return this.ivSchema;
    }

    public final int getNetworkTimeout() {
        return this.ivNetworkTimeout;
    }

    public final Properties getOracleProperties() {
        return this.oracleProperties;
    }

    public String[] introspectSelf() {
        FFDCLogger info = new FFDCLogger(this);
        info.append("changable CRI = ", this.changable);
        info.append("User Name:", this.ivUserName);
        info.append("Password:", this.ivPassword == null ? null : "******");
        info.append("Isolation Level:", AdapterUtil.getIsolationLevelString(this.ivIsoLevel));
        info.append("Catalog:", this.ivCatalog);
        info.append("Schema:", this.ivSchema);
        info.append("Is Read Only?", this.ivReadOnly);
        info.append("Type Map:", this.ivTypeMap);
        info.append("Cursor Holdability:", AdapterUtil.getCursorHoldabilityString(this.ivHoldability));
        info.append("Config ID: " + this.ivConfigID);
        info.append("Hash Code:", Integer.toHexString(this.hashcode));
        info.append("Support isolation switching on connection:", this.supportIsolvlSwitching);
        info.append("gssName = ").append(this.gssName == null ? null : this.gssName.toString());
        info.append("gssCredential = ").append(this.gssCredential == null ? null : this.gssCredential.toString());
        info.append("oracle properties = ").append(this.oracleProperties == null ? null : this.oracleProperties.toString());
        return info.toStringArray();
    }

    public final Boolean isReadOnly() {
        return this.ivReadOnly;
    }

    public final boolean isReconfigurable(WSConnectionRequestInfoImpl cri, boolean reauth) {
        if (reauth) {
            return this.ivConfigID == cri.ivConfigID;
        }
        return WSConnectionRequestInfoImpl.match(this.ivUserName, cri.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, cri.ivPassword) && this.ivConfigID == cri.ivConfigID;
    }

    public final boolean equals(Object arg0) {
        boolean result;
        if (arg0 == this) {
            result = true;
        } else if (arg0 == null) {
            result = false;
        } else {
            try {
                WSConnectionRequestInfoImpl wscri = (WSConnectionRequestInfoImpl)arg0;
                result = this.supportIsolvlSwitching ? this.hasIsolationLevelOnly && wscri.hasIsolationLevelOnly || WSConnectionRequestInfoImpl.match(this.ivUserName, wscri.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wscri.ivPassword) && WSConnectionRequestInfoImpl.match(this.oracleProperties, wscri.oracleProperties) && this.matchKerberosIdentities(wscri) && this.matchHoldability(wscri) && this.matchCatalog(wscri) && this.matchReadOnly(wscri) && this.matchTypeMap(wscri) && this.matchSchema(wscri) && this.matchNetworkTimeout(wscri) && this.ivConfigID == wscri.ivConfigID : this.ivIsoLevel == wscri.ivIsoLevel && (this.hasIsolationLevelOnly && wscri.hasIsolationLevelOnly || this.hashcode == wscri.hashcode && WSConnectionRequestInfoImpl.match(this.ivUserName, wscri.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wscri.ivPassword) && WSConnectionRequestInfoImpl.match(this.oracleProperties, wscri.oracleProperties) && this.matchKerberosIdentities(wscri) && this.matchHoldability(wscri) && this.matchCatalog(wscri) && this.matchReadOnly(wscri) && this.matchTypeMap(wscri) && this.matchSchema(wscri) && this.matchNetworkTimeout(wscri) && this.ivConfigID == wscri.ivConfigID);
            }
            catch (RuntimeException runtimeX) {
                result = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"equals?", (Object[])new Object[]{AdapterUtil.toString(this), AdapterUtil.toString(arg0), result ? Boolean.TRUE : Boolean.FALSE});
        }
        return result;
    }

    private boolean matchKerberosIdentities(WSConnectionRequestInfoImpl cri) {
        boolean flag = false;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"matchKerberosIdentities", (Object[])new Object[]{this, cri});
        }
        if (this.kerberosIdentityisSet && cri.kerberosIdentityisSet) {
            flag = AdapterUtil.matchGSSName(cri.gssName, this.gssName);
        } else if (this.kerberosIdentityisSet || cri.kerberosIdentityisSet) {
            flag = false;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"only one has kerberos identity attributes set so no match", (Object[])new Object[0]);
            }
        } else {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"both have kerberos identity attributes not set so match", (Object[])new Object[0]);
            }
            flag = true;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"matchKerberosIdentities", (Object)flag);
        }
        return flag;
    }

    private static final boolean match(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    private final boolean matchCatalog(WSConnectionRequestInfoImpl cri) {
        String defaultValue = this.defaultCatalog == null ? cri.defaultCatalog : this.defaultCatalog;
        return WSConnectionRequestInfoImpl.match(this.ivCatalog, cri.ivCatalog) || this.ivCatalog == null && WSConnectionRequestInfoImpl.match(defaultValue, cri.ivCatalog) || cri.ivCatalog == null && WSConnectionRequestInfoImpl.match(this.ivCatalog, defaultValue);
    }

    private final boolean matchSchema(WSConnectionRequestInfoImpl cri) {
        String defaultValue = this.defaultSchema == null ? cri.defaultSchema : this.defaultSchema;
        return WSConnectionRequestInfoImpl.match(this.ivSchema, cri.ivSchema) || this.ivSchema == null && WSConnectionRequestInfoImpl.match(defaultValue, cri.ivSchema) || cri.ivSchema == null && WSConnectionRequestInfoImpl.match(this.ivSchema, defaultValue);
    }

    private final boolean matchNetworkTimeout(WSConnectionRequestInfoImpl cri) {
        int defaultValue = this.defaultNetworkTimeout == 0 ? cri.defaultNetworkTimeout : this.defaultNetworkTimeout;
        return this.ivNetworkTimeout == cri.ivNetworkTimeout || this.ivNetworkTimeout == 0 && defaultValue == cri.ivNetworkTimeout || cri.ivNetworkTimeout == 0 && this.ivNetworkTimeout == defaultValue;
    }

    private final boolean matchHoldability(WSConnectionRequestInfoImpl cri) {
        int defaultValue = this.defaultHoldability == 0 ? cri.defaultHoldability : this.defaultHoldability;
        return this.ivHoldability == cri.ivHoldability || this.ivHoldability == 0 && WSConnectionRequestInfoImpl.match(defaultValue, cri.ivHoldability) || cri.ivHoldability == 0 && WSConnectionRequestInfoImpl.match(this.ivHoldability, defaultValue);
    }

    private final boolean matchReadOnly(WSConnectionRequestInfoImpl cri) {
        Boolean defaultValue = this.defaultReadOnly == null ? cri.defaultReadOnly : this.defaultReadOnly;
        return WSConnectionRequestInfoImpl.match(this.ivReadOnly, cri.ivReadOnly) || this.ivReadOnly == null && WSConnectionRequestInfoImpl.match(defaultValue, cri.ivReadOnly) || cri.ivReadOnly == null && WSConnectionRequestInfoImpl.match(this.ivReadOnly, defaultValue);
    }

    private final boolean matchTypeMap(WSConnectionRequestInfoImpl cri) {
        Map<String, Class<?>> defaultValue = this.defaultTypeMap == null ? cri.defaultTypeMap : this.defaultTypeMap;
        return WSConnectionRequestInfoImpl.matchTypeMap(this.ivTypeMap, cri.ivTypeMap) || this.ivTypeMap == null && WSConnectionRequestInfoImpl.matchTypeMap(defaultValue, cri.ivTypeMap) || cri.ivTypeMap == null && WSConnectionRequestInfoImpl.matchTypeMap(this.ivTypeMap, defaultValue);
    }

    public static final boolean matchTypeMap(Map<String, Class<?>> m1, Map<String, Class<?>> m2) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"matchTypeMap", (Object[])new Object[]{m1, m2});
        }
        boolean match = false;
        if (m1 == m2) {
            match = true;
        } else if (m1 != null && m1.equals(m2)) {
            match = true;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"matchTypeMap", (Object)match);
        }
        return match;
    }

    public void setDefaultValues(String catalog, int holdability, Boolean readOnly, Map<String, Class<?>> typeMap, String schema, int networkTimeout) {
        this.defaultCatalog = catalog;
        this.defaultHoldability = holdability;
        this.defaultReadOnly = readOnly;
        this.defaultTypeMap = typeMap;
        this.defaultSchema = schema;
        this.defaultNetworkTimeout = networkTimeout;
    }

    public String toString() {
        String lineSeparator = AdapterUtil.EOLN;
        StringBuilder sb = new StringBuilder(300).append(AdapterUtil.toString(this)).append(lineSeparator + "  changable CRI  = ").append(this.changable).append(lineSeparator + "  UserName       = ").append(this.ivUserName).append(lineSeparator + "  Password       = ").append(this.ivPassword == null ? "null" : "******").append(lineSeparator + "  Catalog/default= ").append(this.ivCatalog);
        if (this.defaultCatalog != null) {
            sb.append(" / ").append(this.defaultCatalog);
        }
        sb.append(lineSeparator + "  Schema/default= ").append(this.ivSchema);
        if (this.defaultSchema != null) {
            sb.append(" / ").append(this.defaultSchema);
        }
        sb.append(lineSeparator + "  NetworkTimeout/default= ").append(this.ivNetworkTimeout);
        sb.append(" / ").append(this.defaultNetworkTimeout);
        sb.append(lineSeparator + "  IsReadOnly/def = ").append(this.ivReadOnly);
        if (this.defaultReadOnly != null) {
            sb.append(" / ").append(this.defaultReadOnly);
        }
        sb.append(lineSeparator + "  TypeMap/default= ").append(this.ivTypeMap);
        if (this.defaultTypeMap != null) {
            sb.append(" / ").append(this.defaultTypeMap);
        }
        sb.append(lineSeparator + "  gssName = ").append(this.gssName == null ? null : this.gssName.toString()).append(lineSeparator + "  gssCredential = ").append(this.gssCredential == null ? null : this.gssCredential.toString()).append(lineSeparator + "  Holdability/def= ").append(AdapterUtil.getCursorHoldabilityString(this.ivHoldability));
        if (this.defaultHoldability != 0) {
            sb.append(" / ").append(this.defaultHoldability);
        }
        sb.append(lineSeparator + "  ConfigID       = ").append(this.ivConfigID).append(lineSeparator + "  Isolation      = ").append(AdapterUtil.getIsolationLevelString(this.ivIsoLevel)).append(lineSeparator + "  Support isolation switching  = ").append(this.supportIsolvlSwitching).append(lineSeparator + "  oracle props   = ").append(this.oracleProperties);
        return new String(sb);
    }

    public final int hashCode() {
        return this.hashcode;
    }

    public void setGssName(GSSName gn) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: GSSName, cri", gn, this));
        }
        this.gssName = gn;
        this.kerberosIdentityisSet = true;
    }

    public void setGssCredential(GSSCredential gc) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: GSSCredential, cri", gc, this));
        }
        this.gssCredential = gc;
        this.kerberosIdentityisSet = true;
    }

    public boolean isKerberosMappingUsed() {
        return this.kerberosMappingIsUsed;
    }

    public void markAsChangable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"This CRI is marked as changable: ", (Object[])new Object[]{this});
        }
        this.changable = true;
    }

    public boolean isCRIChangable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isCRIChangable :", (Object[])new Object[]{this.changable});
        }
        return this.changable;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: catalog, cri", catalog, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting catalog on the CRI to: " + catalog), (Object[])new Object[0]);
        }
        this.ivCatalog = catalog;
    }

    public void setHoldability(int holdability) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: holdability, cri", holdability, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting holdability on the CRI to: " + holdability), (Object[])new Object[0]);
        }
        this.ivHoldability = holdability;
    }

    public void setTransactionIsolationLevel(int iso) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: iso , cri", iso, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Setting isolation level on the CRI to:", (Object[])new Object[]{iso});
        }
        this.ivIsoLevel = iso;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: readOnly , cri", readOnly, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Setting read only on the CRI to:", (Object[])new Object[]{readOnly});
        }
        this.ivReadOnly = readOnly;
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: type map, cri", map, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting the type map on the CRI to: " + map), (Object[])new Object[0]);
        }
        this.ivTypeMap = map;
    }

    public void setSchema(String schema) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: schema, cri", schema, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting the schema on the CRI to: " + schema), (Object[])new Object[0]);
        }
        this.ivSchema = schema;
    }

    public void setNetworkTimeout(int networkTimeout) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", "ConnectionRequestInfo cannot be modified, doing so may result in corruption: networkTimeout, cri", networkTimeout, this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting the networkTimeout on the CRI to: " + networkTimeout), (Object[])new Object[0]);
        }
        this.ivNetworkTimeout = networkTimeout;
    }

    public final boolean getSupportIsolvlSwitchingValue() {
        return this.supportIsolvlSwitching;
    }

    public static WSConnectionRequestInfoImpl createChangableCRIFromNon(WSConnectionRequestInfoImpl oldCRI) {
        WSConnectionRequestInfoImpl connInfo = new WSConnectionRequestInfoImpl(oldCRI.getUserName(), oldCRI.getPassword(), oldCRI.getIsolationLevel(), oldCRI.getCatalog(), oldCRI.isReadOnly(), oldCRI.getTypeMap(), oldCRI.getHoldability(), oldCRI.getSchema(), oldCRI.getNetworkTimeout(), oldCRI.getConfigID(), oldCRI.getSupportIsolvlSwitchingValue());
        connInfo.setDefaultValues(oldCRI.defaultCatalog, oldCRI.defaultHoldability, oldCRI.defaultReadOnly, oldCRI.defaultTypeMap, oldCRI.defaultSchema, oldCRI.defaultNetworkTimeout);
        connInfo.oracleProperties = oldCRI.oracleProperties;
        connInfo.markAsChangable();
        return connInfo;
    }
}

