/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.JDBCDrivers;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.component.ComponentContext;

public class JDBCDriverService
extends Observable
implements LibraryChangeListener {
    private static final TraceComponent tc = Tr.register(JDBCDriverService.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final String FACTORY_PID = "com.ibm.ws.jdbc.jdbcDriver";
    static final String ID = "id";
    public static final String LIBRARY_REF = "libraryRef";
    public static final String JDBC_DRIVER = "jdbcDriver";
    public static final String TARGET_LIBRARY = "sharedLib.target";
    private static final List<String> PROPS_FOR_XA_ONLY = Arrays.asList("ifxIFX_XASPEC");
    private static final List<String> PROPS_NOT_SET_ON_DRIVER = Arrays.asList("isolationLevelSwitchingSupport");
    private ClassLoader classloader;
    private ConnectorService connectorSvc;
    private static ConcurrentLinkedQueue<ClassLoader> embDerbyRefCount = new ConcurrentLinkedQueue();
    private final HashSet<Class<? extends CommonDataSource>> introspectedClasses = new HashSet();
    private final AtomicBoolean isDerbyEmbedded = new AtomicBoolean();
    private boolean isInitialized;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String name;
    private Dictionary<String, ?> properties;
    private Library sharedLib;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        this.name = (String)props.get("config.displayId");
        this.lock.writeLock().lock();
        try {
            this.properties = props;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if ("file".equals(props.get("config.source")) && this.name.startsWith("application[")) {
            throw new IllegalArgumentException(ConnectorService.getMessage((String)"UNSUPPORTED_VALUE_J2CA8011", (Object[])new Object[]{this.name, ID, JDBC_DRIVER}));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    private SQLException classNotFound(Throwable cause) {
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        String sharedLibId = this.sharedLib.id();
        String message = sharedLibId.startsWith("com.ibm.ws.jdbc.jdbcDriver-") ? AdapterUtil.getNLSMessage("DSRA4001.no.suitable.driver.nested", this.name) : AdapterUtil.getNLSMessage("DSRA4000.no.suitable.driver", this.name, sharedLibId);
        message = message + " " + this.getClasspath(this.sharedLib, false);
        return new SQLNonTransientException(message, cause);
    }

    private <T extends CommonDataSource> T create(Class<T> type, final String className, final Hashtable<?, ?> props) throws SQLException {
        boolean trace;
        if (className == null) {
            throw this.classNotFound(null);
        }
        if (this.classloader != null && className.startsWith("org.apache.derby.jdbc.Embedded") && this.isDerbyEmbedded.compareAndSet(false, true)) {
            embDerbyRefCount.add(this.classloader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"ref count for shutdown", (Object[])new Object[]{this.classloader, embDerbyRefCount});
            }
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create", (Object[])new Object[]{type, className, this.classloader, PropertyService.hidePasswords(props)});
        }
        try {
            CommonDataSource ds = (CommonDataSource)AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T run() throws Exception {
                    ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
                    try {
                        ClassLoader loader;
                        if (JDBCDriverService.this.classloader == null) {
                            loader = origTCCL;
                        } else {
                            loader = JDBCDriverService.this.classloader;
                            Thread.currentThread().setContextClassLoader(loader);
                        }
                        Class<?> dsClass = loader.loadClass(className);
                        JDBCDriverService.this.introspectedClasses.add(dsClass);
                        CommonDataSource ds = (CommonDataSource)dsClass.newInstance();
                        Hashtable p = (Hashtable)props.clone();
                        for (PropertyDescriptor descriptor : Introspector.getBeanInfo(dsClass).getPropertyDescriptors()) {
                            String name = descriptor.getName();
                            Object value = p.remove(name);
                            if (value == null && name.equals("url")) {
                                value = p.remove("URL");
                            }
                            boolean isPassword = PropertyService.isPassword(name);
                            if (value == null) continue;
                            try {
                                if (value instanceof String) {
                                    String str = (String)value;
                                    if (isPassword) {
                                        str = PasswordUtil.getCryptoAlgorithm((String)str) == null ? str : PasswordUtil.decode((String)str);
                                    }
                                    JDBCDriverService.setProperty(ds, descriptor, str, !isPassword);
                                    continue;
                                }
                                if (trace && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("set " + name + " = " + value), (Object[])new Object[0]);
                                }
                                descriptor.getWriteMethod().invoke((Object)ds, value);
                            }
                            catch (Throwable x) {
                                if (x instanceof InvocationTargetException) {
                                    x = x.getCause();
                                }
                                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"217", (Object)this, (Object[])new Object[]{className, name, value});
                                SQLException failure = (SQLException)JDBCDriverService.this.connectorSvc.ignoreWarnOrFail(tc, x, SQLException.class, "PROP_SET_ERROR", new Object[]{name, "=" + (isPassword ? "******" : value), AdapterUtil.stackTraceToString(x)});
                                if (failure == null) continue;
                                throw failure;
                            }
                        }
                        if (!p.isEmpty()) {
                            for (Object propertyName : p.keySet()) {
                                SQLException failure;
                                if (PROPS_FOR_XA_ONLY.contains(propertyName) && !(ds instanceof XADataSource) || PROPS_NOT_SET_ON_DRIVER.contains(propertyName) || (failure = (SQLException)JDBCDriverService.this.connectorSvc.ignoreWarnOrFail(tc, null, SQLException.class, "PROP_NOT_FOUND", new Object[]{className, propertyName})) == null) continue;
                                throw failure;
                            }
                        }
                        CommonDataSource commonDataSource = ds;
                        return commonDataSource;
                    }
                    finally {
                        if (JDBCDriverService.this.classloader != null) {
                            Thread.currentThread().setContextClassLoader(origTCCL);
                        }
                    }
                }
            });
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"create", (Object)ds);
            }
            return (T)ds;
        }
        catch (PrivilegedActionException privX) {
            SQLException sqlX;
            Throwable x = privX.getCause();
            FFDCFilter.processException((Throwable)x, (String)JDBCDriverService.class.getName(), (String)"234");
            SQLException sQLException = x instanceof ClassNotFoundException ? this.classNotFound(x) : (sqlX = x instanceof SQLException ? (SQLException)x : new SQLNonTransientException(x));
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"create", (Object)x);
            }
            throw sqlX;
        }
    }

    public CommonDataSource createAnyDataSource(Properties props) throws SQLException {
        this.lock.readLock().lock();
        try {
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            String vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
            String className = (String)this.properties.get(ConnectionPoolDataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(this.getClasspath(this.sharedLib, true)))) {
                ConnectionPoolDataSource connectionPoolDataSource = this.create(ConnectionPoolDataSource.class, className, props);
                return connectionPoolDataSource;
            }
            className = (String)this.properties.get(DataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getDataSourceClassName(this.getClasspath(this.sharedLib, true)))) {
                DataSource dataSource = this.create(DataSource.class, className, props);
                return dataSource;
            }
            className = (String)this.properties.get(XADataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getXADataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getXADataSourceClassName(this.getClasspath(this.sharedLib, true)))) {
                XADataSource xADataSource = this.create(XADataSource.class, className, props);
                return xADataSource;
            }
            throw this.classNotFound(null);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CommonDataSource createDefaultDataSource(Properties props) throws SQLException {
        this.lock.readLock().lock();
        try {
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            String vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
            String className = (String)this.properties.get(XADataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getXADataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getXADataSourceClassName(this.getClasspath(this.sharedLib, true)))) {
                XADataSource xADataSource = this.create(XADataSource.class, className, props);
                return xADataSource;
            }
            className = (String)this.properties.get(ConnectionPoolDataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(this.getClasspath(this.sharedLib, true)))) {
                ConnectionPoolDataSource connectionPoolDataSource = this.create(ConnectionPoolDataSource.class, className, props);
                return connectionPoolDataSource;
            }
            className = (String)this.properties.get(DataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getDataSourceClassName(this.getClasspath(this.sharedLib, true)))) {
                DataSource dataSource = this.create(DataSource.class, className, props);
                return dataSource;
            }
            throw this.classNotFound(null);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        this.lock.readLock().lock();
        try {
            String vendorPropertiesPID;
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(ConnectionPoolDataSource.class.getName())) == null && (className = JDBCDrivers.getConnectionPoolDataSourceClassName(vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties")) == null) {
                className = JDBCDrivers.getConnectionPoolDataSourceClassName(this.getClasspath(this.sharedLib, true));
            }
            ConnectionPoolDataSource connectionPoolDataSource = this.create(ConnectionPoolDataSource.class, className, props);
            return connectionPoolDataSource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource createDataSource(Properties props) throws SQLException {
        this.lock.readLock().lock();
        try {
            String vendorPropertiesPID;
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(DataSource.class.getName())) == null && (className = JDBCDrivers.getDataSourceClassName(vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties")) == null) {
                className = JDBCDrivers.getDataSourceClassName(this.getClasspath(this.sharedLib, true));
            }
            DataSource dataSource = this.create(DataSource.class, className, props);
            return dataSource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XADataSource createXADataSource(Properties props) throws SQLException {
        this.lock.readLock().lock();
        try {
            String vendorPropertiesPID;
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(XADataSource.class.getName())) == null && (className = JDBCDrivers.getXADataSourceClassName(vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties")) == null) {
                className = JDBCDrivers.getXADataSourceClassName(this.getClasspath(this.sharedLib, true));
            }
            XADataSource xADataSource = this.create(XADataSource.class, className, props);
            return xADataSource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
        this.lock.writeLock().lock();
        try {
            if (this.isInitialized) {
                if (this.classloader != null) {
                    if (this.isDerbyEmbedded.get()) {
                        this.shutdownDerbyEmbedded();
                    }
                    this.classloader = null;
                }
                Iterator<Class<? extends CommonDataSource>> it = this.introspectedClasses.iterator();
                while (it.hasNext()) {
                    Introspector.flushFromCaches(it.next());
                    it.remove();
                }
                this.isInitialized = false;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    public ClassLoader getClassLoaderForLibraryRef() {
        this.lock.readLock().lock();
        try {
            ClassLoader classLoader = this.classloader;
            return classLoader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Collection<String> getClasspath(Library sharedLib, boolean upperCaseFileNamesOnly) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getClasspath", (Object[])new Object[]{sharedLib});
        }
        LinkedList<String> classpath = new LinkedList<String>();
        if (sharedLib != null && sharedLib.getFiles() != null) {
            for (File file : sharedLib.getFiles()) {
                classpath.add(upperCaseFileNamesOnly ? file.getName().toUpperCase() : file.getAbsolutePath());
            }
        }
        if (sharedLib != null && sharedLib.getFilesets() != null) {
            for (Fileset fileset : sharedLib.getFilesets()) {
                for (File file : fileset.getFileset()) {
                    classpath.add(upperCaseFileNamesOnly ? file.getName().toUpperCase() : file.getAbsolutePath());
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getClasspath", classpath);
        }
        return classpath;
    }

    public boolean loadFromApp() {
        return Boolean.parseBoolean((String)this.properties.get("ibm.internal.nonship.function")) && "ibm.internal.simulate.no.library.do.not.ship".equals(this.sharedLib.id());
    }

    public void libraryNotification() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"libraryNotification", (Object[])new Object[0]);
        }
        this.modified(null, true);
    }

    protected void modified(ComponentContext context) {
        Dictionary newProperties = context.getProperties();
        this.modified(newProperties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modified(Dictionary<String, ?> newProperties, boolean logMessage) {
        boolean trace;
        block14: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{newProperties});
            }
            boolean replaced = false;
            this.lock.writeLock().lock();
            try {
                if (this.isInitialized) {
                    if (this.classloader != null) {
                        if (this.isDerbyEmbedded.compareAndSet(true, false)) {
                            this.shutdownDerbyEmbedded();
                        }
                        this.classloader = null;
                    }
                    Iterator<Class<? extends CommonDataSource>> it = this.introspectedClasses.iterator();
                    while (it.hasNext()) {
                        Introspector.flushFromCaches(it.next());
                        it.remove();
                    }
                    replaced = true;
                    this.isInitialized = false;
                }
                if (newProperties != null) {
                    this.properties = newProperties;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (replaced) {
                try {
                    this.setChanged();
                    this.notifyObservers();
                }
                catch (Throwable x) {
                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"254", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)x.getMessage(), (Object[])new Object[]{AdapterUtil.stackTraceToString(x)});
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    private static void setProperty(Object obj, PropertyDescriptor pd, String value, boolean doTraceValue) throws Exception {
        Method setter;
        Object param = null;
        String propName = pd.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set " + propName + " = " + (doTraceValue ? value : "******")), (Object[])new Object[0]);
        }
        if ((setter = pd.getWriteMethod()) == null) {
            throw new NoSuchMethodException(AdapterUtil.getNLSMessage("NO_SETTER_METHOD", propName));
        }
        Class<?> paramType = setter.getParameterTypes()[0];
        if (!paramType.isPrimitive()) {
            param = paramType.equals(String.class) ? value : (paramType.equals(Properties.class) ? AdapterUtil.toProperties(value) : (paramType.equals(Character.class) ? Character.valueOf(value.charAt(0)) : paramType.getConstructor(String.class).newInstance(value)));
        } else if (paramType.equals(Integer.TYPE)) {
            param = Integer.valueOf(value);
        } else if (paramType.equals(Long.TYPE)) {
            param = Long.valueOf(value);
        } else if (paramType.equals(Boolean.TYPE)) {
            param = Boolean.valueOf(value);
        } else if (paramType.equals(Double.TYPE)) {
            param = Double.valueOf(value);
        } else if (paramType.equals(Float.TYPE)) {
            param = Float.valueOf(value);
        } else if (paramType.equals(Short.TYPE)) {
            param = Short.valueOf(value);
        } else if (paramType.equals(Byte.TYPE)) {
            param = Byte.valueOf(value);
        } else if (paramType.equals(Character.TYPE)) {
            param = Character.valueOf(value.charAt(0));
        }
        setter.invoke(obj, param);
    }

    protected void setSharedLib(Library lib) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setSharedLib", (Object[])new Object[]{lib});
        }
        this.sharedLib = lib;
    }

    private void shutdownDerbyEmbedded() {
        block9: {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object[])new Object[]{this.classloader, embDerbyRefCount});
            }
            if (embDerbyRefCount.remove(this.classloader) && !embDerbyRefCount.contains(this.classloader)) {
                try {
                    Class<?> EmbDS = AdapterUtil.forNameWithPriv("org.apache.derby.jdbc.EmbeddedDataSource40", true, this.classloader);
                    DataSource ds = (DataSource)EmbDS.newInstance();
                    EmbDS.getMethod("setShutdownDatabase", String.class).invoke((Object)ds, "shutdown");
                    ds.getConnection().close();
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded");
                    }
                    break block9;
                }
                catch (SQLException x) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)(x.getSQLState() + ' ' + x.getErrorCode() + ':' + x.getMessage()));
                    }
                    break block9;
                }
                catch (Throwable x) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)x);
                    }
                    break block9;
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)false);
            }
        }
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    protected void unsetSharedLib(Library lib) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetSharedLib", (Object[])new Object[]{lib});
        }
        this.modified(null, false);
    }
}

