/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class AverageStatisticImpl
extends StatisticImpl
implements SPIAverageStatistic {
    private static final long serialVersionUID = 532089977446362907L;
    protected long count = 0L;
    protected long min = 0L;
    protected long max = 0L;
    protected long total = 0L;
    protected double sumOfSquares = 0.0;
    protected AverageStatisticImpl baseValue = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AverageStatisticImpl(int dataId) {
        super(dataId);
    }

    @Override
    public int getStatisticType() {
        return 3;
    }

    public AverageStatisticImpl(int count, int min, int max, int total, double sumOfSquares, int startTime, int lastSampleTime) {
        super(0);
        this.set(count, min, max, total, sumOfSquares, startTime, lastSampleTime);
    }

    public AverageStatisticImpl(int dataId, long count, long min, long max, long total, double sumOfSquares, long startTime, long lastSampleTime) {
        super(dataId);
        this.set(count, min, max, total, sumOfSquares, startTime, lastSampleTime);
    }

    public AverageStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    @Override
    public WSStatistic copy() {
        AverageStatisticImpl copy = new AverageStatisticImpl(this.id, this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
        copy.baseValue = this.baseValue;
        return copy;
    }

    public void setDataId(int id) {
        this.id = id;
    }

    @Override
    public void add(long val) {
        if (!this.enabled) {
            return;
        }
        this.add(System.currentTimeMillis(), val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void add(long curTime, long val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = curTime;
        if (!this.sync) {
            if (val > this.max) {
                this.max = val;
            }
            if (this.count > 0L) {
                if (val < this.min) {
                    this.min = val;
                }
            } else {
                this.min = val;
            }
            ++this.count;
            this.total += val;
            this.sumOfSquares += (double)(val * val);
        } else {
            AverageStatisticImpl averageStatisticImpl = this;
            synchronized (averageStatisticImpl) {
                ++this.count;
                this.total += val;
            }
            if (val > this.max) {
                this.max = val;
            }
            if (this.count > 0L) {
                if (val < this.min) {
                    this.min = val;
                }
            } else {
                this.min = val;
            }
            this.sumOfSquares += (double)(val * val);
        }
    }

    @Override
    public void set(long count, long min, long max, long total, double sumOfSquares, long startTime, long lastSampleTime) {
        this.count = count;
        this.min = min;
        this.max = max;
        this.total = total;
        this.sumOfSquares = sumOfSquares;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.count = 0L;
        this.total = 0L;
        this.sumOfSquares = 0.0;
        this.min = 0L;
        this.max = 0L;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public double getMean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return (double)this.total * 1.0 / (double)this.count;
    }

    @Override
    public long getMin() {
        return this.min;
    }

    @Override
    public long getMax() {
        return this.max;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public void combine(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        AverageStatisticImpl other = (AverageStatisticImpl)otherStat;
        boolean previousCountWasZero = this.count == 0L;
        this.count += other.count;
        this.total += other.total;
        this.sumOfSquares += other.sumOfSquares;
        if (other.count != 0L && (this.min > other.min || previousCountWasZero)) {
            this.min = other.min;
        }
        if (this.max < other.max) {
            this.max = other.max;
        }
        if (other.lastSampleTime > this.lastSampleTime) {
            this.lastSampleTime = other.lastSampleTime;
        }
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuffer str = new StringBuffer(super.toString(""));
        str.append(", type=").append("AverageStatistic");
        str.append(", avg=").append(this.getMean());
        str.append(", min=").append(this.min);
        str.append(", max=").append(this.max);
        str.append(", total=").append(this.total);
        str.append(", count=").append(this.count);
        str.append(", sumSq=").append(this.sumOfSquares);
        return str.toString();
    }

    @Override
    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<AS");
        res.append(" id=\"");
        res.append(this.id);
        res.append("\" sT=\"");
        res.append(this.startTime);
        res.append("\" lST=\"");
        res.append(this.lastSampleTime);
        res.append("\" ct=\"");
        res.append(this.count);
        res.append("\" max=\"");
        res.append(this.max);
        res.append("\" min=\"");
        res.append(this.min);
        res.append("\" sOS=\"");
        res.append(this.sumOfSquares);
        res.append("\" tot=\"");
        res.append(this.total);
        res.append("\">\n");
        res.append("</AS>");
        return res.toString();
    }

    @Override
    public void update(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        AverageStatisticImpl other = (AverageStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.count = other.getCount();
            this.total = other.getTotal();
            this.sumOfSquares = other.sumOfSquares;
            this.startTime = other.getStartTime();
        } else {
            this.count = other.count - this.baseValue.count;
            this.total = other.total - this.baseValue.total;
            this.sumOfSquares = other.sumOfSquares - this.baseValue.sumOfSquares;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.min = other.getMin();
        this.max = other.getMax();
        this.lastSampleTime = other.getLastSampleTime();
    }

    @Override
    public WSStatistic delta(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        AverageStatisticImpl other = (AverageStatisticImpl)otherStat;
        AverageStatisticImpl newData = new AverageStatisticImpl(this.id);
        newData.min = this.min;
        newData.max = this.max;
        newData.count = this.count - other.getCount();
        newData.total = this.total - other.getTotal();
        newData.sumOfSquares = this.sumOfSquares - other.sumOfSquares;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @Override
    public WSStatistic rateOfChange(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        AverageStatisticImpl other = (AverageStatisticImpl)otherStat;
        AverageStatisticImpl newData = new AverageStatisticImpl(this.id);
        long timeDiff = (this.lastSampleTime - other.lastSampleTime) / 1000L;
        if (timeDiff == 0L) {
            return null;
        }
        newData.count = (this.count - other.count) / timeDiff;
        newData.sumOfSquares = (this.sumOfSquares - other.sumOfSquares) / (double)timeDiff;
        newData.total = (this.total - other.total) / timeDiff;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        newData.max = this.max;
        newData.min = this.min;
        return newData;
    }

    @Override
    public void resetOnClient(WSStatistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new AverageStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(other)) {
            this.baseValue = (AverageStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AverageStatisticImpl)) {
            return false;
        }
        return other.getId() == this.id;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AverageStatisticImpl.class);
    }
}

