/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ProbeAtReturnMethodAdapter
extends ProbeMethodAdapter {
    private Set<ProbeListener> enabledListeners = new HashSet<ProbeListener>();
    static final long serialVersionUID = 6871656496656852646L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ProbeAtReturnMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeAtReturn probeAtReturn = config.getProbeAtReturn();
            if (probeAtReturn == null) continue;
            this.enabledListeners.add(listener);
        }
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (this.enabledListeners.isEmpty() || opcode == 191) {
            return;
        }
        String probeKey = this.createKey();
        ProbeImpl probe = this.getProbe(probeKey);
        long probeId = probe.getIdentifier();
        Type returnType = this.getReturnType();
        this.setProbeInProgress(true);
        if (returnType.getSort() == 0) {
            this.visitLdcInsn(probeId);
            if (this.isStatic()) {
                this.visitInsn(1);
            } else {
                this.visitVarInsn(25, 0);
            }
            this.visitInsn(1);
            this.visitInsn(1);
        } else {
            if (returnType.getSize() == 2) {
                this.visitInsn(92);
            } else {
                this.visitInsn(89);
            }
            this.box(returnType);
            this.visitLdcInsn(probeId);
            this.visitInsn(93);
            this.visitInsn(88);
            if (this.isStatic()) {
                this.visitInsn(1);
            } else {
                this.visitVarInsn(25, 0);
            }
            this.visitInsn(95);
            this.visitInsn(1);
            this.visitInsn(95);
        }
        this.visitFireProbeInvocation();
        this.setProbeInProgress(false);
        this.setProbeListeners(probe, this.enabledListeners);
    }

    private String createKey() {
        StringBuilder sb = new StringBuilder("METHOD_RETURN: ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeAtReturnMethodAdapter.class);
    }
}

