/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.rest.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.microprofile.rest.client.cdi.LibertyRestClientBean;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"api.classes=org.eclipse.microprofile.rest.client.inject.RegisterRestClient;org.eclipse.microprofile.rest.client.inject.RestClient;", "service.vendor=IBM"})
public class LibertyRestClientExtension
implements WebSphereCDIExtension,
Extension {
    private static final TraceComponent tc = Tr.register(LibertyRestClientExtension.class);
    private static final Map<ClassLoader, Set<Class<?>>> restClientClasses = new WeakHashMap();
    private static final Set<Throwable> errors = new LinkedHashSet<Throwable>();
    static final long serialVersionUID = 6038666300457453401L;

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findClients(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> pat) {
        Class restClient = pat.getAnnotatedType().getJavaClass();
        if (restClient.isInterface()) {
            ClassLoader tccl = LibertyRestClientExtension.getContextClassLoader();
            Map<ClassLoader, Set<Class<?>>> map = restClientClasses;
            synchronized (map) {
                Set<Class<?>> classes = restClientClasses.get(tccl);
                if (classes == null) {
                    classes = new LinkedHashSet();
                    restClientClasses.put(tccl, classes);
                }
                classes.add(restClient);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found RestClient: " + restClient.getName() + " from classloader: " + tccl), (Object[])new Object[0]);
            }
            pat.veto();
        } else {
            errors.add(new IllegalArgumentException("The class " + restClient + " is not an interface"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        ClassLoader tccl = LibertyRestClientExtension.getContextClassLoader();
        Set<Class<?>> classes = null;
        Map<ClassLoader, Set<Class<?>>> map = restClientClasses;
        synchronized (map) {
            classes = restClientClasses.get(tccl);
        }
        if (classes != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Registering RestClients from classloader: " + tccl), (Object[])new Object[]{classes});
            }
            classes.stream().map(c -> new LibertyRestClientBean((Class<?>)c, beanManager)).forEach(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addBean(arg_0));
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to register RestClient for unknown app classloader: " + tccl), (Object[])new Object[0]);
        }
    }

    public void registerErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        errors.forEach(arg_0 -> ((AfterDeploymentValidation)afterDeploymentValidation).addDeploymentProblem(arg_0));
    }
}

