/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import com.ibm.ws.microprofile.metrics.impl.HistogramImpl;
import com.ibm.ws.microprofile.metrics.impl.MeterImpl;
import com.ibm.ws.microprofile.metrics.impl.TimerImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetricRegistryImpl
extends MetricRegistry {
    protected final ConcurrentMap<String, Metric> metrics = this.buildMap();
    protected final ConcurrentMap<String, Metadata> metadata = new ConcurrentHashMap<String, Metadata>();
    protected final ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> applicationMap = new ConcurrentHashMap();
    static final long serialVersionUID = -2273440679596247538L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        MetricRegistryImpl.append(builder, name);
        if (names != null) {
            for (String s : names) {
                MetricRegistryImpl.append(builder, s);
            }
        }
        return builder.toString();
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistryImpl.name(klass.getName(), names);
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    public static MetricType from(Metric in) {
        if (Gauge.class.isInstance(in)) {
            return MetricType.GAUGE;
        }
        if (Counter.class.isInstance(in)) {
            return MetricType.COUNTER;
        }
        if (Histogram.class.isInstance(in)) {
            return MetricType.HISTOGRAM;
        }
        if (Meter.class.isInstance(in)) {
            return MetricType.METERED;
        }
        if (Timer.class.isInstance(in)) {
            return MetricType.TIMER;
        }
        return MetricType.INVALID;
    }

    protected ConcurrentMap<String, Metric> buildMap() {
        return new ConcurrentHashMap<String, Metric>();
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.register(name, metric, new Metadata(name, MetricRegistryImpl.from(metric)));
    }

    public <T extends Metric> T register(String name, T metric, Metadata metadata) throws IllegalArgumentException {
        Metric existing = this.metrics.putIfAbsent(name, metric);
        Metadata metadataCopy = new Metadata(metadata.getName(), metadata.getDisplayName(), metadata.getDescription(), metadata.getTypeRaw(), metadata.getUnit());
        for (String tag : metadata.getTags().keySet()) {
            metadataCopy.getTags().put(tag, metadata.getTags().get(tag));
        }
        this.metadata.putIfAbsent(name, metadataCopy);
        if (existing != null) {
            throw new IllegalArgumentException("A metric named " + name + " already exists");
        }
        this.addNameToApplicationMap(name);
        return metric;
    }

    protected void addNameToApplicationMap(String name) {
        ConcurrentLinkedQueue newList;
        String appName = this.getApplicationName();
        if (appName == null) {
            return;
        }
        ConcurrentLinkedQueue<String> list = this.applicationMap.get(appName);
        if (list == null && (list = this.applicationMap.putIfAbsent(appName, newList = new ConcurrentLinkedQueue())) == null) {
            list = newList;
        }
        list.add(name);
    }

    public void unRegisterApplicationMetrics(String appName) {
        ConcurrentLinkedQueue<String> list = this.applicationMap.remove(appName);
        if (list != null) {
            for (String metricName : list) {
                this.remove(metricName);
            }
        }
    }

    private String getApplicationName() {
        J2EEName name;
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            return name.getApplication();
        }
        return null;
    }

    public Counter counter(String name) {
        return this.counter(new Metadata(name, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata) {
        return this.getOrAdd(metadata, MetricBuilder.COUNTERS);
    }

    public Histogram histogram(String name) {
        return this.histogram(new Metadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata) {
        return this.getOrAdd(metadata, MetricBuilder.HISTOGRAMS);
    }

    public Meter meter(String name) {
        return this.meter(new Metadata(name, MetricType.METERED));
    }

    public Meter meter(Metadata metadata) {
        return this.getOrAdd(metadata, MetricBuilder.METERS);
    }

    public Timer timer(String name) {
        return this.timer(new Metadata(name, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata) {
        return this.getOrAdd(metadata, MetricBuilder.TIMERS);
    }

    public boolean remove(String name) {
        Metric metric = (Metric)this.metrics.remove(name);
        this.metadata.remove(name);
        return metric != null;
    }

    public void removeMatching(MetricFilter filter) {
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (!filter.matches((String)entry.getKey(), (Metric)entry.getValue())) continue;
            this.remove((String)entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metrics.keySet()));
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.getMetrics(Gauge.class, filter);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.getMetrics(Counter.class, filter);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.getMetrics(Histogram.class, filter);
    }

    public SortedMap<String, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.getMetrics(Meter.class, filter);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.getMetrics(Timer.class, filter);
    }

    private <T extends Metric> T getOrAdd(Metadata metadata, MetricBuilder<T> builder) {
        block4: {
            Metric metric = (Metric)this.metrics.get(metadata.getName());
            if (builder.isInstance(metric)) {
                return (T)metric;
            }
            if (metric == null) {
                try {
                    return this.register(metadata.getName(), builder.newMetric(), metadata);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl", (String)"439", (Object)((Object)this), (Object[])new Object[]{metadata, builder});
                    Metric added = (Metric)this.metrics.get(metadata.getName());
                    if (!builder.isInstance(added)) break block4;
                    return (T)added;
                }
            }
        }
        throw new IllegalArgumentException(metadata.getName() + " is already used for a different type of metric");
    }

    private <T extends Metric> SortedMap<String, T> getMetrics(Class<T> klass, MetricFilter filter) {
        TreeMap timers = new TreeMap();
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (!klass.isInstance(entry.getValue()) || !filter.matches((String)entry.getKey(), (Metric)entry.getValue())) continue;
            timers.put(entry.getKey(), (Metric)entry.getValue());
        }
        return Collections.unmodifiableSortedMap(timers);
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Metadata getMetadata(String name) {
        return (Metadata)this.metadata.get(name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetricRegistryImpl.class);
    }

    private static interface MetricBuilder<T extends Metric> {
        public static final MetricBuilder<Counter> COUNTERS = new MetricBuilder<Counter>(){
            static final long serialVersionUID = -3814174454516349407L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Counter newMetric() {
                return new CounterImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Counter.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        public static final MetricBuilder<Histogram> HISTOGRAMS = new MetricBuilder<Histogram>(){
            static final long serialVersionUID = 4581045905640971428L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Histogram newMetric() {
                return new HistogramImpl(new ExponentiallyDecayingReservoir());
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Histogram.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        public static final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){
            static final long serialVersionUID = 1796117603241770217L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Meter newMetric() {
                return new MeterImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        public static final MetricBuilder<Timer> TIMERS = new MetricBuilder<Timer>(){
            static final long serialVersionUID = 950097080965817907L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Timer newMetric() {
                return new TimerImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Timer.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        };

        public T newMetric();

        public boolean isInstance(Metric var1);
    }
}

