/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JPAPuScope;
import com.ibm.ws.jpa.management.JPAScopeInfo;
import java.util.HashMap;
import java.util.Map;

public abstract class JPAApplInfo {
    private static final TraceComponent tc = Tr.register(JPAApplInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final AbstractJPAComponent ivJPAComponent;
    private final String applName;
    private Map<String, JPAScopeInfo> puScopes = null;

    protected JPAApplInfo(AbstractJPAComponent jpaComponent, String applName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{applName});
        }
        this.ivJPAComponent = jpaComponent;
        this.applName = applName;
        this.puScopes = new HashMap<String, JPAScopeInfo>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    AbstractJPAComponent getJPAComponent() {
        return this.ivJPAComponent;
    }

    public String getApplName() {
        return this.applName;
    }

    public void addPersistenceUnits(JPAPXml pxml) {
        JPAPuScope puScope;
        String scopeKey;
        JPAScopeInfo scopeInfo;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addPersistenceUnits", (Object[])new Object[]{pxml});
        }
        if ((scopeInfo = this.puScopes.get(scopeKey = (puScope = pxml.getPuScope()) == JPAPuScope.EAR_Scope ? "EAR_Scope_Module" : pxml.getArchiveName())) == null) {
            scopeInfo = new JPAScopeInfo(scopeKey, puScope);
            this.puScopes.put(scopeKey, scopeInfo);
        }
        scopeInfo.processPersistenceUnit(pxml, this);
    }

    protected abstract JPAPUnitInfo createJPAPUnitInfo(JPAPuId var1, JPAPXml var2, JPAScopeInfo var3);

    private final void close(String modName, boolean remove) {
        JPAScopeInfo scopeInfo = this.puScopes.get(modName);
        if (scopeInfo != null) {
            scopeInfo.close();
            if (remove) {
                this.puScopes.remove(modName);
            }
        }
    }

    void closeModule(String modName) {
        this.close(modName, true);
    }

    void closeAllScopeModules() {
        for (String module : this.puScopes.keySet()) {
            this.close(module, false);
        }
        this.puScopes.clear();
    }

    JPAPUnitInfo getPersistenceUnitInfo(String modName, String puName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPersistenceUnitInfo", (Object[])new Object[]{modName, puName, this});
        }
        JPAPUnitInfo rtnVal = null;
        JPAScopeInfo scopeInfo = null;
        if (puName == null || puName.length() == 0) {
            rtnVal = this.getUniquePU(modName);
        } else if (puName.startsWith("../")) {
            scopeInfo = this.puScopes.get("EAR_Scope_Module");
            if (scopeInfo != null) {
                String earPuName = puName.substring("../".length());
                rtnVal = scopeInfo.getPuInfo(earPuName);
            }
        } else {
            scopeInfo = this.puScopes.get(modName);
            if (scopeInfo != null) {
                rtnVal = scopeInfo.getPuInfo(puName);
            }
            if (rtnVal == null && (scopeInfo = this.puScopes.get("EAR_Scope_Module")) != null) {
                rtnVal = scopeInfo.getPuInfo(puName);
            }
        }
        if (rtnVal == null) {
            Tr.error((TraceComponent)tc, (String)"PU_NOT_FOUND_CWWJP0029E", (Object[])new Object[]{this.applName, modName, puName == null || puName.length() == 0 ? "<default>" : puName});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPersistenceUnitInfo", (Object)(rtnVal != null ? rtnVal.getPersistenceUnitName() : "PU not found"));
        }
        return rtnVal;
    }

    private JPAPUnitInfo getUniquePU(String modName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniquePU", (Object[])new Object[]{modName});
        }
        JPAPUnitInfo rtnVal = null;
        JPAScopeInfo scopeInfo = this.puScopes.get(modName);
        int totalPus = scopeInfo != null ? scopeInfo.getAllPuCount() : 0;
        switch (totalPus) {
            case 1: {
                rtnVal = scopeInfo.getUniquePuInfo();
                break;
            }
            case 0: {
                scopeInfo = this.puScopes.get("EAR_Scope_Module");
                int n = totalPus = scopeInfo != null ? scopeInfo.getAllPuCount() : 0;
                if (totalPus == 1) {
                    rtnVal = scopeInfo.getUniquePuInfo();
                    break;
                }
            }
            default: {
                Tr.error((TraceComponent)tc, (String)"PU_NOT_SPECIFIED_AND_NO_UNIQUE_PU_FOUND_CWWJP0012E", (Object[])new Object[]{this.applName, modName});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniquePU", (Object)rtnVal);
        }
        return rtnVal;
    }

    int getScopeSize() {
        return this.puScopes.size();
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("  ApplInfo: Appl = ").append(this.applName);
        for (JPAScopeInfo scopeInfo : this.puScopes.values()) {
            scopeInfo.toStringBuilder(sbuf);
        }
        return sbuf.toString();
    }
}

