/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class AppInfoEntry {
    protected final String tag;
    protected final String text;
    protected final String altText;
    protected final Map<String, String> attributes;
    static final long serialVersionUID = 7568980008491357568L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AppInfoEntry(String tag) {
        this(tag, null, null);
    }

    public AppInfoEntry(String tag, String text) {
        this(tag, text, null);
    }

    public AppInfoEntry(String tag, String text, String altText) {
        this.tag = tag;
        this.text = text == null ? null : text.trim();
        this.altText = altText == null ? null : altText.trim();
        this.attributes = new HashMap<String, String>();
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void write(XMLStreamWriter writer, boolean alternate) throws XMLStreamException {
        if (this.text == null) {
            writer.writeEmptyElement("http://www.ibm.com/xmlns/dde/schema/annotation/ext", this.tag);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                writer.writeAttribute(entry.getKey(), entry.getValue());
            }
        } else {
            writer.writeStartElement("http://www.ibm.com/xmlns/dde/schema/annotation/ext", this.tag);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                writer.writeAttribute(entry.getKey(), entry.getValue());
            }
            String toWrite = this.text;
            if (alternate && this.altText != null) {
                toWrite = this.altText;
            }
            writer.writeCharacters(toWrite);
            writer.writeEndElement();
        }
    }

    public static AppInfoEntry createLabelTag(String text, String string) {
        AppInfoEntry tag = new AppInfoEntry("label", text, string);
        return tag;
    }

    public static AppInfoEntry createRequiresTag(String id, boolean value) {
        AppInfoEntry tag = new AppInfoEntry("requires");
        tag.addAttribute("id", id);
        tag.addAttribute("value", String.valueOf(value));
        return tag;
    }

    public static AppInfoEntry createGroupTag(String id) {
        AppInfoEntry tag = new AppInfoEntry("group");
        tag.addAttribute("id", id);
        return tag;
    }

    public static AppInfoEntry createGroupDeclarationTag(String id, String label, String description) {
        AppInfoEntry tag = new AppInfoEntry("groupDecl", description);
        tag.addAttribute("id", id);
        if (label != null) {
            tag.addAttribute("label", label);
        }
        return tag;
    }

    public static AppInfoEntry createExtraPropertiesTag() {
        AppInfoEntry tag = new AppInfoEntry("extraProperties");
        return tag;
    }

    public static AppInfoEntry createReferenceTag(String name) {
        AppInfoEntry tag = new AppInfoEntry("reference", name);
        return tag;
    }

    public static AppInfoEntry createVariableTag(String variable) {
        return new AppInfoEntry("variable", variable);
    }

    public static AppInfoEntry createUniqueTag(String unique) {
        return new AppInfoEntry("unique", unique);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AppInfoEntry.class);
    }
}

