/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.yoko;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.config.ConfigAdapter;
import com.ibm.ws.transport.iiop.config.ConfigException;
import com.ibm.ws.transport.iiop.spi.IIOPEndpoint;
import com.ibm.ws.transport.iiop.spi.SubsystemFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "orb.type=yoko", "service.ranking:Integer=5"})
public class ORBConfigAdapter
implements ConfigAdapter {
    private static final TraceComponent tc = Tr.register(ORBConfigAdapter.class);
    static final long serialVersionUID = 495296215346796646L;

    @Override
    public ORB createServerORB(Map<String, Object> config, Map<String, Object> extraConfig, List<IIOPEndpoint> endpoints, Collection<SubsystemFactory> subsystemFactories) throws ConfigException {
        ORB orb = this.createORB(this.translateToTargetArgs(config, subsystemFactories), this.translateToTargetProps(config, extraConfig, endpoints, subsystemFactories));
        return orb;
    }

    @Override
    public ORB createClientORB(Map<String, Object> clientProps, Collection<SubsystemFactory> subsystemFactories) throws ConfigException {
        return this.createORB(this.translateToClientArgs(clientProps, subsystemFactories), this.translateToClientProps(clientProps, subsystemFactories));
    }

    private ORB createORB(String[] args, Properties props) {
        return ORB.init((String[])args, (Properties)props);
    }

    private String[] translateToTargetArgs(Map<String, Object> props, Collection<SubsystemFactory> subsystemFactories) throws ConfigException {
        ArrayList<String> list = new ArrayList<String>();
        for (SubsystemFactory sf : subsystemFactories) {
            sf.addTargetORBInitArgs(props, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configargs: " + list), (Object[])new Object[0]);
        }
        return list.toArray(new String[list.size()]);
    }

    private Properties translateToTargetProps(Map<String, Object> config, Map<String, Object> extraConfig, List<IIOPEndpoint> endpoints, Collection<SubsystemFactory> subsystemFactories) throws ConfigException {
        Properties result = this.createYokoORBProperties();
        for (SubsystemFactory sf : subsystemFactories) {
            this.addInitializerPropertyForSubsystem(result, sf, true);
            sf.addTargetORBInitProperties(result, config, endpoints, extraConfig);
        }
        if (!result.containsKey("yoko.orb.oa.endpoint") && !endpoints.isEmpty()) {
            IIOPEndpoint endpoint = endpoints.get(0);
            int port = endpoint.getIiopPort();
            String host = endpoint.getHost();
            if (port > 0) {
                result.put("yoko.orb.oa.endpoint", "iiop --bind " + host + " --host " + host + " --port " + port);
            } else {
                result.put("yoko.orb.oa.endpoint", "iiop --bind " + host + " --host " + host);
            }
        }
        return result;
    }

    private Properties createYokoORBProperties() {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        return result;
    }

    private void addInitializerPropertyForSubsystem(Properties props, SubsystemFactory subsystemFactory, boolean endpoint) {
        String initializerClassName = subsystemFactory.getInitializerClassName(endpoint);
        if (initializerClassName != null) {
            props.put("org.omg.PortableInterceptor.ORBInitializerClass." + initializerClassName, "");
        }
    }

    private String[] translateToClientArgs(Map<String, Object> clientProps, Collection<SubsystemFactory> subsystemFactories) throws ConfigException {
        ArrayList<String> list = new ArrayList<String>();
        for (SubsystemFactory sf : subsystemFactories) {
            sf.addClientORBInitArgs(clientProps, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configargs: " + list), (Object[])new Object[0]);
        }
        return list.toArray(new String[list.size()]);
    }

    private Properties translateToClientProps(Map<String, Object> clientProps, Collection<SubsystemFactory> subsystemFactories) throws ConfigException {
        Properties result = this.createYokoORBProperties();
        for (SubsystemFactory sf : subsystemFactories) {
            this.addInitializerPropertyForSubsystem(result, sf, false);
            sf.addClientORBInitProperties(result, clientProps);
        }
        return result;
    }
}

